/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-09-17 23:08:44 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_activity_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `sub_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `severity` int NOT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `version` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `sub_type_idx` (`sub_type`),
  KEY `severity_idx` (`severity`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_backups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `archive_name` varchar(350) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` int NOT NULL,
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE','TEMPORARY') COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `version` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`(191)),
  KEY `archive_name` (`archive_name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_entities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value_1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_3` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_4` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_5` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `version` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`(191)),
  KEY `value_2` (`value_2`(191)),
  KEY `value_3` (`value_3`(191)),
  KEY `value_4` (`value_4`(191)),
  KEY `value_5` (`value_5`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=2105 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4499 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=2835 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rtl_rsm_logs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `section` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `result` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `wp_users` VALUES 
("1","dentia","$wp$2y$10$vSPwpLN1loaFoy/6TAJecOFgv.71UdNVV/H13SPSMBKFUGRun07vi","suncode","bagher.pebs@yahoo.com","https://dentia.sunthemes.ir","2025-09-03 06:20:59","","0","سان کد");

INSERT IGNORE INTO `wp_usermeta` VALUES 
("1","1","nickname","سان کد"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description","این متن بیوگرافی درباره مدیر سایت است و می توانید از پیشخوان ← کاربران ← کاربر مدیر را ویرایش کنید و زندگی‌نامه را ویرایش نمایید."),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","wp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","wp_user_level","10"),
("14","1","dismissed_wp_pointers","theme_editor_notice"),
("15","1","show_welcome_panel","0"),
("16","1","session_tokens","a:5:{s:64:\"e4660ba116fb92f804b12e542253456fc8d5baf6999fceb6d06a27b001e5b6c7\";a:4:{s:10:\"expiration\";i:1758210245;s:2:\"ip\";s:12:\"46.37.116.27\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36\";s:5:\"login\";i:1758037445;}s:64:\"b92a38a507133ad85547425d0e0bd120a5ad3a323244ffbe6b0de1156206db9f\";a:4:{s:10:\"expiration\";i:1758273137;s:2:\"ip\";s:13:\"46.249.125.82\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36\";s:5:\"login\";i:1758100337;}s:64:\"ddcf986d91edb69bfe12bf26f840c7c6db856a73781cf325aa555f4a12417588\";a:4:{s:10:\"expiration\";i:1758298872;s:2:\"ip\";s:12:\"5.202.25.239\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36\";s:5:\"login\";i:1758126072;}s:64:\"b99dabf4ba0394e6daf253919ef3bb2ffd43ab40d5464333a8eee16586b52d32\";a:4:{s:10:\"expiration\";i:1758320118;s:2:\"ip\";s:12:\"5.202.25.174\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36\";s:5:\"login\";i:1758147318;}s:64:\"c5d3c9f3fa4b758c7b6cf45e6a4969e8115c577c1e4d216d71bafdccac79ca66\";a:4:{s:10:\"expiration\";i:1758323073;s:2:\"ip\";s:13:\"149.22.93.183\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36\";s:5:\"login\";i:1758150273;}}"),
("17","1","wp_dashboard_quick_press_last_post_id","2664"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:11:\"149.22.93.0\";}"),
("19","1","nav_menu_recently_edited","15"),
("20","1","managenav-menuscolumnshidden","a:4:{i:0;s:15:\"title-attribute\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";}"),
("21","1","metaboxhidden_nav-menus","a:6:{i:0;s:23:\"add-post-type-portfolio\";i:1;s:21:\"add-post-type-service\";i:2;s:12:\"add-post_tag\";i:3;s:15:\"add-post_format\";i:4;s:22:\"add-portfolio-category\";i:5;s:20:\"add-service-category\";}"),
("22","1","elementor_introduction","a:2:{s:27:\"ai-get-started-announcement\";b:1;s:20:\"globals_introduction\";b:1;}"),
("23","1","wp_user-settings","editor=tinymce&libraryContent=browse"),
("24","1","wp_user-settings-time","1757845331"),
("25","1","user_position","مدیر سان کد"),
("26","1","user_facebook",""),
("27","1","user_twitter","#"),
("28","1","user_instagram","#"),
("29","1","user_linkedin","#"),
("30","1","user_youtube","#"),
("31","1","wp_elementor_enable_ai","1"),
("32","1","wp_user_avatar","0"),
("33","1","closedpostboxes_post","a:0:{}"),
("34","1","metaboxhidden_post","a:6:{i:0;s:13:\"trackbacksdiv\";i:1;s:10:\"postcustom\";i:2;s:16:\"commentstatusdiv\";i:3;s:11:\"commentsdiv\";i:4;s:7:\"slugdiv\";i:5;s:9:\"authordiv\";}"),
("35","1","elementor_admin_notices","a:1:{s:20:\"experiment_promotion\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:0:{}}}"),
("36","1","meta-box-order_dashboard","a:4:{s:6:\"normal\";s:103:\"wpp_dashboard_primary,e-dashboard-overview,dashboard_site_health,dashboard_right_now,dashboard_activity\";s:4:\"side\";s:39:\"dashboard_quick_press,dashboard_primary\";s:7:\"column3\";s:0:\"\";s:7:\"column4\";s:0:\"\";}"),
("37","1","elementor_dismissed_editor_notices","a:1:{i:0;s:20:\"image_optimizer_hint\";}"),
("38","1","wpcf7_hide_welcome_panel_on","a:1:{i:0;s:3:\"6.1\";}");

INSERT IGNORE INTO `wp_comments` VALUES 
("1","1","یک نویسنده دیدگاه وردپرس","wapuu@wordpress.example","https://fa.wordpress.org/","","2025-09-03 09:50:59","2025-09-03 06:20:59","سلام، این یک دیدگاه است.\nبرای شروع مدیریت، ویرایش و پاک کردن دیدگاه‌ها، لطفا بخش دیدگاه‌ها در پیشخوان را ببینید.\nتصاویر نویسندگان دیدگاه از <a href=\"https://gravatar.com/\">Gravatar</a> گرفته می‌شود.","0","1","","comment","0","0"),
("2","25","علی محمدی","pxlhoang20@gmail.com","https://dentia.sunthemes.ir","127.0.0.1","2025-08-04 08:46:07","2025-08-04 08:46:07","لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.","0","1","","comment","0","0"),
("3","25","رضا حسینی","pxlhoang20@gmail.com","https://dentia.sunthemes.ir","127.0.0.1","2025-08-04 08:46:21","2025-08-04 08:46:21","لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.","0","1","","comment","2","0"),
("4","25","محمد کریمی","pxlhoang20@gmail.com","https://dentia.sunthemes.ir","127.0.0.1","2025-08-04 08:46:33","2025-08-04 08:46:33","چگونه می‌توانید به تیم خود کمک کنید تا به کار از راه دور منتقل شوند؟","0","1","","comment","0","0"),
("5","25","فاطمه احمدی","pxlhoang20@gmail.com","https://dentia.sunthemes.ir","127.0.0.1","2025-08-04 08:46:46","2025-08-04 08:46:46","مشکلاتی که همه در هنگام کار از راه دور دارند و چگونه آن‌ها را حل کنند.","0","1","","comment","4","0"),
("6","25","حسین رضایی","pxlhoang20@gmail.com","https://dentia.sunthemes.ir","127.0.0.1","2025-08-04 08:46:58","2025-08-04 08:46:58","راه بهتری برای بازاریابان جهت بهبود نرخ تبدیل.","0","1","","comment","0","0"),
("7","107","بررسی کننده","info@sdsdsdsd.cxsdsd","","46.249.125.82","2025-09-17 08:22:02","2025-09-17 04:52:02","این یک دیدگاه برای بررسی نوشته است.","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36","comment","0","0");

INSERT IGNORE INTO `wp_duplicator_activity_logs` VALUES 
("1","websites_scan","scan_start","10","اسکن","{\n    \"packageId\": 1,\n    \"packageName\": \"20250917_d982d8a7d984d8a8d988d8b1d8afd9bed8b1d8b\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 0,\n    \"dirCount\": 0,\n    \"size\": 0\n}","0","4.5.22.4","2025-09-17 23:05:56","2025-09-17 23:05:56"),
("2","websites_scan","scan_end","10","اسکن تکمیل شد","{\n    \"packageId\": 1,\n    \"packageName\": \"20250917_d982d8a7d984d8a8d988d8b1d8afd9bed8b1d8b\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 11024,\n    \"dirCount\": 1894,\n    \"size\": 232952207\n}","1","4.5.22.4","2025-09-17 23:05:57","2025-09-17 23:05:57"),
("3","backup_create","start","10","ایجاد بک‌آپ: 20250917_d982d8a7d984d8a8d988d8b1d8afd9bed8b1d8b","{\n    \"packageId\": 2,\n    \"packageName\": \"20250917_d982d8a7d984d8a8d988d8b1d8afd9bed8b1d8b\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 11024,\n    \"dirCount\": 1894,\n    \"size\": 232952207,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"\\u0628\\u0627\\u06cc\\u06af\\u0627\\u0646\\u06cc \\u0632\\u06cc\\u067e\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","0","4.5.22.4","2025-09-17 23:08:44","2025-09-17 23:08:44"),
("4","backup_create","db_dump","10","ایجاد بک‌آپ: 20250917_d982d8a7d984d8a8d988d8b1d8afd9bed8b1d8b - دامپ دیتابیس","{\n    \"packageId\": 2,\n    \"packageName\": \"20250917_d982d8a7d984d8a8d988d8b1d8afd9bed8b1d8b\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 11024,\n    \"dirCount\": 1894,\n    \"size\": 232952207,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"\\u0628\\u0627\\u06cc\\u06af\\u0627\\u0646\\u06cc \\u0632\\u06cc\\u067e\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","3","4.5.22.4","2025-09-17 23:08:44","2025-09-17 23:08:44");

INSERT IGNORE INTO `wp_duplicator_backups` VALUES 
("1","Standard","20250917_d982d8a7d984d8a8d988d8b1d8afd9bed8b1d8b","30f278b839d74b894932_20250917230555","20250917_d982d8a7d984d8a8d988d8b1d8afd9bed8b1d8b_30f278b839d74b894932_20250917230555_archive.zip","5","MANUAL,ZIP_ARCHIVE,TEMPORARY","{\n    \"ID\": 1,\n    \"VersionWP\": \"6.8.2\",\n    \"VersionDB\": \"8.0.37\",\n    \"VersionPHP\": \"8.1.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20250917_d982d8a7d984d8a8d988d8b1d8afd9bed8b1d8b\",\n    \"hash\": \"30f278b839d74b894932_20250917230555\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250917_d982d8a7d984d8a8d988d8b1d8afd9bed8b1d8b_30f278b839d74b894932_20250917230555_scan.json\",\n    \"timer_start\": -1,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"\\u0628\\u0633\\u062a\\u0647 \\u0646\\u0635\\u0628\\u06cc \\u0642\\u0627\\u0644\\u0628 \\u062f\\u0646\\u062a\\u06cc\\u0627 | \\u0633\\u0627\\u0646 \\u06a9\\u062f | \\u0631\\u0627\\u0633\\u062a\\u0686\\u06cc\\u0646\",\n    \"Brand_ID\": 9,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/.opcache\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/.tmb\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/bps-backup\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/cache\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/old-cache\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/updraft\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/wfcache\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/.htaccess\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/.user.ini\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/php.ini\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/web.config\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-config.php\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250917_d982d8a7d984d8a8d988d8b1d8afd9bed8b1d8b_30f278b839d74b894932_20250917230555_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/suntheme\\/public_html\\/dentia\\/\",\n        \"Size\": 232952207,\n        \"Dirs\": [],\n        \"DirCount\": 1894,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 11024,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 106139762,\n                        \"bytes\": \"101.22MB\",\n                        \"nodes\": 7914,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 172608407,\n                        \"bytes\": \"164.61MB\",\n                        \"nodes\": 9829,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-snapshots\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/.opcache\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/.tmb\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/old-cache\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/updraft\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/wfcache\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/cache\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 5477348,\n                        \"bytes\": \"5.22MB\",\n                        \"nodes\": 1,\n                        \"name\": \"attachment.zip\",\n                        \"dir\": \"wp-content\\/uploads\\/pxlart_temp\\/dentia\",\n                        \"path\": \"wp-content\\/uploads\\/pxlart_temp\\/dentia\\/attachment.zip\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/.htaccess\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/.user.ini\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/php.ini\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/web.config\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/debug.log\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"text\": \"\\/home\\/suntheme\\/public_html\\/dentia <span class=\\\"size\\\" >222.16MB<\\/span> <span class=\\\"nodes\\\" >12918<\\/span>\",\n                \"fullPath\": \"\\/home\\/suntheme\\/public_html\\/dentia\",\n                \"type\": \"folder\",\n                \"state\": {\n                    \"opened\": true,\n                    \"disabled\": false,\n                    \"selected\": false,\n                    \"checked\": false,\n                    \"checkbox_disabled\": true\n                },\n                \"children\": [\n                    {\n                        \"text\": \"wp-content <span class=\\\"size\\\" >164.61MB<\\/span> <span class=\\\"nodes\\\" >9829<\\/span>\",\n                        \"fullPath\": \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\",\n                        \"type\": \"folder\",\n                        \"state\": {\n                            \"opened\": true,\n                            \"disabled\": false,\n                            \"selected\": false,\n                            \"checked\": false,\n                            \"checkbox_disabled\": false\n                        },\n                        \"children\": [\n                            {\n                                \"text\": \"plugins <span class=\\\"size\\\" >101.22MB<\\/span> <span class=\\\"nodes\\\" >7914<\\/span>\",\n                                \"fullPath\": \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/plugins\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": false,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": true,\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            },\n                            {\n                                \"text\": \"uploads <span class=\\\"size\\\" >35.17MB<\\/span> <span class=\\\"nodes\\\" >905<\\/span>\",\n                                \"fullPath\": \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": true,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": [\n                                    {\n                                        \"text\": \"pxlart_temp <span class=\\\"size\\\" >7.47MB<\\/span> <span class=\\\"nodes\\\" >12<\\/span>\",\n                                        \"fullPath\": \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/pxlart_temp\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": true,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": [\n                                            {\n                                                \"text\": \"dentia <span class=\\\"size\\\" >7.47MB<\\/span> <span class=\\\"nodes\\\" >11<\\/span>\",\n                                                \"fullPath\": \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/pxlart_temp\\/dentia\",\n                                                \"type\": \"folder\",\n                                                \"state\": {\n                                                    \"opened\": true,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": [\n                                                    {\n                                                        \"text\": \"attachment.zip <span class=\\\"size\\\" >5.22MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/pxlart_temp\\/dentia\\/attachment.zip\",\n                                                        \"type\": \"file\",\n                                                        \"state\": {\n                                                            \"opened\": false,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": null,\n                                                        \"li_attr\": {\n                                                            \"class\": \" warning-node\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    }\n                                                ],\n                                                \"li_attr\": {\n                                                    \"data-full-loaded\": false,\n                                                    \"class\": \" warning-childs\"\n                                                },\n                                                \"a_attr\": []\n                                            }\n                                        ],\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-childs\"\n                                        },\n                                        \"a_attr\": []\n                                    }\n                                ],\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-childs\"\n                                },\n                                \"a_attr\": []\n                            }\n                        ],\n                        \"li_attr\": {\n                            \"data-full-loaded\": false,\n                            \"class\": \" warning-node\"\n                        },\n                        \"a_attr\": []\n                    }\n                ],\n                \"li_attr\": {\n                    \"data-full-loaded\": false,\n                    \"class\": \" root-node core-node warning-childs\"\n                },\n                \"a_attr\": {\n                    \"title\": \"\\u067e\\u0648\\u0634\\u0647\\u200c\\u0647\\u0627\\u06cc \\u0627\\u0635\\u0644\\u06cc \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633 \\u0646\\u0628\\u0627\\u06cc\\u062f \\u0641\\u06cc\\u0644\\u062a\\u0631 \\u0634\\u0648\\u0646\\u062f. \\u062f\\u0631 \\u062d\\u0630\\u0641 \\u0641\\u0627\\u06cc\\u0644\\u200c\\u0647\\u0627 \\u0627\\u062d\\u062a\\u06cc\\u0627\\u0637 \\u06a9\\u0646\\u06cc\\u062f.\"\n                }\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250917_d982d8a7d984d8a8d988d8b1d8afd9bed8b1d8b_30f278b839d74b894932_20250917230555_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"XUlQP0kz9oxOTjCUaZsg0NwQM87Twzf+c0vp7cAp+BJ0FefsYB9HsTnZG5f701cUEJrQBrZeIt8jtIPFf4KtxA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"suntheme_dentia\",\n            \"tablesBaseCount\": 17,\n            \"tablesFinalCount\": 17,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3128,\n            \"tablesSizeOnDisk\": 22593536,\n            \"tablesList\": {\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"278\",\n                    \"insertedRows\": 0,\n                    \"size\": 2179072\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"2352\",\n                    \"insertedRows\": 0,\n                    \"size\": 15040512\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"292\",\n                    \"insertedRows\": 0,\n                    \"size\": 4423680\n                },\n                \"wp_rtl_rsm_logs\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"117\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"32\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.37\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20250917_d982d8a7d984d8a8d988d8b1d8afd9bed8b1d8b_30f278b839d74b894932_20250917230555_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 5,\n    \"progressPercent\": 5,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.22.4\",\n    \"created\": \"2025-09-17 23:05:55\",\n    \"updated\": \"2025-09-17 23:05:57\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\",\n        \"TEMPORARY\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 1,\n    \"mainActivityLogId\": 0\n}","4.5.22.4","2025-09-17 23:05:55","2025-09-17 23:05:57"),
("2","Standard","20250917_d982d8a7d984d8a8d988d8b1d8afd9bed8b1d8b","30f278b839d74b894932_20250917230555","20250917_d982d8a7d984d8a8d988d8b1d8afd9bed8b1d8b_30f278b839d74b894932_20250917230555_archive.zip","20","MANUAL,ZIP_ARCHIVE","{\n    \"ID\": 2,\n    \"VersionWP\": \"6.8.2\",\n    \"VersionDB\": \"8.0.37\",\n    \"VersionPHP\": \"8.1.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20250917_d982d8a7d984d8a8d988d8b1d8afd9bed8b1d8b\",\n    \"hash\": \"30f278b839d74b894932_20250917230555\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250917_d982d8a7d984d8a8d988d8b1d8afd9bed8b1d8b_30f278b839d74b894932_20250917230555_scan.json\",\n    \"timer_start\": 1758150524.618483066558837890625,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"\\u0628\\u0633\\u062a\\u0647 \\u0646\\u0635\\u0628\\u06cc \\u0642\\u0627\\u0644\\u0628 \\u062f\\u0646\\u062a\\u06cc\\u0627 | \\u0633\\u0627\\u0646 \\u06a9\\u062f | \\u0631\\u0627\\u0633\\u062a\\u0686\\u06cc\\u0646\",\n    \"Brand_ID\": 9,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/.opcache\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/.tmb\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/bps-backup\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/cache\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/old-cache\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/updraft\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/wfcache\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/.htaccess\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/.user.ini\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/php.ini\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/web.config\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-config.php\",\n            \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250917_d982d8a7d984d8a8d988d8b1d8afd9bed8b1d8b_30f278b839d74b894932_20250917230555_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/suntheme\\/public_html\\/dentia\\/\",\n        \"Size\": 232952207,\n        \"Dirs\": [],\n        \"DirCount\": 1894,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 11024,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 106139762,\n                        \"bytes\": \"101.22MB\",\n                        \"nodes\": 7914,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 172608407,\n                        \"bytes\": \"164.61MB\",\n                        \"nodes\": 9829,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-snapshots\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/.opcache\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/.tmb\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/old-cache\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/updraft\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/wfcache\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/cache\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 5477348,\n                        \"bytes\": \"5.22MB\",\n                        \"nodes\": 1,\n                        \"name\": \"attachment.zip\",\n                        \"dir\": \"wp-content\\/uploads\\/pxlart_temp\\/dentia\",\n                        \"path\": \"wp-content\\/uploads\\/pxlart_temp\\/dentia\\/attachment.zip\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/.htaccess\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/.user.ini\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/php.ini\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/web.config\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/debug.log\",\n                    \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"treeList\": []\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250917_d982d8a7d984d8a8d988d8b1d8afd9bed8b1d8b_30f278b839d74b894932_20250917230555_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"pCGTvKBTDuZyR+GGPDLsYEPAdj0pXkpIje\\/+i32TB1Cir56glrZ\\/BRGF\\/\\/gcXrEFDQlhiR4LY34K5vyKBOfPGQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"suntheme_dentia\",\n            \"tablesBaseCount\": 17,\n            \"tablesFinalCount\": 17,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3128,\n            \"tablesSizeOnDisk\": 22593536,\n            \"tablesList\": {\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"278\",\n                    \"insertedRows\": 0,\n                    \"size\": 2179072\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"2352\",\n                    \"insertedRows\": 0,\n                    \"size\": 15040512\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"292\",\n                    \"insertedRows\": 0,\n                    \"size\": 4423680\n                },\n                \"wp_rtl_rsm_logs\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"117\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"32\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.37\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20250917_d982d8a7d984d8a8d988d8b1d8afd9bed8b1d8b_30f278b839d74b894932_20250917230555_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/suntheme\\/public_html\\/dentia\\/wp-content\\/backups-dup-pro\\/tmp\\/20250917_d982d8a7d984d8a8d988d8b1d8afd9bed8b1d8b_30f278b839d74b894932_20250917230555_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 20,\n    \"progressPercent\": 20,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 1758150525,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"wp_users\",\n            \"wp_usermeta\",\n            \"wp_commentmeta\",\n            \"wp_comments\",\n            \"wp_duplicator_activity_logs\",\n            \"wp_duplicator_backups\",\n            \"wp_duplicator_entities\",\n            \"wp_e_events\",\n            \"wp_links\",\n            \"wp_options\",\n            \"wp_postmeta\",\n            \"wp_posts\",\n            \"wp_rtl_rsm_logs\",\n            \"wp_term_relationships\",\n            \"wp_term_taxonomy\",\n            \"wp_termmeta\",\n            \"wp_terms\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1758150524.6266019344329833984375,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 3128,\n            \"tables\": {\n                \"wp_users\": {\n                    \"start\": \"1\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_rtl_rsm_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.22.4\",\n    \"created\": \"2025-09-17 23:05:55\",\n    \"updated\": \"2025-09-17 23:08:45\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 1,\n    \"mainActivityLogId\": 3\n}","4.5.22.4","2025-09-17 23:05:55","2025-09-17 23:08:45");

INSERT IGNORE INTO `wp_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","","","","","","{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"crypt\": true,\n    \"email_summary_frequency\": \"weekly\",\n    \"email_summary_recipients\": [\n        \"bagher.pebs@yahoo.com\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"max_package_transfer_time_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"bagher.pebs@yahoo.com\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"ajax_protocol\": \"https\",\n    \"custom_ajax_url\": \"https:\\/\\/dentia.sunthemes.ir\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"purgeBackupRecords\": 0,\n    \"manual_mode_storage_ids\": [\n        3\n    ],\n    \"license_key_visible\": 1,\n    \"lkp\": \"\",\n    \"last_system_check_timestamp\": 0,\n    \"initial_activation_timestamp\": 1758150067,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 1,\n    \"version\": \"4.5.22.4\",\n    \"created\": \"2025-09-17 23:01:07\",\n    \"updated\": \"2025-09-17 23:05:55\"\n}","4.5.22.4","2025-09-17 23:01:07","2025-09-17 23:05:55"),
("2","Dynamic_Entity","","","","","","{\n    \"data\": \"pv56Dn5rJI8nTH3TXVYIo4Ioc9f9XTqinPAyZ8AgoQ3Cdw8c9YYgtbSfz6pviq40xgfK8h5GEjak5g2QOygHB2FnygiUAJ4n\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 2,\n    \"version\": \"4.5.22.4\",\n    \"created\": \"2025-09-17 23:01:07\",\n    \"updated\": \"2025-09-17 23:03:27\",\n    \"dataIsEncrypted\": true\n}","4.5.22.4","2025-09-17 23:01:07","2025-09-17 23:03:27"),
("3","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"\\u067e\\u06cc\\u0634\\u200c\\u0641\\u0631\\u0636\",\n    \"notes\": \"\\u0645\\u06a9\\u0627\\u0646 \\u067e\\u06cc\\u0634\\u200c\\u0641\\u0631\\u0636 \\u0628\\u0631\\u0627\\u06cc \\u0630\\u062e\\u06cc\\u0631\\u0647\\u200c\\u0633\\u0627\\u0632\\u06cc \\u062f\\u0631 \\u0627\\u06cc\\u0646 \\u0633\\u0631\\u0648\\u0631.\",\n    \"storage_type\": -2,\n    \"config\": \"MtH2XtR0MBp0sG107NH8a71GAYVEn94KPL+X69WDtTFRafMTeNEqeSFA05d4xw5UBAjKswse\\/S\\/xpAsI4uQBFofbWCFYL\\/TQnGWcGgQh+kCAeHa5D8ew8dUVtHrXF2wz70W6ofge5WfvowbaSHWsxDZiGGaKMR0oMiO+jbpU1YPuq3ybPCTemXBMKgts0em1IzyL5D3yqNH5ZTIHhmROBem3AOjhknfisvZUfz2vxnANyrHAhIMqqk8K7Oc1RII\\/y6zdnvBCO8o=\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 3,\n    \"version\": \"4.5.22.4\",\n    \"created\": \"2025-09-17 23:01:07\",\n    \"updated\": \"2025-09-17 23:03:27\"\n}","4.5.22.4","2025-09-17 23:01:07","2025-09-17 23:03:27"),
("4","EmailSummary","","","","","","{\n    \"manualPackageIds\": [],\n    \"scheduledPackageIds\": [],\n    \"failedPackageIds\": [],\n    \"failedUploads\": [],\n    \"cancelledUploads\": [],\n    \"successfulUploads\": [],\n    \"scheduleIds\": [],\n    \"storageIds\": [],\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 4,\n    \"version\": \"4.5.22.4\",\n    \"created\": \"2025-09-17 23:01:07\",\n    \"updated\": \"2025-09-17 23:01:07\"\n}","4.5.22.4","2025-09-17 23:01:07","2025-09-17 23:01:07"),
("5","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"\\u067e\\u06cc\\u0634\\u200c\\u0641\\u0631\\u0636\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"\\u0642\\u0627\\u0644\\u0628 \\u067e\\u06cc\\u0634\\u200c\\u0641\\u0631\\u0636.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"Z7Qwu+ArSMqrlmIdzsmTl64GaRhMjFmJSKKzGGHTo8Oh1m684RmT6KuYDAC9m2G4vsZQHY2LnlcKM\\/CASjeeyA==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 5,\n    \"version\": \"4.5.22.4\",\n    \"created\": \"2025-09-17 23:01:07\",\n    \"updated\": \"2025-09-17 23:01:07\"\n}","4.5.22.4","2025-09-17 23:01:07","2025-09-17 23:01:07"),
("6","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"[\\u062d\\u0627\\u0644\\u062a \\u062f\\u0633\\u062a\\u06cc]\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"U1GD\\/rw4oqi+BsoooD3MI2QQQhn6XWDGiWRaWGy9HlqUklddP3ZB1m2jk2swTVh\\/oGBW+WjdLYHOx1lTa+Yk+A==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": 9,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 6,\n    \"version\": \"4.5.22.4\",\n    \"created\": \"2025-09-17 23:01:07\",\n    \"updated\": \"2025-09-17 23:05:55\"\n}","4.5.22.4","2025-09-17 23:01:07","2025-09-17 23:05:55"),
("7","LicenseDataEntity","","","","","","{\n    \"licenseKey\": \"lAKva3vCAaMbpmsjdPUzrWII44XMjAxUjJ0phtkWks1+yr3q5LR8fLvPc9E\\/ntV90D72uVEiLK2H21AfGJGiEg==\",\n    \"status\": \"aH1gLwzHQRsKvTc+WYiE\\/jM\\/\\/uu0OAtUD+k4tbInwQCROfZvsA\\/PdDxu0AmWWMVlsQ\\/p3JBRQlY1Pp\\/\\/1HmOi03yC4CaTCt2\",\n    \"type\": \"3sAiElcyFy9qQO2L44APU+QMjWo0eqIaRi\\/\\/qEgkRY3JSs6VVFZYbbjp01cJcs\\/ksvZCA9Bql9bGQxUYtvSkY8cmpVJsoKw7\",\n    \"data\": \"F33ErAJpknQXFKCWTBtXJdM9EEUUs5+DDSB\\/isL1sAdWyo0K+w03sNPxdUn4kPRehANw7IRxO5QTj7hH9893Z\\/fcRo65F5tJEMb1mTF6iG71JAaJW+93iDDPoWklcROD6yBoHEMot4XZwrldyvXWZMx8kitUFDgEjkvFIm3Q2kCtaEzFSZZGKaTqeJeh\\/s6PP1f7U1dq0GPXiyXn6gt0eJ5NkO58YKX2ptEE9OCtdmGpTZTqbNf2jIQDcOyEcTuU6\\/SfpHDl0+WFQJtOfSjG10STlquzQOCT2rprkOvVm+QfkaMIbkVq5qZDCVRlOfPgTV4X3Txz5U6cGHVXI5KvZPPdV2aNL0OeGtQxeJdOgQbhc7D\\/Dkz8lx6yLK1sYVo6JyVunLZfSvD0leSrRq3DpP9wK+IBbvnPNVwhakYmrBY=\",\n    \"lastRemoteUpdate\": \"\",\n    \"lastFailureTime\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 7,\n    \"version\": \"4.5.22.4\",\n    \"created\": \"2025-09-17 23:01:07\",\n    \"updated\": \"2025-09-17 23:08:45\"\n}","4.5.22.4","2025-09-17 23:01:07","2025-09-17 23:08:45"),
("8","DUP_PRO_System_Global_Entity","","","","","","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1758150524,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 8,\n    \"version\": \"4.5.22.4\",\n    \"created\": \"2025-09-17 23:01:08\",\n    \"updated\": \"2025-09-17 23:08:44\"\n}","4.5.22.4","2025-09-17 23:01:08","2025-09-17 23:08:44"),
("9","DUP_PRO_Brand_Entity","","","","","","{\n    \"name\": \"\\u0628\\u0633\\u062a\\u0647 \\u0646\\u0635\\u0628\\u06cc \\u0642\\u0627\\u0644\\u0628 \\u062f\\u0646\\u062a\\u06cc\\u0627 | \\u0633\\u0627\\u0646 \\u06a9\\u062f | \\u0631\\u0627\\u0633\\u062a\\u0686\\u06cc\\u0646\",\n    \"notes\": \"\",\n    \"editable\": true,\n    \"logo\": \"<i class=\\\"fa fa-bolt fa-sm\\\"><\\/i> \\u0628\\u0633\\u062a\\u0647 \\u0646\\u0635\\u0628\\u06cc \\u0642\\u0627\\u0644\\u0628 \\u062f\\u0646\\u062a\\u06cc\\u0627 <img src=\\\"https:\\/\\/sunthemes.ir\\/images\\/logo.png\\\" alt=\\\"\\u0633\\u0627\\u0646 \\u06a9\\u062f\\\" \\/>\",\n    \"attachments\": [\n        \"\"\n    ],\n    \"default\": false,\n    \"brandMode\": 1,\n    \"active\": false,\n    \"style\": [],\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 9,\n    \"version\": \"4.5.22.4\",\n    \"created\": \"2025-09-17 23:03:12\",\n    \"updated\": \"2025-09-17 23:03:12\"\n}","4.5.22.4","2025-09-17 23:03:12","2025-09-17 23:03:12");

INSERT IGNORE INTO `wp_options` VALUES 
("1","cron","a:17:{i:1758151107;a:1:{s:32:\"duplicator_backup_storages_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:41:\"duplicator_backup_storages_check_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1758151259;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1758157077;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"ec75a147fe8386f41dee173c25077b20\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:2834;}}}}i:1758163380;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1758172345;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1758176459;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1758176483;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1758176485;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1758180059;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1758181859;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1758183659;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1758193146;a:1:{s:13:\"rsmAutoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1758236607;a:1:{s:31:\"duplicator_activity_log_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"duplicator_daily_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1758537000;a:1:{s:33:\"duplicator_pro_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1758695129;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1758791727;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","on"),
("2","siteurl","https://dentia.sunthemes.ir","on"),
("3","home","https://dentia.sunthemes.ir","on"),
("4","blogname","قالب وردپرس Dentia","on"),
("5","blogdescription","","on"),
("6","users_can_register","0","on"),
("7","admin_email","bagher.pebs@yahoo.com","on"),
("8","start_of_week","6","on"),
("9","use_balanceTags","0","on"),
("10","use_smilies","1","on"),
("11","require_name_email","1","on"),
("12","comments_notify","1","on"),
("13","posts_per_rss","10","on"),
("14","rss_use_excerpt","0","on"),
("15","mailserver_url","mail.example.com","on"),
("16","mailserver_login","login@example.com","on"),
("17","mailserver_pass","","on"),
("18","mailserver_port","110","on"),
("19","default_category","1","on"),
("20","default_comment_status","open","on"),
("21","default_ping_status","open","on"),
("22","default_pingback_flag","1","on"),
("23","posts_per_page","5","on"),
("24","date_format","j F Y","on"),
("25","time_format","g:i a","on"),
("26","links_updated_date_format","F j, Y g:i a","on"),
("27","comment_moderation","0","on"),
("28","moderation_notify","1","on"),
("29","permalink_structure","/%postname%/","on"),
("30","rewrite_rules","a:202:{s:12:\"portfolio/?$\";s:29:\"index.php?post_type=portfolio\";s:42:\"portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:37:\"portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:29:\"portfolio/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:10:\"service/?$\";s:27:\"index.php?post_type=service\";s:40:\"service/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=service&feed=$matches[1]\";s:35:\"service/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=service&feed=$matches[1]\";s:27:\"service/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=service&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:40:\"pxl-template/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"pxl-template/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"pxl-template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"pxl-template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"pxl-template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"pxl-template/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"pxl-template/([^/]+)/embed/?$\";s:45:\"index.php?pxl-template=$matches[1]&embed=true\";s:33:\"pxl-template/([^/]+)/trackback/?$\";s:39:\"index.php?pxl-template=$matches[1]&tb=1\";s:41:\"pxl-template/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?pxl-template=$matches[1]&paged=$matches[2]\";s:48:\"pxl-template/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?pxl-template=$matches[1]&cpage=$matches[2]\";s:37:\"pxl-template/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?pxl-template=$matches[1]&page=$matches[2]\";s:29:\"pxl-template/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"pxl-template/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"pxl-template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"pxl-template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"pxl-template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"pxl-template/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:50:\"portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:45:\"portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"service/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"service/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"service/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"service/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"service/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"service/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"service/([^/]+)/embed/?$\";s:40:\"index.php?service=$matches[1]&embed=true\";s:28:\"service/([^/]+)/trackback/?$\";s:34:\"index.php?service=$matches[1]&tb=1\";s:48:\"service/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?service=$matches[1]&feed=$matches[2]\";s:43:\"service/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?service=$matches[1]&feed=$matches[2]\";s:36:\"service/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?service=$matches[1]&paged=$matches[2]\";s:43:\"service/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?service=$matches[1]&cpage=$matches[2]\";s:32:\"service/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?service=$matches[1]&page=$matches[2]\";s:24:\"service/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"service/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"service/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"service/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"service/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"service/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio-category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio-category=$matches[1]&feed=$matches[2]\";s:35:\"portfolio-category/([^/]+)/embed/?$\";s:51:\"index.php?portfolio-category=$matches[1]&embed=true\";s:47:\"portfolio-category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio-category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio-category/([^/]+)/?$\";s:40:\"index.php?portfolio-category=$matches[1]\";s:57:\"service-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?service-category=$matches[1]&feed=$matches[2]\";s:52:\"service-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?service-category=$matches[1]&feed=$matches[2]\";s:33:\"service-category/([^/]+)/embed/?$\";s:49:\"index.php?service-category=$matches[1]&embed=true\";s:45:\"service-category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?service-category=$matches[1]&paged=$matches[2]\";s:27:\"service-category/([^/]+)/?$\";s:38:\"index.php?service-category=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"mc4wp-form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"mc4wp-form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"mc4wp-form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"mc4wp-form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"mc4wp-form/([^/]+)/embed/?$\";s:43:\"index.php?mc4wp-form=$matches[1]&embed=true\";s:31:\"mc4wp-form/([^/]+)/trackback/?$\";s:37:\"index.php?mc4wp-form=$matches[1]&tb=1\";s:39:\"mc4wp-form/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&paged=$matches[2]\";s:46:\"mc4wp-form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&cpage=$matches[2]\";s:35:\"mc4wp-form/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?mc4wp-form=$matches[1]&page=$matches[2]\";s:27:\"mc4wp-form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"mc4wp-form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"mc4wp-form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"mc4wp-form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=16&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","on"),
("31","hack_file","0","on"),
("32","blog_charset","UTF-8","on"),
("33","moderation_keys","","off"),
("34","active_plugins","a:10:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";i:1;s:35:\"redux-framework/redux-framework.php\";i:2;s:31:\"bravis-addons/bravis-addons.php\";i:3;s:33:\"classic-editor/classic-editor.php\";i:4;s:36:\"contact-form-7/wp-contact-form-7.php\";i:5;s:33:\"duplicator-pro/duplicator-pro.php\";i:6;s:23:\"elementor/elementor.php\";i:7;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:8;s:35:\"one-user-avatar/one-user-avatar.php\";i:9;s:29:\"wp-parsidate/wp-parsidate.php\";}","on"),
("35","category_base","","on"),
("36","ping_sites","https://rpc.pingomatic.com/","on"),
("37","comment_max_links","2","on"),
("38","gmt_offset","","on"),
("39","default_email_category","1","on"),
("40","recently_edited","a:5:{i:0;s:111:\"/home/suntheme/public_html/dentia/wp-content/themes/dentia/suncode/persian_datepicker/persian-datepicker.min.js\";i:1;s:105:\"/home/suntheme/public_html/dentia/wp-content/themes/dentia/suncode/persian_datepicker/persian-date.min.js\";i:2;s:88:\"/home/suntheme/public_html/dentia/wp-content/themes/dentia/suncode/suncode_functions.php\";i:4;s:68:\"/home/suntheme/public_html/dentia/wp-content/themes/dentia/style.css\";i:5;s:0:\"\";}","off"),
("41","template","dentia","on"),
("42","stylesheet","dentia","on"),
("43","comment_registration","0","on"),
("44","html_type","text/html","on"),
("45","use_trackback","0","on"),
("46","default_role","subscriber","on"),
("47","db_version","60421","on"),
("48","uploads_use_yearmonth_folders","1","on"),
("49","upload_path","","on"),
("50","blog_public","1","on"),
("51","default_link_category","2","on"),
("52","show_on_front","page","on"),
("53","tag_base","","on"),
("54","show_avatars","1","on"),
("55","avatar_rating","G","on"),
("56","upload_url_path","","on"),
("57","thumbnail_size_w","150","on"),
("58","thumbnail_size_h","150","on"),
("59","thumbnail_crop","1","on"),
("60","medium_size_w","300","on"),
("61","medium_size_h","300","on"),
("62","avatar_default","mystery","on"),
("63","large_size_w","1024","on"),
("64","large_size_h","1024","on"),
("65","image_default_link_type","none","on"),
("66","image_default_size","","on"),
("67","image_default_align","","on"),
("68","close_comments_for_old_posts","0","on"),
("69","close_comments_days_old","14","on"),
("70","thread_comments","1","on"),
("71","thread_comments_depth","5","on"),
("72","page_comments","0","on"),
("73","comments_per_page","50","on"),
("74","default_comments_page","newest","on"),
("75","comment_order","asc","on"),
("76","sticky_posts","a:0:{}","on"),
("77","widget_categories","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("78","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("79","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("80","uninstall_plugins","a:1:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}","off"),
("81","timezone_string","Asia/Tehran","on"),
("82","page_for_posts","18","on"),
("83","page_on_front","16","on"),
("84","default_post_format","0","on"),
("85","link_manager_enabled","0","on"),
("86","finished_splitting_shared_terms","1","on"),
("87","site_icon","0","on"),
("88","medium_large_size_w","768","on"),
("89","medium_large_size_h","0","on"),
("90","wp_page_for_privacy_policy","3","on"),
("91","show_comments_cookies_opt_in","1","on"),
("92","admin_email_lifespan","1772432459","on"),
("93","disallowed_keys","","off"),
("94","comment_previously_approved","1","on"),
("95","auto_plugin_theme_update_emails","a:0:{}","off"),
("96","auto_update_core_dev","enabled","on"),
("97","auto_update_core_minor","enabled","on"),
("98","auto_update_core_major","enabled","on"),
("99","wp_force_deactivated_plugins","a:0:{}","on"),
("100","wp_attachment_pages_enabled","0","on"),
("101","initial_db_version","60421","on"),
("102","wp_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:70:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","on"),
("103","fresh_site","0","off"),
("104","WPLANG","fa_IR","auto"),
("105","user_count","1","off"),
("106","widget_block","a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","auto"),
("107","sidebars_widgets","a:4:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:12:\"sidebar-blog\";a:2:{i:0;s:18:\"pxl_recent_posts-1\";i:1;s:11:\"tag_cloud-1\";}s:12:\"sidebar-page\";a:0:{}s:13:\"array_version\";i:3;}","auto"),
("108","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("109","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("110","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("111","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("112","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("113","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("114","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("115","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("116","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("117","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("118","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("119","widget_tag_cloud","a:2:{i:1;a:3:{s:5:\"title\";s:30:\"برچسب‌های محبوب\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";}s:12:\"_multiwidget\";i:1;}","auto"),
("120","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("121","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("122","_transient_wp_core_block_css_files","a:2:{s:7:\"version\";s:5:\"6.8.2\";s:5:\"files\";a:536:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:26:\"post-content/style-rtl.css\";i:309;s:30:\"post-content/style-rtl.min.css\";i:310;s:22:\"post-content/style.css\";i:311;s:26:\"post-content/style.min.css\";i:312;s:23:\"post-date/style-rtl.css\";i:313;s:27:\"post-date/style-rtl.min.css\";i:314;s:19:\"post-date/style.css\";i:315;s:23:\"post-date/style.min.css\";i:316;s:27:\"post-excerpt/editor-rtl.css\";i:317;s:31:\"post-excerpt/editor-rtl.min.css\";i:318;s:23:\"post-excerpt/editor.css\";i:319;s:27:\"post-excerpt/editor.min.css\";i:320;s:26:\"post-excerpt/style-rtl.css\";i:321;s:30:\"post-excerpt/style-rtl.min.css\";i:322;s:22:\"post-excerpt/style.css\";i:323;s:26:\"post-excerpt/style.min.css\";i:324;s:34:\"post-featured-image/editor-rtl.css\";i:325;s:38:\"post-featured-image/editor-rtl.min.css\";i:326;s:30:\"post-featured-image/editor.css\";i:327;s:34:\"post-featured-image/editor.min.css\";i:328;s:33:\"post-featured-image/style-rtl.css\";i:329;s:37:\"post-featured-image/style-rtl.min.css\";i:330;s:29:\"post-featured-image/style.css\";i:331;s:33:\"post-featured-image/style.min.css\";i:332;s:34:\"post-navigation-link/style-rtl.css\";i:333;s:38:\"post-navigation-link/style-rtl.min.css\";i:334;s:30:\"post-navigation-link/style.css\";i:335;s:34:\"post-navigation-link/style.min.css\";i:336;s:27:\"post-template/style-rtl.css\";i:337;s:31:\"post-template/style-rtl.min.css\";i:338;s:23:\"post-template/style.css\";i:339;s:27:\"post-template/style.min.css\";i:340;s:24:\"post-terms/style-rtl.css\";i:341;s:28:\"post-terms/style-rtl.min.css\";i:342;s:20:\"post-terms/style.css\";i:343;s:24:\"post-terms/style.min.css\";i:344;s:24:\"post-title/style-rtl.css\";i:345;s:28:\"post-title/style-rtl.min.css\";i:346;s:20:\"post-title/style.css\";i:347;s:24:\"post-title/style.min.css\";i:348;s:26:\"preformatted/style-rtl.css\";i:349;s:30:\"preformatted/style-rtl.min.css\";i:350;s:22:\"preformatted/style.css\";i:351;s:26:\"preformatted/style.min.css\";i:352;s:24:\"pullquote/editor-rtl.css\";i:353;s:28:\"pullquote/editor-rtl.min.css\";i:354;s:20:\"pullquote/editor.css\";i:355;s:24:\"pullquote/editor.min.css\";i:356;s:23:\"pullquote/style-rtl.css\";i:357;s:27:\"pullquote/style-rtl.min.css\";i:358;s:19:\"pullquote/style.css\";i:359;s:23:\"pullquote/style.min.css\";i:360;s:23:\"pullquote/theme-rtl.css\";i:361;s:27:\"pullquote/theme-rtl.min.css\";i:362;s:19:\"pullquote/theme.css\";i:363;s:23:\"pullquote/theme.min.css\";i:364;s:39:\"query-pagination-numbers/editor-rtl.css\";i:365;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:366;s:35:\"query-pagination-numbers/editor.css\";i:367;s:39:\"query-pagination-numbers/editor.min.css\";i:368;s:31:\"query-pagination/editor-rtl.css\";i:369;s:35:\"query-pagination/editor-rtl.min.css\";i:370;s:27:\"query-pagination/editor.css\";i:371;s:31:\"query-pagination/editor.min.css\";i:372;s:30:\"query-pagination/style-rtl.css\";i:373;s:34:\"query-pagination/style-rtl.min.css\";i:374;s:26:\"query-pagination/style.css\";i:375;s:30:\"query-pagination/style.min.css\";i:376;s:25:\"query-title/style-rtl.css\";i:377;s:29:\"query-title/style-rtl.min.css\";i:378;s:21:\"query-title/style.css\";i:379;s:25:\"query-title/style.min.css\";i:380;s:25:\"query-total/style-rtl.css\";i:381;s:29:\"query-total/style-rtl.min.css\";i:382;s:21:\"query-total/style.css\";i:383;s:25:\"query-total/style.min.css\";i:384;s:20:\"query/editor-rtl.css\";i:385;s:24:\"query/editor-rtl.min.css\";i:386;s:16:\"query/editor.css\";i:387;s:20:\"query/editor.min.css\";i:388;s:19:\"quote/style-rtl.css\";i:389;s:23:\"quote/style-rtl.min.css\";i:390;s:15:\"quote/style.css\";i:391;s:19:\"quote/style.min.css\";i:392;s:19:\"quote/theme-rtl.css\";i:393;s:23:\"quote/theme-rtl.min.css\";i:394;s:15:\"quote/theme.css\";i:395;s:19:\"quote/theme.min.css\";i:396;s:23:\"read-more/style-rtl.css\";i:397;s:27:\"read-more/style-rtl.min.css\";i:398;s:19:\"read-more/style.css\";i:399;s:23:\"read-more/style.min.css\";i:400;s:18:\"rss/editor-rtl.css\";i:401;s:22:\"rss/editor-rtl.min.css\";i:402;s:14:\"rss/editor.css\";i:403;s:18:\"rss/editor.min.css\";i:404;s:17:\"rss/style-rtl.css\";i:405;s:21:\"rss/style-rtl.min.css\";i:406;s:13:\"rss/style.css\";i:407;s:17:\"rss/style.min.css\";i:408;s:21:\"search/editor-rtl.css\";i:409;s:25:\"search/editor-rtl.min.css\";i:410;s:17:\"search/editor.css\";i:411;s:21:\"search/editor.min.css\";i:412;s:20:\"search/style-rtl.css\";i:413;s:24:\"search/style-rtl.min.css\";i:414;s:16:\"search/style.css\";i:415;s:20:\"search/style.min.css\";i:416;s:20:\"search/theme-rtl.css\";i:417;s:24:\"search/theme-rtl.min.css\";i:418;s:16:\"search/theme.css\";i:419;s:20:\"search/theme.min.css\";i:420;s:24:\"separator/editor-rtl.css\";i:421;s:28:\"separator/editor-rtl.min.css\";i:422;s:20:\"separator/editor.css\";i:423;s:24:\"separator/editor.min.css\";i:424;s:23:\"separator/style-rtl.css\";i:425;s:27:\"separator/style-rtl.min.css\";i:426;s:19:\"separator/style.css\";i:427;s:23:\"separator/style.min.css\";i:428;s:23:\"separator/theme-rtl.css\";i:429;s:27:\"separator/theme-rtl.min.css\";i:430;s:19:\"separator/theme.css\";i:431;s:23:\"separator/theme.min.css\";i:432;s:24:\"shortcode/editor-rtl.css\";i:433;s:28:\"shortcode/editor-rtl.min.css\";i:434;s:20:\"shortcode/editor.css\";i:435;s:24:\"shortcode/editor.min.css\";i:436;s:24:\"site-logo/editor-rtl.css\";i:437;s:28:\"site-logo/editor-rtl.min.css\";i:438;s:20:\"site-logo/editor.css\";i:439;s:24:\"site-logo/editor.min.css\";i:440;s:23:\"site-logo/style-rtl.css\";i:441;s:27:\"site-logo/style-rtl.min.css\";i:442;s:19:\"site-logo/style.css\";i:443;s:23:\"site-logo/style.min.css\";i:444;s:27:\"site-tagline/editor-rtl.css\";i:445;s:31:\"site-tagline/editor-rtl.min.css\";i:446;s:23:\"site-tagline/editor.css\";i:447;s:27:\"site-tagline/editor.min.css\";i:448;s:26:\"site-tagline/style-rtl.css\";i:449;s:30:\"site-tagline/style-rtl.min.css\";i:450;s:22:\"site-tagline/style.css\";i:451;s:26:\"site-tagline/style.min.css\";i:452;s:25:\"site-title/editor-rtl.css\";i:453;s:29:\"site-title/editor-rtl.min.css\";i:454;s:21:\"site-title/editor.css\";i:455;s:25:\"site-title/editor.min.css\";i:456;s:24:\"site-title/style-rtl.css\";i:457;s:28:\"site-title/style-rtl.min.css\";i:458;s:20:\"site-title/style.css\";i:459;s:24:\"site-title/style.min.css\";i:460;s:26:\"social-link/editor-rtl.css\";i:461;s:30:\"social-link/editor-rtl.min.css\";i:462;s:22:\"social-link/editor.css\";i:463;s:26:\"social-link/editor.min.css\";i:464;s:27:\"social-links/editor-rtl.css\";i:465;s:31:\"social-links/editor-rtl.min.css\";i:466;s:23:\"social-links/editor.css\";i:467;s:27:\"social-links/editor.min.css\";i:468;s:26:\"social-links/style-rtl.css\";i:469;s:30:\"social-links/style-rtl.min.css\";i:470;s:22:\"social-links/style.css\";i:471;s:26:\"social-links/style.min.css\";i:472;s:21:\"spacer/editor-rtl.css\";i:473;s:25:\"spacer/editor-rtl.min.css\";i:474;s:17:\"spacer/editor.css\";i:475;s:21:\"spacer/editor.min.css\";i:476;s:20:\"spacer/style-rtl.css\";i:477;s:24:\"spacer/style-rtl.min.css\";i:478;s:16:\"spacer/style.css\";i:479;s:20:\"spacer/style.min.css\";i:480;s:20:\"table/editor-rtl.css\";i:481;s:24:\"table/editor-rtl.min.css\";i:482;s:16:\"table/editor.css\";i:483;s:20:\"table/editor.min.css\";i:484;s:19:\"table/style-rtl.css\";i:485;s:23:\"table/style-rtl.min.css\";i:486;s:15:\"table/style.css\";i:487;s:19:\"table/style.min.css\";i:488;s:19:\"table/theme-rtl.css\";i:489;s:23:\"table/theme-rtl.min.css\";i:490;s:15:\"table/theme.css\";i:491;s:19:\"table/theme.min.css\";i:492;s:24:\"tag-cloud/editor-rtl.css\";i:493;s:28:\"tag-cloud/editor-rtl.min.css\";i:494;s:20:\"tag-cloud/editor.css\";i:495;s:24:\"tag-cloud/editor.min.css\";i:496;s:23:\"tag-cloud/style-rtl.css\";i:497;s:27:\"tag-cloud/style-rtl.min.css\";i:498;s:19:\"tag-cloud/style.css\";i:499;s:23:\"tag-cloud/style.min.css\";i:500;s:28:\"template-part/editor-rtl.css\";i:501;s:32:\"template-part/editor-rtl.min.css\";i:502;s:24:\"template-part/editor.css\";i:503;s:28:\"template-part/editor.min.css\";i:504;s:27:\"template-part/theme-rtl.css\";i:505;s:31:\"template-part/theme-rtl.min.css\";i:506;s:23:\"template-part/theme.css\";i:507;s:27:\"template-part/theme.min.css\";i:508;s:30:\"term-description/style-rtl.css\";i:509;s:34:\"term-description/style-rtl.min.css\";i:510;s:26:\"term-description/style.css\";i:511;s:30:\"term-description/style.min.css\";i:512;s:27:\"text-columns/editor-rtl.css\";i:513;s:31:\"text-columns/editor-rtl.min.css\";i:514;s:23:\"text-columns/editor.css\";i:515;s:27:\"text-columns/editor.min.css\";i:516;s:26:\"text-columns/style-rtl.css\";i:517;s:30:\"text-columns/style-rtl.min.css\";i:518;s:22:\"text-columns/style.css\";i:519;s:26:\"text-columns/style.min.css\";i:520;s:19:\"verse/style-rtl.css\";i:521;s:23:\"verse/style-rtl.min.css\";i:522;s:15:\"verse/style.css\";i:523;s:19:\"verse/style.min.css\";i:524;s:20:\"video/editor-rtl.css\";i:525;s:24:\"video/editor-rtl.min.css\";i:526;s:16:\"video/editor.css\";i:527;s:20:\"video/editor.min.css\";i:528;s:19:\"video/style-rtl.css\";i:529;s:23:\"video/style-rtl.min.css\";i:530;s:15:\"video/style.css\";i:531;s:19:\"video/style.min.css\";i:532;s:19:\"video/theme-rtl.css\";i:533;s:23:\"video/theme-rtl.min.css\";i:534;s:15:\"video/theme.css\";i:535;s:19:\"video/theme.min.css\";}}","on"),
("126","recovery_keys","a:1:{s:22:\"3V4UjXerHETqbug316VoGs\";a:2:{s:10:\"hashed_key\";s:49:\"$generic$zyM1iZvgQYqrZab_0vPJEofh4-ib_sfmMoYCOF1E\";s:10:\"created_at\";i:1758090587;}}","off"),
("127","theme_mods_twentytwentyfive","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1756880735;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","off"),
("128","_transient_wp_styles_for_blocks","a:2:{s:4:\"hash\";s:32:\"1831f4a91c8f95e8a4a207c2e9318038\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}","on"),
("141","can_compress_scripts","0","on"),
("156","finished_updating_comment_type","1","auto"),
("167","current_theme","Dentia","auto"),
("168","theme_mods_dentia","a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:15;}s:18:\"custom_css_post_id\";i:-1;}","on"),
("169","theme_switched","","auto"),
("172","elementor_cpt_support","a:5:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:12:\"pxl-template\";i:3;s:9:\"portfolio\";i:4;s:7:\"service\";}","auto"),
("174","recovery_mode_email_last_sent","1758090587","auto"),
("175","suncode_dentia_options","a:14:{s:13:\"elementor_css\";i:1;s:9:\"admin_css\";i:1;s:9:\"login_css\";i:1;s:12:\"adminbar_css\";i:1;s:11:\"woo_address\";i:1;s:15:\"elementor_fonts\";i:1;s:15:\"revslider_fonts\";i:1;s:18:\"redux_custom_fonts\";i:1;s:7:\"rtl_css\";i:1;s:19:\"translations_loader\";i:1;s:19:\"trans_pixelart-core\";i:1;s:25:\"trans_ultimate-addons-cf7\";i:1;s:15:\"trans_revslider\";i:1;s:20:\"trans_duplicator-pro\";i:1;}","auto"),
("176","dentia-theme_purchase_code_status","valid","auto"),
("177","dentia_purchase_code_status","valid","auto"),
("182","avatar_default_wp_user_avatar","","auto"),
("183","wp_user_avatar_allow_upload","0","auto"),
("184","wp_user_avatar_disable_um_avatars","0","auto"),
("185","wp_user_avatar_force_file_uploader","0","auto"),
("186","wp_user_avatar_disable_gravatar","0","auto"),
("187","wp_user_avatar_edit_avatar","1","auto"),
("188","wp_user_avatar_resize_crop","0","auto"),
("189","wp_user_avatar_resize_h","96","auto"),
("190","wp_user_avatar_resize_upload","0","auto"),
("191","wp_user_avatar_resize_w","96","auto"),
("192","wp_user_avatar_tinymce","1","auto"),
("193","wp_user_avatar_upload_size_limit","0","auto"),
("197","widget_wp_user_avatar_profile","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("198","wp_user_avatar_default_avatar_updated","1","auto"),
("199","wp_user_avatar_users_updated","1","auto"),
("200","wp_user_avatar_media_updated","1","auto"),
("203","widget_pxl_author_info_widget","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("204","widget_pxl_recent_posts","a:2:{i:1;a:3:{s:5:\"title\";s:28:\"نوشته‌های جدید\";s:6:\"number\";i:4;s:7:\"post_in\";s:6:\"recent\";}s:12:\"_multiwidget\";i:1;}","auto"),
("205","widget_pxl_elementor_box","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("207","elementor_active_kit","8","on"),
("208","elementor_font_display","swap","auto"),
("212","elementor_landing_pages_activation","0","auto"),
("213","elementor_checklist","{\"last_opened_timestamp\":1756884557,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":true}","auto"),
("214","elementor_version","3.32.1","auto"),
("215","elementor_install_history","a:4:{s:6:\"3.31.3\";i:1756883616;s:6:\"3.31.5\";i:1757843601;s:6:\"3.32.0\";i:1757999545;s:6:\"3.32.1\";i:1758051139;}","auto"),
("216","elementor_events_db_version","1.0.0","off"),
("219","elementor_experiment-e_font_icon_svg","inactive","on"),
("226","_elementor_installed_time","1756883619","auto"),
("227","elementor_connect_site_key","aec2c0632fda802e138743c9fb6343bd","auto"),
("228","elementor_remote_info_library","a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}","off"),
("229","elementor_remote_info_feed_data","a:3:{i:0;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:67:\"What Is an MCP? The AI Breakthrough Web Creators Shouldn’t Ignore\";s:7:\"excerpt\";s:143:\"Discover how Model Context Protocol (MCP) is shaping AI-tool interaction and redefining how pro web creators build, manage, and scale websites.\";s:7:\"created\";i:1754310811;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/mcp-explained-for-web-creators/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:100:\"Introducing Elementor 3.30: new Editor V4 capabilities, full Website Templates in the cloud, & more!\";s:7:\"excerpt\";s:361:\"Elementor 3.30 is here and it includes upgrades that accelerate your workflow, bring you a step closer to the full power of Editor V4, and help you deliver beautiful, accessible websites faster than ever. From advanced styling tools and smarter editing to full Website Templates in the cloud, this release enhances both the way you design and the way you scale.\";s:7:\"created\";i:1751974442;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-330-v4-alpha-website-templates/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}","off"),
("232","wpcf7","a:2:{s:7:\"version\";s:5:\"6.1.1\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1756883620;s:7:\"version\";s:5:\"6.1.1\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}","auto"),
("244","pxl_theme_options","a:57:{s:8:\"last_tab\";s:0:\"\";s:13:\"primary_color\";s:0:\"\";s:15:\"secondary_color\";s:0:\"\";s:10:\"link_color\";a:3:{s:7:\"regular\";s:0:\"\";s:5:\"hover\";s:0:\"\";s:6:\"active\";s:0:\"\";}s:14:\"gradient_color\";a:2:{s:4:\"from\";s:0:\"\";s:2:\"to\";s:0:\"\";}s:15:\"body_text_color\";s:0:\"\";s:18:\"heading_text_color\";s:0:\"\";s:7:\"favicon\";a:5:{s:3:\"url\";s:63:\"https://dentia.sunthemes.ir/wp-content/uploads/2025/08/logo.png\";s:2:\"id\";s:2:\"24\";s:6:\"height\";s:2:\"20\";s:5:\"width\";s:2:\"20\";s:9:\"thumbnail\";s:63:\"https://dentia.sunthemes.ir/wp-content/uploads/2025/08/logo.png\";}s:20:\"mouse_move_animation\";s:1:\"0\";s:16:\"mouse_move_style\";s:13:\"style-default\";s:11:\"site_loader\";s:1:\"1\";s:12:\"loader_style\";s:13:\"style-default\";s:11:\"loader_text\";s:0:\"\";s:17:\"loader_text_color\";s:7:\"primary\";s:13:\"cookie_policy\";s:4:\"hide\";s:25:\"cookie_policy_description\";s:0:\"\";s:30:\"cookie_policy_description_typo\";a:8:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:21:\"cookie_policy_btntext\";s:0:\"\";s:18:\"cookie_policy_link\";s:0:\"\";s:9:\"subscribe\";s:4:\"hide\";s:12:\"popup_effect\";s:4:\"fade\";s:13:\"header_layout\";s:2:\"33\";s:20:\"header_layout_sticky\";s:0:\"\";s:13:\"sticky_scroll\";s:14:\"pxl-sticky-stb\";s:14:\"mobile_display\";s:4:\"show\";s:12:\"mobile_style\";s:5:\"light\";s:6:\"logo_m\";a:5:{s:3:\"url\";s:71:\"https://dentia.sunthemes.ir/wp-content/uploads/2025/08/logo-black-1.png\";s:2:\"id\";s:4:\"2637\";s:6:\"height\";s:2:\"44\";s:5:\"width\";s:3:\"185\";s:9:\"thumbnail\";s:78:\"https://dentia.sunthemes.ir/wp-content/uploads/2025/08/logo-black-1-150x44.png\";}s:11:\"logo_height\";a:2:{s:6:\"height\";s:0:\"\";s:5:\"units\";s:2:\"px\";}s:13:\"search_mobile\";s:1:\"1\";s:25:\"search_placeholder_mobile\";s:0:\"\";s:7:\"pt_mode\";s:2:\"df\";s:13:\"footer_layout\";s:4:\"1443\";s:13:\"back_totop_on\";s:1:\"1\";s:12:\"footer_fixed\";s:3:\"off\";s:16:\"blog_sidebar_pos\";s:5:\"right\";s:12:\"archive_date\";s:1:\"1\";s:16:\"archive_category\";s:1:\"1\";s:22:\"archive_excerpt_length\";s:0:\"\";s:21:\"archive_readmore_text\";s:0:\"\";s:16:\"post_sidebar_pos\";s:5:\"right\";s:14:\"pxl_post_title\";s:7:\"default\";s:19:\"pxl_post_title_text\";s:23:\"جزئیات نوشته\";s:16:\"post_comments_on\";s:1:\"1\";s:19:\"pxl_body_typography\";s:11:\"google-font\";s:9:\"font_body\";a:9:{s:11:\"font-family\";s:5:\"Peyda\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:5:\"false\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:22:\"pxl_heading_typography\";s:11:\"google-font\";s:12:\"font_heading\";a:7:{s:11:\"font-family\";s:5:\"Peyda\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:5:\"false\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:13:\"theme_default\";a:4:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:7:\"subsets\";s:0:\"\";}s:17:\"portfolio_display\";s:1:\"1\";s:14:\"portfolio_slug\";s:0:\"\";s:14:\"portfolio_name\";s:17:\"نمونه کار\";s:22:\"archive_portfolio_link\";s:0:\"\";s:15:\"service_display\";s:1:\"1\";s:12:\"service_slug\";s:0:\"\";s:12:\"service_name\";s:10:\"خدمات\";s:20:\"archive_service_link\";s:0:\"\";s:13:\"ptitle_layout\";s:1:\"1\";}","auto"),
("245","pxl_theme_options-transients","a:4:{s:14:\"changed_values\";a:3:{s:9:\"font_body\";a:9:{s:11:\"font-family\";s:5:\"Peyda\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:5:\"false\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:12:\"font_heading\";a:7:{s:11:\"font-family\";s:5:\"Peyda\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:13:\"ptitle_layout\";s:1:\"1\";}s:9:\"last_save\";i:1758081515;s:13:\"last_compiler\";i:1758081436;s:11:\"last_import\";i:1758081436;}","auto"),
("252","widget_mc4wp_form_widget","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("258","mc4wp_version","4.10.7","auto"),
("262","mc4wp_flash_messages","a:0:{}","off"),
("274","elementor_log","a:18:{s:32:\"19bae9e5149dd3d6814717fafe229de5\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-09-03 10:45:42\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:55:\"Attempt to read property &quot;post_title&quot; on null\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2025-09-03 10:45:42\";i:1;s:19:\"2025-09-03 10:45:42\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:45:\"Attempt to read property \"post_title\" on null\";s:4:\"file\";s:99:\"/home/suntheme/public_html/dentia/wp-content/plugins/elementor/core/isolation/elementor-adapter.php\";s:4:\"line\";i:28;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:99:\"/home/suntheme/public_html/dentia/wp-content/plugins/elementor/core/isolation/elementor-adapter.php\";s:7:\"\0*\0line\";i:28;}s:32:\"8c714fac5f337ed34edbecea3ee69a2d\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-09-03 10:11:30\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:107:\"Failed to execute &#039;querySelector&#039; on &#039;Document&#039;: &#039;#&#039; is not a valid selector.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:8;s:14:\"\0*\0times_dates\";a:8:{i:0;s:19:\"2025-09-03 10:11:30\";i:1;s:19:\"2025-09-03 10:11:30\";i:2;s:19:\"2025-09-03 10:11:42\";i:3;s:19:\"2025-09-03 10:11:42\";i:4;s:19:\"2025-09-16 11:39:50\";i:5;s:19:\"2025-09-16 11:39:50\";i:6;s:19:\"2025-09-16 11:43:14\";i:7;s:19:\"2025-09-16 11:43:14\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1756894290\";s:7:\"message\";s:77:\"Failed to execute \'querySelector\' on \'Document\': \'#\' is not a valid selector.\";s:3:\"url\";s:91:\"https://dentia.sunthemes.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.31.3\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:7:\"1262868\";}s:7:\"\0*\0file\";s:91:\"https://dentia.sunthemes.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.31.3\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:7:\"1262868\";}s:32:\"7913213b0b0f12529fa740685d4d8f94\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-14 13:23:21\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-14 13:23:21\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"98cd81f7f9c023e342b6bf393a5f34eb\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-14 13:23:21\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-14 13:23:21\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"0bfb4b1eb8b90d41a53186cf220c0e38\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-14 13:23:21\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-14 13:23:21\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"43f854a924b79f4a689fa7f6d7e60c30\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-14 13:23:21\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.31.3\";s:2:\"to\";s:6:\"3.31.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-14 13:23:21\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.31.3\";s:2:\"to\";s:6:\"3.31.5\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"f4866aa705581c5b53b5846be11af3c3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-14 13:23:21\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.31.3\";s:2:\"to\";s:6:\"3.31.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-14 13:23:21\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.31.3\";s:2:\"to\";s:6:\"3.31.5\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"f99eb5ed417492ef28b6b3000203a316\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-09-14 09:57:14\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:61:\"Cannot read properties of undefined (reading &#039;get&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-14 09:57:14\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1757843834\";s:7:\"message\";s:51:\"Cannot read properties of undefined (reading \'get\')\";s:3:\"url\";s:91:\"https://dentia.sunthemes.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.31.5\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:5:\"22587\";}s:7:\"\0*\0file\";s:91:\"https://dentia.sunthemes.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.31.5\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:5:\"22587\";}s:32:\"0bae31ebd593a69fdbf0ca0ef321530f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-16 08:42:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-16 08:42:25\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"ed54dc65ff48305b97f7dba988430da9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-16 08:42:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-16 08:42:25\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"3e23b8aae0513c7c4a2e837107eb023d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-16 08:42:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-16 08:42:25\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"51f578503a77c654ec2519a030e929d6\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-16 08:42:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.31.5\";s:2:\"to\";s:6:\"3.32.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-16 08:42:25\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.31.5\";s:2:\"to\";s:6:\"3.32.0\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"9cbd6b4bad10870c329d7611af757536\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-16 08:42:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.31.5\";s:2:\"to\";s:6:\"3.32.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-16 08:42:25\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.31.5\";s:2:\"to\";s:6:\"3.32.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"bafe10d868f50c97e1e32139a9c94f2e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-16 08:42:26\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.31.5\";s:2:\"to\";s:6:\"3.32.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-16 08:42:26\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.31.5\";s:2:\"to\";s:6:\"3.32.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"5237239e30d5ec37e9614421d84e26a9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-16 23:02:19\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-16 23:02:19\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"f2c70cd528cb4dbc98a89959a4204057\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-16 23:02:19\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-16 23:02:19\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"21dbe9d7f02df107118e0da3e48791b5\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-16 23:02:19\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-16 23:02:19\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"9bf3383f233d3a67c4265bb115723ae3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-16 23:02:19\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.32.0\";s:2:\"to\";s:6:\"3.32.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-16 23:02:19\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.32.0\";s:2:\"to\";s:6:\"3.32.1\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}}","off"),
("275","wp_calendar_block_has_published_posts","1","auto"),
("276","category_children","a:0:{}","auto"),
("277","portfolio-category_children","a:0:{}","auto"),
("278","service-category_children","a:0:{}","auto"),
("279","elementor_library_category_children","a:0:{}","auto"),
("281","woocommerce_shop_page_id","10","auto"),
("282","woocommerce_cart_page_id","11","auto"),
("283","woocommerce_checkout_page_id","12","auto"),
("284","woocommerce_myaccount_page_id","13","auto"),
("285","elementor_css_print_method","external","auto"),
("286","pxl_import_demo_id","dentia","auto"),
("289","_elementor_element_cache_unique_id","9f9b7b4eca1f2faa99bc308d2bca713d","auto"),
("293","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","off"),
("297","e_editor_counter","64","auto"),
("298","_elementor_free_to_pro_upsell","a:2:{s:7:\"timeout\";i:1758164100;s:5:\"value\";s:723:\"[{\"id\":\"animated_headline\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/animated_headline.jpg\"},{\"id\":\"video_playlist\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/video_playlist.jpg\"},{\"id\":\"cta\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/cta.jpg\"},{\"id\":\"testimonial_widget\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/testimonial_widget.jpg\"},{\"id\":\"image_carousel\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/image_carousel.jpg\"},{\"id\":\"connect-pro-upgrade\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/connect-pro-upgrade.jpg\"}]\";}","off"),
("299","_elementor_notifications_data","a:2:{s:7:\"timeout\";i:1758164100;s:5:\"value\";s:18404:\"[{\"id\":\"variables-3.31\",\"title\":\"Scalable design with Variables\",\"description\":\"Define once, reuse everywhere. Color & Font Variables help you build consistent, scalable design systems that update globally and are perfect for large sites or teams.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-variables.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"host-special-offer\",\"title\":\"Host with Elementor, Get Unified Support for Building & Hosting\",\"description\":\"Advance to Elementor\'s Cloud Hosting powered by Google Cloud and Cloudflare. Use the coupon CLOUDPLUSSPECIAL2025 to get Host Cloud Plus at the price of Host Cloud.\",\"topic\":\"Special offer: Elementor Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/host_coupon.png\",\"chipTags\":[\"Cloud Hosting\"],\"cta\":\"Get it Now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/host-whats-new-host-discount\\/\"},{\"id\":\"filters-3.31\",\"title\":\"Visual effects with Filters and Backdrop Filters\",\"description\":\"Apply multiple Filters like blur, brightness, and contrast. Stack, reorder, and preview in real time without writing a line of code.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-filters.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-assistant\",\"title\":\"New! Fix accessibility issues with Ally Assistant\",\"description\":\"Scan any page for accessibility issues and fix them in one click. From color contrast to missing alt text, Ally Assistant provides guided steps or AI-powered fixes to make your site more inclusive.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-assistant.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Scan for free\",\"ctaLink\":\"http:\\/\\/go.elementor.com\\/acc-assistant-launch-whats-new\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"classes-3.31\",\"title\":\"Smarter Class Manager tools\",\"description\":\"Quickly locate and manage Global Classes with usage counts, a new locator panel, and full class search. Perfect for scaling and refactoring complex design systems.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-classes.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"send-notification-august\",\"title\":\"All Your Assets, One Library\",\"description\":\"Save time and skip the re-uploads - now you can pull images straight from your WordPress Media Library into Send. Faster, simpler, and built for WordPress.\",\"topic\":\"Send: Email & SMS built for WooCommerce\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aug_send.png\",\"chipTags\":[\"Cart abandonment\"],\"cta\":\"Upload Your Assets\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/ML_WN\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"send-app\\/send-app.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-attributes\\/\"},{\"id\":\"classes-3.30\",\"title\":\"Better class control\",\"description\":\"Get popovers with your class name, breakpoint, state and possible conflicts. Plus, the exact class names you define are now reflected in the code, making debugging and working with external tools easier!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/classes-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.30-cloud-websites\\/\"},{\"id\":\"tools-3.30\",\"title\":\"Essential Editor tools\",\"description\":\"V4 now includes a long list of essential V3 capabilities, re-engineered to fit the new framework - IDs, custom unit, anchor offset, display none, object fit, clear icons and more!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/tools-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"youtube-3.30\",\"title\":\"YouTube Element\",\"description\":\"The new YouTube Element is purpose-built to support V4 capabilities with faster rendering, better performance, and familiar controls like autoplay, loop, mute, and aspect ratio.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/youtube-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"host-google-cloud\",\"title\":\"Deliver fast, secure websites at scale - free migration included!\",\"description\":\"Host your site on Elementor\\u2019s infrastructure - built for speed, security, and scale. Powered by Google Cloud, with free migration and 24\\/7 expert support.\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/host-google-cloud.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/elementor-host-google-cloud\",\"readMoreText\":\"Read More\"},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates\\/\"},{\"id\":\"classes-3.29\",\"title\":\"Classes: Style Once, Apply Everywhere\",\"description\":\"Create Classes to define styling patterns once and apply them across your entire site with a single click. Add States for stunning hover and focus effects\\u2014no coding needed!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-classes.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"style-tab-3.29\",\"title\":\"Consistent Styling Everywhere\",\"description\":\"Every V4 element shares the same styling capabilities in the same logical order and location. Plus, we\'ve streamlined from 3 tabs to just 2\\u2014content in one, styling in the other!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-style-tab.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"responsive-3.29\",\"title\":\"Fully Responsive Design\",\"description\":\"With Editor V4, every single style property can be customized per device. Complete creative control for desktop, tablet, and mobile!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-responsive.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"performance-3.29\",\"title\":\"Blazing fast performance\",\"description\":\"In Editor V4, each element uses one clean div instead of multiple nested divs like in the current version\\u2014your sites will load lightning-fast with cleaner code!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-performance.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"migration-host\",\"title\":\"Move to Better Cloud Hosting, Painlessly\",\"description\":\"Migrate your Elementor website for free to a home that\\u2019s perfect for it, in minutes, with a combination of\\u2028advanced automation and free expert support\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/migration-host.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\",\"readMoreText\":\"Learn More\",\"cta\":\"Migrate for free\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"introduction_meta\",\"meta\":\"ai_get_started\"}]],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Start Free Trial\",\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"hello-biz-contact\",\"title\":\"New Contact Widget, Visual Layout Presets & more\",\"description\":\"Hello Biz just got an update! Explore the new Contact Widget, Visual Layout Presets, Form Submissions integration, and fresh new kits.\",\"topic\":\"Hello Biz\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/hello-biz-contact.png\",\"chipTags\":[\"New Features\"],\"link\":\"https:\\/\\/go.elementor.com\\/hello-biz-updates\",\"readMoreText\":\"Learn More\"},{\"id\":\"ai-site-planner-colors\",\"title\":\"Style Your Wireframe, Speed Up Your Store Build\",\"description\":\"Site Planner now lets you style your wireframe with fonts and colors - instantly visualizing your site\\u2019s look and feel. Plus, it predesigns pages for WooCommerce like Cart and Checkout, so you can dive straight into customizations\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/site-planner-colors.png\",\"chipTags\":[\"New Feature\"],\"link\":\"http:\\/\\/www.elementor.com\\/ai-site-planner\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-notification\",\"title\":\"Just released! Ally - a new plugin for web accessibility & usability\",\"description\":\"Ally simplifies the complexities of making your website more accessible. With new regulations here and coming, making your website more usable and inclusive is no longer just an option, but a must.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get it free\",\"ctaLink\":\"https:\\/\\/wordpress.org\\/plugins\\/pojo-accessibility\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"ai-site-planner\",\"title\":\"Instant Sitemaps & Wireframes\",\"description\":\"Get your website plan in minutes with AI Site Planner. Describe your desired site and AI will generate a sitemap, brief and wireframe populated with initial content, ready for you to customize.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aI-site-planner.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-site-planner\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"grid-span-3.27\",\"title\":\"Design Grid layouts that fit your exact vision\",\"description\":\"Advanced column and row span controls give you the power to design Grid Container layouts that fit your exact vision.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/grid-span-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-grid-span-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"local-fonts-3.27\",\"title\":\"Load Google Fonts safer and faster\",\"description\":\"Once enabled, Google Fonts are served directly from your server, streamlining the loading process and enhancing security.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/local-google-fonts-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-local-fonts-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"video-shorts-3.27\",\"title\":\"Showcase short-form, vertical videos\",\"description\":\"The Video widget now supports YouTube Shorts in a vertical 9:16 ratio, the go-to format for engaging audiences.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/video-shorts-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-video-shorts-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"dynamic-off-canvas-3.26\",\"title\":\"Dynamic Off-Canvas for Loop Grids\",\"description\":\"Create richer, more interactive designs by linking Dynamic Content to the Off Canvas widget, delivering seamless user experiences.\",\"topic\":\"Elementor Pro 3.26\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas-loop-grids.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.26-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"dynamic-off-canvas-3.26\",\"title\":\"Dynamic Off-Canvas for Loop Grids\",\"description\":\"Create richer, more interactive designs by linking Dynamic Content to the Off Canvas widget, delivering seamless user experiences.\",\"topic\":\"Elementor Pro 3.26\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas-loop-grids.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.26-loop-off-canvas\\/\"},{\"id\":\"image-optimizer-3.19\",\"title\":\"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.\",\"description\":\"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.\",\"topic\":\"Image Optimizer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get the Image Optimizer\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"image-optimization\\/image-optimization.php\"}]]},{\"id\":\"5-star-rating-prompt\",\"title\":\"Love the New Features? Let Us Know with 5 Stars!\",\"description\":\"Help spread the word by telling the world what you love about Elementor.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png\",\"cta\":\"Leave a Review\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/\"},{\"id\":\"site-mailer-introducing\",\"title\":\"Introducing Site Mailer\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"topic\":\"Site Mailer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/Site-mailer.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/sm-wp-dash-whatsnew\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"site-mailer\\/site-mailer.php\"}]]}]\";}","off"),
("302","_elementor_settings_update_time","1756884593","auto"),
("303","elementor_disable_color_schemes","yes","auto"),
("304","elementor_disable_typography_schemes","yes","auto"),
("305","elementor_allow_tracking_last_update","1756884593","auto"),
("306","elementor_allow_tracking","no","auto"),
("307","elementor_google_maps_api_key","","auto"),
("308","elementor_editor_break_lines","","auto"),
("309","elementor_unfiltered_files_upload","","auto"),
("310","elementor_google_font","0","auto"),
("311","elementor_load_fa4_shim","","auto"),
("312","elementor_meta_generator_tag","","auto"),
("313","elementor_optimized_image_loading","1","auto"),
("314","elementor_optimized_gutenberg_loading","1","auto"),
("315","elementor_lazy_load_background_images","1","auto"),
("316","elementor_element_cache_ttl","24","auto"),
("317","elementor_experiment-cloud-library","default","auto"),
("318","elementor_experiment-additional_custom_breakpoints","default","auto"),
("319","elementor_experiment-container","default","auto"),
("320","elementor_experiment-e_optimized_markup","default","auto"),
("321","elementor_experiment-nested-elements","default","auto"),
("322","elementor_experiment-e_element_cache","default","auto"),
("325","auto_update_redux_google_fonts","1","auto"),
("332","_site_transient_wp_plugin_dependencies_plugin_data","a:0:{}","off"),
("343","recently_activated","a:1:{s:47:\"better-search-replace/better-search-replace.php\";i:1758109702;}","off"),
("911","pxl_page_options","a:27:{s:17:\"_wp_page_template\";s:7:\"default\";s:13:\"header_layout\";s:4:\"1594\";s:20:\"header_layout_sticky\";s:2:\"-1\";s:6:\"logo_m\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:12:\"mobile_style\";s:7:\"inherit\";s:6:\"p_menu\";s:0:\"\";s:13:\"sticky_scroll\";s:2:\"-1\";s:7:\"pt_mode\";s:4:\"none\";s:13:\"custom_ptitle\";s:0:\"\";s:16:\"page_sidebar_pos\";s:1:\"0\";s:15:\"content_spacing\";a:3:{s:5:\"units\";s:2:\"px\";s:11:\"padding-top\";s:1:\"0\";s:14:\"padding-bottom\";s:1:\"0\";}s:13:\"footer_layout\";s:2:\"-1\";s:14:\"p_footer_fixed\";s:7:\"inherit\";s:13:\"body_bg_color\";s:0:\"\";s:13:\"primary_color\";s:0:\"\";s:15:\"secondary_color\";s:0:\"\";s:14:\"gradient_color\";a:2:{s:4:\"from\";s:0:\"\";s:2:\"to\";s:0:\"\";}s:17:\"body_custom_class\";s:0:\"\";s:20:\"_elementor_edit_mode\";s:7:\"builder\";s:24:\"_elementor_template_type\";s:7:\"wp-page\";s:18:\"_elementor_version\";s:6:\"3.32.0\";s:15:\"_elementor_data\";s:76806:\"[{\"id\":\"5161d23\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"slideshow\",\"background_slideshow_gallery\":[{\"id\":1485,\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/1-min-e1758004018967.jpg\"},{\"id\":1486,\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/2-min-e1758004028449.jpg\"}],\"background_slideshow_background_size\":\"cover\",\"background_slideshow_background_position\":\"center center\",\"background_slideshow_lazyload\":\"yes\",\"background_overlay_background\":\"gradient\",\"background_overlay_color\":\"#000A5B66\",\"background_overlay_color_stop\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"background_overlay_color_b\":\"#000A5B\",\"background_overlay_gradient_angle\":{\"unit\":\"deg\",\"size\":-90,\"sizes\":[]},\"background_overlay_opacity\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"padding\":{\"unit\":\"px\",\"top\":\"220\",\"right\":\"15\",\"bottom\":\"192\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"background_slideshow_slide_transition\":\"slide_right\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"73\",\"right\":\"15\",\"bottom\":\"70\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"0b31933\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"bd11b0a\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0644\\u0628\\u062e\\u0646\\u062f\\u0647\\u0627\\u06cc \\u0632\\u06cc\\u0628\\u0627\\u062a\\u0631 \\u0628\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u062a\\u062e\\u0635\\u0635\\u06cc \\u0648 \\u0644\\u0645\\u0633 \\u0645\\u0644\\u0627\\u06cc\\u0645\",\"sub_title\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647\",\"h_width\":{\"unit\":\"%\",\"size\":49,\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":55,\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h1\",\"title_color\":\"#FFFFFF\",\"sub_title_color\":\"#FFFFFF\",\"sub_title_typography_typography\":\"custom\",\"sub_title_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"sub_title_typography_font_weight\":\"600\",\"sub_title_typography_line_height\":{\"unit\":\"em\",\"size\":1.5,\"sizes\":[]},\"sub_title_typography_line_height_laptop\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"sub_title_typography_line_height_tablet_extra\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"sub_title_typography_line_height_mobile_extra\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\"},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"c162dc7\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0631\\u0632\\u0631\\u0648 \\u0646\\u0648\\u0628\\u062a\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/booking\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"btn_bg_color\":\"#02010100\",\"border_type\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"border_color\":\"#FFFFFF\",\"color_hover\":\"#FFFFFF\",\"btn_bg_color_hover\":\"#000A5B\",\"btn_bg_color_active\":\"#000A5B\",\"btn_bg_color_focus\":\"#000A5B\",\"border_color_hover\":\"#000A5B\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"30\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_button\"},{\"id\":\"9d1bee4\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_align_items\":\"center\",\"flex_gap\":{\"column\":\"15\",\"row\":\"15\",\"isLinked\":true,\"unit\":\"px\",\"size\":15},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"animation\":\"fadeInUp\",\"animation_delay\":600,\"flex_wrap\":\"wrap\"},\"elements\":[{\"id\":\"ac6b6cf\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<div class=\\\"me-3\\\">\\u0631\\u062a\\u0628\\u0647\\u200c\\u0628\\u0646\\u062f\\u06cc \\u06af\\u0648\\u06af\\u0644<\\/div>\",\"text_color\":\"#F8F9FA\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"05b35cf\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<div class=\\\"me-3\\\"><div class=\\\"me-3\\\">5.0<\\/div><\\/div>\",\"text_color\":\"#F8F9FA\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"bd513bf\",\"elType\":\"widget\",\"settings\":{\"icons\":[{\"_id\":\"e1ef7bc\",\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"}},{\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"},\"_id\":\"1fbf14e\"},{\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"},\"_id\":\"98ed77d\"},{\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"},\"_id\":\"1685a7b\"},{\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"},\"_id\":\"67aa573\"}],\"color\":\"#FEC42C\",\"icon_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"icon_space\":{\"unit\":\"px\",\"size\":2,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_icon\"},{\"id\":\"6531703\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<div class=\\\"me-3\\\"><div class=\\\"me-3\\\"><div class=\\\"me-3\\\">\\u0628\\u0631 \\u0627\\u0633\\u0627\\u0633 \\u06f2\\u06f3 \\u0647\\u0632\\u0627\\u0631 \\u0646\\u0642\\u062f \\u0648 \\u0628\\u0631\\u0631\\u0633\\u06cc<\\/div><\\/div><\\/div>\",\"text_color\":\"#F8F9FA\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false},{\"id\":\"af13e9f\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#000A5B\",\"padding\":{\"unit\":\"px\",\"top\":\"25\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_align_items\":\"center\",\"flex_direction_mobile_extra\":\"column\"},\"elements\":[{\"id\":\"f6f14ff\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"2f08b27\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"15\",\"bottom\":\"0\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_align_items\":\"center\",\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"3627c0a\",\"elType\":\"widget\",\"settings\":{\"layout\":\"2\",\"pxl_icon\":{\"value\":\"fas fa-phone-alt\",\"library\":\"fa-solid\"},\"title\":\"\\u0628\\u0647 \\u062e\\u062f\\u0645\\u0627\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0646\\u06cc\\u0627\\u0632 \\u062f\\u0627\\u0631\\u06cc\\u062f\\u061f\",\"desc\":\"\\u062a\\u0645\\u0627\\u0633: 021123456789\",\"title_color\":\"#FFFFFF\",\"icon_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_width\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"desc_color\":\"#FFFFFF99\",\"icon_color\":\"#4A7DC2\",\"icon_bg_color\":\"#02010100\",\"title_bottom\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"inner_space\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"4a79de0\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"0\",\"left\":\"1\",\"isLinked\":false},\"border_color\":\"#FFFFFF80\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"border_width_mobile_extra\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"1\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"91829d8\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"15\",\"bottom\":\"0\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"pxl_parallax_bg_position\":\"\",\"pxl_parallax_bg_position_laptop\":\"\",\"pxl_parallax_bg_position_tablet_extra\":\"\",\"pxl_parallax_bg_position_tablet\":\"\",\"pxl_parallax_bg_position_mobile_extra\":\"\",\"pxl_parallax_bg_position_mobile\":\"\",\"pxl_parallax_bg_pos_custom_x\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size\":\"\",\"pxl_parallax_bg_size_laptop\":\"\",\"pxl_parallax_bg_size_tablet_extra\":\"\",\"pxl_parallax_bg_size_tablet\":\"\",\"pxl_parallax_bg_size_mobile_extra\":\"\",\"pxl_parallax_bg_size_mobile\":\"\",\"pxl_parallax_bg_size_custom\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"pxl_parallax_bg_size_custom_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_overlay_img_position\":\"\",\"pxl_overlay_img_position_laptop\":\"\",\"pxl_overlay_img_position_tablet_extra\":\"\",\"pxl_overlay_img_position_tablet\":\"\",\"pxl_overlay_img_position_mobile_extra\":\"\",\"pxl_overlay_img_position_mobile\":\"\",\"pxl_overlay_img_right_position\":\"\",\"pxl_overlay_img_right_position_laptop\":\"\",\"pxl_overlay_img_right_position_tablet_extra\":\"\",\"pxl_overlay_img_right_position_tablet\":\"\",\"pxl_overlay_img_right_position_mobile_extra\":\"\",\"pxl_overlay_img_right_position_mobile\":\"\",\"row_effect_images\":[],\"flex_align_items\":\"center\"},\"elements\":[{\"id\":\"b6383c4\",\"elType\":\"widget\",\"settings\":{\"layout\":\"2\",\"pxl_icon\":{\"value\":\"fas fa-clock\",\"library\":\"fa-solid\"},\"title\":\"\\u0633\\u0627\\u0639\\u0627\\u062a \\u06a9\\u0627\\u0631\\u06cc\",\"desc\":\"\\u0647\\u0631 \\u0631\\u0648\\u0632 \\u0627\\u0632 08:00 \\u062a\\u0627 20:00\",\"title_color\":\"#FFFFFF\",\"icon_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_width\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"desc_color\":\"#FFFFFF99\",\"icon_color\":\"#4A7DC2\",\"icon_bg_color\":\"#02010100\",\"title_bottom\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"inner_space\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"_element_width_mobile\":\"inherit\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"6a5100f\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"4eaeb3c\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"15\",\"bottom\":\"0\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"pxl_parallax_bg_position\":\"\",\"pxl_parallax_bg_position_laptop\":\"\",\"pxl_parallax_bg_position_tablet_extra\":\"\",\"pxl_parallax_bg_position_tablet\":\"\",\"pxl_parallax_bg_position_mobile_extra\":\"\",\"pxl_parallax_bg_position_mobile\":\"\",\"pxl_parallax_bg_pos_custom_x\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size\":\"\",\"pxl_parallax_bg_size_laptop\":\"\",\"pxl_parallax_bg_size_tablet_extra\":\"\",\"pxl_parallax_bg_size_tablet\":\"\",\"pxl_parallax_bg_size_mobile_extra\":\"\",\"pxl_parallax_bg_size_mobile\":\"\",\"pxl_parallax_bg_size_custom\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"pxl_parallax_bg_size_custom_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_overlay_img_position\":\"\",\"pxl_overlay_img_position_laptop\":\"\",\"pxl_overlay_img_position_tablet_extra\":\"\",\"pxl_overlay_img_position_tablet\":\"\",\"pxl_overlay_img_position_mobile_extra\":\"\",\"pxl_overlay_img_position_mobile\":\"\",\"pxl_overlay_img_right_position\":\"\",\"pxl_overlay_img_right_position_laptop\":\"\",\"pxl_overlay_img_right_position_tablet_extra\":\"\",\"pxl_overlay_img_right_position_tablet\":\"\",\"pxl_overlay_img_right_position_mobile_extra\":\"\",\"pxl_overlay_img_right_position_mobile\":\"\",\"row_effect_images\":[],\"flex_align_items\":\"center\"},\"elements\":[{\"id\":\"ff38d6d\",\"elType\":\"widget\",\"settings\":{\"layout\":\"2\",\"pxl_icon\":{\"value\":\"fas fa-envelope\",\"library\":\"fa-solid\"},\"title\":\"\\u0627\\u06cc\\u0645\\u06cc\\u0644 \\u0645\\u0627\",\"desc\":\"contact@dentiaclinic.com\",\"title_color\":\"#FFFFFF\",\"icon_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_width\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"desc_color\":\"#FFFFFF99\",\"icon_color\":\"#4A7DC2\",\"icon_bg_color\":\"#02010100\",\"title_bottom\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"inner_space\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"_element_width_mobile\":\"inherit\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false},{\"id\":\"15b34f8\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":50,\"column\":\"50\",\"row\":\"50\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"135\",\"right\":\"15\",\"bottom\":\"130\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_gap_laptop\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"0\",\"bottom\":\"70\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"98ca70d\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"flex_gap\":{\"column\":\"22\",\"row\":\"22\",\"isLinked\":true,\"unit\":\"px\",\"size\":22},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_direction_tablet\":\"column\"},\"elements\":[{\"id\":\"43ff422\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"b698bb4\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/about-img1.jpg\",\"id\":463,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":399,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"300\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"300\"},\"elements\":[],\"widgetType\":\"pxl_image\"}],\"isInner\":true},{\"id\":\"4c3a639\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"padding\":{\"unit\":\"px\",\"top\":\"55\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"3a26ecd\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/about-img2.jpg\",\"id\":464,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":399,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"500\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_image\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"9dd8e84\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"b0297bf\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u062a\\u062e\\u0635\\u0635\\u0627\\u0646 \\u0648 \\u062a\\u0639\\u0627\\u0644\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0634\\u062e\\u0635\\u06cc\",\"sub_title\":\"\\u062f\\u0631\\u0628\\u0627\\u0631\\u0647 \\u0645\\u0627\",\"h_width\":{\"unit\":\"%\",\"size\":80,\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"6bc87e8\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0645\\u0627 \\u062e\\u062f\\u0645\\u0627\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0628\\u0627 \\u06a9\\u06cc\\u0641\\u06cc\\u062a \\u0628\\u0627\\u0644\\u0627 \\u0648 \\u0645\\u062a\\u0646\\u0627\\u0633\\u0628 \\u0628\\u0627 \\u0646\\u06cc\\u0627\\u0632 \\u062a\\u0645\\u0627\\u0645 \\u0627\\u0639\\u0636\\u0627\\u06cc \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647 \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645. \\u0627\\u0632 \\u0645\\u0639\\u0627\\u06cc\\u0646\\u0627\\u062a \\u0631\\u0648\\u062a\\u06cc\\u0646 \\u06af\\u0631\\u0641\\u062a\\u0647 \\u062a\\u0627 \\u062f\\u0631\\u0645\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647\\u060c \\u062a\\u06cc\\u0645 \\u062f\\u0644\\u0633\\u0648\\u0632 \\u0645\\u0627 \\u062a\\u0636\\u0645\\u06cc\\u0646 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u062f \\u06a9\\u0647 \\u0644\\u0628\\u062e\\u0646\\u062f \\u0634\\u0645\\u0627 \\u0633\\u0627\\u0644\\u0645 \\u0648 \\u0628\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f \\u0628\\u0647 \\u0646\\u0641\\u0633 \\u0628\\u0627\\u0642\\u06cc \\u0628\\u0645\\u0627\\u0646\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"17\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"bb0da06\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_gap\":{\"column\":\"35\",\"row\":\"35\",\"isLinked\":true,\"unit\":\"px\",\"size\":35},\"flex_gap_laptop\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_direction_tablet\":\"column\",\"flex_gap_tablet\":{\"column\":\"5\",\"row\":\"5\",\"isLinked\":true,\"unit\":\"px\",\"size\":5}},\"elements\":[{\"id\":\"9028010\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"827cdc3\",\"elType\":\"widget\",\"settings\":{\"lists\":[{\"_id\":\"29fdacb\",\"pxl_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"},\"text\":\"\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0631\\u0645\\u0627\\u0646 \\u0634\\u062e\\u0635\\u06cc\\u200c\\u0633\\u0627\\u0632\\u06cc\\u200c\\u0634\\u062f\\u0647\"},{\"pxl_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"},\"text\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u0645\\u0644\\u0627\\u06cc\\u0645 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646 \\u0648 \\u0628\\u0632\\u0631\\u06af\\u0633\\u0627\\u0644\\u0627\\u0646\",\"_id\":\"7ff6475\"}],\"text_typography_typography\":\"custom\",\"text_typography_font_size_laptop\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"icon_color\":\"#4A7DC2\",\"icon_space\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"03\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"600\",\"align_items\":\"start\"},\"elements\":[],\"widgetType\":\"pxl_list\"}],\"isInner\":true},{\"id\":\"6db1ff5\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"fa6490e\",\"elType\":\"widget\",\"settings\":{\"lists\":[{\"_id\":\"29fdacb\",\"pxl_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"},\"text\":\"\\u0641\\u0646\\u0627\\u0648\\u0631\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647\"},{\"pxl_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"},\"text\":\"\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647\\u200c\\u0631\\u06cc\\u0632\\u06cc \\u0627\\u0646\\u0639\\u0637\\u0627\\u0641\\u200c\\u067e\\u0630\\u06cc\\u0631 \\u0628\\u0631\\u0627\\u06cc \\u0642\\u0631\\u0627\\u0631 \\u0645\\u0644\\u0627\\u0642\\u0627\\u062a\",\"_id\":\"7ff6475\"}],\"text_typography_typography\":\"custom\",\"text_typography_font_size_laptop\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"icon_color\":\"#4A7DC2\",\"icon_space\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"03\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"600\",\"align_items\":\"start\"},\"elements\":[],\"widgetType\":\"pxl_list\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"f3897d9\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0631\\u0632\\u0631\\u0648 \\u0646\\u0648\\u0628\\u062a\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"700\",\"_margin\":{\"unit\":\"px\",\"top\":\"28\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_button\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"9f68bac\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#4A7CD21A\",\"padding\":{\"unit\":\"px\",\"top\":\"120\",\"right\":\"15\",\"bottom\":\"130\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"15\",\"bottom\":\"70\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"ac1ac70\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"c74a3ee\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u06a9\\u0627\\u0645\\u0644 \\u0628\\u0631\\u0627\\u06cc \\u0647\\u0631 \\u0644\\u0628\\u062e\\u0646\\u062f\",\"sub_title\":\"\\u062e\\u062f\\u0645\\u0627\\u062a \\u0645\\u0627\",\"h_width\":{\"unit\":\"%\",\"size\":80,\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]},\"align\":\"center\"},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"72847f9\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0627\\u0632 \\u062a\\u0645\\u06cc\\u0632 \\u06a9\\u0631\\u062f\\u0646\\u200c\\u0647\\u0627\\u06cc \\u0631\\u0648\\u062a\\u06cc\\u0646 \\u06af\\u0631\\u0641\\u062a\\u0647 \\u062a\\u0627 \\u062a\\u0631\\u0645\\u06cc\\u0645\\u200c\\u0647\\u0627\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647\\u060c \\u0645\\u0627 \\u0631\\u0627\\u0647\\u200c\\u062d\\u0644\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0634\\u062e\\u0635\\u06cc\\u200c\\u0633\\u0627\\u0632\\u06cc\\u200c\\u0634\\u062f\\u0647 \\u0631\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u0628\\u06cc\\u0645\\u0627\\u0631\\u0627\\u0646 \\u062f\\u0631 \\u0647\\u0631 \\u0633\\u0646\\u06cc \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"42\",\"left\":\"0\",\"isLinked\":false},\"align\":\"center\",\"t_width\":{\"unit\":\"px\",\"size\":563,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"7371f8b\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"pxl_parallax_bg_position\":\"\",\"pxl_parallax_bg_position_laptop\":\"\",\"pxl_parallax_bg_position_tablet_extra\":\"\",\"pxl_parallax_bg_position_tablet\":\"\",\"pxl_parallax_bg_position_mobile_extra\":\"\",\"pxl_parallax_bg_position_mobile\":\"\",\"pxl_parallax_bg_pos_custom_x\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size\":\"\",\"pxl_parallax_bg_size_laptop\":\"\",\"pxl_parallax_bg_size_tablet_extra\":\"\",\"pxl_parallax_bg_size_tablet\":\"\",\"pxl_parallax_bg_size_mobile_extra\":\"\",\"pxl_parallax_bg_size_mobile\":\"\",\"pxl_parallax_bg_size_custom\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"pxl_parallax_bg_size_custom_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_overlay_img_position\":\"\",\"pxl_overlay_img_position_laptop\":\"\",\"pxl_overlay_img_position_tablet_extra\":\"\",\"pxl_overlay_img_position_tablet\":\"\",\"pxl_overlay_img_position_mobile_extra\":\"\",\"pxl_overlay_img_position_mobile\":\"\",\"pxl_overlay_img_right_position\":\"\",\"pxl_overlay_img_right_position_laptop\":\"\",\"pxl_overlay_img_right_position_tablet_extra\":\"\",\"pxl_overlay_img_right_position_tablet\":\"\",\"pxl_overlay_img_right_position_mobile_extra\":\"\",\"pxl_overlay_img_right_position_mobile\":\"\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"37741dc\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"flex_gap\":{\"column\":\"24\",\"row\":\"24\",\"isLinked\":true,\"unit\":\"px\",\"size\":24},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_wrap_tablet_extra\":\"wrap\",\"flex_gap_laptop\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20}},\"elements\":[{\"id\":\"5855528\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet_extra\":{\"unit\":\"%\",\"size\":48.5,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":48,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"ff281fa\",\"elType\":\"widget\",\"settings\":{\"layout\":\"3\",\"icon_type\":\"image\",\"icon_image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/tooth-1.png\",\"id\":626,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0639\\u0645\\u0648\\u0645\\u06cc\",\"desc\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u06a9\\u0627\\u0645\\u0644 \\u062f\\u0647\\u0627\\u0646 \\u0648 \\u062f\\u0646\\u062f\\u0627\\u0646 \\u0628\\u0631\\u0627\\u06cc \\u0647\\u0631 \\u0644\\u0628\\u062e\\u0646\\u062f\\u06cc \\u0628\\u0627 \\u062c\\u0631\\u0645\\u200c\\u06af\\u06cc\\u0631\\u06cc\\u060c \\u0645\\u0639\\u0627\\u06cc\\u0646\\u0647 \\u0648 \\u0645\\u0648\\u0627\\u0631\\u062f \\u062f\\u06cc\\u06af\\u0631.\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/service\\/general-dentistry\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"title_btn\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"pxl_animate\":\"wow scaleIn\",\"pxl_animate_delay\":\"300\",\"pxl_animate2\":\"wow fadeInUp\",\"pxl_animate_delay2\":\"500\",\"title_color\":\"#10244B\",\"background_color\":\"#FFFFFF\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true},{\"id\":\"62a7ae9\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet_extra\":{\"unit\":\"%\",\"size\":49,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":48.5,\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"c880081\",\"elType\":\"widget\",\"settings\":{\"layout\":\"3\",\"icon_type\":\"image\",\"icon_image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/tooth-2.png\",\"id\":627,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0632\\u06cc\\u0628\\u0627\\u06cc\\u06cc\",\"desc\":\"\\u0632\\u06cc\\u0628\\u0627\\u06cc\\u06cc \\u0644\\u0628\\u062e\\u0646\\u062f \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0628\\u0627 \\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\\u060c \\u0648\\u0646\\u06cc\\u0631\\u0647\\u0627 \\u0648 \\u0645\\u0648\\u0627\\u0631\\u062f \\u062f\\u06cc\\u06af\\u0631 \\u0627\\u0641\\u0632\\u0627\\u06cc\\u0634 \\u062f\\u0647\\u06cc\\u062f.\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/service\\/cosmetic-dentistry\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"title_btn\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"pxl_animate\":\"wow scaleIn\",\"pxl_animate_delay\":\"300\",\"pxl_animate2\":\"wow fadeInUp\",\"pxl_animate_delay2\":\"500\",\"title_color\":\"#10244B\",\"background_color\":\"#FFFFFF\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true},{\"id\":\"964d2d6\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"background_background\":\"classic\",\"background_image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_position\":\"center center\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"width_tablet_extra\":{\"unit\":\"%\",\"size\":48.5,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":48,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"flex_justify_content\":\"center\"},\"elements\":[{\"id\":\"336bf6f\",\"elType\":\"widget\",\"settings\":{\"layout\":\"3\",\"icon_type\":\"image\",\"icon_image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/tooth-3.png\",\"id\":628,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646\",\"desc\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u0645\\u0644\\u0627\\u06cc\\u0645 \\u0648 \\u0633\\u0631\\u06af\\u0631\\u0645\\u200c\\u06a9\\u0646\\u0646\\u062f\\u0647 \\u0627\\u0632 \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646 \\u062a\\u0627 \\u0644\\u0628\\u062e\\u0646\\u062f\\u06cc \\u0633\\u0627\\u0644\\u0645 \\u0648 \\u0634\\u0627\\u062f \\u062f\\u0627\\u0634\\u062a\\u0647 \\u0628\\u0627\\u0634\\u0646\\u062f.\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/service\\/pediatric-dentistry\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"title_btn\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"pxl_animate\":\"wow scaleIn\",\"pxl_animate_delay\":\"300\",\"pxl_animate2\":\"wow fadeInUp\",\"pxl_animate_delay2\":\"500\",\"title_color\":\"#10244B\",\"background_color\":\"#FFFFFF\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true},{\"id\":\"2e4cbee\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet_extra\":{\"unit\":\"%\",\"size\":49,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":48.5,\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"2029233\",\"elType\":\"widget\",\"settings\":{\"layout\":\"3\",\"icon_type\":\"image\",\"icon_image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/tooth-4.png\",\"id\":629,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u062a\\u0631\\u0645\\u06cc\\u0645\\u06cc\",\"desc\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u0634\\u0645\\u0627 \\u0631\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u0631\\u0627\\u062d\\u062a\\u06cc \\u0648 \\u0639\\u0645\\u0644\\u06a9\\u0631\\u062f \\u067e\\u0627\\u06cc\\u062f\\u0627\\u0631 \\u062a\\u0631\\u0645\\u06cc\\u0645 \\u0648 \\u0628\\u0627\\u0632\\u0633\\u0627\\u0632\\u06cc \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u062f.\\n\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/service\\/restorative-dentistry\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"title_btn\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"pxl_animate\":\"wow scaleIn\",\"pxl_animate_delay\":\"300\",\"pxl_animate2\":\"wow fadeInUp\",\"pxl_animate_delay2\":\"500\",\"title_color\":\"#10244B\",\"background_color\":\"#FFFFFF\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true},{\"id\":\"e71413a\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u0647\\u0645\\u0647 \\u062e\\u062f\\u0645\\u0627\\u062a\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/all-services\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"align\":\"center\",\"_margin\":{\"unit\":\"px\",\"top\":\"48\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_button\"}],\"isInner\":false},{\"id\":\"b92d7a4\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#000A5B\",\"padding\":{\"unit\":\"px\",\"top\":\"60\",\"right\":\"15\",\"bottom\":\"60\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"d408d83\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"25\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"c08f676\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0628\\u06cc\\u0645\\u0627\\u0631\\u0627\\u0646 \\u0634\\u0627\\u062f\",\"starting_number\":5000,\"ending_number\":10000,\"suffix\":\"+\",\"pxl_animate\":\"wow fadeInRight\",\"pxl_animate_delay\":\"300\"},\"elements\":[],\"widgetType\":\"pxl_counter\"}],\"isInner\":true},{\"id\":\"3ffca2e\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"25\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"17f3015\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\",\"starting_number\":2000,\"ending_number\":2500,\"suffix\":\"+\",\"pxl_animate\":\"wow fadeInRight\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_counter\"}],\"isInner\":true},{\"id\":\"5163797\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"25\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"344472f\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u06cc\\u0645\\u067e\\u0644\\u0646\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\",\"starting_number\":500,\"ending_number\":800,\"suffix\":\"+\",\"pxl_animate\":\"wow fadeInRight\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_counter\"}],\"isInner\":true},{\"id\":\"7ac7412\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"25\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"62d672d\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0633\\u0627\\u0644 \\u062a\\u062c\\u0631\\u0628\\u0647\",\"ending_number\":15,\"suffix\":\"+\",\"pxl_animate\":\"wow fadeInRight\",\"pxl_animate_delay\":\"600\"},\"elements\":[],\"widgetType\":\"pxl_counter\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"fc38de1\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":50,\"column\":\"50\",\"row\":\"50\",\"isLinked\":true},\"flex_direction_mobile_extra\":\"column\",\"flex_gap_laptop\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"padding\":{\"unit\":\"px\",\"top\":\"120\",\"right\":\"15\",\"bottom\":\"155\",\"left\":\"15\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"0\",\"bottom\":\"70\",\"left\":\"0\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"931cd86\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"c7857de\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0633\\u062a\\u062b\\u0646\\u0627\\u06cc\\u06cc \\u0628\\u0627 \\u0631\\u0648\\u06cc\\u06a9\\u0631\\u062f\\u06cc \\u0634\\u062e\\u0635\\u06cc\",\"sub_title\":\"\\u0686\\u0631\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0645\\u0627 \\u0631\\u0627 \\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u06a9\\u0646\\u06cc\\u062f\",\"h_width\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"602ea93\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0627\\u0631\\u0627\\u0626\\u0647 \\u062f\\u0647\\u0646\\u062f\\u0647 \\u062e\\u062f\\u0645\\u0627\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0645\\u0646\\u0627\\u0633\\u0628 \\u0627\\u0647\\u0645\\u06cc\\u062a \\u062f\\u0627\\u0631\\u062f. \\u0645\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062a\\u062e\\u0635\\u0635\\u06cc\\u060c \\u0641\\u0646\\u0627\\u0648\\u0631\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647 \\u0648 \\u0641\\u0636\\u0627\\u06cc\\u06cc \\u06af\\u0631\\u0645 \\u0631\\u0627 \\u0628\\u0627 \\u0647\\u0645 \\u062a\\u0631\\u06a9\\u06cc\\u0628 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u06cc\\u0645 \\u062a\\u0627 \\u0627\\u0637\\u0645\\u06cc\\u0646\\u0627\\u0646 \\u062d\\u0627\\u0635\\u0644 \\u06a9\\u0646\\u06cc\\u0645 \\u06a9\\u0647 \\u0647\\u0631 \\u0648\\u06cc\\u0632\\u06cc\\u062a \\u0631\\u0627\\u062d\\u062a\\u060c \\u06a9\\u0627\\u0631\\u0622\\u0645\\u062f \\u0648 \\u0645\\u062a\\u0646\\u0627\\u0633\\u0628 \\u0628\\u0627 \\u0646\\u06cc\\u0627\\u0632\\u0647\\u0627\\u06cc \\u0645\\u0646\\u062d\\u0635\\u0631 \\u0628\\u0647 \\u0641\\u0631\\u062f \\u0634\\u0645\\u0627 \\u062e\\u0648\\u0627\\u0647\\u062f \\u0628\\u0648\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"21\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"9f3be1f\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_gap\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"flex_gap_laptop\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_direction_tablet\":\"column\",\"flex_gap_tablet\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"border_color\":\"#0000004D\",\"padding\":{\"unit\":\"px\",\"top\":\"22\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"e4d5e10\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_gap\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"flex_gap_tablet_extra\":{\"column\":\"15\",\"row\":\"15\",\"isLinked\":true,\"unit\":\"px\",\"size\":15}},\"elements\":[{\"id\":\"3f475ce\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"d437b1c\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<h5>\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0628\\u0627\\u062a\\u062c\\u0631\\u0628\\u0647<\\/h5>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"78e6e2b\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062a\\u062e\\u0635\\u0635\\u06cc \\u0628\\u0627 \\u067e\\u0634\\u062a\\u0648\\u0627\\u0646\\u0647 \\u0633\\u0627\\u0644\\u200c\\u0647\\u0627 \\u062a\\u062c\\u0631\\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0642\\u0627\\u0628\\u0644 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"c548350\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"65c31f4\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<h5>\\u062f\\u0631\\u0645\\u0627\\u0646 \\u0634\\u062e\\u0635\\u06cc\\u200c\\u0633\\u0627\\u0632\\u06cc\\u200c\\u0634\\u062f\\u0647<\\/h5>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"24d4409\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647\\u200c\\u0647\\u0627\\u06cc \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u06cc \\u0633\\u0641\\u0627\\u0631\\u0634\\u06cc \\u06a9\\u0647 \\u0645\\u062a\\u0646\\u0627\\u0633\\u0628 \\u0628\\u0627 \\u0644\\u0628\\u062e\\u0646\\u062f \\u0648 \\u0633\\u0628\\u06a9 \\u0632\\u0646\\u062f\\u06af\\u06cc \\u0634\\u0645\\u0627 \\u062a\\u0647\\u06cc\\u0647 \\u0645\\u06cc\\u200c\\u0634\\u0648\\u0646\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"64807c6\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_gap\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"flex_gap_tablet_extra\":{\"column\":\"15\",\"row\":\"15\",\"isLinked\":true,\"unit\":\"px\",\"size\":15}},\"elements\":[{\"id\":\"0cb580b\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"pxl_parallax_bg_position\":\"\",\"pxl_parallax_bg_position_laptop\":\"\",\"pxl_parallax_bg_position_tablet_extra\":\"\",\"pxl_parallax_bg_position_tablet\":\"\",\"pxl_parallax_bg_position_mobile_extra\":\"\",\"pxl_parallax_bg_position_mobile\":\"\",\"pxl_parallax_bg_pos_custom_x\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size\":\"\",\"pxl_parallax_bg_size_laptop\":\"\",\"pxl_parallax_bg_size_tablet_extra\":\"\",\"pxl_parallax_bg_size_tablet\":\"\",\"pxl_parallax_bg_size_mobile_extra\":\"\",\"pxl_parallax_bg_size_mobile\":\"\",\"pxl_parallax_bg_size_custom\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"pxl_parallax_bg_size_custom_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_overlay_img_position\":\"\",\"pxl_overlay_img_position_laptop\":\"\",\"pxl_overlay_img_position_tablet_extra\":\"\",\"pxl_overlay_img_position_tablet\":\"\",\"pxl_overlay_img_position_mobile_extra\":\"\",\"pxl_overlay_img_position_mobile\":\"\",\"pxl_overlay_img_right_position\":\"\",\"pxl_overlay_img_right_position_laptop\":\"\",\"pxl_overlay_img_right_position_tablet_extra\":\"\",\"pxl_overlay_img_right_position_tablet\":\"\",\"pxl_overlay_img_right_position_mobile_extra\":\"\",\"pxl_overlay_img_right_position_mobile\":\"\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"89fbcf5\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<h5>\\u0641\\u0646\\u0627\\u0648\\u0631\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647<\\/h5>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"1a2ce28\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0627\\u0628\\u0632\\u0627\\u0631\\u0647\\u0627\\u06cc \\u0645\\u062f\\u0631\\u0646\\u060c \\u062f\\u0631\\u0645\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0642\\u06cc\\u0642 \\u0648 \\u06a9\\u0627\\u0631\\u0622\\u0645\\u062f \\u0631\\u0627 \\u062a\\u0636\\u0645\\u06cc\\u0646 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0646\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"5c18bec\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"0139430\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<h5>\\u0645\\u0646\\u0627\\u0633\\u0628 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647<\\/h5>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"3e9309c\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0641\\u0636\\u0627\\u06cc\\u06cc \\u062f\\u0644\\u0646\\u0634\\u06cc\\u0646 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646\\u060c \\u0646\\u0648\\u062c\\u0648\\u0627\\u0646\\u0627\\u0646\\u060c \\u0628\\u0632\\u0631\\u06af\\u0633\\u0627\\u0644\\u0627\\u0646 \\u0648 \\u0633\\u0627\\u0644\\u0645\\u0646\\u062f\\u0627\\u0646.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true},{\"id\":\"c0bac5e\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"flex_align_items\":\"center\",\"flex_gap\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"9ce2c5c\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_gap\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"flex_gap_tablet_extra\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"e530c81\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/exceptional2.jpg\",\"id\":607,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":236.80000000000001136868377216160297393798828125,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"300\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"300\",\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"60\",\"isLinked\":false},\"_padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_image\"},{\"id\":\"21bc2cb\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/exceptional1.jpg\",\"id\":606,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":296,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"500\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_image\"}],\"isInner\":true},{\"id\":\"2b3fb22\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"a7be7b9\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/exceptional3.jpg\",\"id\":608,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":399.6000000000000227373675443232059478759765625,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"400\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_image\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false},{\"id\":\"d0d5540\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#4A7CD21A\",\"padding\":{\"unit\":\"px\",\"top\":\"120\",\"right\":\"15\",\"bottom\":\"108\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"15\",\"bottom\":\"70\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"964e490\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"d075595\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u062a\\u0639\\u0647\\u062f \\u0628\\u0647 \\u0644\\u0628\\u062e\\u0646\\u062f \\u0634\\u0645\\u0627\",\"sub_title\":\" \\u0628\\u0627 \\u062a\\u06cc\\u0645 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0645\\u0627 \\u0622\\u0634\\u0646\\u0627 \\u0634\\u0648\\u06cc\\u062f\",\"h_width\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"align\":\"center\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"acd7da4\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p class=\\\"wow fadeInUp animated\\\">\\u062a\\u06cc\\u0645 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0628\\u0627\\u062a\\u062c\\u0631\\u0628\\u0647 \\u0645\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0647\\u0633\\u062a\\u0646\\u062f \\u062a\\u0627 \\u0647\\u0631 \\u0648\\u06cc\\u0632\\u06cc\\u062a \\u0631\\u0627 \\u0645\\u062b\\u0628\\u062a \\u0648 \\u0634\\u062e\\u0635\\u06cc\\u200c\\u0633\\u0627\\u0632\\u06cc\\u200c\\u0634\\u062f\\u0647 \\u06a9\\u0646\\u0646\\u062f. \\u0628\\u0627 \\u062f\\u0633\\u062a\\u0627\\u0646\\u06cc \\u0645\\u0647\\u0631\\u0628\\u0627\\u0646 \\u0648 \\u0642\\u0644\\u0628\\u06cc \\u0645\\u0647\\u0631\\u0628\\u0627\\u0646.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"37\",\"left\":\"0\",\"isLinked\":false},\"align\":\"center\",\"t_width\":{\"unit\":\"px\",\"size\":628,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"8e36ff0\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"9c707a0\",\"elType\":\"widget\",\"settings\":{\"team\":[{\"_id\":\"836b840\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/dentists-img1.jpg\",\"id\":179,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u06a9\\u062a\\u0631 \\u0633\\u0627\\u0631\\u0627 \\u0645\\u06cc\\u0631\\u0632\\u0627\\u0626\\u06cc\",\"position\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0627\\u0631\\u0634\\u062f\"},{\"_id\":\"baa6cb5\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/dentists-img2.jpg\",\"id\":180,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u06a9\\u062a\\u0631 \\u0645\\u0631\\u06cc\\u0645 \\u0622\\u0642\\u0627\\u062c\\u0627\\u0646\\u06cc\",\"position\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0632\\u06cc\\u0628\\u0627\\u06cc\\u06cc\"},{\"_id\":\"3faca8d\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/dentists-img3.jpg\",\"id\":181,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u06a9\\u062a\\u0631 \\u0634\\u0647\\u0627\\u0628 \\u0637\\u0647\\u0645\\u0627\\u0633\\u0628\\u06cc\",\"position\":\"\\u0645\\u062a\\u062e\\u0635\\u0635 \\u0627\\u0637\\u0641\\u0627\\u0644\"},{\"_id\":\"33e5523\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/dentists-img4.jpg\",\"id\":182,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u06a9\\u062a\\u0631 \\u0627\\u0645\\u06cc\\u0631 \\u06a9\\u0631\\u0645\\u0627\\u0646\\u06cc\\u200c\\u0645\\u0642\\u062f\\u0645\",\"position\":\"\\u0628\\u0647\\u062f\\u0627\\u0634\\u062a\\u06a9\\u0627\\u0631 \\u062f\\u0647\\u0627\\u0646 \\u0648 \\u062f\\u0646\\u062f\\u0627\\u0646\"}],\"item_spacer\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"pxl_animate_img\":\"wow zoomInSmall\",\"pxl_animate_img2\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"600\",\"pxl_animate_content\":\"wow fadeInDown\",\"pxl_animate_ct_delay\":\"700\"},\"elements\":[],\"widgetType\":\"pxl_team_grid\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"07e3439\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":30,\"column\":\"30\",\"row\":\"30\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"123\",\"right\":\"15\",\"bottom\":\"120\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_direction_mobile_extra\":\"column\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"0\",\"bottom\":\"70\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"cabeee0\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_mobile_extra\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"92a30c5\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0633\\u0648\\u0627\\u0644\\u0627\\u062a \\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\",\"sub_title\":\"\\u0647\\u0631 \\u0622\\u0646\\u0686\\u0647 \\u06a9\\u0647 \\u0628\\u0627\\u06cc\\u062f \\u0628\\u062f\\u0627\\u0646\\u06cc\\u062f\",\"title_tag\":\"h2\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_heading\"}],\"isInner\":true},{\"id\":\"cb0bd9f\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":68.599999999999994315658113919198513031005859375},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_mobile_extra\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"eff6c82\",\"elType\":\"widget\",\"settings\":{\"active\":0,\"accordion\":[{\"_id\":\"324d3d2\",\"title\":\"\\u0686\\u0646\\u062f \\u0648\\u0642\\u062a \\u06cc\\u06a9\\u0628\\u0627\\u0631 \\u0628\\u0627\\u06cc\\u062f \\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0647 \\u06a9\\u0646\\u0645\\u061f \",\"desc\":\"\\u062a\\u0648\\u0635\\u06cc\\u0647 \\u0645\\u06cc\\u200c\\u0634\\u0648\\u062f \\u0647\\u0631 \\u06f6 \\u0645\\u0627\\u0647 \\u06cc\\u06a9\\u0628\\u0627\\u0631 \\u0628\\u0631\\u0627\\u06cc \\u0645\\u0639\\u0627\\u06cc\\u0646\\u0647 \\u0648 \\u062a\\u0645\\u06cc\\u0632 \\u06a9\\u0631\\u062f\\u0646 \\u0631\\u0648\\u062a\\u06cc\\u0646 \\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u062e\\u0648\\u062f \\u0645\\u0631\\u0627\\u062c\\u0639\\u0647 \\u06a9\\u0646\\u06cc\\u062f\\u060c \\u0645\\u06af\\u0631 \\u0627\\u06cc\\u0646\\u06a9\\u0647 \\u067e\\u0632\\u0634\\u06a9 \\u062a\\u0648\\u0635\\u06cc\\u0647 \\u062f\\u06cc\\u06af\\u0631\\u06cc \\u062f\\u0627\\u0634\\u062a\\u0647 \\u0628\\u0627\\u0634\\u062f. \"},{\"_id\":\"b063b10\",\"title\":\"\\u062f\\u0631 \\u0645\\u0648\\u0627\\u0642\\u0639 \\u0627\\u0648\\u0631\\u0698\\u0627\\u0646\\u0633 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0686\\u0647 \\u0628\\u0627\\u06cc\\u062f \\u0628\\u06a9\\u0646\\u0645\\u061f \",\"desc\":\"\\u0641\\u0648\\u0631\\u0627\\u064b \\u0628\\u0627 \\u0645\\u0637\\u0628 \\u0645\\u0627 \\u062a\\u0645\\u0627\\u0633 \\u0628\\u06af\\u06cc\\u0631\\u06cc\\u062f. \\u0645\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u0645\\u0648\\u0627\\u0631\\u062f\\u06cc \\u0645\\u0627\\u0646\\u0646\\u062f \\u062f\\u0631\\u062f \\u0634\\u062f\\u06cc\\u062f\\u060c \\u0634\\u06a9\\u0633\\u062a\\u06af\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646 \\u06cc\\u0627 \\u062a\\u0648\\u0631\\u0645\\u060c \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u0627\\u0648\\u0631\\u0698\\u0627\\u0646\\u0633\\u06cc \\u062f\\u0631 \\u0647\\u0645\\u0627\\u0646 \\u0631\\u0648\\u0632 \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645. \"},{\"_id\":\"8895a65\",\"title\":\"\\u0622\\u06cc\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u0628\\u0686\\u0647\\u200c\\u0647\\u0627 \\u062e\\u062f\\u0645\\u0627\\u062a\\u06cc \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u062f\\u061f \",\"desc\":\"\\u06a9\\u0627\\u0645\\u0644\\u0627\\u064b! \\u0645\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646 \\u0631\\u0627 \\u0628\\u0627 \\u0645\\u0644\\u0627\\u06cc\\u0645\\u062a \\u0648 \\u0628\\u0647 \\u0634\\u06a9\\u0644\\u06cc \\u062f\\u0648\\u0633\\u062a\\u0627\\u0646\\u0647 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646 \\u062f\\u0631 \\u062a\\u0645\\u0627\\u0645 \\u0633\\u0646\\u06cc\\u0646 \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645. \"},{\"_id\":\"40426f2\",\"title\":\"\\u06af\\u0632\\u06cc\\u0646\\u0647\\u200c\\u0647\\u0627\\u06cc \\u0645\\u0646 \\u0628\\u0631\\u0627\\u06cc \\u062c\\u0627\\u06cc\\u06af\\u0632\\u06cc\\u0646\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u0627\\u0632 \\u062f\\u0633\\u062a \\u0631\\u0641\\u062a\\u0647 \\u0686\\u06cc\\u0633\\u062a\\u061f \",\"desc\":\"\\u0645\\u0627 \\u0628\\u0633\\u062a\\u0647 \\u0628\\u0647 \\u0646\\u06cc\\u0627\\u0632\\u0647\\u0627 \\u0648 \\u062a\\u0631\\u062c\\u06cc\\u062d\\u0627\\u062a \\u0634\\u0645\\u0627\\u060c \\u0627\\u06cc\\u0645\\u067e\\u0644\\u0646\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u060c \\u0628\\u0631\\u06cc\\u062c \\u0648 \\u062f\\u0646\\u062f\\u0627\\u0646 \\u0645\\u0635\\u0646\\u0648\\u0639\\u06cc \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645. \"},{\"_id\":\"0d93a43\",\"title\":\"\\u0622\\u06cc\\u0627 \\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627 \\u0628\\u06cc\\u200c\\u062e\\u0637\\u0631 \\u0627\\u0633\\u062a\\u061f \",\"desc\":\"\\u0628\\u0644\\u0647\\u060c \\u0648\\u0642\\u062a\\u06cc \\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627 \\u062a\\u0648\\u0633\\u0637 \\u06cc\\u06a9 \\u0645\\u062a\\u062e\\u0635\\u0635 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0627\\u0646\\u062c\\u0627\\u0645 \\u0634\\u0648\\u062f\\u060c \\u0627\\u06cc\\u0645\\u0646 \\u0648 \\u0645\\u0624\\u062b\\u0631 \\u0627\\u0633\\u062a \\u0648 \\u0646\\u062a\\u0627\\u06cc\\u062c \\u0622\\u0646 \\u0645\\u0627\\u0646\\u062f\\u06af\\u0627\\u0631 \\u062e\\u0648\\u0627\\u0647\\u062f \\u0628\\u0648\\u062f. \"}],\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"300\"},\"elements\":[],\"widgetType\":\"pxl_accordion\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"faed713\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#4A7CD21A\",\"padding\":{\"unit\":\"px\",\"top\":\"115\",\"right\":\"0\",\"bottom\":\"105\",\"left\":\"0\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"content_width\":\"full\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"15\",\"bottom\":\"70\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"ba2fc12\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"15\",\"bottom\":\"0\",\"left\":\"15\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"cd71716\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646 \\u0631\\u0627\\u0636\\u06cc \\u0645\\u0627\",\"sub_title\":\"\\u0646\\u0638\\u0631\\u0627\\u062a \\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646\",\"h_width\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"align\":\"center\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"17efbb0\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p class=\\\"wow fadeInUp animated\\\">\\u0628\\u0647 \\u0647\\u0632\\u0627\\u0631\\u0627\\u0646 \\u0628\\u06cc\\u0645\\u0627\\u0631 \\u0631\\u0627\\u0636\\u06cc \\u0628\\u067e\\u06cc\\u0648\\u0646\\u062f\\u06cc\\u062f \\u06a9\\u0647 \\u0628\\u0631\\u0627\\u06cc \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u0645\\u0644\\u0627\\u06cc\\u0645 \\u0648 \\u062a\\u062e\\u0635\\u0635\\u06cc \\u0648 \\u0644\\u0628\\u062e\\u0646\\u062f\\u0647\\u0627\\u06cc \\u0632\\u06cc\\u0628\\u0627 \\u0628\\u0647 \\u0645\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0646\\u062f. \\u062a\\u062c\\u0631\\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0628\\u06cc\\u200c\\u0646\\u0638\\u06cc\\u0631 \\u0634\\u0645\\u0627 \\u0627\\u0632 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0634\\u0631\\u0648\\u0639 \\u0645\\u06cc\\u200c\\u0634\\u0648\\u062f!<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"50\",\"left\":\"0\",\"isLinked\":false},\"align\":\"center\",\"t_width\":{\"unit\":\"px\",\"size\":628,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"6356f20\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"a06f7d2\",\"elType\":\"widget\",\"settings\":{\"layout\":\"2\",\"testimonial\":[],\"testimonial_lv2\":[{\"_id\":\"8f77d95\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/author1.jpg\",\"id\":92,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0645\\u06cc\\u06a9\\u0627\\u0626\\u06cc\\u0644 \\u0634\\u0647\\u0627\\u0628\\u06cc\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0645\\u0646 \\u0647\\u0645\\u06cc\\u0634\\u0647 \\u0627\\u0632 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0647 \\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0646\\u06af\\u0631\\u0627\\u0646 \\u0628\\u0648\\u062f\\u0647\\u200c\\u0627\\u0645\\u060c \\u0627\\u0645\\u0627 \\u06a9\\u0627\\u0631\\u06a9\\u0646\\u0627\\u0646 \\u0628\\u0627\\u0639\\u062b \\u0634\\u062f\\u0646\\u062f \\u06a9\\u0627\\u0645\\u0644\\u0627\\u064b \\u0627\\u062d\\u0633\\u0627\\u0633 \\u0631\\u0627\\u062d\\u062a\\u06cc \\u06a9\\u0646\\u0645. \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u0645\\u0644\\u0627\\u06cc\\u0645 \\u0648 \\u062a\\u0648\\u062c\\u0647 \\u0622\\u0646\\u0647\\u0627 \\u0628\\u0647 \\u062c\\u0632\\u0626\\u06cc\\u0627\\u062a \\u0648\\u0627\\u0642\\u0639\\u0627\\u064b \\u0628\\u0631\\u062c\\u0633\\u062a\\u0647 \\u0627\\u0633\\u062a.\\\"\"},{\"_id\":\"4c80bef\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img3.jpg\",\"id\":218,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0631\\u0627\\u0645\\u06cc\\u0646 \\u0633\\u0647\\u0631\\u0627\\u0628\\u06cc\\u200c\\u0646\\u0698\\u0627\\u062f\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0645\\u0646 \\u0648 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647\\u200c\\u0627\\u0645 \\u0633\\u0627\\u0644\\u200c\\u0647\\u0627\\u0633\\u062a \\u06a9\\u0647 \\u0628\\u0647 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0645\\u06cc\\u200c\\u0622\\u06cc\\u0645. \\u062e\\u062f\\u0645\\u0627\\u062a \\u0641\\u0648\\u0642\\u200c\\u0627\\u0644\\u0639\\u0627\\u062f\\u0647 \\u0627\\u0633\\u062a \\u0648 \\u062a\\u06cc\\u0645 \\u0645\\u0627 \\u0647\\u0645\\u06cc\\u0634\\u0647 \\u062a\\u0645\\u0627\\u0645 \\u062a\\u0644\\u0627\\u0634 \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u062f \\u062a\\u0627 \\u0645\\u0637\\u0645\\u0626\\u0646 \\u0634\\u0648\\u062f \\u0645\\u0627 \\u0631\\u0627\\u0636\\u06cc \\u0647\\u0633\\u062a\\u06cc\\u0645 \\u0648 \\u0628\\u0647 \\u062e\\u0648\\u0628\\u06cc \\u0627\\u0632 \\u0645\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u0645\\u06cc\\u200c\\u0634\\u0648\\u062f.\\\"\"},{\"_id\":\"dd49806\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img4.jpg\",\"id\":219,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0622\\u0631\\u0627\\u062f \\u0627\\u0645\\u0627\\u0645\\u06cc\\u200c\\u0641\\u0631\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0645\\u0646 \\u0628\\u0631\\u0627\\u06cc \\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc\\u0645 \\u0628\\u0647 \\u0645\\u0637\\u0628 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0647 \\u06a9\\u0631\\u062f\\u0645 \\u0648 \\u0628\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f \\u0628\\u0647 \\u0646\\u0641\\u0633\\u06cc \\u06a9\\u0627\\u0645\\u0644\\u0627\\u064b \\u062c\\u062f\\u06cc\\u062f \\u0622\\u0646\\u062c\\u0627 \\u0631\\u0627 \\u062a\\u0631\\u06a9 \\u06a9\\u0631\\u062f\\u0645. \\u0646\\u062a\\u0627\\u06cc\\u062c \\u0634\\u06af\\u0641\\u062a\\u200c\\u0627\\u0646\\u06af\\u06cc\\u0632 \\u0628\\u0648\\u062f \\u0648 \\u06a9\\u0627\\u0631\\u06a9\\u0646\\u0627\\u0646\\u060c \\u0627\\u06cc\\u0646 \\u062a\\u062c\\u0631\\u0628\\u0647 \\u0631\\u0627 \\u0628\\u0647 \\u062a\\u062c\\u0631\\u0628\\u0647\\u200c\\u0627\\u06cc \\u0622\\u0631\\u0627\\u0645\\u0634\\u200c\\u0628\\u062e\\u0634 \\u062a\\u0628\\u062f\\u06cc\\u0644 \\u06a9\\u0631\\u062f\\u0646\\u062f.\\\"\"},{\"_id\":\"e16c281\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img5.jpg\",\"id\":220,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0633\\u06cc\\u0646\\u0627 \\u0641\\u0647\\u06cc\\u0645\\u06cc\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\\"\\u0622\\u0646\\u0647\\u0627 \\u062d\\u0631\\u0641\\u0647\\u200c\\u0627\\u06cc\\u060c \\u062f\\u0648\\u0633\\u062a\\u0627\\u0646\\u0647 \\u0648 \\u0648\\u0627\\u0642\\u0639\\u0627\\u064b \\u0628\\u0647 \\u0633\\u0644\\u0627\\u0645\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u0634\\u0645\\u0627 \\u0627\\u0647\\u0645\\u06cc\\u062a \\u0645\\u06cc\\u200c\\u062f\\u0647\\u0646\\u062f. \\u0645\\u0646 \\u06a9\\u0627\\u0645\\u0644\\u0627\\u064b \\u0628\\u0647 \\u0622\\u0646\\u0647\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f \\u062f\\u0627\\u0631\\u0645 \\u0648 \\u0622\\u0646\\u0647\\u0627 \\u0631\\u0627 \\u0628\\u0647 \\u0647\\u0631 \\u06a9\\u0633\\u06cc \\u06a9\\u0647 \\u0628\\u0647 \\u062f\\u0646\\u0628\\u0627\\u0644 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u0639\\u0627\\u0644\\u06cc \\u0627\\u0633\\u062a \\u062a\\u0648\\u0635\\u06cc\\u0647 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0645.\\\"\"},{\"_id\":\"99106f0\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img6.jpg\",\"id\":221,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0634\\u0627\\u0647\\u0648 \\u0622\\u0631\\u06cc\\u0627\\u0646\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0628\\u062f\\u0648\\u0646 \\u0634\\u06a9 \\u0628\\u0647\\u062a\\u0631\\u06cc\\u0646 \\u062a\\u062c\\u0631\\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u06a9\\u0647 \\u062a\\u0627 \\u0628\\u0647 \\u062d\\u0627\\u0644 \\u062f\\u0627\\u0634\\u062a\\u0647\\u200c\\u0627\\u0645. \\u0647\\u0645\\u0647 \\u0686\\u06cc\\u0632 \\u0627\\u0632 \\u062a\\u0639\\u06cc\\u06cc\\u0646 \\u0648\\u0642\\u062a \\u062a\\u0627 \\u062f\\u0631\\u0645\\u0627\\u0646 \\u0631\\u0648\\u0627\\u0646\\u060c \\u0631\\u0627\\u062d\\u062a \\u0648 \\u0628\\u0627 \\u0633\\u0644\\u06cc\\u0642\\u0647 \\u0634\\u062e\\u0635\\u06cc \\u0627\\u0646\\u062c\\u0627\\u0645 \\u0634\\u062f.\\\"\"},{\"_id\":\"69170d9\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img7.jpg\",\"id\":222,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u067e\\u06cc\\u0645\\u0627\\u0646 \\u0627\\u06a9\\u0628\\u0631\\u06cc\\u0627\\u0646\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0645\\u0646 \\u0647\\u0631\\u06af\\u0632 \\u062f\\u0631 \\u0645\\u0637\\u0628 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u062a\\u0627 \\u0627\\u06cc\\u0646 \\u062d\\u062f \\u0627\\u062d\\u0633\\u0627\\u0633 \\u0631\\u0627\\u062d\\u062a\\u06cc \\u0646\\u06a9\\u0631\\u062f\\u0647 \\u0628\\u0648\\u062f\\u0645. \\u062a\\u06cc\\u0645 \\u0622\\u0646\\u0647\\u0627 \\u0628\\u0633\\u06cc\\u0627\\u0631 \\u0645\\u0647\\u0631\\u0628\\u0627\\u0646\\u060c \\u062d\\u0631\\u0641\\u0647\\u200c\\u0627\\u06cc \\u0648 \\u062f\\u0642\\u06cc\\u0642 \\u0627\\u0633\\u062a. \\u0622\\u0646\\u0647\\u0627 \\u0647\\u0645\\u06cc\\u0634\\u0647 \\u0647\\u0645\\u0647 \\u0686\\u06cc\\u0632 \\u0631\\u0627 \\u0628\\u0627 \\u062c\\u0632\\u0626\\u06cc\\u0627\\u062a \\u062a\\u0648\\u0636\\u06cc\\u062d \\u0645\\u06cc\\u200c\\u062f\\u0647\\u0646\\u062f \\u0648 \\u0645\\u0646 \\u0647\\u0631 \\u0628\\u0627\\u0631 \\u0628\\u0627 \\u0644\\u0628\\u062e\\u0646\\u062f \\u0622\\u0646\\u062c\\u0627 \\u0631\\u0627 \\u062a\\u0631\\u06a9 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0645!\\\"\"},{\"_id\":\"2fd1679\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img8.jpg\",\"id\":223,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u062f\\u0627\\u0646\\u06cc\\u0627\\u0644 \\u0628\\u06cc\\u06af\\u06cc\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u062a\\u062c\\u0631\\u0628\\u0647 \\u0645\\u0646 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0641\\u0648\\u0642\\u200c\\u0627\\u0644\\u0639\\u0627\\u062f\\u0647 \\u0628\\u0648\\u062f\\u0647 \\u0627\\u0633\\u062a! \\u06a9\\u0627\\u0631\\u06a9\\u0646\\u0627\\u0646 \\u062e\\u0648\\u0634\\u200c\\u0628\\u0631\\u062e\\u0648\\u0631\\u062f \\u0647\\u0633\\u062a\\u0646\\u062f\\u060c \\u0645\\u0637\\u0628 \\u0628\\u06cc\\u200c\\u0639\\u06cc\\u0628 \\u0648 \\u0646\\u0642\\u0635 \\u0627\\u0633\\u062a \\u0648 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627 \\u062f\\u0631\\u062c\\u0647 \\u06cc\\u06a9 \\u0647\\u0633\\u062a\\u0646\\u062f. \\u0645\\u0646 \\u0647\\u0645\\u06cc\\u0634\\u0647 \\u0627\\u062d\\u0633\\u0627\\u0633 \\u0622\\u0631\\u0627\\u0645\\u0634 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0645 \\u0648 \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc\\u0645 \\u0647\\u0631\\u06af\\u0632 \\u0628\\u0647\\u062a\\u0631 \\u0627\\u0632 \\u0627\\u06cc\\u0646 \\u0628\\u0647 \\u0646\\u0638\\u0631 \\u0646\\u0631\\u0633\\u06cc\\u062f\\u0647\\u200c\\u0627\\u0646\\u062f!\\\"\"},{\"_id\":\"018e3c6\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img9.jpg\",\"id\":224,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0633\\u0627\\u0645\\u0627\\u0646 \\u0628\\u06cc\\u0631\\u0627\\u0645\\u06cc\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0627\\u0632 \\u0647\\u0645\\u0627\\u0646 \\u0644\\u062d\\u0638\\u0647 \\u0648\\u0631\\u0648\\u062f\\u060c \\u0627\\u062d\\u0633\\u0627\\u0633 \\u0631\\u0627\\u062d\\u062a\\u06cc \\u06a9\\u0631\\u062f\\u0645. \\u06a9\\u0627\\u0631\\u06a9\\u0646\\u0627\\u0646 \\u0637\\u0648\\u0631\\u06cc \\u0631\\u0641\\u062a\\u0627\\u0631 \\u06a9\\u0631\\u062f\\u0646\\u062f \\u06a9\\u0647 \\u0627\\u062d\\u0633\\u0627\\u0633 \\u06a9\\u0646\\u0645 \\u0645\\u062b\\u0644 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647\\u200c\\u0627\\u0645 \\u0647\\u0633\\u062a\\u0645 \\u0648 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u06cc \\u06a9\\u0647 \\u062f\\u0631\\u06cc\\u0627\\u0641\\u062a \\u06a9\\u0631\\u062f\\u0645 \\u0627\\u0633\\u062a\\u062b\\u0646\\u0627\\u06cc\\u06cc \\u0628\\u0648\\u062f. \\u0627\\u0632 \\u0644\\u0628\\u062e\\u0646\\u062f\\u0645 \\u062e\\u06cc\\u0644\\u06cc \\u0631\\u0627\\u0636\\u06cc \\u0647\\u0633\\u062a\\u0645. \\u0628\\u0627\\u0628\\u062a \\u0647\\u0645\\u0647 \\u0686\\u06cc\\u0632 \\u0645\\u0645\\u0646\\u0648\\u0646\\u0645!\\\"\"}],\"col_xxl\":\"5\",\"center\":\"true\",\"pagination\":\"true\",\"infinite\":\"true\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"600\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"-240\",\"bottom\":\"0\",\"left\":\"-240\",\"isLinked\":false},\"col_md\":\"2\",\"_margin_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_testimonial_carousel\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"d1c1cbb\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":30,\"column\":\"30\",\"row\":\"30\",\"isLinked\":true},\"flex_align_items\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#4A7CD2\",\"padding\":{\"unit\":\"px\",\"top\":\"50\",\"right\":\"15\",\"bottom\":\"50\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"8418409\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":60},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"0d1c6c2\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0622\\u0645\\u0627\\u062f\\u0647 \\u0631\\u0632\\u0631\\u0648 \\u0646\\u0648\\u0628\\u062a \\u062e\\u0648\\u062f \\u0647\\u0633\\u062a\\u06cc\\u062f\\u061f\",\"title_color\":\"#FFFFFF\",\"title_typography_typography\":\"custom\",\"title_typography_font_size\":{\"unit\":\"px\",\"size\":32,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"3cf7c4b\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0647\\u0645\\u06cc\\u0646 \\u0627\\u0645\\u0631\\u0648\\u0632 \\u0628\\u0627 \\u0645\\u0627 \\u062a\\u0645\\u0627\\u0633 \\u0628\\u06af\\u06cc\\u0631\\u06cc\\u062f \\u062a\\u0627 \\u0648\\u0642\\u062a \\u0645\\u0644\\u0627\\u0642\\u0627\\u062a \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0631\\u0632\\u0631\\u0648 \\u06a9\\u0646\\u06cc\\u062f \\u0648 \\u0627\\u0648\\u0644\\u06cc\\u0646 \\u0642\\u062f\\u0645 \\u0631\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u062f\\u0627\\u0634\\u062a\\u0646 \\u0644\\u0628\\u062e\\u0646\\u062f\\u06cc \\u0633\\u0627\\u0644\\u0645\\u200c\\u062a\\u0631 \\u0628\\u0631\\u062f\\u0627\\u0631\\u06cc\\u062f.<\\/p>\",\"text_color\":\"#FFFFFF99\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"97ded05\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":40},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"b7a7381\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0631\\u0632\\u0631\\u0648 \\u0646\\u0648\\u0628\\u062a\",\"align\":\"left\",\"border_type\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"border_color\":\"#FFFFFF80\",\"border_color_hover\":\"#10244B\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/booking\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"}},\"elements\":[],\"widgetType\":\"pxl_button\"}],\"isInner\":true}],\"isInner\":false}]\";s:10:\"_edit_lock\";s:12:\"1758147530:1\";s:10:\"_edit_last\";s:1:\"1\";s:22:\"_elementor_page_assets\";a:2:{s:7:\"scripts\";a:14:{i:0;s:18:\"elementor-frontend\";i:1;s:6:\"swiper\";i:2;s:19:\"elementor-waypoints\";i:3;s:16:\"jquery-numerator\";i:4;s:11:\"pxl-counter\";i:5;s:14:\"dentia-counter\";i:6;s:4:\"tilt\";i:7;s:12:\"pxl-tweenmax\";i:8;s:17:\"pxl-counter-slide\";i:9;s:12:\"imagesloaded\";i:10;s:7:\"isotope\";i:11;s:13:\"pxl-post-grid\";i:12;s:16:\"dentia-accordion\";i:13;s:10:\"pxl-swiper\";}s:6:\"styles\";a:2:{i:0;s:20:\"e-animation-fadeInUp\";i:1;s:8:\"e-swiper\";}}s:14:\"_elementor_css\";a:6:{s:4:\"time\";i:1758109738;s:5:\"fonts\";a:0:{}s:5:\"icons\";a:2:{i:0;s:0:\"\";i:1;s:8:\"fa-solid\";}s:20:\"dynamic_elements_ids\";a:0:{}s:6:\"status\";s:4:\"file\";i:0;s:0:\"\";}s:24:\"_elementor_element_cache\";s:90303:\"{\"timeout\":1758208738,\"value\":{\"content\":\"<div class=\\\"elementor-element elementor-element-5161d23 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"5161d23\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;slideshow&quot;,&quot;background_slideshow_gallery&quot;:[{&quot;id&quot;:1485,&quot;url&quot;:&quot;https:\\\\\\/\\\\\\/dentia.sunthemes.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/2025\\\\\\/08\\\\\\/1-min-e1758004018967.jpg&quot;},{&quot;id&quot;:1486,&quot;url&quot;:&quot;https:\\\\\\/\\\\\\/dentia.sunthemes.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/2025\\\\\\/08\\\\\\/2-min-e1758004028449.jpg&quot;}],&quot;background_slideshow_lazyload&quot;:&quot;yes&quot;,&quot;background_slideshow_slide_transition&quot;:&quot;slide_right&quot;,&quot;background_slideshow_loop&quot;:&quot;yes&quot;,&quot;background_slideshow_slide_duration&quot;:5000,&quot;background_slideshow_transition_duration&quot;:500}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-0b31933 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"0b31933\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImJkMTFiMGEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDY0NFx1MDYyOFx1MDYyZVx1MDY0Nlx1MDYyZlx1MDY0N1x1MDYyN1x1MDZjYyBcdTA2MzJcdTA2Y2NcdTA2MjhcdTA2MjdcdTA2MmFcdTA2MzEgXHUwNjI4XHUwNjI3IFx1MDY0NVx1MDYzMVx1MDYyN1x1MDY0Mlx1MDYyOFx1MDYyYSBcdTA2MmFcdTA2MmVcdTA2MzVcdTA2MzVcdTA2Y2MgXHUwNjQ4IFx1MDY0NFx1MDY0NVx1MDYzMyBcdTA2NDVcdTA2NDRcdTA2MjdcdTA2Y2NcdTA2NDUiLCJzdWJfdGl0bGUiOiJcdTA2NDVcdTA2MzFcdTA2MjdcdTA2NDJcdTA2MjhcdTA2MmFcdTIwMGNcdTA2NDdcdTA2MjdcdTA2Y2MgXHUwNjJmXHUwNjQ2XHUwNjJmXHUwNjI3XHUwNjQ2XHUwNjdlXHUwNjMyXHUwNjM0XHUwNmE5XHUwNmNjIFx1MDYyZVx1MDYyN1x1MDY0Nlx1MDY0OFx1MDYyN1x1MDYyZlx1MDY0NyIsImhfd2lkdGgiOnsidW5pdCI6IiUiLCJzaXplIjo0OSwic2l6ZXMiOltdfSwiaF93aWR0aF9sYXB0b3AiOnsidW5pdCI6IiUiLCJzaXplIjo1NSwic2l6ZXMiOltdfSwiaF93aWR0aF90YWJsZXRfZXh0cmEiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF90YWJsZXQiOnsidW5pdCI6IiUiLCJzaXplIjoxMDAsInNpemVzIjpbXX0sImhfd2lkdGhfbW9iaWxlX2V4dHJhIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sImhfd2lkdGhfbW9iaWxlIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sInRpdGxlX3RhZyI6ImgxIiwidGl0bGVfY29sb3IiOiIjRkZGRkZGIiwic3ViX3RpdGxlX2NvbG9yIjoiI0ZGRkZGRiIsInN1Yl90aXRsZV90eXBvZ3JhcGh5X3R5cG9ncmFwaHkiOiJjdXN0b20iLCJzdWJfdGl0bGVfdHlwb2dyYXBoeV9mb250X3NpemUiOnsidW5pdCI6InB4Iiwic2l6ZSI6MTYsInNpemVzIjpbXX0sInN1Yl90aXRsZV90eXBvZ3JhcGh5X2ZvbnRfd2VpZ2h0IjoiNjAwIiwic3ViX3RpdGxlX3R5cG9ncmFwaHlfbGluZV9oZWlnaHQiOnsidW5pdCI6ImVtIiwic2l6ZSI6MS41LCJzaXplcyI6W119LCJzdWJfdGl0bGVfdHlwb2dyYXBoeV9saW5lX2hlaWdodF9sYXB0b3AiOnsidW5pdCI6ImVtIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sInN1Yl90aXRsZV90eXBvZ3JhcGh5X2xpbmVfaGVpZ2h0X3RhYmxldF9leHRyYSI6eyJ1bml0IjoiZW0iLCJzaXplIjoiIiwic2l6ZXMiOltdfSwic3ViX3RpdGxlX3R5cG9ncmFwaHlfbGluZV9oZWlnaHRfbW9iaWxlX2V4dHJhIjp7InVuaXQiOiJlbSIsInNpemUiOiIiLCJzaXplcyI6W119LCJzdWJfdGl0bGVfc3BhY2VfYm90dG9tIjp7InVuaXQiOiJweCIsInNpemUiOjIwLCJzaXplcyI6W119LCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIyMCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwidGl0bGVfdHlwb2dyYXBoeV90eXBvZ3JhcGh5IjoiY3VzdG9tIiwidGl0bGVfdHlwb2dyYXBoeV9mb250X3NpemVfbW9iaWxlIjp7InVuaXQiOiJweCIsInNpemUiOjQ1LCJzaXplcyI6W119LCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNDAwIiwicHhsX2FuaW1hdGVfc3ViIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXlfc3ViIjoiMzAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9oZWFkaW5nIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImMxNjJkYzciLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0IjoiXHUwNjMxXHUwNjMyXHUwNjMxXHUwNjQ4IFx1MDY0Nlx1MDY0OFx1MDYyOFx1MDYyYSIsImxpbmsiOnsidXJsIjoiaHR0cHM6XC9cL2RlbnRpYS5zdW50aGVtZXMuaXJcL2Jvb2tpbmdcLyIsImlzX2V4dGVybmFsIjoiIiwibm9mb2xsb3ciOiIiLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9LCJidG5fYmdfY29sb3IiOiIjMDIwMTAxMDAiLCJib3JkZXJfdHlwZSI6InNvbGlkIiwiYm9yZGVyX3dpZHRoIjp7InVuaXQiOiJweCIsInRvcCI6IjEiLCJyaWdodCI6IjEiLCJib3R0b20iOiIxIiwibGVmdCI6IjEiLCJpc0xpbmtlZCI6dHJ1ZX0sImJvcmRlcl9jb2xvciI6IiNGRkZGRkYiLCJjb2xvcl9ob3ZlciI6IiNGRkZGRkYiLCJidG5fYmdfY29sb3JfaG92ZXIiOiIjMDAwQTVCIiwiYnRuX2JnX2NvbG9yX2FjdGl2ZSI6IiMwMDBBNUIiLCJidG5fYmdfY29sb3JfZm9jdXMiOiIjMDAwQTVCIiwiYm9yZGVyX2NvbG9yX2hvdmVyIjoiIzAwMEE1QiIsIl9tYXJnaW4iOnsidW5pdCI6InB4IiwidG9wIjoiMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjMwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9LCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNTAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9idXR0b24ifQ==\\\"]<div class=\\\"elementor-element elementor-element-9d1bee4 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none elementor-invisible e-con e-child \\\" data-id=\\\"9d1bee4\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;animation&quot;:&quot;fadeInUp&quot;,&quot;animation_delay&quot;:600}\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImFjNmI2Y2YiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGRpdiBjbGFzcz1cIm1lLTNcIj5cdTA2MzFcdTA2MmFcdTA2MjhcdTA2NDdcdTIwMGNcdTA2MjhcdTA2NDZcdTA2MmZcdTA2Y2MgXHUwNmFmXHUwNjQ4XHUwNmFmXHUwNjQ0PFwvZGl2PiIsInRleHRfY29sb3IiOiIjRjhGOUZBIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjA1YjM1Y2YiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGRpdiBjbGFzcz1cIm1lLTNcIj48ZGl2IGNsYXNzPVwibWUtM1wiPjUuMDxcL2Rpdj48XC9kaXY+IiwidGV4dF9jb2xvciI6IiNGOEY5RkEifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX3RleHRfZWRpdG9yIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImJkNTEzYmYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpY29ucyI6W3siX2lkIjoiZTFlZjdiYyIsInB4bF9pY29uIjp7InZhbHVlIjoiZmFzIGZhLXN0YXIiLCJsaWJyYXJ5IjoiZmEtc29saWQifX0seyJweGxfaWNvbiI6eyJ2YWx1ZSI6ImZhcyBmYS1zdGFyIiwibGlicmFyeSI6ImZhLXNvbGlkIn0sIl9pZCI6IjFmYmYxNGUifSx7InB4bF9pY29uIjp7InZhbHVlIjoiZmFzIGZhLXN0YXIiLCJsaWJyYXJ5IjoiZmEtc29saWQifSwiX2lkIjoiOThlZDc3ZCJ9LHsicHhsX2ljb24iOnsidmFsdWUiOiJmYXMgZmEtc3RhciIsImxpYnJhcnkiOiJmYS1zb2xpZCJ9LCJfaWQiOiIxNjg1YTdiIn0seyJweGxfaWNvbiI6eyJ2YWx1ZSI6ImZhcyBmYS1zdGFyIiwibGlicmFyeSI6ImZhLXNvbGlkIn0sIl9pZCI6IjY3YWE1NzMifV0sImNvbG9yIjoiI0ZFQzQyQyIsImljb25fZm9udF9zaXplIjp7InVuaXQiOiJweCIsInNpemUiOjE1LCJzaXplcyI6W119LCJpY29uX3NwYWNlIjp7InVuaXQiOiJweCIsInNpemUiOjIsInNpemVzIjpbXX19LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfaWNvbiJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjY1MzE3MDMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGRpdiBjbGFzcz1cIm1lLTNcIj48ZGl2IGNsYXNzPVwibWUtM1wiPjxkaXYgY2xhc3M9XCJtZS0zXCI+XHUwNjI4XHUwNjMxIFx1MDYyN1x1MDYzM1x1MDYyN1x1MDYzMyBcdTA2ZjJcdTA2ZjMgXHUwNjQ3XHUwNjMyXHUwNjI3XHUwNjMxIFx1MDY0Nlx1MDY0Mlx1MDYyZiBcdTA2NDggXHUwNjI4XHUwNjMxXHUwNjMxXHUwNjMzXHUwNmNjPFwvZGl2PjxcL2Rpdj48XC9kaXY+IiwidGV4dF9jb2xvciI6IiNGOEY5RkEifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX3RleHRfZWRpdG9yIn0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-af13e9f e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"af13e9f\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-f6f14ff e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"f6f14ff\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-2f08b27 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"2f08b27\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjM2MjdjMGEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIyIiwicHhsX2ljb24iOnsidmFsdWUiOiJmYXMgZmEtcGhvbmUtYWx0IiwibGlicmFyeSI6ImZhLXNvbGlkIn0sInRpdGxlIjoiXHUwNjI4XHUwNjQ3IFx1MDYyZVx1MDYyZlx1MDY0NVx1MDYyN1x1MDYyYSBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDZcdTA2N2VcdTA2MzJcdTA2MzRcdTA2YTlcdTA2Y2MgXHUwNjQ2XHUwNmNjXHUwNjI3XHUwNjMyIFx1MDYyZlx1MDYyN1x1MDYzMVx1MDZjY1x1MDYyZlx1MDYxZiIsImRlc2MiOiJcdTA2MmFcdTA2NDVcdTA2MjdcdTA2MzM6IDAyMTEyMzQ1Njc4OSIsInRpdGxlX2NvbG9yIjoiI0ZGRkZGRiIsImljb25fZm9udF9zaXplIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX2hlaWdodCI6eyJ1bml0IjoicHgiLCJzaXplIjo2MCwic2l6ZXMiOltdfSwiZGVzY19jb2xvciI6IiNGRkZGRkY5OSIsImljb25fY29sb3IiOiIjNEE3REMyIiwiaWNvbl9iZ19jb2xvciI6IiMwMjAxMDEwMCIsInRpdGxlX2JvdHRvbSI6eyJ1bml0IjoicHgiLCJzaXplIjowLCJzaXplcyI6W119LCJpbm5lcl9zcGFjZSI6eyJ1bml0IjoicHgiLCJzaXplIjoxNSwic2l6ZXMiOltdfSwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIzMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9fSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ljb25fYm94In0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-4a79de0 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"4a79de0\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-91829d8 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"91829d8\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImI2MzgzYzQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIyIiwicHhsX2ljb24iOnsidmFsdWUiOiJmYXMgZmEtY2xvY2siLCJsaWJyYXJ5IjoiZmEtc29saWQifSwidGl0bGUiOiJcdTA2MzNcdTA2MjdcdTA2MzlcdTA2MjdcdTA2MmEgXHUwNmE5XHUwNjI3XHUwNjMxXHUwNmNjIiwiZGVzYyI6Ilx1MDY0N1x1MDYzMSBcdTA2MzFcdTA2NDhcdTA2MzIgXHUwNjI3XHUwNjMyIDA4OjAwIFx1MDYyYVx1MDYyNyAyMDowMCIsInRpdGxlX2NvbG9yIjoiI0ZGRkZGRiIsImljb25fZm9udF9zaXplIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX2hlaWdodCI6eyJ1bml0IjoicHgiLCJzaXplIjo2MCwic2l6ZXMiOltdfSwiZGVzY19jb2xvciI6IiNGRkZGRkY5OSIsImljb25fY29sb3IiOiIjNEE3REMyIiwiaWNvbl9iZ19jb2xvciI6IiMwMjAxMDEwMCIsInRpdGxlX2JvdHRvbSI6eyJ1bml0IjoicHgiLCJzaXplIjowLCJzaXplcyI6W119LCJpbm5lcl9zcGFjZSI6eyJ1bml0IjoicHgiLCJzaXplIjoxNSwic2l6ZXMiOltdfSwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIzMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9LCJfZWxlbWVudF93aWR0aF9tb2JpbGUiOiJpbmhlcml0In0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9pY29uX2JveCJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-6a5100f e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"6a5100f\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-4eaeb3c e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"4eaeb3c\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImZmMzhkNmQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIyIiwicHhsX2ljb24iOnsidmFsdWUiOiJmYXMgZmEtZW52ZWxvcGUiLCJsaWJyYXJ5IjoiZmEtc29saWQifSwidGl0bGUiOiJcdTA2MjdcdTA2Y2NcdTA2NDVcdTA2Y2NcdTA2NDQgXHUwNjQ1XHUwNjI3IiwiZGVzYyI6ImNvbnRhY3RAZGVudGlhY2xpbmljLmNvbSIsInRpdGxlX2NvbG9yIjoiI0ZGRkZGRiIsImljb25fZm9udF9zaXplIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX2hlaWdodCI6eyJ1bml0IjoicHgiLCJzaXplIjo2MCwic2l6ZXMiOltdfSwiZGVzY19jb2xvciI6IiNGRkZGRkY5OSIsImljb25fY29sb3IiOiIjNEE3REMyIiwiaWNvbl9iZ19jb2xvciI6IiMwMjAxMDEwMCIsInRpdGxlX2JvdHRvbSI6eyJ1bml0IjoicHgiLCJzaXplIjowLCJzaXplcyI6W119LCJpbm5lcl9zcGFjZSI6eyJ1bml0IjoicHgiLCJzaXplIjoxNSwic2l6ZXMiOltdfSwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIzMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9LCJfZWxlbWVudF93aWR0aF9tb2JpbGUiOiJpbmhlcml0In0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9pY29uX2JveCJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-15b34f8 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"15b34f8\\\" data-element_type=\\\"container\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-98ca70d e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"98ca70d\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-43ff422 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"43ff422\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImI2OThiYjQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2Fib3V0LWltZzEuanBnIiwiaWQiOjQ2Mywic2l6ZSI6IiIsImFsdCI6IiIsInNvdXJjZSI6ImxpYnJhcnkifSwiaW1hZ2VfdHlwZSI6ImJnIiwiaW1hZ2VfaGVpZ2h0Ijp7InVuaXQiOiJweCIsInNpemUiOjM5OSwic2l6ZXMiOltdfSwiYm9yZGVyX3JhZGl1cyI6eyJ1bml0IjoicHgiLCJ0b3AiOiIyMCIsInJpZ2h0IjoiMjAiLCJib3R0b20iOiIyMCIsImxlZnQiOiIyMCIsImlzTGlua2VkIjp0cnVlfSwicGFyYWxsYXhfdmFsdWUiOiI0MCIsIm1heF90aWx0IjoiMTAiLCJzcGVlZF90aWx0IjoiNDAwIiwicGVyc3BlY3RpdmVfdGlsdCI6IjEwMDAiLCJweGxfYW5pbWF0ZSI6IndvdyB6b29tSW5TbWFsbCIsInB4bF9hbmltYXRlX2RlbGF5IjoiMzAwIiwicHhsX2FuaW1hdGVfaW1nIjoid293IHNjYWxlSW4iLCJweGxfYW5pbWF0ZV9pbWdfZGVsYXkiOiIzMDAifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ltYWdlIn0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-4c3a639 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"4c3a639\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjNhMjZlY2QiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2Fib3V0LWltZzIuanBnIiwiaWQiOjQ2NCwic2l6ZSI6IiIsImFsdCI6IiIsInNvdXJjZSI6ImxpYnJhcnkifSwiaW1hZ2VfdHlwZSI6ImJnIiwiaW1hZ2VfaGVpZ2h0Ijp7InVuaXQiOiJweCIsInNpemUiOjM5OSwic2l6ZXMiOltdfSwiYm9yZGVyX3JhZGl1cyI6eyJ1bml0IjoicHgiLCJ0b3AiOiIyMCIsInJpZ2h0IjoiMjAiLCJib3R0b20iOiIyMCIsImxlZnQiOiIyMCIsImlzTGlua2VkIjp0cnVlfSwicGFyYWxsYXhfdmFsdWUiOiI0MCIsIm1heF90aWx0IjoiMTAiLCJzcGVlZF90aWx0IjoiNDAwIiwicGVyc3BlY3RpdmVfdGlsdCI6IjEwMDAiLCJweGxfYW5pbWF0ZSI6IndvdyB6b29tSW5TbWFsbCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNTAwIiwicHhsX2FuaW1hdGVfaW1nIjoid293IHNjYWxlSW4iLCJweGxfYW5pbWF0ZV9pbWdfZGVsYXkiOiI1MDAifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ltYWdlIn0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-9dd8e84 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"9dd8e84\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImIwMjk3YmYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDY0NVx1MDYyYVx1MDYyZVx1MDYzNVx1MDYzNVx1MDYyN1x1MDY0NiBcdTA2NDggXHUwNjJhXHUwNjM5XHUwNjI3XHUwNjQ0XHUwNmNjIFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2MzRcdTA2MmVcdTA2MzVcdTA2Y2MiLCJzdWJfdGl0bGUiOiJcdTA2MmZcdTA2MzFcdTA2MjhcdTA2MjdcdTA2MzFcdTA2NDcgXHUwNjQ1XHUwNjI3IiwiaF93aWR0aCI6eyJ1bml0IjoiJSIsInNpemUiOjgwLCJzaXplcyI6W119LCJoX3dpZHRoX2xhcHRvcCI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJoX3dpZHRoX3RhYmxldF9leHRyYSI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJoX3dpZHRoX3RhYmxldCI6eyJ1bml0IjoiJSIsInNpemUiOjEwMCwic2l6ZXMiOltdfSwiaF93aWR0aF9tb2JpbGVfZXh0cmEiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF9tb2JpbGUiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwidGl0bGVfdGFnIjoiaDIiLCJzdWJfdGl0bGVfc3BhY2VfYm90dG9tIjp7InVuaXQiOiJweCIsInNpemUiOjE3LCJzaXplcyI6W119LCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIyMCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjQwMCIsInB4bF9hbmltYXRlX3N1YiI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5X3N1YiI6IjMwMCIsInRpdGxlX3R5cG9ncmFwaHlfdHlwb2dyYXBoeSI6ImN1c3RvbSIsInRpdGxlX3R5cG9ncmFwaHlfZm9udF9zaXplX21vYmlsZSI6eyJ1bml0IjoicHgiLCJzaXplIjo0NSwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9oZWFkaW5nIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjZiYzg3ZTgiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjQ1XHUwNjI3IFx1MDYyZVx1MDYyZlx1MDY0NVx1MDYyN1x1MDYyYSBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDZcdTA2N2VcdTA2MzJcdTA2MzRcdTA2YTlcdTA2Y2MgXHUwNjI4XHUwNjI3IFx1MDZhOVx1MDZjY1x1MDY0MVx1MDZjY1x1MDYyYSBcdTA2MjhcdTA2MjdcdTA2NDRcdTA2MjcgXHUwNjQ4IFx1MDY0NVx1MDYyYVx1MDY0Nlx1MDYyN1x1MDYzM1x1MDYyOCBcdTA2MjhcdTA2MjcgXHUwNjQ2XHUwNmNjXHUwNjI3XHUwNjMyIFx1MDYyYVx1MDY0NVx1MDYyN1x1MDY0NSBcdTA2MjdcdTA2MzlcdTA2MzZcdTA2MjdcdTA2Y2MgXHUwNjJlXHUwNjI3XHUwNjQ2XHUwNjQ4XHUwNjI3XHUwNjJmXHUwNjQ3IFx1MDYyN1x1MDYzMVx1MDYyN1x1MDYyNlx1MDY0NyBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2MmZcdTA2NDdcdTA2Y2NcdTA2NDUuIFx1MDYyN1x1MDYzMiBcdTA2NDVcdTA2MzlcdTA2MjdcdTA2Y2NcdTA2NDZcdTA2MjdcdTA2MmEgXHUwNjMxXHUwNjQ4XHUwNjJhXHUwNmNjXHUwNjQ2IFx1MDZhZlx1MDYzMVx1MDY0MVx1MDYyYVx1MDY0NyBcdTA2MmFcdTA2MjcgXHUwNjJmXHUwNjMxXHUwNjQ1XHUwNjI3XHUwNjQ2XHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY3ZVx1MDZjY1x1MDYzNFx1MDYzMVx1MDY0MVx1MDYyYVx1MDY0N1x1MDYwYyBcdTA2MmFcdTA2Y2NcdTA2NDUgXHUwNjJmXHUwNjQ0XHUwNjMzXHUwNjQ4XHUwNjMyIFx1MDY0NVx1MDYyNyBcdTA2MmFcdTA2MzZcdTA2NDVcdTA2Y2NcdTA2NDYgXHUwNjQ1XHUwNmNjXHUyMDBjXHUwNmE5XHUwNjQ2XHUwNjJmIFx1MDZhOVx1MDY0NyBcdTA2NDRcdTA2MjhcdTA2MmVcdTA2NDZcdTA2MmYgXHUwNjM0XHUwNjQ1XHUwNjI3IFx1MDYzM1x1MDYyN1x1MDY0NFx1MDY0NSBcdTA2NDggXHUwNjI4XHUwNjI3IFx1MDYyN1x1MDYzOVx1MDYyYVx1MDY0NVx1MDYyN1x1MDYyZiBcdTA2MjhcdTA2NDcgXHUwNjQ2XHUwNjQxXHUwNjMzIFx1MDYyOFx1MDYyN1x1MDY0Mlx1MDZjYyBcdTA2MjhcdTA2NDVcdTA2MjdcdTA2NDZcdTA2MmYuPFwvcD4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNTAwIiwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIwIiwicmlnaHQiOiIwIiwiYm90dG9tIjoiMTciLCJsZWZ0IjoiMCIsImlzTGlua2VkIjpmYWxzZX19LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfdGV4dF9lZGl0b3IifQ==\\\"]<div class=\\\"elementor-element elementor-element-bb0da06 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"bb0da06\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-9028010 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"9028010\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjgyN2NkYzMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsaXN0cyI6W3siX2lkIjoiMjlmZGFjYiIsInB4bF9pY29uIjp7InZhbHVlIjoiZmFzIGZhLWNoZWNrIiwibGlicmFyeSI6ImZhLXNvbGlkIn0sInRleHQiOiJcdTA2MjhcdTA2MzFcdTA2NDZcdTA2MjdcdTA2NDVcdTA2NDdcdTIwMGNcdTA2NDdcdTA2MjdcdTA2Y2MgXHUwNjJmXHUwNjMxXHUwNjQ1XHUwNjI3XHUwNjQ2IFx1MDYzNFx1MDYyZVx1MDYzNVx1MDZjY1x1MjAwY1x1MDYzM1x1MDYyN1x1MDYzMlx1MDZjY1x1MjAwY1x1MDYzNFx1MDYyZlx1MDY0NyJ9LHsicHhsX2ljb24iOnsidmFsdWUiOiJmYXMgZmEtY2hlY2siLCJsaWJyYXJ5IjoiZmEtc29saWQifSwidGV4dCI6Ilx1MDY0NVx1MDYzMVx1MDYyN1x1MDY0Mlx1MDYyOFx1MDYyYSBcdTA2NDVcdTA2NDRcdTA2MjdcdTA2Y2NcdTA2NDUgXHUwNjI4XHUwNjMxXHUwNjI3XHUwNmNjIFx1MDZhOVx1MDY0OFx1MDYyZlx1MDZhOVx1MDYyN1x1MDY0NiBcdTA2NDggXHUwNjI4XHUwNjMyXHUwNjMxXHUwNmFmXHUwNjMzXHUwNjI3XHUwNjQ0XHUwNjI3XHUwNjQ2IiwiX2lkIjoiN2ZmNjQ3NSJ9XSwidGV4dF90eXBvZ3JhcGh5X3R5cG9ncmFwaHkiOiJjdXN0b20iLCJ0ZXh0X3R5cG9ncmFwaHlfZm9udF9zaXplX2xhcHRvcCI6eyJ1bml0IjoicHgiLCJzaXplIjoxNSwic2l6ZXMiOltdfSwiaWNvbl9jb2xvciI6IiM0QTdEQzIiLCJpY29uX3NwYWNlIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAzIiwiYm90dG9tIjoiMCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjYwMCIsImFsaWduX2l0ZW1zIjoic3RhcnQifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2xpc3QifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-6db1ff5 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"6db1ff5\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImZhNjQ5MGUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsaXN0cyI6W3siX2lkIjoiMjlmZGFjYiIsInB4bF9pY29uIjp7InZhbHVlIjoiZmFzIGZhLWNoZWNrIiwibGlicmFyeSI6ImZhLXNvbGlkIn0sInRleHQiOiJcdTA2NDFcdTA2NDZcdTA2MjdcdTA2NDhcdTA2MzFcdTA2Y2MgXHUwNjdlXHUwNmNjXHUwNjM0XHUwNjMxXHUwNjQxXHUwNjJhXHUwNjQ3In0seyJweGxfaWNvbiI6eyJ2YWx1ZSI6ImZhcyBmYS1jaGVjayIsImxpYnJhcnkiOiJmYS1zb2xpZCJ9LCJ0ZXh0IjoiXHUwNjI4XHUwNjMxXHUwNjQ2XHUwNjI3XHUwNjQ1XHUwNjQ3XHUyMDBjXHUwNjMxXHUwNmNjXHUwNjMyXHUwNmNjIFx1MDYyN1x1MDY0Nlx1MDYzOVx1MDYzN1x1MDYyN1x1MDY0MVx1MjAwY1x1MDY3ZVx1MDYzMFx1MDZjY1x1MDYzMSBcdTA2MjhcdTA2MzFcdTA2MjdcdTA2Y2MgXHUwNjQyXHUwNjMxXHUwNjI3XHUwNjMxIFx1MDY0NVx1MDY0NFx1MDYyN1x1MDY0Mlx1MDYyN1x1MDYyYSIsIl9pZCI6IjdmZjY0NzUifV0sInRleHRfdHlwb2dyYXBoeV90eXBvZ3JhcGh5IjoiY3VzdG9tIiwidGV4dF90eXBvZ3JhcGh5X2ZvbnRfc2l6ZV9sYXB0b3AiOnsidW5pdCI6InB4Iiwic2l6ZSI6MTUsInNpemVzIjpbXX0sImljb25fY29sb3IiOiIjNEE3REMyIiwiaWNvbl9zcGFjZSI6eyJ1bml0IjoicHgiLCJ0b3AiOiIwIiwicmlnaHQiOiIwMyIsImJvdHRvbSI6IjAiLCJsZWZ0IjoiMCIsImlzTGlua2VkIjpmYWxzZX0sInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI2MDAiLCJhbGlnbl9pdGVtcyI6InN0YXJ0In0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9saXN0In0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImYzODk3ZDkiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0IjoiXHUwNjMxXHUwNjMyXHUwNjMxXHUwNjQ4IFx1MDY0Nlx1MDY0OFx1MDYyOFx1MDYyYSIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI3MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjI4IiwicmlnaHQiOiIwIiwiYm90dG9tIjoiMCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9idXR0b24ifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-9f68bac e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"9f68bac\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-ac1ac70 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"ac1ac70\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImM3NGEzZWUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDY0NVx1MDYzMVx1MDYyN1x1MDY0Mlx1MDYyOFx1MDYyYSBcdTA2YTlcdTA2MjdcdTA2NDVcdTA2NDQgXHUwNjI4XHUwNjMxXHUwNjI3XHUwNmNjIFx1MDY0N1x1MDYzMSBcdTA2NDRcdTA2MjhcdTA2MmVcdTA2NDZcdTA2MmYiLCJzdWJfdGl0bGUiOiJcdTA2MmVcdTA2MmZcdTA2NDVcdTA2MjdcdTA2MmEgXHUwNjQ1XHUwNjI3IiwiaF93aWR0aCI6eyJ1bml0IjoiJSIsInNpemUiOjgwLCJzaXplcyI6W119LCJoX3dpZHRoX2xhcHRvcCI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJoX3dpZHRoX3RhYmxldF9leHRyYSI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJoX3dpZHRoX3RhYmxldCI6eyJ1bml0IjoiJSIsInNpemUiOjEwMCwic2l6ZXMiOltdfSwiaF93aWR0aF9tb2JpbGVfZXh0cmEiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF9tb2JpbGUiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwidGl0bGVfdGFnIjoiaDIiLCJzdWJfdGl0bGVfc3BhY2VfYm90dG9tIjp7InVuaXQiOiJweCIsInNpemUiOjE3LCJzaXplcyI6W119LCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIyMCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjQwMCIsInB4bF9hbmltYXRlX3N1YiI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5X3N1YiI6IjMwMCIsInRpdGxlX3R5cG9ncmFwaHlfdHlwb2dyYXBoeSI6ImN1c3RvbSIsInRpdGxlX3R5cG9ncmFwaHlfZm9udF9zaXplX21vYmlsZSI6eyJ1bml0IjoicHgiLCJzaXplIjo0NSwic2l6ZXMiOltdfSwiYWxpZ24iOiJjZW50ZXIifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2hlYWRpbmcifQ==\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjcyODQ3ZjkiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjI3XHUwNjMyIFx1MDYyYVx1MDY0NVx1MDZjY1x1MDYzMiBcdTA2YTlcdTA2MzFcdTA2MmZcdTA2NDZcdTIwMGNcdTA2NDdcdTA2MjdcdTA2Y2MgXHUwNjMxXHUwNjQ4XHUwNjJhXHUwNmNjXHUwNjQ2IFx1MDZhZlx1MDYzMVx1MDY0MVx1MDYyYVx1MDY0NyBcdTA2MmFcdTA2MjcgXHUwNjJhXHUwNjMxXHUwNjQ1XHUwNmNjXHUwNjQ1XHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY3ZVx1MDZjY1x1MDYzNFx1MDYzMVx1MDY0MVx1MDYyYVx1MDY0N1x1MDYwYyBcdTA2NDVcdTA2MjcgXHUwNjMxXHUwNjI3XHUwNjQ3XHUyMDBjXHUwNjJkXHUwNjQ0XHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2MzRcdTA2MmVcdTA2MzVcdTA2Y2NcdTIwMGNcdTA2MzNcdTA2MjdcdTA2MzJcdTA2Y2NcdTIwMGNcdTA2MzRcdTA2MmZcdTA2NDcgXHUwNjMxXHUwNjI3IFx1MDYyOFx1MDYzMVx1MDYyN1x1MDZjYyBcdTA2MjhcdTA2Y2NcdTA2NDVcdTA2MjdcdTA2MzFcdTA2MjdcdTA2NDYgXHUwNjJmXHUwNjMxIFx1MDY0N1x1MDYzMSBcdTA2MzNcdTA2NDZcdTA2Y2MgXHUwNjI3XHUwNjMxXHUwNjI3XHUwNjI2XHUwNjQ3IFx1MDY0NVx1MDZjY1x1MjAwY1x1MDYyZlx1MDY0N1x1MDZjY1x1MDY0NS48XC9wPiIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiI0MiIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwiYWxpZ24iOiJjZW50ZXIiLCJ0X3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjU2Mywic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]<div class=\\\"elementor-element elementor-element-7371f8b e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"7371f8b\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-37741dc e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"37741dc\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-5855528 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"5855528\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImZmMjgxZmEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIzIiwiaWNvbl90eXBlIjoiaW1hZ2UiLCJpY29uX2ltYWdlIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC93cC1jb250ZW50XC91cGxvYWRzXC8yMDI1XC8wOFwvdG9vdGgtMS5wbmciLCJpZCI6NjI2LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJ0aXRsZSI6Ilx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2MzlcdTA2NDVcdTA2NDhcdTA2NDVcdTA2Y2MiLCJkZXNjIjoiXHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhIFx1MDZhOVx1MDYyN1x1MDY0NVx1MDY0NCBcdTA2MmZcdTA2NDdcdTA2MjdcdTA2NDYgXHUwNjQ4IFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0NiBcdTA2MjhcdTA2MzFcdTA2MjdcdTA2Y2MgXHUwNjQ3XHUwNjMxIFx1MDY0NFx1MDYyOFx1MDYyZVx1MDY0Nlx1MDYyZlx1MDZjYyBcdTA2MjhcdTA2MjcgXHUwNjJjXHUwNjMxXHUwNjQ1XHUyMDBjXHUwNmFmXHUwNmNjXHUwNjMxXHUwNmNjXHUwNjBjIFx1MDY0NVx1MDYzOVx1MDYyN1x1MDZjY1x1MDY0Nlx1MDY0NyBcdTA2NDggXHUwNjQ1XHUwNjQ4XHUwNjI3XHUwNjMxXHUwNjJmIFx1MDYyZlx1MDZjY1x1MDZhZlx1MDYzMS4iLCJsaW5rIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC9zZXJ2aWNlXC9nZW5lcmFsLWRlbnRpc3RyeVwvIiwiaXNfZXh0ZXJuYWwiOiIiLCJub2ZvbGxvdyI6IiIsImN1c3RvbV9hdHRyaWJ1dGVzIjoiIn0sInRpdGxlX2J0biI6Ilx1MDYyN1x1MDYzN1x1MDY0NFx1MDYyN1x1MDYzOVx1MDYyN1x1MDYyYSBcdTA2MjhcdTA2Y2NcdTA2MzRcdTA2MmFcdTA2MzEiLCJweGxfYW5pbWF0ZSI6IndvdyBzY2FsZUluIiwicHhsX2FuaW1hdGVfZGVsYXkiOiIzMDAiLCJweGxfYW5pbWF0ZTIiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheTIiOiI1MDAiLCJ0aXRsZV9jb2xvciI6IiMxMDI0NEIiLCJiYWNrZ3JvdW5kX2NvbG9yIjoiI0ZGRkZGRiJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfaWNvbl9ib3gifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-62a7ae9 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"62a7ae9\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImM4ODAwODEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIzIiwiaWNvbl90eXBlIjoiaW1hZ2UiLCJpY29uX2ltYWdlIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC93cC1jb250ZW50XC91cGxvYWRzXC8yMDI1XC8wOFwvdG9vdGgtMi5wbmciLCJpZCI6NjI3LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJ0aXRsZSI6Ilx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOSBcdTA2MzJcdTA2Y2NcdTA2MjhcdTA2MjdcdTA2Y2NcdTA2Y2MiLCJkZXNjIjoiXHUwNjMyXHUwNmNjXHUwNjI4XHUwNjI3XHUwNmNjXHUwNmNjIFx1MDY0NFx1MDYyOFx1MDYyZVx1MDY0Nlx1MDYyZiBcdTA2MmVcdTA2NDhcdTA2MmYgXHUwNjMxXHUwNjI3IFx1MDYyOFx1MDYyNyBcdTA2MzNcdTA2NDFcdTA2Y2NcdTA2MmYgXHUwNmE5XHUwNjMxXHUwNjJmXHUwNjQ2IFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDYwYyBcdTA2NDhcdTA2NDZcdTA2Y2NcdTA2MzFcdTA2NDdcdTA2MjcgXHUwNjQ4IFx1MDY0NVx1MDY0OFx1MDYyN1x1MDYzMVx1MDYyZiBcdTA2MmZcdTA2Y2NcdTA2YWZcdTA2MzEgXHUwNjI3XHUwNjQxXHUwNjMyXHUwNjI3XHUwNmNjXHUwNjM0IFx1MDYyZlx1MDY0N1x1MDZjY1x1MDYyZi4iLCJsaW5rIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC9zZXJ2aWNlXC9jb3NtZXRpYy1kZW50aXN0cnlcLyIsImlzX2V4dGVybmFsIjoiIiwibm9mb2xsb3ciOiIiLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9LCJ0aXRsZV9idG4iOiJcdTA2MjdcdTA2MzdcdTA2NDRcdTA2MjdcdTA2MzlcdTA2MjdcdTA2MmEgXHUwNjI4XHUwNmNjXHUwNjM0XHUwNjJhXHUwNjMxIiwicHhsX2FuaW1hdGUiOiJ3b3cgc2NhbGVJbiIsInB4bF9hbmltYXRlX2RlbGF5IjoiMzAwIiwicHhsX2FuaW1hdGUyIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkyIjoiNTAwIiwidGl0bGVfY29sb3IiOiIjMTAyNDRCIiwiYmFja2dyb3VuZF9jb2xvciI6IiNGRkZGRkYifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ljb25fYm94In0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-964d2d6 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"964d2d6\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjMzNmJmNmYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIzIiwiaWNvbl90eXBlIjoiaW1hZ2UiLCJpY29uX2ltYWdlIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC93cC1jb250ZW50XC91cGxvYWRzXC8yMDI1XC8wOFwvdG9vdGgtMy5wbmciLCJpZCI6NjI4LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJ0aXRsZSI6Ilx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2YTlcdTA2NDhcdTA2MmZcdTA2YTlcdTA2MjdcdTA2NDYiLCJkZXNjIjoiXHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhXHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY0NVx1MDY0NFx1MDYyN1x1MDZjY1x1MDY0NSBcdTA2NDggXHUwNjMzXHUwNjMxXHUwNmFmXHUwNjMxXHUwNjQ1XHUyMDBjXHUwNmE5XHUwNjQ2XHUwNjQ2XHUwNjJmXHUwNjQ3IFx1MDYyN1x1MDYzMiBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDZcdTIwMGNcdTA2NDdcdTA2MjcgXHUwNjI4XHUwNjMxXHUwNjI3XHUwNmNjIFx1MDZhOVx1MDY0OFx1MDYyZlx1MDZhOVx1MDYyN1x1MDY0NiBcdTA2MmFcdTA2MjcgXHUwNjQ0XHUwNjI4XHUwNjJlXHUwNjQ2XHUwNjJmXHUwNmNjIFx1MDYzM1x1MDYyN1x1MDY0NFx1MDY0NSBcdTA2NDggXHUwNjM0XHUwNjI3XHUwNjJmIFx1MDYyZlx1MDYyN1x1MDYzNFx1MDYyYVx1MDY0NyBcdTA2MjhcdTA2MjdcdTA2MzRcdTA2NDZcdTA2MmYuIiwibGluayI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvc2VydmljZVwvcGVkaWF0cmljLWRlbnRpc3RyeVwvIiwiaXNfZXh0ZXJuYWwiOiIiLCJub2ZvbGxvdyI6IiIsImN1c3RvbV9hdHRyaWJ1dGVzIjoiIn0sInRpdGxlX2J0biI6Ilx1MDYyN1x1MDYzN1x1MDY0NFx1MDYyN1x1MDYzOVx1MDYyN1x1MDYyYSBcdTA2MjhcdTA2Y2NcdTA2MzRcdTA2MmFcdTA2MzEiLCJweGxfYW5pbWF0ZSI6IndvdyBzY2FsZUluIiwicHhsX2FuaW1hdGVfZGVsYXkiOiIzMDAiLCJweGxfYW5pbWF0ZTIiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheTIiOiI1MDAiLCJ0aXRsZV9jb2xvciI6IiMxMDI0NEIiLCJiYWNrZ3JvdW5kX2NvbG9yIjoiI0ZGRkZGRiJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfaWNvbl9ib3gifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-2e4cbee e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"2e4cbee\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjIwMjkyMzMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIzIiwiaWNvbl90eXBlIjoiaW1hZ2UiLCJpY29uX2ltYWdlIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC93cC1jb250ZW50XC91cGxvYWRzXC8yMDI1XC8wOFwvdG9vdGgtNC5wbmciLCJpZCI6NjI5LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJ0aXRsZSI6Ilx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2MmFcdTA2MzFcdTA2NDVcdTA2Y2NcdTA2NDVcdTA2Y2MiLCJkZXNjIjoiXHUwNjJmXHUwNjQ2XHUwNjJmXHUwNjI3XHUwNjQ2XHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDYzNFx1MDY0NVx1MDYyNyBcdTA2MzFcdTA2MjcgXHUwNjI4XHUwNjMxXHUwNjI3XHUwNmNjIFx1MDYzMVx1MDYyN1x1MDYyZFx1MDYyYVx1MDZjYyBcdTA2NDggXHUwNjM5XHUwNjQ1XHUwNjQ0XHUwNmE5XHUwNjMxXHUwNjJmIFx1MDY3ZVx1MDYyN1x1MDZjY1x1MDYyZlx1MDYyN1x1MDYzMSBcdTA2MmFcdTA2MzFcdTA2NDVcdTA2Y2NcdTA2NDUgXHUwNjQ4IFx1MDYyOFx1MDYyN1x1MDYzMlx1MDYzM1x1MDYyN1x1MDYzMlx1MDZjYyBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2YTlcdTA2NDZcdTA2MmYuXG4iLCJsaW5rIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC9zZXJ2aWNlXC9yZXN0b3JhdGl2ZS1kZW50aXN0cnlcLyIsImlzX2V4dGVybmFsIjoiIiwibm9mb2xsb3ciOiIiLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9LCJ0aXRsZV9idG4iOiJcdTA2MjdcdTA2MzdcdTA2NDRcdTA2MjdcdTA2MzlcdTA2MjdcdTA2MmEgXHUwNjI4XHUwNmNjXHUwNjM0XHUwNjJhXHUwNjMxIiwicHhsX2FuaW1hdGUiOiJ3b3cgc2NhbGVJbiIsInB4bF9hbmltYXRlX2RlbGF5IjoiMzAwIiwicHhsX2FuaW1hdGUyIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkyIjoiNTAwIiwidGl0bGVfY29sb3IiOiIjMTAyNDRCIiwiYmFja2dyb3VuZF9jb2xvciI6IiNGRkZGRkYifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ljb25fYm94In0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImU3MTQxM2EiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0IjoiXHUwNjQ1XHUwNjM0XHUwNjI3XHUwNjQ3XHUwNjJmXHUwNjQ3IFx1MDY0N1x1MDY0NVx1MDY0NyBcdTA2MmVcdTA2MmZcdTA2NDVcdTA2MjdcdTA2MmEiLCJsaW5rIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC9hbGwtc2VydmljZXNcLyIsImlzX2V4dGVybmFsIjoiIiwibm9mb2xsb3ciOiIiLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9LCJhbGlnbiI6ImNlbnRlciIsIl9tYXJnaW4iOnsidW5pdCI6InB4IiwidG9wIjoiNDgiLCJyaWdodCI6IjAiLCJib3R0b20iOiIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9fSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2J1dHRvbiJ9\\\"]\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-b92d7a4 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"b92d7a4\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-d408d83 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"d408d83\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImMwOGY2NzYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYyOFx1MDZjY1x1MDY0NVx1MDYyN1x1MDYzMVx1MDYyN1x1MDY0NiBcdTA2MzRcdTA2MjdcdTA2MmYiLCJzdGFydGluZ19udW1iZXIiOjUwMDAsImVuZGluZ19udW1iZXIiOjEwMDAwLCJzdWZmaXgiOiIrIiwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluUmlnaHQiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjMwMCJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfY291bnRlciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-3ffca2e e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"3ffca2e\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjE3ZjMwMTUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYzM1x1MDY0MVx1MDZjY1x1MDYyZiBcdTA2YTlcdTA2MzFcdTA2MmZcdTA2NDYgXHUwNjJmXHUwNjQ2XHUwNjJmXHUwNjI3XHUwNjQ2Iiwic3RhcnRpbmdfbnVtYmVyIjoyMDAwLCJlbmRpbmdfbnVtYmVyIjoyNTAwLCJzdWZmaXgiOiIrIiwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluUmlnaHQiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjQwMCJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfY291bnRlciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-5163797 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"5163797\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjM0NDQ3MmYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYyN1x1MDZjY1x1MDY0NVx1MDY3ZVx1MDY0NFx1MDY0Nlx1MDYyYSBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDYiLCJzdGFydGluZ19udW1iZXIiOjUwMCwiZW5kaW5nX251bWJlciI6ODAwLCJzdWZmaXgiOiIrIiwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluUmlnaHQiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjUwMCJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfY291bnRlciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-7ac7412 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"7ac7412\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjYyZDY3MmQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYzM1x1MDYyN1x1MDY0NCBcdTA2MmFcdTA2MmNcdTA2MzFcdTA2MjhcdTA2NDciLCJlbmRpbmdfbnVtYmVyIjoxNSwic3VmZml4IjoiKyIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblJpZ2h0IiwicHhsX2FuaW1hdGVfZGVsYXkiOiI2MDAifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2NvdW50ZXIifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-fc38de1 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"fc38de1\\\" data-element_type=\\\"container\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-931cd86 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"931cd86\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImM3ODU3ZGUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYyZVx1MDYyZlx1MDY0NVx1MDYyN1x1MDYyYSBcdTA2MjdcdTA2MzNcdTA2MmFcdTA2MmJcdTA2NDZcdTA2MjdcdTA2Y2NcdTA2Y2MgXHUwNjI4XHUwNjI3IFx1MDYzMVx1MDY0OFx1MDZjY1x1MDZhOVx1MDYzMVx1MDYyZlx1MDZjYyBcdTA2MzRcdTA2MmVcdTA2MzVcdTA2Y2MiLCJzdWJfdGl0bGUiOiJcdTA2ODZcdTA2MzFcdTA2MjcgXHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhXHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2NDVcdTA2MjcgXHUwNjMxXHUwNjI3IFx1MDYyN1x1MDY0Nlx1MDYyYVx1MDYyZVx1MDYyN1x1MDYyOCBcdTA2YTlcdTA2NDZcdTA2Y2NcdTA2MmYiLCJoX3dpZHRoIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sImhfd2lkdGhfbGFwdG9wIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sImhfd2lkdGhfdGFibGV0X2V4dHJhIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sImhfd2lkdGhfdGFibGV0Ijp7InVuaXQiOiIlIiwic2l6ZSI6MTAwLCJzaXplcyI6W119LCJoX3dpZHRoX21vYmlsZV9leHRyYSI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJoX3dpZHRoX21vYmlsZSI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJ0aXRsZV90YWciOiJoMiIsInN1Yl90aXRsZV9zcGFjZV9ib3R0b20iOnsidW5pdCI6InB4Iiwic2l6ZSI6MTcsInNpemVzIjpbXX0sIl9tYXJnaW4iOnsidW5pdCI6InB4IiwidG9wIjoiMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9LCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNDAwIiwicHhsX2FuaW1hdGVfc3ViIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXlfc3ViIjoiMzAwIiwidGl0bGVfdHlwb2dyYXBoeV90eXBvZ3JhcGh5IjoiY3VzdG9tIiwidGl0bGVfdHlwb2dyYXBoeV9mb250X3NpemVfbW9iaWxlIjp7InVuaXQiOiJweCIsInNpemUiOjQ1LCJzaXplcyI6W119fSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2hlYWRpbmcifQ==\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjYwMmVhOTMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjI3XHUwNjQ2XHUwNjJhXHUwNjJlXHUwNjI3XHUwNjI4IFx1MDYyN1x1MDYzMVx1MDYyN1x1MDYyNlx1MDY0NyBcdTA2MmZcdTA2NDdcdTA2NDZcdTA2MmZcdTA2NDcgXHUwNjJlXHUwNjJmXHUwNjQ1XHUwNjI3XHUwNjJhIFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2NDVcdTA2NDZcdTA2MjdcdTA2MzNcdTA2MjggXHUwNjI3XHUwNjQ3XHUwNjQ1XHUwNmNjXHUwNjJhIFx1MDYyZlx1MDYyN1x1MDYzMVx1MDYyZi4gXHUwNjQ1XHUwNjI3IFx1MDY0NVx1MDYzMVx1MDYyN1x1MDY0Mlx1MDYyOFx1MDYyYVx1MjAwY1x1MDY0N1x1MDYyN1x1MDZjYyBcdTA2MmFcdTA2MmVcdTA2MzVcdTA2MzVcdTA2Y2NcdTA2MGMgXHUwNjQxXHUwNjQ2XHUwNjI3XHUwNjQ4XHUwNjMxXHUwNmNjIFx1MDY3ZVx1MDZjY1x1MDYzNFx1MDYzMVx1MDY0MVx1MDYyYVx1MDY0NyBcdTA2NDggXHUwNjQxXHUwNjM2XHUwNjI3XHUwNmNjXHUwNmNjIFx1MDZhZlx1MDYzMVx1MDY0NSBcdTA2MzFcdTA2MjcgXHUwNjI4XHUwNjI3IFx1MDY0N1x1MDY0NSBcdTA2MmFcdTA2MzFcdTA2YTlcdTA2Y2NcdTA2MjggXHUwNjQ1XHUwNmNjXHUyMDBjXHUwNmE5XHUwNjQ2XHUwNmNjXHUwNjQ1IFx1MDYyYVx1MDYyNyBcdTA2MjdcdTA2MzdcdTA2NDVcdTA2Y2NcdTA2NDZcdTA2MjdcdTA2NDYgXHUwNjJkXHUwNjI3XHUwNjM1XHUwNjQ0IFx1MDZhOVx1MDY0Nlx1MDZjY1x1MDY0NSBcdTA2YTlcdTA2NDcgXHUwNjQ3XHUwNjMxIFx1MDY0OFx1MDZjY1x1MDYzMlx1MDZjY1x1MDYyYSBcdTA2MzFcdTA2MjdcdTA2MmRcdTA2MmFcdTA2MGMgXHUwNmE5XHUwNjI3XHUwNjMxXHUwNjIyXHUwNjQ1XHUwNjJmIFx1MDY0OCBcdTA2NDVcdTA2MmFcdTA2NDZcdTA2MjdcdTA2MzNcdTA2MjggXHUwNjI4XHUwNjI3IFx1MDY0Nlx1MDZjY1x1MDYyN1x1MDYzMlx1MDY0N1x1MDYyN1x1MDZjYyBcdTA2NDVcdTA2NDZcdTA2MmRcdTA2MzVcdTA2MzEgXHUwNjI4XHUwNjQ3IFx1MDY0MVx1MDYzMVx1MDYyZiBcdTA2MzRcdTA2NDVcdTA2MjcgXHUwNjJlXHUwNjQ4XHUwNjI3XHUwNjQ3XHUwNjJmIFx1MDYyOFx1MDY0OFx1MDYyZi48XC9wPiIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIyMSIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]<div class=\\\"elementor-element elementor-element-9f3be1f e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"9f3be1f\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-e4d5e10 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"e4d5e10\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-3f475ce e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"3f475ce\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImQ0MzdiMWMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGg1Plx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOSBcdTA2MjhcdTA2MjdcdTA2MmFcdTA2MmNcdTA2MzFcdTA2MjhcdTA2NDc8XC9oNT4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNDAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6Ijc4ZTZlMmIiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhXHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDYyYVx1MDYyZVx1MDYzNVx1MDYzNVx1MDZjYyBcdTA2MjhcdTA2MjcgXHUwNjdlXHUwNjM0XHUwNjJhXHUwNjQ4XHUwNjI3XHUwNjQ2XHUwNjQ3IFx1MDYzM1x1MDYyN1x1MDY0NFx1MjAwY1x1MDY0N1x1MDYyNyBcdTA2MmFcdTA2MmNcdTA2MzFcdTA2MjhcdTA2NDcgXHUwNjJmXHUwNjQ2XHUwNjJmXHUwNjI3XHUwNjQ2XHUwNjdlXHUwNjMyXHUwNjM0XHUwNmE5XHUwNmNjIFx1MDY0Mlx1MDYyN1x1MDYyOFx1MDY0NCBcdTA2MjdcdTA2MzlcdTA2MmFcdTA2NDVcdTA2MjdcdTA2MmYuPFwvcD4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNTAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-c548350 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"c548350\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjY1YzMxZjQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGg1Plx1MDYyZlx1MDYzMVx1MDY0NVx1MDYyN1x1MDY0NiBcdTA2MzRcdTA2MmVcdTA2MzVcdTA2Y2NcdTIwMGNcdTA2MzNcdTA2MjdcdTA2MzJcdTA2Y2NcdTIwMGNcdTA2MzRcdTA2MmZcdTA2NDc8XC9oNT4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNDAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjI0ZDQ0MDkiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjI4XHUwNjMxXHUwNjQ2XHUwNjI3XHUwNjQ1XHUwNjQ3XHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY0NVx1MDYzMVx1MDYyN1x1MDY0Mlx1MDYyOFx1MDYyYVx1MDZjYyBcdTA2MzNcdTA2NDFcdTA2MjdcdTA2MzFcdTA2MzRcdTA2Y2MgXHUwNmE5XHUwNjQ3IFx1MDY0NVx1MDYyYVx1MDY0Nlx1MDYyN1x1MDYzM1x1MDYyOCBcdTA2MjhcdTA2MjcgXHUwNjQ0XHUwNjI4XHUwNjJlXHUwNjQ2XHUwNjJmIFx1MDY0OCBcdTA2MzNcdTA2MjhcdTA2YTkgXHUwNjMyXHUwNjQ2XHUwNjJmXHUwNmFmXHUwNmNjIFx1MDYzNFx1MDY0NVx1MDYyNyBcdTA2MmFcdTA2NDdcdTA2Y2NcdTA2NDcgXHUwNjQ1XHUwNmNjXHUyMDBjXHUwNjM0XHUwNjQ4XHUwNjQ2XHUwNjJmLjxcL3A+IiwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjUwMCJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfdGV4dF9lZGl0b3IifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-64807c6 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"64807c6\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-0cb580b e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"0cb580b\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6Ijg5ZmJjZjUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGg1Plx1MDY0MVx1MDY0Nlx1MDYyN1x1MDY0OFx1MDYzMVx1MDZjYyBcdTA2N2VcdTA2Y2NcdTA2MzRcdTA2MzFcdTA2NDFcdTA2MmFcdTA2NDc8XC9oNT4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNDAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjFhMmNlMjgiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjI3XHUwNjI4XHUwNjMyXHUwNjI3XHUwNjMxXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY0NVx1MDYyZlx1MDYzMVx1MDY0Nlx1MDYwYyBcdTA2MmZcdTA2MzFcdTA2NDVcdTA2MjdcdTA2NDZcdTIwMGNcdTA2NDdcdTA2MjdcdTA2Y2MgXHUwNjJmXHUwNjQyXHUwNmNjXHUwNjQyIFx1MDY0OCBcdTA2YTlcdTA2MjdcdTA2MzFcdTA2MjJcdTA2NDVcdTA2MmYgXHUwNjMxXHUwNjI3IFx1MDYyYVx1MDYzNlx1MDY0NVx1MDZjY1x1MDY0NiBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2YTlcdTA2NDZcdTA2NDZcdTA2MmYuPFwvcD4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNTAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-5c18bec e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"5c18bec\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjAxMzk0MzAiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGg1Plx1MDY0NVx1MDY0Nlx1MDYyN1x1MDYzM1x1MDYyOCBcdTA2MmVcdTA2MjdcdTA2NDZcdTA2NDhcdTA2MjdcdTA2MmZcdTA2NDc8XC9oNT4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNDAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjNlOTMwOWMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjQxXHUwNjM2XHUwNjI3XHUwNmNjXHUwNmNjIFx1MDYyZlx1MDY0NFx1MDY0Nlx1MDYzNFx1MDZjY1x1MDY0NiBcdTA2MjhcdTA2MzFcdTA2MjdcdTA2Y2MgXHUwNmE5XHUwNjQ4XHUwNjJmXHUwNmE5XHUwNjI3XHUwNjQ2XHUwNjBjIFx1MDY0Nlx1MDY0OFx1MDYyY1x1MDY0OFx1MDYyN1x1MDY0Nlx1MDYyN1x1MDY0Nlx1MDYwYyBcdTA2MjhcdTA2MzJcdTA2MzFcdTA2YWZcdTA2MzNcdTA2MjdcdTA2NDRcdTA2MjdcdTA2NDYgXHUwNjQ4IFx1MDYzM1x1MDYyN1x1MDY0NFx1MDY0NVx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Ni48XC9wPiIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX3RleHRfZWRpdG9yIn0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-c0bac5e e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"c0bac5e\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-9ce2c5c e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"9ce2c5c\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImU1MzBjODEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2V4Y2VwdGlvbmFsMi5qcGciLCJpZCI6NjA3LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJpbWFnZV90eXBlIjoiYmciLCJpbWFnZV9oZWlnaHQiOnsidW5pdCI6InB4Iiwic2l6ZSI6MjM2LjgwMDAwMDAwMDAwMDAxMTM2ODY4Mzc3MjE2MTYwMjk3MzkzNzk4ODI4MTI1LCJzaXplcyI6W119LCJib3JkZXJfcmFkaXVzIjp7InVuaXQiOiJweCIsInRvcCI6IjIwIiwicmlnaHQiOiIyMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjIwIiwiaXNMaW5rZWQiOnRydWV9LCJwYXJhbGxheF92YWx1ZSI6IjQwIiwibWF4X3RpbHQiOiIxMCIsInNwZWVkX3RpbHQiOiI0MDAiLCJwZXJzcGVjdGl2ZV90aWx0IjoiMTAwMCIsInB4bF9hbmltYXRlIjoid293IHpvb21JblNtYWxsIiwicHhsX2FuaW1hdGVfZGVsYXkiOiIzMDAiLCJweGxfYW5pbWF0ZV9pbWciOiJ3b3cgc2NhbGVJbiIsInB4bF9hbmltYXRlX2ltZ19kZWxheSI6IjMwMCIsIl9wYWRkaW5nIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIwIiwibGVmdCI6IjYwIiwiaXNMaW5rZWQiOmZhbHNlfSwiX3BhZGRpbmdfdGFibGV0Ijp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9fSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ltYWdlIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjIxYmMyY2IiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2V4Y2VwdGlvbmFsMS5qcGciLCJpZCI6NjA2LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJpbWFnZV90eXBlIjoiYmciLCJpbWFnZV9oZWlnaHQiOnsidW5pdCI6InB4Iiwic2l6ZSI6Mjk2LCJzaXplcyI6W119LCJib3JkZXJfcmFkaXVzIjp7InVuaXQiOiJweCIsInRvcCI6IjIwIiwicmlnaHQiOiIyMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjIwIiwiaXNMaW5rZWQiOnRydWV9LCJwYXJhbGxheF92YWx1ZSI6IjQwIiwibWF4X3RpbHQiOiIxMCIsInNwZWVkX3RpbHQiOiI0MDAiLCJwZXJzcGVjdGl2ZV90aWx0IjoiMTAwMCIsInB4bF9hbmltYXRlIjoid293IHpvb21JblNtYWxsIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJweGxfYW5pbWF0ZV9pbWciOiJ3b3cgc2NhbGVJbiIsInB4bF9hbmltYXRlX2ltZ19kZWxheSI6IjUwMCJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfaW1hZ2UifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-2b3fb22 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"2b3fb22\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImE3YmU3YjkiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2V4Y2VwdGlvbmFsMy5qcGciLCJpZCI6NjA4LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJpbWFnZV90eXBlIjoiYmciLCJpbWFnZV9oZWlnaHQiOnsidW5pdCI6InB4Iiwic2l6ZSI6Mzk5LjYwMDAwMDAwMDAwMDAyMjczNzM2NzU0NDMyMzIwNTk0Nzg3NTk3NjU2MjUsInNpemVzIjpbXX0sImJvcmRlcl9yYWRpdXMiOnsidW5pdCI6InB4IiwidG9wIjoiMjAiLCJyaWdodCI6IjIwIiwiYm90dG9tIjoiMjAiLCJsZWZ0IjoiMjAiLCJpc0xpbmtlZCI6dHJ1ZX0sInBhcmFsbGF4X3ZhbHVlIjoiNDAiLCJtYXhfdGlsdCI6IjEwIiwic3BlZWRfdGlsdCI6IjQwMCIsInBlcnNwZWN0aXZlX3RpbHQiOiIxMDAwIiwicHhsX2FuaW1hdGUiOiJ3b3cgem9vbUluU21hbGwiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjQwMCIsInB4bF9hbmltYXRlX2ltZyI6IndvdyBzY2FsZUluIiwicHhsX2FuaW1hdGVfaW1nX2RlbGF5IjoiNDAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9pbWFnZSJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-d0d5540 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"d0d5540\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-964e490 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"964e490\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImQwNzU1OTUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDY0NVx1MDYyYVx1MDYzOVx1MDY0N1x1MDYyZiBcdTA2MjhcdTA2NDcgXHUwNjQ0XHUwNjI4XHUwNjJlXHUwNjQ2XHUwNjJmIFx1MDYzNFx1MDY0NVx1MDYyNyIsInN1Yl90aXRsZSI6IiBcdTA2MjhcdTA2MjcgXHUwNjJhXHUwNmNjXHUwNjQ1IFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2NDVcdTA2MjcgXHUwNjIyXHUwNjM0XHUwNjQ2XHUwNjI3IFx1MDYzNFx1MDY0OFx1MDZjY1x1MDYyZiIsImhfd2lkdGgiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF9sYXB0b3AiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF90YWJsZXRfZXh0cmEiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF90YWJsZXQiOnsidW5pdCI6IiUiLCJzaXplIjoxMDAsInNpemVzIjpbXX0sImhfd2lkdGhfbW9iaWxlX2V4dHJhIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sImhfd2lkdGhfbW9iaWxlIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sInRpdGxlX3RhZyI6ImgyIiwic3ViX3RpdGxlX3NwYWNlX2JvdHRvbSI6eyJ1bml0IjoicHgiLCJzaXplIjoxNywic2l6ZXMiOltdfSwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIwIiwicmlnaHQiOiIwIiwiYm90dG9tIjoiMjAiLCJsZWZ0IjoiMCIsImlzTGlua2VkIjpmYWxzZX0sInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI0MDAiLCJweGxfYW5pbWF0ZV9zdWIiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheV9zdWIiOiIzMDAiLCJhbGlnbiI6ImNlbnRlciIsInRpdGxlX3R5cG9ncmFwaHlfdHlwb2dyYXBoeSI6ImN1c3RvbSIsInRpdGxlX3R5cG9ncmFwaHlfZm9udF9zaXplX21vYmlsZSI6eyJ1bml0IjoicHgiLCJzaXplIjo0NSwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9oZWFkaW5nIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImFjZDdkYTQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHAgY2xhc3M9XCJ3b3cgZmFkZUluVXAgYW5pbWF0ZWRcIj5cdTA2MmFcdTA2Y2NcdTA2NDUgXHUwNjJmXHUwNjQ2XHUwNjJmXHUwNjI3XHUwNjQ2XHUwNjdlXHUwNjMyXHUwNjM0XHUwNmE5XHUwNmNjIFx1MDYyOFx1MDYyN1x1MDYyYVx1MDYyY1x1MDYzMVx1MDYyOFx1MDY0NyBcdTA2NDVcdTA2MjcgXHUwNjI3XHUwNmNjXHUwNjQ2XHUwNjJjXHUwNjI3IFx1MDY0N1x1MDYzM1x1MDYyYVx1MDY0Nlx1MDYyZiBcdTA2MmFcdTA2MjcgXHUwNjQ3XHUwNjMxIFx1MDY0OFx1MDZjY1x1MDYzMlx1MDZjY1x1MDYyYSBcdTA2MzFcdTA2MjcgXHUwNjQ1XHUwNjJiXHUwNjI4XHUwNjJhIFx1MDY0OCBcdTA2MzRcdTA2MmVcdTA2MzVcdTA2Y2NcdTIwMGNcdTA2MzNcdTA2MjdcdTA2MzJcdTA2Y2NcdTIwMGNcdTA2MzRcdTA2MmZcdTA2NDcgXHUwNmE5XHUwNjQ2XHUwNjQ2XHUwNjJmLiBcdTA2MjhcdTA2MjcgXHUwNjJmXHUwNjMzXHUwNjJhXHUwNjI3XHUwNjQ2XHUwNmNjIFx1MDY0NVx1MDY0N1x1MDYzMVx1MDYyOFx1MDYyN1x1MDY0NiBcdTA2NDggXHUwNjQyXHUwNjQ0XHUwNjI4XHUwNmNjIFx1MDY0NVx1MDY0N1x1MDYzMVx1MDYyOFx1MDYyN1x1MDY0Ni48XC9wPiIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIzNyIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwiYWxpZ24iOiJjZW50ZXIiLCJ0X3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjYyOCwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-8e36ff0 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"8e36ff0\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjljNzA3YTAiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZWFtIjpbeyJfaWQiOiI4MzZiODQwIiwiaW1hZ2UiOnsidXJsIjoiaHR0cHM6XC9cL2RlbnRpYS5zdW50aGVtZXMuaXJcL3dwLWNvbnRlbnRcL3VwbG9hZHNcLzIwMjVcLzA4XC9kZW50aXN0cy1pbWcxLmpwZyIsImlkIjoxNzksInNpemUiOiIiLCJhbHQiOiIiLCJzb3VyY2UiOiJsaWJyYXJ5In0sInRpdGxlIjoiXHUwNjJmXHUwNmE5XHUwNjJhXHUwNjMxIFx1MDYzM1x1MDYyN1x1MDYzMVx1MDYyNyBcdTA2NDVcdTA2Y2NcdTA2MzFcdTA2MzJcdTA2MjdcdTA2MjZcdTA2Y2MiLCJwb3NpdGlvbiI6Ilx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOSBcdTA2MjdcdTA2MzFcdTA2MzRcdTA2MmYifSx7Il9pZCI6ImJhYTZjYjUiLCJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2RlbnRpc3RzLWltZzIuanBnIiwiaWQiOjE4MCwic2l6ZSI6IiIsImFsdCI6IiIsInNvdXJjZSI6ImxpYnJhcnkifSwidGl0bGUiOiJcdTA2MmZcdTA2YTlcdTA2MmFcdTA2MzEgXHUwNjQ1XHUwNjMxXHUwNmNjXHUwNjQ1IFx1MDYyMlx1MDY0Mlx1MDYyN1x1MDYyY1x1MDYyN1x1MDY0Nlx1MDZjYyIsInBvc2l0aW9uIjoiXHUwNjJmXHUwNjQ2XHUwNjJmXHUwNjI3XHUwNjQ2XHUwNjdlXHUwNjMyXHUwNjM0XHUwNmE5IFx1MDYzMlx1MDZjY1x1MDYyOFx1MDYyN1x1MDZjY1x1MDZjYyJ9LHsiX2lkIjoiM2ZhY2E4ZCIsImltYWdlIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC93cC1jb250ZW50XC91cGxvYWRzXC8yMDI1XC8wOFwvZGVudGlzdHMtaW1nMy5qcGciLCJpZCI6MTgxLCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJ0aXRsZSI6Ilx1MDYyZlx1MDZhOVx1MDYyYVx1MDYzMSBcdTA2MzRcdTA2NDdcdTA2MjdcdTA2MjggXHUwNjM3XHUwNjQ3XHUwNjQ1XHUwNjI3XHUwNjMzXHUwNjI4XHUwNmNjIiwicG9zaXRpb24iOiJcdTA2NDVcdTA2MmFcdTA2MmVcdTA2MzVcdTA2MzUgXHUwNjI3XHUwNjM3XHUwNjQxXHUwNjI3XHUwNjQ0In0seyJfaWQiOiIzM2U1NTIzIiwiaW1hZ2UiOnsidXJsIjoiaHR0cHM6XC9cL2RlbnRpYS5zdW50aGVtZXMuaXJcL3dwLWNvbnRlbnRcL3VwbG9hZHNcLzIwMjVcLzA4XC9kZW50aXN0cy1pbWc0LmpwZyIsImlkIjoxODIsInNpemUiOiIiLCJhbHQiOiIiLCJzb3VyY2UiOiJsaWJyYXJ5In0sInRpdGxlIjoiXHUwNjJmXHUwNmE5XHUwNjJhXHUwNjMxIFx1MDYyN1x1MDY0NVx1MDZjY1x1MDYzMSBcdTA2YTlcdTA2MzFcdTA2NDVcdTA2MjdcdTA2NDZcdTA2Y2NcdTIwMGNcdTA2NDVcdTA2NDJcdTA2MmZcdTA2NDUiLCJwb3NpdGlvbiI6Ilx1MDYyOFx1MDY0N1x1MDYyZlx1MDYyN1x1MDYzNFx1MDYyYVx1MDZhOVx1MDYyN1x1MDYzMSBcdTA2MmZcdTA2NDdcdTA2MjdcdTA2NDYgXHUwNjQ4IFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0NiJ9XSwiaXRlbV9zcGFjZXIiOnsidW5pdCI6InB4Iiwic2l6ZSI6MTIsInNpemVzIjpbXX0sInB4bF9hbmltYXRlX2ltZyI6IndvdyB6b29tSW5TbWFsbCIsInB4bF9hbmltYXRlX2ltZzIiOiJ3b3cgc2NhbGVJbiIsInB4bF9hbmltYXRlX2ltZ19kZWxheSI6IjYwMCIsInB4bF9hbmltYXRlX2NvbnRlbnQiOiJ3b3cgZmFkZUluRG93biIsInB4bF9hbmltYXRlX2N0X2RlbGF5IjoiNzAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZWFtX2dyaWQifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-07e3439 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"07e3439\\\" data-element_type=\\\"container\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-cabeee0 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"cabeee0\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjkyYTMwYzUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYzM1x1MDY0OFx1MDYyN1x1MDY0NFx1MDYyN1x1MDYyYSBcdTA2NDVcdTA2MmFcdTA2MmZcdTA2MjdcdTA2NDhcdTA2NDQiLCJzdWJfdGl0bGUiOiJcdTA2NDdcdTA2MzEgXHUwNjIyXHUwNjQ2XHUwNjg2XHUwNjQ3IFx1MDZhOVx1MDY0NyBcdTA2MjhcdTA2MjdcdTA2Y2NcdTA2MmYgXHUwNjI4XHUwNjJmXHUwNjI3XHUwNjQ2XHUwNmNjXHUwNjJmIiwidGl0bGVfdGFnIjoiaDIiLCJ0aXRsZV90eXBvZ3JhcGh5X3R5cG9ncmFwaHkiOiJjdXN0b20iLCJ0aXRsZV90eXBvZ3JhcGh5X2ZvbnRfc2l6ZV9tb2JpbGUiOnsidW5pdCI6InB4Iiwic2l6ZSI6NDUsInNpemVzIjpbXX0sInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJweGxfYW5pbWF0ZV9zdWIiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheV9zdWIiOiIzMDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIyMCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9oZWFkaW5nIn0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-cb0bd9f e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"cb0bd9f\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"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\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-faed713 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"faed713\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\"><div class=\\\"elementor-element elementor-element-ba2fc12 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"ba2fc12\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImNkNzE3MTYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDY0NVx1MDYzNFx1MDYyYVx1MDYzMVx1MDZjY1x1MDYyN1x1MDY0NiBcdTA2MzFcdTA2MjdcdTA2MzZcdTA2Y2MgXHUwNjQ1XHUwNjI3Iiwic3ViX3RpdGxlIjoiXHUwNjQ2XHUwNjM4XHUwNjMxXHUwNjI3XHUwNjJhIFx1MDY0NVx1MDYzNFx1MDYyYVx1MDYzMVx1MDZjY1x1MDYyN1x1MDY0NiIsImhfd2lkdGgiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF9sYXB0b3AiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF90YWJsZXRfZXh0cmEiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF90YWJsZXQiOnsidW5pdCI6IiUiLCJzaXplIjoxMDAsInNpemVzIjpbXX0sImhfd2lkdGhfbW9iaWxlX2V4dHJhIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sImhfd2lkdGhfbW9iaWxlIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sInRpdGxlX3RhZyI6ImgyIiwic3ViX3RpdGxlX3NwYWNlX2JvdHRvbSI6eyJ1bml0IjoicHgiLCJzaXplIjoxNywic2l6ZXMiOltdfSwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIwIiwicmlnaHQiOiIwIiwiYm90dG9tIjoiMjAiLCJsZWZ0IjoiMCIsImlzTGlua2VkIjpmYWxzZX0sInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI0MDAiLCJweGxfYW5pbWF0ZV9zdWIiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheV9zdWIiOiIzMDAiLCJhbGlnbiI6ImNlbnRlciIsInRpdGxlX3R5cG9ncmFwaHlfdHlwb2dyYXBoeSI6ImN1c3RvbSIsInRpdGxlX3R5cG9ncmFwaHlfZm9udF9zaXplX21vYmlsZSI6eyJ1bml0IjoicHgiLCJzaXplIjo0NSwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9oZWFkaW5nIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjE3ZWZiYjAiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHAgY2xhc3M9XCJ3b3cgZmFkZUluVXAgYW5pbWF0ZWRcIj5cdTA2MjhcdTA2NDcgXHUwNjQ3XHUwNjMyXHUwNjI3XHUwNjMxXHUwNjI3XHUwNjQ2IFx1MDYyOFx1MDZjY1x1MDY0NVx1MDYyN1x1MDYzMSBcdTA2MzFcdTA2MjdcdTA2MzZcdTA2Y2MgXHUwNjI4XHUwNjdlXHUwNmNjXHUwNjQ4XHUwNjQ2XHUwNjJmXHUwNmNjXHUwNjJmIFx1MDZhOVx1MDY0NyBcdTA2MjhcdTA2MzFcdTA2MjdcdTA2Y2MgXHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhXHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY0NVx1MDY0NFx1MDYyN1x1MDZjY1x1MDY0NSBcdTA2NDggXHUwNjJhXHUwNjJlXHUwNjM1XHUwNjM1XHUwNmNjIFx1MDY0OCBcdTA2NDRcdTA2MjhcdTA2MmVcdTA2NDZcdTA2MmZcdTA2NDdcdTA2MjdcdTA2Y2MgXHUwNjMyXHUwNmNjXHUwNjI4XHUwNjI3IFx1MDYyOFx1MDY0NyBcdTA2NDVcdTA2MjcgXHUwNjI3XHUwNjM5XHUwNjJhXHUwNjQ1XHUwNjI3XHUwNjJmIFx1MDY0NVx1MDZjY1x1MjAwY1x1MDZhOVx1MDY0Nlx1MDY0Nlx1MDYyZi4gXHUwNjJhXHUwNjJjXHUwNjMxXHUwNjI4XHUwNjQ3IFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2MjhcdTA2Y2NcdTIwMGNcdTA2NDZcdTA2MzhcdTA2Y2NcdTA2MzEgXHUwNjM0XHUwNjQ1XHUwNjI3IFx1MDYyN1x1MDYzMiBcdTA2MjdcdTA2Y2NcdTA2NDZcdTA2MmNcdTA2MjcgXHUwNjM0XHUwNjMxXHUwNjQ4XHUwNjM5IFx1MDY0NVx1MDZjY1x1MjAwY1x1MDYzNFx1MDY0OFx1MDYyZiE8XC9wPiIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiI1MCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwiYWxpZ24iOiJjZW50ZXIiLCJ0X3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjYyOCwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-6356f20 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"6356f20\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"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\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-d1c1cbb e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"d1c1cbb\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-8418409 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"8418409\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjBkMWM2YzIiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYyMlx1MDY0NVx1MDYyN1x1MDYyZlx1MDY0NyBcdTA2MzFcdTA2MzJcdTA2MzFcdTA2NDggXHUwNjQ2XHUwNjQ4XHUwNjI4XHUwNjJhIFx1MDYyZVx1MDY0OFx1MDYyZiBcdTA2NDdcdTA2MzNcdTA2MmFcdTA2Y2NcdTA2MmZcdTA2MWYiLCJ0aXRsZV9jb2xvciI6IiNGRkZGRkYiLCJ0aXRsZV90eXBvZ3JhcGh5X3R5cG9ncmFwaHkiOiJjdXN0b20iLCJ0aXRsZV90eXBvZ3JhcGh5X2ZvbnRfc2l6ZSI6eyJ1bml0IjoicHgiLCJzaXplIjozMiwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9oZWFkaW5nIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjNjZjdjNGIiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjQ3XHUwNjQ1XHUwNmNjXHUwNjQ2IFx1MDYyN1x1MDY0NVx1MDYzMVx1MDY0OFx1MDYzMiBcdTA2MjhcdTA2MjcgXHUwNjQ1XHUwNjI3IFx1MDYyYVx1MDY0NVx1MDYyN1x1MDYzMyBcdTA2MjhcdTA2YWZcdTA2Y2NcdTA2MzFcdTA2Y2NcdTA2MmYgXHUwNjJhXHUwNjI3IFx1MDY0OFx1MDY0Mlx1MDYyYSBcdTA2NDVcdTA2NDRcdTA2MjdcdTA2NDJcdTA2MjdcdTA2MmEgXHUwNjJlXHUwNjQ4XHUwNjJmIFx1MDYzMVx1MDYyNyBcdTA2MzFcdTA2MzJcdTA2MzFcdTA2NDggXHUwNmE5XHUwNjQ2XHUwNmNjXHUwNjJmIFx1MDY0OCBcdTA2MjdcdTA2NDhcdTA2NDRcdTA2Y2NcdTA2NDYgXHUwNjQyXHUwNjJmXHUwNjQ1IFx1MDYzMVx1MDYyNyBcdTA2MjhcdTA2MzFcdTA2MjdcdTA2Y2MgXHUwNjJmXHUwNjI3XHUwNjM0XHUwNjJhXHUwNjQ2IFx1MDY0NFx1MDYyOFx1MDYyZVx1MDY0Nlx1MDYyZlx1MDZjYyBcdTA2MzNcdTA2MjdcdTA2NDRcdTA2NDVcdTIwMGNcdTA2MmFcdTA2MzEgXHUwNjI4XHUwNjMxXHUwNjJmXHUwNjI3XHUwNjMxXHUwNmNjXHUwNjJmLjxcL3A+IiwidGV4dF9jb2xvciI6IiNGRkZGRkY5OSJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfdGV4dF9lZGl0b3IifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-97ded05 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"97ded05\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImI3YTczODEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0IjoiXHUwNjMxXHUwNjMyXHUwNjMxXHUwNjQ4IFx1MDY0Nlx1MDY0OFx1MDYyOFx1MDYyYSIsImFsaWduIjoibGVmdCIsImJvcmRlcl90eXBlIjoic29saWQiLCJib3JkZXJfd2lkdGgiOnsidW5pdCI6InB4IiwidG9wIjoiMSIsInJpZ2h0IjoiMSIsImJvdHRvbSI6IjEiLCJsZWZ0IjoiMSIsImlzTGlua2VkIjp0cnVlfSwiYm9yZGVyX2NvbG9yIjoiI0ZGRkZGRjgwIiwiYm9yZGVyX2NvbG9yX2hvdmVyIjoiIzEwMjQ0QiIsImxpbmsiOnsidXJsIjoiaHR0cHM6XC9cL2RlbnRpYS5zdW50aGVtZXMuaXJcL2Jvb2tpbmdcLyIsImlzX2V4dGVybmFsIjoiIiwibm9mb2xsb3ciOiIiLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9fSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2J1dHRvbiJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\",\"scripts\":[],\"styles\":[]}}\";}","auto-off");

INSERT IGNORE INTO `wp_options` VALUES 
("912","pxl_portfolio_options","a:27:{s:17:\"_wp_page_template\";s:7:\"default\";s:13:\"header_layout\";s:4:\"1594\";s:20:\"header_layout_sticky\";s:2:\"-1\";s:6:\"logo_m\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:12:\"mobile_style\";s:7:\"inherit\";s:6:\"p_menu\";s:0:\"\";s:13:\"sticky_scroll\";s:2:\"-1\";s:7:\"pt_mode\";s:4:\"none\";s:13:\"custom_ptitle\";s:0:\"\";s:16:\"page_sidebar_pos\";s:1:\"0\";s:15:\"content_spacing\";a:3:{s:5:\"units\";s:2:\"px\";s:11:\"padding-top\";s:1:\"0\";s:14:\"padding-bottom\";s:1:\"0\";}s:13:\"footer_layout\";s:2:\"-1\";s:14:\"p_footer_fixed\";s:7:\"inherit\";s:13:\"body_bg_color\";s:0:\"\";s:13:\"primary_color\";s:0:\"\";s:15:\"secondary_color\";s:0:\"\";s:14:\"gradient_color\";a:2:{s:4:\"from\";s:0:\"\";s:2:\"to\";s:0:\"\";}s:17:\"body_custom_class\";s:0:\"\";s:20:\"_elementor_edit_mode\";s:7:\"builder\";s:24:\"_elementor_template_type\";s:7:\"wp-page\";s:18:\"_elementor_version\";s:6:\"3.32.0\";s:15:\"_elementor_data\";s:76806:\"[{\"id\":\"5161d23\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"slideshow\",\"background_slideshow_gallery\":[{\"id\":1485,\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/1-min-e1758004018967.jpg\"},{\"id\":1486,\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/2-min-e1758004028449.jpg\"}],\"background_slideshow_background_size\":\"cover\",\"background_slideshow_background_position\":\"center center\",\"background_slideshow_lazyload\":\"yes\",\"background_overlay_background\":\"gradient\",\"background_overlay_color\":\"#000A5B66\",\"background_overlay_color_stop\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"background_overlay_color_b\":\"#000A5B\",\"background_overlay_gradient_angle\":{\"unit\":\"deg\",\"size\":-90,\"sizes\":[]},\"background_overlay_opacity\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"padding\":{\"unit\":\"px\",\"top\":\"220\",\"right\":\"15\",\"bottom\":\"192\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"background_slideshow_slide_transition\":\"slide_right\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"73\",\"right\":\"15\",\"bottom\":\"70\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"0b31933\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"bd11b0a\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0644\\u0628\\u062e\\u0646\\u062f\\u0647\\u0627\\u06cc \\u0632\\u06cc\\u0628\\u0627\\u062a\\u0631 \\u0628\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u062a\\u062e\\u0635\\u0635\\u06cc \\u0648 \\u0644\\u0645\\u0633 \\u0645\\u0644\\u0627\\u06cc\\u0645\",\"sub_title\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647\",\"h_width\":{\"unit\":\"%\",\"size\":49,\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":55,\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h1\",\"title_color\":\"#FFFFFF\",\"sub_title_color\":\"#FFFFFF\",\"sub_title_typography_typography\":\"custom\",\"sub_title_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"sub_title_typography_font_weight\":\"600\",\"sub_title_typography_line_height\":{\"unit\":\"em\",\"size\":1.5,\"sizes\":[]},\"sub_title_typography_line_height_laptop\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"sub_title_typography_line_height_tablet_extra\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"sub_title_typography_line_height_mobile_extra\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\"},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"c162dc7\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0631\\u0632\\u0631\\u0648 \\u0646\\u0648\\u0628\\u062a\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/booking\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"btn_bg_color\":\"#02010100\",\"border_type\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"border_color\":\"#FFFFFF\",\"color_hover\":\"#FFFFFF\",\"btn_bg_color_hover\":\"#000A5B\",\"btn_bg_color_active\":\"#000A5B\",\"btn_bg_color_focus\":\"#000A5B\",\"border_color_hover\":\"#000A5B\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"30\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_button\"},{\"id\":\"9d1bee4\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_align_items\":\"center\",\"flex_gap\":{\"column\":\"15\",\"row\":\"15\",\"isLinked\":true,\"unit\":\"px\",\"size\":15},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"animation\":\"fadeInUp\",\"animation_delay\":600,\"flex_wrap\":\"wrap\"},\"elements\":[{\"id\":\"ac6b6cf\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<div class=\\\"me-3\\\">\\u0631\\u062a\\u0628\\u0647\\u200c\\u0628\\u0646\\u062f\\u06cc \\u06af\\u0648\\u06af\\u0644<\\/div>\",\"text_color\":\"#F8F9FA\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"05b35cf\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<div class=\\\"me-3\\\"><div class=\\\"me-3\\\">5.0<\\/div><\\/div>\",\"text_color\":\"#F8F9FA\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"bd513bf\",\"elType\":\"widget\",\"settings\":{\"icons\":[{\"_id\":\"e1ef7bc\",\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"}},{\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"},\"_id\":\"1fbf14e\"},{\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"},\"_id\":\"98ed77d\"},{\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"},\"_id\":\"1685a7b\"},{\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"},\"_id\":\"67aa573\"}],\"color\":\"#FEC42C\",\"icon_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"icon_space\":{\"unit\":\"px\",\"size\":2,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_icon\"},{\"id\":\"6531703\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<div class=\\\"me-3\\\"><div class=\\\"me-3\\\"><div class=\\\"me-3\\\">\\u0628\\u0631 \\u0627\\u0633\\u0627\\u0633 \\u06f2\\u06f3 \\u0647\\u0632\\u0627\\u0631 \\u0646\\u0642\\u062f \\u0648 \\u0628\\u0631\\u0631\\u0633\\u06cc<\\/div><\\/div><\\/div>\",\"text_color\":\"#F8F9FA\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false},{\"id\":\"af13e9f\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#000A5B\",\"padding\":{\"unit\":\"px\",\"top\":\"25\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_align_items\":\"center\",\"flex_direction_mobile_extra\":\"column\"},\"elements\":[{\"id\":\"f6f14ff\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"2f08b27\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"15\",\"bottom\":\"0\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_align_items\":\"center\",\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"3627c0a\",\"elType\":\"widget\",\"settings\":{\"layout\":\"2\",\"pxl_icon\":{\"value\":\"fas fa-phone-alt\",\"library\":\"fa-solid\"},\"title\":\"\\u0628\\u0647 \\u062e\\u062f\\u0645\\u0627\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0646\\u06cc\\u0627\\u0632 \\u062f\\u0627\\u0631\\u06cc\\u062f\\u061f\",\"desc\":\"\\u062a\\u0645\\u0627\\u0633: 021123456789\",\"title_color\":\"#FFFFFF\",\"icon_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_width\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"desc_color\":\"#FFFFFF99\",\"icon_color\":\"#4A7DC2\",\"icon_bg_color\":\"#02010100\",\"title_bottom\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"inner_space\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"4a79de0\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"0\",\"left\":\"1\",\"isLinked\":false},\"border_color\":\"#FFFFFF80\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"border_width_mobile_extra\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"1\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"91829d8\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"15\",\"bottom\":\"0\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"pxl_parallax_bg_position\":\"\",\"pxl_parallax_bg_position_laptop\":\"\",\"pxl_parallax_bg_position_tablet_extra\":\"\",\"pxl_parallax_bg_position_tablet\":\"\",\"pxl_parallax_bg_position_mobile_extra\":\"\",\"pxl_parallax_bg_position_mobile\":\"\",\"pxl_parallax_bg_pos_custom_x\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size\":\"\",\"pxl_parallax_bg_size_laptop\":\"\",\"pxl_parallax_bg_size_tablet_extra\":\"\",\"pxl_parallax_bg_size_tablet\":\"\",\"pxl_parallax_bg_size_mobile_extra\":\"\",\"pxl_parallax_bg_size_mobile\":\"\",\"pxl_parallax_bg_size_custom\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"pxl_parallax_bg_size_custom_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_overlay_img_position\":\"\",\"pxl_overlay_img_position_laptop\":\"\",\"pxl_overlay_img_position_tablet_extra\":\"\",\"pxl_overlay_img_position_tablet\":\"\",\"pxl_overlay_img_position_mobile_extra\":\"\",\"pxl_overlay_img_position_mobile\":\"\",\"pxl_overlay_img_right_position\":\"\",\"pxl_overlay_img_right_position_laptop\":\"\",\"pxl_overlay_img_right_position_tablet_extra\":\"\",\"pxl_overlay_img_right_position_tablet\":\"\",\"pxl_overlay_img_right_position_mobile_extra\":\"\",\"pxl_overlay_img_right_position_mobile\":\"\",\"row_effect_images\":[],\"flex_align_items\":\"center\"},\"elements\":[{\"id\":\"b6383c4\",\"elType\":\"widget\",\"settings\":{\"layout\":\"2\",\"pxl_icon\":{\"value\":\"fas fa-clock\",\"library\":\"fa-solid\"},\"title\":\"\\u0633\\u0627\\u0639\\u0627\\u062a \\u06a9\\u0627\\u0631\\u06cc\",\"desc\":\"\\u0647\\u0631 \\u0631\\u0648\\u0632 \\u0627\\u0632 08:00 \\u062a\\u0627 20:00\",\"title_color\":\"#FFFFFF\",\"icon_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_width\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"desc_color\":\"#FFFFFF99\",\"icon_color\":\"#4A7DC2\",\"icon_bg_color\":\"#02010100\",\"title_bottom\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"inner_space\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"_element_width_mobile\":\"inherit\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"6a5100f\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"4eaeb3c\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"15\",\"bottom\":\"0\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"pxl_parallax_bg_position\":\"\",\"pxl_parallax_bg_position_laptop\":\"\",\"pxl_parallax_bg_position_tablet_extra\":\"\",\"pxl_parallax_bg_position_tablet\":\"\",\"pxl_parallax_bg_position_mobile_extra\":\"\",\"pxl_parallax_bg_position_mobile\":\"\",\"pxl_parallax_bg_pos_custom_x\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size\":\"\",\"pxl_parallax_bg_size_laptop\":\"\",\"pxl_parallax_bg_size_tablet_extra\":\"\",\"pxl_parallax_bg_size_tablet\":\"\",\"pxl_parallax_bg_size_mobile_extra\":\"\",\"pxl_parallax_bg_size_mobile\":\"\",\"pxl_parallax_bg_size_custom\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"pxl_parallax_bg_size_custom_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_overlay_img_position\":\"\",\"pxl_overlay_img_position_laptop\":\"\",\"pxl_overlay_img_position_tablet_extra\":\"\",\"pxl_overlay_img_position_tablet\":\"\",\"pxl_overlay_img_position_mobile_extra\":\"\",\"pxl_overlay_img_position_mobile\":\"\",\"pxl_overlay_img_right_position\":\"\",\"pxl_overlay_img_right_position_laptop\":\"\",\"pxl_overlay_img_right_position_tablet_extra\":\"\",\"pxl_overlay_img_right_position_tablet\":\"\",\"pxl_overlay_img_right_position_mobile_extra\":\"\",\"pxl_overlay_img_right_position_mobile\":\"\",\"row_effect_images\":[],\"flex_align_items\":\"center\"},\"elements\":[{\"id\":\"ff38d6d\",\"elType\":\"widget\",\"settings\":{\"layout\":\"2\",\"pxl_icon\":{\"value\":\"fas fa-envelope\",\"library\":\"fa-solid\"},\"title\":\"\\u0627\\u06cc\\u0645\\u06cc\\u0644 \\u0645\\u0627\",\"desc\":\"contact@dentiaclinic.com\",\"title_color\":\"#FFFFFF\",\"icon_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_width\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"desc_color\":\"#FFFFFF99\",\"icon_color\":\"#4A7DC2\",\"icon_bg_color\":\"#02010100\",\"title_bottom\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"inner_space\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"_element_width_mobile\":\"inherit\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false},{\"id\":\"15b34f8\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":50,\"column\":\"50\",\"row\":\"50\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"135\",\"right\":\"15\",\"bottom\":\"130\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_gap_laptop\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"0\",\"bottom\":\"70\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"98ca70d\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"flex_gap\":{\"column\":\"22\",\"row\":\"22\",\"isLinked\":true,\"unit\":\"px\",\"size\":22},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_direction_tablet\":\"column\"},\"elements\":[{\"id\":\"43ff422\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"b698bb4\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/about-img1.jpg\",\"id\":463,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":399,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"300\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"300\"},\"elements\":[],\"widgetType\":\"pxl_image\"}],\"isInner\":true},{\"id\":\"4c3a639\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"padding\":{\"unit\":\"px\",\"top\":\"55\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"3a26ecd\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/about-img2.jpg\",\"id\":464,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":399,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"500\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_image\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"9dd8e84\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"b0297bf\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u062a\\u062e\\u0635\\u0635\\u0627\\u0646 \\u0648 \\u062a\\u0639\\u0627\\u0644\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0634\\u062e\\u0635\\u06cc\",\"sub_title\":\"\\u062f\\u0631\\u0628\\u0627\\u0631\\u0647 \\u0645\\u0627\",\"h_width\":{\"unit\":\"%\",\"size\":80,\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"6bc87e8\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0645\\u0627 \\u062e\\u062f\\u0645\\u0627\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0628\\u0627 \\u06a9\\u06cc\\u0641\\u06cc\\u062a \\u0628\\u0627\\u0644\\u0627 \\u0648 \\u0645\\u062a\\u0646\\u0627\\u0633\\u0628 \\u0628\\u0627 \\u0646\\u06cc\\u0627\\u0632 \\u062a\\u0645\\u0627\\u0645 \\u0627\\u0639\\u0636\\u0627\\u06cc \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647 \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645. \\u0627\\u0632 \\u0645\\u0639\\u0627\\u06cc\\u0646\\u0627\\u062a \\u0631\\u0648\\u062a\\u06cc\\u0646 \\u06af\\u0631\\u0641\\u062a\\u0647 \\u062a\\u0627 \\u062f\\u0631\\u0645\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647\\u060c \\u062a\\u06cc\\u0645 \\u062f\\u0644\\u0633\\u0648\\u0632 \\u0645\\u0627 \\u062a\\u0636\\u0645\\u06cc\\u0646 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u062f \\u06a9\\u0647 \\u0644\\u0628\\u062e\\u0646\\u062f \\u0634\\u0645\\u0627 \\u0633\\u0627\\u0644\\u0645 \\u0648 \\u0628\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f \\u0628\\u0647 \\u0646\\u0641\\u0633 \\u0628\\u0627\\u0642\\u06cc \\u0628\\u0645\\u0627\\u0646\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"17\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"bb0da06\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_gap\":{\"column\":\"35\",\"row\":\"35\",\"isLinked\":true,\"unit\":\"px\",\"size\":35},\"flex_gap_laptop\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_direction_tablet\":\"column\",\"flex_gap_tablet\":{\"column\":\"5\",\"row\":\"5\",\"isLinked\":true,\"unit\":\"px\",\"size\":5}},\"elements\":[{\"id\":\"9028010\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"827cdc3\",\"elType\":\"widget\",\"settings\":{\"lists\":[{\"_id\":\"29fdacb\",\"pxl_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"},\"text\":\"\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0631\\u0645\\u0627\\u0646 \\u0634\\u062e\\u0635\\u06cc\\u200c\\u0633\\u0627\\u0632\\u06cc\\u200c\\u0634\\u062f\\u0647\"},{\"pxl_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"},\"text\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u0645\\u0644\\u0627\\u06cc\\u0645 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646 \\u0648 \\u0628\\u0632\\u0631\\u06af\\u0633\\u0627\\u0644\\u0627\\u0646\",\"_id\":\"7ff6475\"}],\"text_typography_typography\":\"custom\",\"text_typography_font_size_laptop\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"icon_color\":\"#4A7DC2\",\"icon_space\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"03\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"600\",\"align_items\":\"start\"},\"elements\":[],\"widgetType\":\"pxl_list\"}],\"isInner\":true},{\"id\":\"6db1ff5\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"fa6490e\",\"elType\":\"widget\",\"settings\":{\"lists\":[{\"_id\":\"29fdacb\",\"pxl_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"},\"text\":\"\\u0641\\u0646\\u0627\\u0648\\u0631\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647\"},{\"pxl_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"},\"text\":\"\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647\\u200c\\u0631\\u06cc\\u0632\\u06cc \\u0627\\u0646\\u0639\\u0637\\u0627\\u0641\\u200c\\u067e\\u0630\\u06cc\\u0631 \\u0628\\u0631\\u0627\\u06cc \\u0642\\u0631\\u0627\\u0631 \\u0645\\u0644\\u0627\\u0642\\u0627\\u062a\",\"_id\":\"7ff6475\"}],\"text_typography_typography\":\"custom\",\"text_typography_font_size_laptop\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"icon_color\":\"#4A7DC2\",\"icon_space\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"03\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"600\",\"align_items\":\"start\"},\"elements\":[],\"widgetType\":\"pxl_list\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"f3897d9\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0631\\u0632\\u0631\\u0648 \\u0646\\u0648\\u0628\\u062a\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"700\",\"_margin\":{\"unit\":\"px\",\"top\":\"28\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_button\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"9f68bac\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#4A7CD21A\",\"padding\":{\"unit\":\"px\",\"top\":\"120\",\"right\":\"15\",\"bottom\":\"130\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"15\",\"bottom\":\"70\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"ac1ac70\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"c74a3ee\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u06a9\\u0627\\u0645\\u0644 \\u0628\\u0631\\u0627\\u06cc \\u0647\\u0631 \\u0644\\u0628\\u062e\\u0646\\u062f\",\"sub_title\":\"\\u062e\\u062f\\u0645\\u0627\\u062a \\u0645\\u0627\",\"h_width\":{\"unit\":\"%\",\"size\":80,\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]},\"align\":\"center\"},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"72847f9\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0627\\u0632 \\u062a\\u0645\\u06cc\\u0632 \\u06a9\\u0631\\u062f\\u0646\\u200c\\u0647\\u0627\\u06cc \\u0631\\u0648\\u062a\\u06cc\\u0646 \\u06af\\u0631\\u0641\\u062a\\u0647 \\u062a\\u0627 \\u062a\\u0631\\u0645\\u06cc\\u0645\\u200c\\u0647\\u0627\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647\\u060c \\u0645\\u0627 \\u0631\\u0627\\u0647\\u200c\\u062d\\u0644\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0634\\u062e\\u0635\\u06cc\\u200c\\u0633\\u0627\\u0632\\u06cc\\u200c\\u0634\\u062f\\u0647 \\u0631\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u0628\\u06cc\\u0645\\u0627\\u0631\\u0627\\u0646 \\u062f\\u0631 \\u0647\\u0631 \\u0633\\u0646\\u06cc \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"42\",\"left\":\"0\",\"isLinked\":false},\"align\":\"center\",\"t_width\":{\"unit\":\"px\",\"size\":563,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"7371f8b\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"pxl_parallax_bg_position\":\"\",\"pxl_parallax_bg_position_laptop\":\"\",\"pxl_parallax_bg_position_tablet_extra\":\"\",\"pxl_parallax_bg_position_tablet\":\"\",\"pxl_parallax_bg_position_mobile_extra\":\"\",\"pxl_parallax_bg_position_mobile\":\"\",\"pxl_parallax_bg_pos_custom_x\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size\":\"\",\"pxl_parallax_bg_size_laptop\":\"\",\"pxl_parallax_bg_size_tablet_extra\":\"\",\"pxl_parallax_bg_size_tablet\":\"\",\"pxl_parallax_bg_size_mobile_extra\":\"\",\"pxl_parallax_bg_size_mobile\":\"\",\"pxl_parallax_bg_size_custom\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"pxl_parallax_bg_size_custom_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_overlay_img_position\":\"\",\"pxl_overlay_img_position_laptop\":\"\",\"pxl_overlay_img_position_tablet_extra\":\"\",\"pxl_overlay_img_position_tablet\":\"\",\"pxl_overlay_img_position_mobile_extra\":\"\",\"pxl_overlay_img_position_mobile\":\"\",\"pxl_overlay_img_right_position\":\"\",\"pxl_overlay_img_right_position_laptop\":\"\",\"pxl_overlay_img_right_position_tablet_extra\":\"\",\"pxl_overlay_img_right_position_tablet\":\"\",\"pxl_overlay_img_right_position_mobile_extra\":\"\",\"pxl_overlay_img_right_position_mobile\":\"\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"37741dc\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"flex_gap\":{\"column\":\"24\",\"row\":\"24\",\"isLinked\":true,\"unit\":\"px\",\"size\":24},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_wrap_tablet_extra\":\"wrap\",\"flex_gap_laptop\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20}},\"elements\":[{\"id\":\"5855528\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet_extra\":{\"unit\":\"%\",\"size\":48.5,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":48,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"ff281fa\",\"elType\":\"widget\",\"settings\":{\"layout\":\"3\",\"icon_type\":\"image\",\"icon_image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/tooth-1.png\",\"id\":626,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0639\\u0645\\u0648\\u0645\\u06cc\",\"desc\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u06a9\\u0627\\u0645\\u0644 \\u062f\\u0647\\u0627\\u0646 \\u0648 \\u062f\\u0646\\u062f\\u0627\\u0646 \\u0628\\u0631\\u0627\\u06cc \\u0647\\u0631 \\u0644\\u0628\\u062e\\u0646\\u062f\\u06cc \\u0628\\u0627 \\u062c\\u0631\\u0645\\u200c\\u06af\\u06cc\\u0631\\u06cc\\u060c \\u0645\\u0639\\u0627\\u06cc\\u0646\\u0647 \\u0648 \\u0645\\u0648\\u0627\\u0631\\u062f \\u062f\\u06cc\\u06af\\u0631.\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/service\\/general-dentistry\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"title_btn\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"pxl_animate\":\"wow scaleIn\",\"pxl_animate_delay\":\"300\",\"pxl_animate2\":\"wow fadeInUp\",\"pxl_animate_delay2\":\"500\",\"title_color\":\"#10244B\",\"background_color\":\"#FFFFFF\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true},{\"id\":\"62a7ae9\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet_extra\":{\"unit\":\"%\",\"size\":49,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":48.5,\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"c880081\",\"elType\":\"widget\",\"settings\":{\"layout\":\"3\",\"icon_type\":\"image\",\"icon_image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/tooth-2.png\",\"id\":627,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0632\\u06cc\\u0628\\u0627\\u06cc\\u06cc\",\"desc\":\"\\u0632\\u06cc\\u0628\\u0627\\u06cc\\u06cc \\u0644\\u0628\\u062e\\u0646\\u062f \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0628\\u0627 \\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\\u060c \\u0648\\u0646\\u06cc\\u0631\\u0647\\u0627 \\u0648 \\u0645\\u0648\\u0627\\u0631\\u062f \\u062f\\u06cc\\u06af\\u0631 \\u0627\\u0641\\u0632\\u0627\\u06cc\\u0634 \\u062f\\u0647\\u06cc\\u062f.\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/service\\/cosmetic-dentistry\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"title_btn\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"pxl_animate\":\"wow scaleIn\",\"pxl_animate_delay\":\"300\",\"pxl_animate2\":\"wow fadeInUp\",\"pxl_animate_delay2\":\"500\",\"title_color\":\"#10244B\",\"background_color\":\"#FFFFFF\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true},{\"id\":\"964d2d6\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"background_background\":\"classic\",\"background_image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_position\":\"center center\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"width_tablet_extra\":{\"unit\":\"%\",\"size\":48.5,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":48,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"flex_justify_content\":\"center\"},\"elements\":[{\"id\":\"336bf6f\",\"elType\":\"widget\",\"settings\":{\"layout\":\"3\",\"icon_type\":\"image\",\"icon_image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/tooth-3.png\",\"id\":628,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646\",\"desc\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u0645\\u0644\\u0627\\u06cc\\u0645 \\u0648 \\u0633\\u0631\\u06af\\u0631\\u0645\\u200c\\u06a9\\u0646\\u0646\\u062f\\u0647 \\u0627\\u0632 \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646 \\u062a\\u0627 \\u0644\\u0628\\u062e\\u0646\\u062f\\u06cc \\u0633\\u0627\\u0644\\u0645 \\u0648 \\u0634\\u0627\\u062f \\u062f\\u0627\\u0634\\u062a\\u0647 \\u0628\\u0627\\u0634\\u0646\\u062f.\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/service\\/pediatric-dentistry\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"title_btn\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"pxl_animate\":\"wow scaleIn\",\"pxl_animate_delay\":\"300\",\"pxl_animate2\":\"wow fadeInUp\",\"pxl_animate_delay2\":\"500\",\"title_color\":\"#10244B\",\"background_color\":\"#FFFFFF\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true},{\"id\":\"2e4cbee\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet_extra\":{\"unit\":\"%\",\"size\":49,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":48.5,\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"2029233\",\"elType\":\"widget\",\"settings\":{\"layout\":\"3\",\"icon_type\":\"image\",\"icon_image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/tooth-4.png\",\"id\":629,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u062a\\u0631\\u0645\\u06cc\\u0645\\u06cc\",\"desc\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u0634\\u0645\\u0627 \\u0631\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u0631\\u0627\\u062d\\u062a\\u06cc \\u0648 \\u0639\\u0645\\u0644\\u06a9\\u0631\\u062f \\u067e\\u0627\\u06cc\\u062f\\u0627\\u0631 \\u062a\\u0631\\u0645\\u06cc\\u0645 \\u0648 \\u0628\\u0627\\u0632\\u0633\\u0627\\u0632\\u06cc \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u062f.\\n\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/service\\/restorative-dentistry\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"title_btn\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"pxl_animate\":\"wow scaleIn\",\"pxl_animate_delay\":\"300\",\"pxl_animate2\":\"wow fadeInUp\",\"pxl_animate_delay2\":\"500\",\"title_color\":\"#10244B\",\"background_color\":\"#FFFFFF\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true},{\"id\":\"e71413a\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u0647\\u0645\\u0647 \\u062e\\u062f\\u0645\\u0627\\u062a\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/all-services\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"align\":\"center\",\"_margin\":{\"unit\":\"px\",\"top\":\"48\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_button\"}],\"isInner\":false},{\"id\":\"b92d7a4\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#000A5B\",\"padding\":{\"unit\":\"px\",\"top\":\"60\",\"right\":\"15\",\"bottom\":\"60\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"d408d83\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"25\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"c08f676\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0628\\u06cc\\u0645\\u0627\\u0631\\u0627\\u0646 \\u0634\\u0627\\u062f\",\"starting_number\":5000,\"ending_number\":10000,\"suffix\":\"+\",\"pxl_animate\":\"wow fadeInRight\",\"pxl_animate_delay\":\"300\"},\"elements\":[],\"widgetType\":\"pxl_counter\"}],\"isInner\":true},{\"id\":\"3ffca2e\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"25\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"17f3015\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\",\"starting_number\":2000,\"ending_number\":2500,\"suffix\":\"+\",\"pxl_animate\":\"wow fadeInRight\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_counter\"}],\"isInner\":true},{\"id\":\"5163797\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"25\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"344472f\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u06cc\\u0645\\u067e\\u0644\\u0646\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\",\"starting_number\":500,\"ending_number\":800,\"suffix\":\"+\",\"pxl_animate\":\"wow fadeInRight\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_counter\"}],\"isInner\":true},{\"id\":\"7ac7412\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"25\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"62d672d\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0633\\u0627\\u0644 \\u062a\\u062c\\u0631\\u0628\\u0647\",\"ending_number\":15,\"suffix\":\"+\",\"pxl_animate\":\"wow fadeInRight\",\"pxl_animate_delay\":\"600\"},\"elements\":[],\"widgetType\":\"pxl_counter\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"fc38de1\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":50,\"column\":\"50\",\"row\":\"50\",\"isLinked\":true},\"flex_direction_mobile_extra\":\"column\",\"flex_gap_laptop\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"padding\":{\"unit\":\"px\",\"top\":\"120\",\"right\":\"15\",\"bottom\":\"155\",\"left\":\"15\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"0\",\"bottom\":\"70\",\"left\":\"0\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"931cd86\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"c7857de\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0633\\u062a\\u062b\\u0646\\u0627\\u06cc\\u06cc \\u0628\\u0627 \\u0631\\u0648\\u06cc\\u06a9\\u0631\\u062f\\u06cc \\u0634\\u062e\\u0635\\u06cc\",\"sub_title\":\"\\u0686\\u0631\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0645\\u0627 \\u0631\\u0627 \\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u06a9\\u0646\\u06cc\\u062f\",\"h_width\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"602ea93\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0627\\u0631\\u0627\\u0626\\u0647 \\u062f\\u0647\\u0646\\u062f\\u0647 \\u062e\\u062f\\u0645\\u0627\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0645\\u0646\\u0627\\u0633\\u0628 \\u0627\\u0647\\u0645\\u06cc\\u062a \\u062f\\u0627\\u0631\\u062f. \\u0645\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062a\\u062e\\u0635\\u0635\\u06cc\\u060c \\u0641\\u0646\\u0627\\u0648\\u0631\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647 \\u0648 \\u0641\\u0636\\u0627\\u06cc\\u06cc \\u06af\\u0631\\u0645 \\u0631\\u0627 \\u0628\\u0627 \\u0647\\u0645 \\u062a\\u0631\\u06a9\\u06cc\\u0628 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u06cc\\u0645 \\u062a\\u0627 \\u0627\\u0637\\u0645\\u06cc\\u0646\\u0627\\u0646 \\u062d\\u0627\\u0635\\u0644 \\u06a9\\u0646\\u06cc\\u0645 \\u06a9\\u0647 \\u0647\\u0631 \\u0648\\u06cc\\u0632\\u06cc\\u062a \\u0631\\u0627\\u062d\\u062a\\u060c \\u06a9\\u0627\\u0631\\u0622\\u0645\\u062f \\u0648 \\u0645\\u062a\\u0646\\u0627\\u0633\\u0628 \\u0628\\u0627 \\u0646\\u06cc\\u0627\\u0632\\u0647\\u0627\\u06cc \\u0645\\u0646\\u062d\\u0635\\u0631 \\u0628\\u0647 \\u0641\\u0631\\u062f \\u0634\\u0645\\u0627 \\u062e\\u0648\\u0627\\u0647\\u062f \\u0628\\u0648\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"21\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"9f3be1f\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_gap\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"flex_gap_laptop\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_direction_tablet\":\"column\",\"flex_gap_tablet\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"border_color\":\"#0000004D\",\"padding\":{\"unit\":\"px\",\"top\":\"22\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"e4d5e10\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_gap\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"flex_gap_tablet_extra\":{\"column\":\"15\",\"row\":\"15\",\"isLinked\":true,\"unit\":\"px\",\"size\":15}},\"elements\":[{\"id\":\"3f475ce\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"d437b1c\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<h5>\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0628\\u0627\\u062a\\u062c\\u0631\\u0628\\u0647<\\/h5>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"78e6e2b\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062a\\u062e\\u0635\\u0635\\u06cc \\u0628\\u0627 \\u067e\\u0634\\u062a\\u0648\\u0627\\u0646\\u0647 \\u0633\\u0627\\u0644\\u200c\\u0647\\u0627 \\u062a\\u062c\\u0631\\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0642\\u0627\\u0628\\u0644 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"c548350\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"65c31f4\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<h5>\\u062f\\u0631\\u0645\\u0627\\u0646 \\u0634\\u062e\\u0635\\u06cc\\u200c\\u0633\\u0627\\u0632\\u06cc\\u200c\\u0634\\u062f\\u0647<\\/h5>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"24d4409\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647\\u200c\\u0647\\u0627\\u06cc \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u06cc \\u0633\\u0641\\u0627\\u0631\\u0634\\u06cc \\u06a9\\u0647 \\u0645\\u062a\\u0646\\u0627\\u0633\\u0628 \\u0628\\u0627 \\u0644\\u0628\\u062e\\u0646\\u062f \\u0648 \\u0633\\u0628\\u06a9 \\u0632\\u0646\\u062f\\u06af\\u06cc \\u0634\\u0645\\u0627 \\u062a\\u0647\\u06cc\\u0647 \\u0645\\u06cc\\u200c\\u0634\\u0648\\u0646\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"64807c6\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_gap\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"flex_gap_tablet_extra\":{\"column\":\"15\",\"row\":\"15\",\"isLinked\":true,\"unit\":\"px\",\"size\":15}},\"elements\":[{\"id\":\"0cb580b\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"pxl_parallax_bg_position\":\"\",\"pxl_parallax_bg_position_laptop\":\"\",\"pxl_parallax_bg_position_tablet_extra\":\"\",\"pxl_parallax_bg_position_tablet\":\"\",\"pxl_parallax_bg_position_mobile_extra\":\"\",\"pxl_parallax_bg_position_mobile\":\"\",\"pxl_parallax_bg_pos_custom_x\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size\":\"\",\"pxl_parallax_bg_size_laptop\":\"\",\"pxl_parallax_bg_size_tablet_extra\":\"\",\"pxl_parallax_bg_size_tablet\":\"\",\"pxl_parallax_bg_size_mobile_extra\":\"\",\"pxl_parallax_bg_size_mobile\":\"\",\"pxl_parallax_bg_size_custom\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"pxl_parallax_bg_size_custom_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_overlay_img_position\":\"\",\"pxl_overlay_img_position_laptop\":\"\",\"pxl_overlay_img_position_tablet_extra\":\"\",\"pxl_overlay_img_position_tablet\":\"\",\"pxl_overlay_img_position_mobile_extra\":\"\",\"pxl_overlay_img_position_mobile\":\"\",\"pxl_overlay_img_right_position\":\"\",\"pxl_overlay_img_right_position_laptop\":\"\",\"pxl_overlay_img_right_position_tablet_extra\":\"\",\"pxl_overlay_img_right_position_tablet\":\"\",\"pxl_overlay_img_right_position_mobile_extra\":\"\",\"pxl_overlay_img_right_position_mobile\":\"\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"89fbcf5\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<h5>\\u0641\\u0646\\u0627\\u0648\\u0631\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647<\\/h5>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"1a2ce28\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0627\\u0628\\u0632\\u0627\\u0631\\u0647\\u0627\\u06cc \\u0645\\u062f\\u0631\\u0646\\u060c \\u062f\\u0631\\u0645\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0642\\u06cc\\u0642 \\u0648 \\u06a9\\u0627\\u0631\\u0622\\u0645\\u062f \\u0631\\u0627 \\u062a\\u0636\\u0645\\u06cc\\u0646 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0646\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"5c18bec\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"0139430\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<h5>\\u0645\\u0646\\u0627\\u0633\\u0628 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647<\\/h5>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"3e9309c\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0641\\u0636\\u0627\\u06cc\\u06cc \\u062f\\u0644\\u0646\\u0634\\u06cc\\u0646 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646\\u060c \\u0646\\u0648\\u062c\\u0648\\u0627\\u0646\\u0627\\u0646\\u060c \\u0628\\u0632\\u0631\\u06af\\u0633\\u0627\\u0644\\u0627\\u0646 \\u0648 \\u0633\\u0627\\u0644\\u0645\\u0646\\u062f\\u0627\\u0646.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true},{\"id\":\"c0bac5e\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"flex_align_items\":\"center\",\"flex_gap\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"9ce2c5c\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_gap\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"flex_gap_tablet_extra\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"e530c81\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/exceptional2.jpg\",\"id\":607,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":236.80000000000001136868377216160297393798828125,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"300\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"300\",\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"60\",\"isLinked\":false},\"_padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_image\"},{\"id\":\"21bc2cb\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/exceptional1.jpg\",\"id\":606,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":296,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"500\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_image\"}],\"isInner\":true},{\"id\":\"2b3fb22\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"a7be7b9\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/exceptional3.jpg\",\"id\":608,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":399.6000000000000227373675443232059478759765625,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"400\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_image\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false},{\"id\":\"d0d5540\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#4A7CD21A\",\"padding\":{\"unit\":\"px\",\"top\":\"120\",\"right\":\"15\",\"bottom\":\"108\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"15\",\"bottom\":\"70\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"964e490\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"d075595\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u062a\\u0639\\u0647\\u062f \\u0628\\u0647 \\u0644\\u0628\\u062e\\u0646\\u062f \\u0634\\u0645\\u0627\",\"sub_title\":\" \\u0628\\u0627 \\u062a\\u06cc\\u0645 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0645\\u0627 \\u0622\\u0634\\u0646\\u0627 \\u0634\\u0648\\u06cc\\u062f\",\"h_width\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"align\":\"center\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"acd7da4\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p class=\\\"wow fadeInUp animated\\\">\\u062a\\u06cc\\u0645 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0628\\u0627\\u062a\\u062c\\u0631\\u0628\\u0647 \\u0645\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0647\\u0633\\u062a\\u0646\\u062f \\u062a\\u0627 \\u0647\\u0631 \\u0648\\u06cc\\u0632\\u06cc\\u062a \\u0631\\u0627 \\u0645\\u062b\\u0628\\u062a \\u0648 \\u0634\\u062e\\u0635\\u06cc\\u200c\\u0633\\u0627\\u0632\\u06cc\\u200c\\u0634\\u062f\\u0647 \\u06a9\\u0646\\u0646\\u062f. \\u0628\\u0627 \\u062f\\u0633\\u062a\\u0627\\u0646\\u06cc \\u0645\\u0647\\u0631\\u0628\\u0627\\u0646 \\u0648 \\u0642\\u0644\\u0628\\u06cc \\u0645\\u0647\\u0631\\u0628\\u0627\\u0646.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"37\",\"left\":\"0\",\"isLinked\":false},\"align\":\"center\",\"t_width\":{\"unit\":\"px\",\"size\":628,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"8e36ff0\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"9c707a0\",\"elType\":\"widget\",\"settings\":{\"team\":[{\"_id\":\"836b840\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/dentists-img1.jpg\",\"id\":179,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u06a9\\u062a\\u0631 \\u0633\\u0627\\u0631\\u0627 \\u0645\\u06cc\\u0631\\u0632\\u0627\\u0626\\u06cc\",\"position\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0627\\u0631\\u0634\\u062f\"},{\"_id\":\"baa6cb5\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/dentists-img2.jpg\",\"id\":180,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u06a9\\u062a\\u0631 \\u0645\\u0631\\u06cc\\u0645 \\u0622\\u0642\\u0627\\u062c\\u0627\\u0646\\u06cc\",\"position\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0632\\u06cc\\u0628\\u0627\\u06cc\\u06cc\"},{\"_id\":\"3faca8d\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/dentists-img3.jpg\",\"id\":181,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u06a9\\u062a\\u0631 \\u0634\\u0647\\u0627\\u0628 \\u0637\\u0647\\u0645\\u0627\\u0633\\u0628\\u06cc\",\"position\":\"\\u0645\\u062a\\u062e\\u0635\\u0635 \\u0627\\u0637\\u0641\\u0627\\u0644\"},{\"_id\":\"33e5523\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/dentists-img4.jpg\",\"id\":182,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u06a9\\u062a\\u0631 \\u0627\\u0645\\u06cc\\u0631 \\u06a9\\u0631\\u0645\\u0627\\u0646\\u06cc\\u200c\\u0645\\u0642\\u062f\\u0645\",\"position\":\"\\u0628\\u0647\\u062f\\u0627\\u0634\\u062a\\u06a9\\u0627\\u0631 \\u062f\\u0647\\u0627\\u0646 \\u0648 \\u062f\\u0646\\u062f\\u0627\\u0646\"}],\"item_spacer\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"pxl_animate_img\":\"wow zoomInSmall\",\"pxl_animate_img2\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"600\",\"pxl_animate_content\":\"wow fadeInDown\",\"pxl_animate_ct_delay\":\"700\"},\"elements\":[],\"widgetType\":\"pxl_team_grid\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"07e3439\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":30,\"column\":\"30\",\"row\":\"30\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"123\",\"right\":\"15\",\"bottom\":\"120\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_direction_mobile_extra\":\"column\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"0\",\"bottom\":\"70\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"cabeee0\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_mobile_extra\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"92a30c5\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0633\\u0648\\u0627\\u0644\\u0627\\u062a \\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\",\"sub_title\":\"\\u0647\\u0631 \\u0622\\u0646\\u0686\\u0647 \\u06a9\\u0647 \\u0628\\u0627\\u06cc\\u062f \\u0628\\u062f\\u0627\\u0646\\u06cc\\u062f\",\"title_tag\":\"h2\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_heading\"}],\"isInner\":true},{\"id\":\"cb0bd9f\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":68.599999999999994315658113919198513031005859375},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_mobile_extra\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"eff6c82\",\"elType\":\"widget\",\"settings\":{\"active\":0,\"accordion\":[{\"_id\":\"324d3d2\",\"title\":\"\\u0686\\u0646\\u062f \\u0648\\u0642\\u062a \\u06cc\\u06a9\\u0628\\u0627\\u0631 \\u0628\\u0627\\u06cc\\u062f \\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0647 \\u06a9\\u0646\\u0645\\u061f \",\"desc\":\"\\u062a\\u0648\\u0635\\u06cc\\u0647 \\u0645\\u06cc\\u200c\\u0634\\u0648\\u062f \\u0647\\u0631 \\u06f6 \\u0645\\u0627\\u0647 \\u06cc\\u06a9\\u0628\\u0627\\u0631 \\u0628\\u0631\\u0627\\u06cc \\u0645\\u0639\\u0627\\u06cc\\u0646\\u0647 \\u0648 \\u062a\\u0645\\u06cc\\u0632 \\u06a9\\u0631\\u062f\\u0646 \\u0631\\u0648\\u062a\\u06cc\\u0646 \\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u062e\\u0648\\u062f \\u0645\\u0631\\u0627\\u062c\\u0639\\u0647 \\u06a9\\u0646\\u06cc\\u062f\\u060c \\u0645\\u06af\\u0631 \\u0627\\u06cc\\u0646\\u06a9\\u0647 \\u067e\\u0632\\u0634\\u06a9 \\u062a\\u0648\\u0635\\u06cc\\u0647 \\u062f\\u06cc\\u06af\\u0631\\u06cc \\u062f\\u0627\\u0634\\u062a\\u0647 \\u0628\\u0627\\u0634\\u062f. \"},{\"_id\":\"b063b10\",\"title\":\"\\u062f\\u0631 \\u0645\\u0648\\u0627\\u0642\\u0639 \\u0627\\u0648\\u0631\\u0698\\u0627\\u0646\\u0633 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0686\\u0647 \\u0628\\u0627\\u06cc\\u062f \\u0628\\u06a9\\u0646\\u0645\\u061f \",\"desc\":\"\\u0641\\u0648\\u0631\\u0627\\u064b \\u0628\\u0627 \\u0645\\u0637\\u0628 \\u0645\\u0627 \\u062a\\u0645\\u0627\\u0633 \\u0628\\u06af\\u06cc\\u0631\\u06cc\\u062f. \\u0645\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u0645\\u0648\\u0627\\u0631\\u062f\\u06cc \\u0645\\u0627\\u0646\\u0646\\u062f \\u062f\\u0631\\u062f \\u0634\\u062f\\u06cc\\u062f\\u060c \\u0634\\u06a9\\u0633\\u062a\\u06af\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646 \\u06cc\\u0627 \\u062a\\u0648\\u0631\\u0645\\u060c \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u0627\\u0648\\u0631\\u0698\\u0627\\u0646\\u0633\\u06cc \\u062f\\u0631 \\u0647\\u0645\\u0627\\u0646 \\u0631\\u0648\\u0632 \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645. \"},{\"_id\":\"8895a65\",\"title\":\"\\u0622\\u06cc\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u0628\\u0686\\u0647\\u200c\\u0647\\u0627 \\u062e\\u062f\\u0645\\u0627\\u062a\\u06cc \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u062f\\u061f \",\"desc\":\"\\u06a9\\u0627\\u0645\\u0644\\u0627\\u064b! \\u0645\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646 \\u0631\\u0627 \\u0628\\u0627 \\u0645\\u0644\\u0627\\u06cc\\u0645\\u062a \\u0648 \\u0628\\u0647 \\u0634\\u06a9\\u0644\\u06cc \\u062f\\u0648\\u0633\\u062a\\u0627\\u0646\\u0647 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646 \\u062f\\u0631 \\u062a\\u0645\\u0627\\u0645 \\u0633\\u0646\\u06cc\\u0646 \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645. \"},{\"_id\":\"40426f2\",\"title\":\"\\u06af\\u0632\\u06cc\\u0646\\u0647\\u200c\\u0647\\u0627\\u06cc \\u0645\\u0646 \\u0628\\u0631\\u0627\\u06cc \\u062c\\u0627\\u06cc\\u06af\\u0632\\u06cc\\u0646\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u0627\\u0632 \\u062f\\u0633\\u062a \\u0631\\u0641\\u062a\\u0647 \\u0686\\u06cc\\u0633\\u062a\\u061f \",\"desc\":\"\\u0645\\u0627 \\u0628\\u0633\\u062a\\u0647 \\u0628\\u0647 \\u0646\\u06cc\\u0627\\u0632\\u0647\\u0627 \\u0648 \\u062a\\u0631\\u062c\\u06cc\\u062d\\u0627\\u062a \\u0634\\u0645\\u0627\\u060c \\u0627\\u06cc\\u0645\\u067e\\u0644\\u0646\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u060c \\u0628\\u0631\\u06cc\\u062c \\u0648 \\u062f\\u0646\\u062f\\u0627\\u0646 \\u0645\\u0635\\u0646\\u0648\\u0639\\u06cc \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645. \"},{\"_id\":\"0d93a43\",\"title\":\"\\u0622\\u06cc\\u0627 \\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627 \\u0628\\u06cc\\u200c\\u062e\\u0637\\u0631 \\u0627\\u0633\\u062a\\u061f \",\"desc\":\"\\u0628\\u0644\\u0647\\u060c \\u0648\\u0642\\u062a\\u06cc \\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627 \\u062a\\u0648\\u0633\\u0637 \\u06cc\\u06a9 \\u0645\\u062a\\u062e\\u0635\\u0635 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0627\\u0646\\u062c\\u0627\\u0645 \\u0634\\u0648\\u062f\\u060c \\u0627\\u06cc\\u0645\\u0646 \\u0648 \\u0645\\u0624\\u062b\\u0631 \\u0627\\u0633\\u062a \\u0648 \\u0646\\u062a\\u0627\\u06cc\\u062c \\u0622\\u0646 \\u0645\\u0627\\u0646\\u062f\\u06af\\u0627\\u0631 \\u062e\\u0648\\u0627\\u0647\\u062f \\u0628\\u0648\\u062f. \"}],\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"300\"},\"elements\":[],\"widgetType\":\"pxl_accordion\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"faed713\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#4A7CD21A\",\"padding\":{\"unit\":\"px\",\"top\":\"115\",\"right\":\"0\",\"bottom\":\"105\",\"left\":\"0\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"content_width\":\"full\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"15\",\"bottom\":\"70\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"ba2fc12\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"15\",\"bottom\":\"0\",\"left\":\"15\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"cd71716\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646 \\u0631\\u0627\\u0636\\u06cc \\u0645\\u0627\",\"sub_title\":\"\\u0646\\u0638\\u0631\\u0627\\u062a \\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646\",\"h_width\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"align\":\"center\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"17efbb0\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p class=\\\"wow fadeInUp animated\\\">\\u0628\\u0647 \\u0647\\u0632\\u0627\\u0631\\u0627\\u0646 \\u0628\\u06cc\\u0645\\u0627\\u0631 \\u0631\\u0627\\u0636\\u06cc \\u0628\\u067e\\u06cc\\u0648\\u0646\\u062f\\u06cc\\u062f \\u06a9\\u0647 \\u0628\\u0631\\u0627\\u06cc \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u0645\\u0644\\u0627\\u06cc\\u0645 \\u0648 \\u062a\\u062e\\u0635\\u0635\\u06cc \\u0648 \\u0644\\u0628\\u062e\\u0646\\u062f\\u0647\\u0627\\u06cc \\u0632\\u06cc\\u0628\\u0627 \\u0628\\u0647 \\u0645\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0646\\u062f. \\u062a\\u062c\\u0631\\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0628\\u06cc\\u200c\\u0646\\u0638\\u06cc\\u0631 \\u0634\\u0645\\u0627 \\u0627\\u0632 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0634\\u0631\\u0648\\u0639 \\u0645\\u06cc\\u200c\\u0634\\u0648\\u062f!<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"50\",\"left\":\"0\",\"isLinked\":false},\"align\":\"center\",\"t_width\":{\"unit\":\"px\",\"size\":628,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"6356f20\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"a06f7d2\",\"elType\":\"widget\",\"settings\":{\"layout\":\"2\",\"testimonial\":[],\"testimonial_lv2\":[{\"_id\":\"8f77d95\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/author1.jpg\",\"id\":92,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0645\\u06cc\\u06a9\\u0627\\u0626\\u06cc\\u0644 \\u0634\\u0647\\u0627\\u0628\\u06cc\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0645\\u0646 \\u0647\\u0645\\u06cc\\u0634\\u0647 \\u0627\\u0632 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0647 \\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0646\\u06af\\u0631\\u0627\\u0646 \\u0628\\u0648\\u062f\\u0647\\u200c\\u0627\\u0645\\u060c \\u0627\\u0645\\u0627 \\u06a9\\u0627\\u0631\\u06a9\\u0646\\u0627\\u0646 \\u0628\\u0627\\u0639\\u062b \\u0634\\u062f\\u0646\\u062f \\u06a9\\u0627\\u0645\\u0644\\u0627\\u064b \\u0627\\u062d\\u0633\\u0627\\u0633 \\u0631\\u0627\\u062d\\u062a\\u06cc \\u06a9\\u0646\\u0645. \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u0645\\u0644\\u0627\\u06cc\\u0645 \\u0648 \\u062a\\u0648\\u062c\\u0647 \\u0622\\u0646\\u0647\\u0627 \\u0628\\u0647 \\u062c\\u0632\\u0626\\u06cc\\u0627\\u062a \\u0648\\u0627\\u0642\\u0639\\u0627\\u064b \\u0628\\u0631\\u062c\\u0633\\u062a\\u0647 \\u0627\\u0633\\u062a.\\\"\"},{\"_id\":\"4c80bef\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img3.jpg\",\"id\":218,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0631\\u0627\\u0645\\u06cc\\u0646 \\u0633\\u0647\\u0631\\u0627\\u0628\\u06cc\\u200c\\u0646\\u0698\\u0627\\u062f\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0645\\u0646 \\u0648 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647\\u200c\\u0627\\u0645 \\u0633\\u0627\\u0644\\u200c\\u0647\\u0627\\u0633\\u062a \\u06a9\\u0647 \\u0628\\u0647 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0645\\u06cc\\u200c\\u0622\\u06cc\\u0645. \\u062e\\u062f\\u0645\\u0627\\u062a \\u0641\\u0648\\u0642\\u200c\\u0627\\u0644\\u0639\\u0627\\u062f\\u0647 \\u0627\\u0633\\u062a \\u0648 \\u062a\\u06cc\\u0645 \\u0645\\u0627 \\u0647\\u0645\\u06cc\\u0634\\u0647 \\u062a\\u0645\\u0627\\u0645 \\u062a\\u0644\\u0627\\u0634 \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u062f \\u062a\\u0627 \\u0645\\u0637\\u0645\\u0626\\u0646 \\u0634\\u0648\\u062f \\u0645\\u0627 \\u0631\\u0627\\u0636\\u06cc \\u0647\\u0633\\u062a\\u06cc\\u0645 \\u0648 \\u0628\\u0647 \\u062e\\u0648\\u0628\\u06cc \\u0627\\u0632 \\u0645\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u0645\\u06cc\\u200c\\u0634\\u0648\\u062f.\\\"\"},{\"_id\":\"dd49806\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img4.jpg\",\"id\":219,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0622\\u0631\\u0627\\u062f \\u0627\\u0645\\u0627\\u0645\\u06cc\\u200c\\u0641\\u0631\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0645\\u0646 \\u0628\\u0631\\u0627\\u06cc \\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc\\u0645 \\u0628\\u0647 \\u0645\\u0637\\u0628 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0647 \\u06a9\\u0631\\u062f\\u0645 \\u0648 \\u0628\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f \\u0628\\u0647 \\u0646\\u0641\\u0633\\u06cc \\u06a9\\u0627\\u0645\\u0644\\u0627\\u064b \\u062c\\u062f\\u06cc\\u062f \\u0622\\u0646\\u062c\\u0627 \\u0631\\u0627 \\u062a\\u0631\\u06a9 \\u06a9\\u0631\\u062f\\u0645. \\u0646\\u062a\\u0627\\u06cc\\u062c \\u0634\\u06af\\u0641\\u062a\\u200c\\u0627\\u0646\\u06af\\u06cc\\u0632 \\u0628\\u0648\\u062f \\u0648 \\u06a9\\u0627\\u0631\\u06a9\\u0646\\u0627\\u0646\\u060c \\u0627\\u06cc\\u0646 \\u062a\\u062c\\u0631\\u0628\\u0647 \\u0631\\u0627 \\u0628\\u0647 \\u062a\\u062c\\u0631\\u0628\\u0647\\u200c\\u0627\\u06cc \\u0622\\u0631\\u0627\\u0645\\u0634\\u200c\\u0628\\u062e\\u0634 \\u062a\\u0628\\u062f\\u06cc\\u0644 \\u06a9\\u0631\\u062f\\u0646\\u062f.\\\"\"},{\"_id\":\"e16c281\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img5.jpg\",\"id\":220,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0633\\u06cc\\u0646\\u0627 \\u0641\\u0647\\u06cc\\u0645\\u06cc\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\\"\\u0622\\u0646\\u0647\\u0627 \\u062d\\u0631\\u0641\\u0647\\u200c\\u0627\\u06cc\\u060c \\u062f\\u0648\\u0633\\u062a\\u0627\\u0646\\u0647 \\u0648 \\u0648\\u0627\\u0642\\u0639\\u0627\\u064b \\u0628\\u0647 \\u0633\\u0644\\u0627\\u0645\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u0634\\u0645\\u0627 \\u0627\\u0647\\u0645\\u06cc\\u062a \\u0645\\u06cc\\u200c\\u062f\\u0647\\u0646\\u062f. \\u0645\\u0646 \\u06a9\\u0627\\u0645\\u0644\\u0627\\u064b \\u0628\\u0647 \\u0622\\u0646\\u0647\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f \\u062f\\u0627\\u0631\\u0645 \\u0648 \\u0622\\u0646\\u0647\\u0627 \\u0631\\u0627 \\u0628\\u0647 \\u0647\\u0631 \\u06a9\\u0633\\u06cc \\u06a9\\u0647 \\u0628\\u0647 \\u062f\\u0646\\u0628\\u0627\\u0644 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u0639\\u0627\\u0644\\u06cc \\u0627\\u0633\\u062a \\u062a\\u0648\\u0635\\u06cc\\u0647 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0645.\\\"\"},{\"_id\":\"99106f0\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img6.jpg\",\"id\":221,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0634\\u0627\\u0647\\u0648 \\u0622\\u0631\\u06cc\\u0627\\u0646\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0628\\u062f\\u0648\\u0646 \\u0634\\u06a9 \\u0628\\u0647\\u062a\\u0631\\u06cc\\u0646 \\u062a\\u062c\\u0631\\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u06a9\\u0647 \\u062a\\u0627 \\u0628\\u0647 \\u062d\\u0627\\u0644 \\u062f\\u0627\\u0634\\u062a\\u0647\\u200c\\u0627\\u0645. \\u0647\\u0645\\u0647 \\u0686\\u06cc\\u0632 \\u0627\\u0632 \\u062a\\u0639\\u06cc\\u06cc\\u0646 \\u0648\\u0642\\u062a \\u062a\\u0627 \\u062f\\u0631\\u0645\\u0627\\u0646 \\u0631\\u0648\\u0627\\u0646\\u060c \\u0631\\u0627\\u062d\\u062a \\u0648 \\u0628\\u0627 \\u0633\\u0644\\u06cc\\u0642\\u0647 \\u0634\\u062e\\u0635\\u06cc \\u0627\\u0646\\u062c\\u0627\\u0645 \\u0634\\u062f.\\\"\"},{\"_id\":\"69170d9\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img7.jpg\",\"id\":222,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u067e\\u06cc\\u0645\\u0627\\u0646 \\u0627\\u06a9\\u0628\\u0631\\u06cc\\u0627\\u0646\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0645\\u0646 \\u0647\\u0631\\u06af\\u0632 \\u062f\\u0631 \\u0645\\u0637\\u0628 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u062a\\u0627 \\u0627\\u06cc\\u0646 \\u062d\\u062f \\u0627\\u062d\\u0633\\u0627\\u0633 \\u0631\\u0627\\u062d\\u062a\\u06cc \\u0646\\u06a9\\u0631\\u062f\\u0647 \\u0628\\u0648\\u062f\\u0645. \\u062a\\u06cc\\u0645 \\u0622\\u0646\\u0647\\u0627 \\u0628\\u0633\\u06cc\\u0627\\u0631 \\u0645\\u0647\\u0631\\u0628\\u0627\\u0646\\u060c \\u062d\\u0631\\u0641\\u0647\\u200c\\u0627\\u06cc \\u0648 \\u062f\\u0642\\u06cc\\u0642 \\u0627\\u0633\\u062a. \\u0622\\u0646\\u0647\\u0627 \\u0647\\u0645\\u06cc\\u0634\\u0647 \\u0647\\u0645\\u0647 \\u0686\\u06cc\\u0632 \\u0631\\u0627 \\u0628\\u0627 \\u062c\\u0632\\u0626\\u06cc\\u0627\\u062a \\u062a\\u0648\\u0636\\u06cc\\u062d \\u0645\\u06cc\\u200c\\u062f\\u0647\\u0646\\u062f \\u0648 \\u0645\\u0646 \\u0647\\u0631 \\u0628\\u0627\\u0631 \\u0628\\u0627 \\u0644\\u0628\\u062e\\u0646\\u062f \\u0622\\u0646\\u062c\\u0627 \\u0631\\u0627 \\u062a\\u0631\\u06a9 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0645!\\\"\"},{\"_id\":\"2fd1679\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img8.jpg\",\"id\":223,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u062f\\u0627\\u0646\\u06cc\\u0627\\u0644 \\u0628\\u06cc\\u06af\\u06cc\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u062a\\u062c\\u0631\\u0628\\u0647 \\u0645\\u0646 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0641\\u0648\\u0642\\u200c\\u0627\\u0644\\u0639\\u0627\\u062f\\u0647 \\u0628\\u0648\\u062f\\u0647 \\u0627\\u0633\\u062a! \\u06a9\\u0627\\u0631\\u06a9\\u0646\\u0627\\u0646 \\u062e\\u0648\\u0634\\u200c\\u0628\\u0631\\u062e\\u0648\\u0631\\u062f \\u0647\\u0633\\u062a\\u0646\\u062f\\u060c \\u0645\\u0637\\u0628 \\u0628\\u06cc\\u200c\\u0639\\u06cc\\u0628 \\u0648 \\u0646\\u0642\\u0635 \\u0627\\u0633\\u062a \\u0648 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627 \\u062f\\u0631\\u062c\\u0647 \\u06cc\\u06a9 \\u0647\\u0633\\u062a\\u0646\\u062f. \\u0645\\u0646 \\u0647\\u0645\\u06cc\\u0634\\u0647 \\u0627\\u062d\\u0633\\u0627\\u0633 \\u0622\\u0631\\u0627\\u0645\\u0634 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0645 \\u0648 \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc\\u0645 \\u0647\\u0631\\u06af\\u0632 \\u0628\\u0647\\u062a\\u0631 \\u0627\\u0632 \\u0627\\u06cc\\u0646 \\u0628\\u0647 \\u0646\\u0638\\u0631 \\u0646\\u0631\\u0633\\u06cc\\u062f\\u0647\\u200c\\u0627\\u0646\\u062f!\\\"\"},{\"_id\":\"018e3c6\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img9.jpg\",\"id\":224,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0633\\u0627\\u0645\\u0627\\u0646 \\u0628\\u06cc\\u0631\\u0627\\u0645\\u06cc\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0627\\u0632 \\u0647\\u0645\\u0627\\u0646 \\u0644\\u062d\\u0638\\u0647 \\u0648\\u0631\\u0648\\u062f\\u060c \\u0627\\u062d\\u0633\\u0627\\u0633 \\u0631\\u0627\\u062d\\u062a\\u06cc \\u06a9\\u0631\\u062f\\u0645. \\u06a9\\u0627\\u0631\\u06a9\\u0646\\u0627\\u0646 \\u0637\\u0648\\u0631\\u06cc \\u0631\\u0641\\u062a\\u0627\\u0631 \\u06a9\\u0631\\u062f\\u0646\\u062f \\u06a9\\u0647 \\u0627\\u062d\\u0633\\u0627\\u0633 \\u06a9\\u0646\\u0645 \\u0645\\u062b\\u0644 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647\\u200c\\u0627\\u0645 \\u0647\\u0633\\u062a\\u0645 \\u0648 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u06cc \\u06a9\\u0647 \\u062f\\u0631\\u06cc\\u0627\\u0641\\u062a \\u06a9\\u0631\\u062f\\u0645 \\u0627\\u0633\\u062a\\u062b\\u0646\\u0627\\u06cc\\u06cc \\u0628\\u0648\\u062f. \\u0627\\u0632 \\u0644\\u0628\\u062e\\u0646\\u062f\\u0645 \\u062e\\u06cc\\u0644\\u06cc \\u0631\\u0627\\u0636\\u06cc \\u0647\\u0633\\u062a\\u0645. \\u0628\\u0627\\u0628\\u062a \\u0647\\u0645\\u0647 \\u0686\\u06cc\\u0632 \\u0645\\u0645\\u0646\\u0648\\u0646\\u0645!\\\"\"}],\"col_xxl\":\"5\",\"center\":\"true\",\"pagination\":\"true\",\"infinite\":\"true\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"600\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"-240\",\"bottom\":\"0\",\"left\":\"-240\",\"isLinked\":false},\"col_md\":\"2\",\"_margin_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_testimonial_carousel\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"d1c1cbb\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":30,\"column\":\"30\",\"row\":\"30\",\"isLinked\":true},\"flex_align_items\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#4A7CD2\",\"padding\":{\"unit\":\"px\",\"top\":\"50\",\"right\":\"15\",\"bottom\":\"50\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"8418409\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":60},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"0d1c6c2\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0622\\u0645\\u0627\\u062f\\u0647 \\u0631\\u0632\\u0631\\u0648 \\u0646\\u0648\\u0628\\u062a \\u062e\\u0648\\u062f \\u0647\\u0633\\u062a\\u06cc\\u062f\\u061f\",\"title_color\":\"#FFFFFF\",\"title_typography_typography\":\"custom\",\"title_typography_font_size\":{\"unit\":\"px\",\"size\":32,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"3cf7c4b\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0647\\u0645\\u06cc\\u0646 \\u0627\\u0645\\u0631\\u0648\\u0632 \\u0628\\u0627 \\u0645\\u0627 \\u062a\\u0645\\u0627\\u0633 \\u0628\\u06af\\u06cc\\u0631\\u06cc\\u062f \\u062a\\u0627 \\u0648\\u0642\\u062a \\u0645\\u0644\\u0627\\u0642\\u0627\\u062a \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0631\\u0632\\u0631\\u0648 \\u06a9\\u0646\\u06cc\\u062f \\u0648 \\u0627\\u0648\\u0644\\u06cc\\u0646 \\u0642\\u062f\\u0645 \\u0631\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u062f\\u0627\\u0634\\u062a\\u0646 \\u0644\\u0628\\u062e\\u0646\\u062f\\u06cc \\u0633\\u0627\\u0644\\u0645\\u200c\\u062a\\u0631 \\u0628\\u0631\\u062f\\u0627\\u0631\\u06cc\\u062f.<\\/p>\",\"text_color\":\"#FFFFFF99\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"97ded05\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":40},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"b7a7381\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0631\\u0632\\u0631\\u0648 \\u0646\\u0648\\u0628\\u062a\",\"align\":\"left\",\"border_type\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"border_color\":\"#FFFFFF80\",\"border_color_hover\":\"#10244B\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/booking\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"}},\"elements\":[],\"widgetType\":\"pxl_button\"}],\"isInner\":true}],\"isInner\":false}]\";s:10:\"_edit_lock\";s:12:\"1758147530:1\";s:10:\"_edit_last\";s:1:\"1\";s:22:\"_elementor_page_assets\";a:2:{s:7:\"scripts\";a:14:{i:0;s:18:\"elementor-frontend\";i:1;s:6:\"swiper\";i:2;s:19:\"elementor-waypoints\";i:3;s:16:\"jquery-numerator\";i:4;s:11:\"pxl-counter\";i:5;s:14:\"dentia-counter\";i:6;s:4:\"tilt\";i:7;s:12:\"pxl-tweenmax\";i:8;s:17:\"pxl-counter-slide\";i:9;s:12:\"imagesloaded\";i:10;s:7:\"isotope\";i:11;s:13:\"pxl-post-grid\";i:12;s:16:\"dentia-accordion\";i:13;s:10:\"pxl-swiper\";}s:6:\"styles\";a:2:{i:0;s:20:\"e-animation-fadeInUp\";i:1;s:8:\"e-swiper\";}}s:14:\"_elementor_css\";a:6:{s:4:\"time\";i:1758109738;s:5:\"fonts\";a:0:{}s:5:\"icons\";a:2:{i:0;s:0:\"\";i:1;s:8:\"fa-solid\";}s:20:\"dynamic_elements_ids\";a:0:{}s:6:\"status\";s:4:\"file\";i:0;s:0:\"\";}s:24:\"_elementor_element_cache\";s:90303:\"{\"timeout\":1758208738,\"value\":{\"content\":\"<div class=\\\"elementor-element elementor-element-5161d23 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"5161d23\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;slideshow&quot;,&quot;background_slideshow_gallery&quot;:[{&quot;id&quot;:1485,&quot;url&quot;:&quot;https:\\\\\\/\\\\\\/dentia.sunthemes.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/2025\\\\\\/08\\\\\\/1-min-e1758004018967.jpg&quot;},{&quot;id&quot;:1486,&quot;url&quot;:&quot;https:\\\\\\/\\\\\\/dentia.sunthemes.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/2025\\\\\\/08\\\\\\/2-min-e1758004028449.jpg&quot;}],&quot;background_slideshow_lazyload&quot;:&quot;yes&quot;,&quot;background_slideshow_slide_transition&quot;:&quot;slide_right&quot;,&quot;background_slideshow_loop&quot;:&quot;yes&quot;,&quot;background_slideshow_slide_duration&quot;:5000,&quot;background_slideshow_transition_duration&quot;:500}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-0b31933 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"0b31933\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"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\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImMxNjJkYzciLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0IjoiXHUwNjMxXHUwNjMyXHUwNjMxXHUwNjQ4IFx1MDY0Nlx1MDY0OFx1MDYyOFx1MDYyYSIsImxpbmsiOnsidXJsIjoiaHR0cHM6XC9cL2RlbnRpYS5zdW50aGVtZXMuaXJcL2Jvb2tpbmdcLyIsImlzX2V4dGVybmFsIjoiIiwibm9mb2xsb3ciOiIiLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9LCJidG5fYmdfY29sb3IiOiIjMDIwMTAxMDAiLCJib3JkZXJfdHlwZSI6InNvbGlkIiwiYm9yZGVyX3dpZHRoIjp7InVuaXQiOiJweCIsInRvcCI6IjEiLCJyaWdodCI6IjEiLCJib3R0b20iOiIxIiwibGVmdCI6IjEiLCJpc0xpbmtlZCI6dHJ1ZX0sImJvcmRlcl9jb2xvciI6IiNGRkZGRkYiLCJjb2xvcl9ob3ZlciI6IiNGRkZGRkYiLCJidG5fYmdfY29sb3JfaG92ZXIiOiIjMDAwQTVCIiwiYnRuX2JnX2NvbG9yX2FjdGl2ZSI6IiMwMDBBNUIiLCJidG5fYmdfY29sb3JfZm9jdXMiOiIjMDAwQTVCIiwiYm9yZGVyX2NvbG9yX2hvdmVyIjoiIzAwMEE1QiIsIl9tYXJnaW4iOnsidW5pdCI6InB4IiwidG9wIjoiMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjMwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9LCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNTAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9idXR0b24ifQ==\\\"]<div class=\\\"elementor-element elementor-element-9d1bee4 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none elementor-invisible e-con e-child \\\" data-id=\\\"9d1bee4\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;animation&quot;:&quot;fadeInUp&quot;,&quot;animation_delay&quot;:600}\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImFjNmI2Y2YiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGRpdiBjbGFzcz1cIm1lLTNcIj5cdTA2MzFcdTA2MmFcdTA2MjhcdTA2NDdcdTIwMGNcdTA2MjhcdTA2NDZcdTA2MmZcdTA2Y2MgXHUwNmFmXHUwNjQ4XHUwNmFmXHUwNjQ0PFwvZGl2PiIsInRleHRfY29sb3IiOiIjRjhGOUZBIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjA1YjM1Y2YiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGRpdiBjbGFzcz1cIm1lLTNcIj48ZGl2IGNsYXNzPVwibWUtM1wiPjUuMDxcL2Rpdj48XC9kaXY+IiwidGV4dF9jb2xvciI6IiNGOEY5RkEifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX3RleHRfZWRpdG9yIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImJkNTEzYmYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpY29ucyI6W3siX2lkIjoiZTFlZjdiYyIsInB4bF9pY29uIjp7InZhbHVlIjoiZmFzIGZhLXN0YXIiLCJsaWJyYXJ5IjoiZmEtc29saWQifX0seyJweGxfaWNvbiI6eyJ2YWx1ZSI6ImZhcyBmYS1zdGFyIiwibGlicmFyeSI6ImZhLXNvbGlkIn0sIl9pZCI6IjFmYmYxNGUifSx7InB4bF9pY29uIjp7InZhbHVlIjoiZmFzIGZhLXN0YXIiLCJsaWJyYXJ5IjoiZmEtc29saWQifSwiX2lkIjoiOThlZDc3ZCJ9LHsicHhsX2ljb24iOnsidmFsdWUiOiJmYXMgZmEtc3RhciIsImxpYnJhcnkiOiJmYS1zb2xpZCJ9LCJfaWQiOiIxNjg1YTdiIn0seyJweGxfaWNvbiI6eyJ2YWx1ZSI6ImZhcyBmYS1zdGFyIiwibGlicmFyeSI6ImZhLXNvbGlkIn0sIl9pZCI6IjY3YWE1NzMifV0sImNvbG9yIjoiI0ZFQzQyQyIsImljb25fZm9udF9zaXplIjp7InVuaXQiOiJweCIsInNpemUiOjE1LCJzaXplcyI6W119LCJpY29uX3NwYWNlIjp7InVuaXQiOiJweCIsInNpemUiOjIsInNpemVzIjpbXX19LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfaWNvbiJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjY1MzE3MDMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGRpdiBjbGFzcz1cIm1lLTNcIj48ZGl2IGNsYXNzPVwibWUtM1wiPjxkaXYgY2xhc3M9XCJtZS0zXCI+XHUwNjI4XHUwNjMxIFx1MDYyN1x1MDYzM1x1MDYyN1x1MDYzMyBcdTA2ZjJcdTA2ZjMgXHUwNjQ3XHUwNjMyXHUwNjI3XHUwNjMxIFx1MDY0Nlx1MDY0Mlx1MDYyZiBcdTA2NDggXHUwNjI4XHUwNjMxXHUwNjMxXHUwNjMzXHUwNmNjPFwvZGl2PjxcL2Rpdj48XC9kaXY+IiwidGV4dF9jb2xvciI6IiNGOEY5RkEifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX3RleHRfZWRpdG9yIn0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-af13e9f e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"af13e9f\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-f6f14ff e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"f6f14ff\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-2f08b27 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"2f08b27\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjM2MjdjMGEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIyIiwicHhsX2ljb24iOnsidmFsdWUiOiJmYXMgZmEtcGhvbmUtYWx0IiwibGlicmFyeSI6ImZhLXNvbGlkIn0sInRpdGxlIjoiXHUwNjI4XHUwNjQ3IFx1MDYyZVx1MDYyZlx1MDY0NVx1MDYyN1x1MDYyYSBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDZcdTA2N2VcdTA2MzJcdTA2MzRcdTA2YTlcdTA2Y2MgXHUwNjQ2XHUwNmNjXHUwNjI3XHUwNjMyIFx1MDYyZlx1MDYyN1x1MDYzMVx1MDZjY1x1MDYyZlx1MDYxZiIsImRlc2MiOiJcdTA2MmFcdTA2NDVcdTA2MjdcdTA2MzM6IDAyMTEyMzQ1Njc4OSIsInRpdGxlX2NvbG9yIjoiI0ZGRkZGRiIsImljb25fZm9udF9zaXplIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX2hlaWdodCI6eyJ1bml0IjoicHgiLCJzaXplIjo2MCwic2l6ZXMiOltdfSwiZGVzY19jb2xvciI6IiNGRkZGRkY5OSIsImljb25fY29sb3IiOiIjNEE3REMyIiwiaWNvbl9iZ19jb2xvciI6IiMwMjAxMDEwMCIsInRpdGxlX2JvdHRvbSI6eyJ1bml0IjoicHgiLCJzaXplIjowLCJzaXplcyI6W119LCJpbm5lcl9zcGFjZSI6eyJ1bml0IjoicHgiLCJzaXplIjoxNSwic2l6ZXMiOltdfSwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIzMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9fSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ljb25fYm94In0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-4a79de0 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"4a79de0\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-91829d8 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"91829d8\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImI2MzgzYzQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIyIiwicHhsX2ljb24iOnsidmFsdWUiOiJmYXMgZmEtY2xvY2siLCJsaWJyYXJ5IjoiZmEtc29saWQifSwidGl0bGUiOiJcdTA2MzNcdTA2MjdcdTA2MzlcdTA2MjdcdTA2MmEgXHUwNmE5XHUwNjI3XHUwNjMxXHUwNmNjIiwiZGVzYyI6Ilx1MDY0N1x1MDYzMSBcdTA2MzFcdTA2NDhcdTA2MzIgXHUwNjI3XHUwNjMyIDA4OjAwIFx1MDYyYVx1MDYyNyAyMDowMCIsInRpdGxlX2NvbG9yIjoiI0ZGRkZGRiIsImljb25fZm9udF9zaXplIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX2hlaWdodCI6eyJ1bml0IjoicHgiLCJzaXplIjo2MCwic2l6ZXMiOltdfSwiZGVzY19jb2xvciI6IiNGRkZGRkY5OSIsImljb25fY29sb3IiOiIjNEE3REMyIiwiaWNvbl9iZ19jb2xvciI6IiMwMjAxMDEwMCIsInRpdGxlX2JvdHRvbSI6eyJ1bml0IjoicHgiLCJzaXplIjowLCJzaXplcyI6W119LCJpbm5lcl9zcGFjZSI6eyJ1bml0IjoicHgiLCJzaXplIjoxNSwic2l6ZXMiOltdfSwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIzMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9LCJfZWxlbWVudF93aWR0aF9tb2JpbGUiOiJpbmhlcml0In0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9pY29uX2JveCJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-6a5100f e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"6a5100f\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-4eaeb3c e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"4eaeb3c\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImZmMzhkNmQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIyIiwicHhsX2ljb24iOnsidmFsdWUiOiJmYXMgZmEtZW52ZWxvcGUiLCJsaWJyYXJ5IjoiZmEtc29saWQifSwidGl0bGUiOiJcdTA2MjdcdTA2Y2NcdTA2NDVcdTA2Y2NcdTA2NDQgXHUwNjQ1XHUwNjI3IiwiZGVzYyI6ImNvbnRhY3RAZGVudGlhY2xpbmljLmNvbSIsInRpdGxlX2NvbG9yIjoiI0ZGRkZGRiIsImljb25fZm9udF9zaXplIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX2hlaWdodCI6eyJ1bml0IjoicHgiLCJzaXplIjo2MCwic2l6ZXMiOltdfSwiZGVzY19jb2xvciI6IiNGRkZGRkY5OSIsImljb25fY29sb3IiOiIjNEE3REMyIiwiaWNvbl9iZ19jb2xvciI6IiMwMjAxMDEwMCIsInRpdGxlX2JvdHRvbSI6eyJ1bml0IjoicHgiLCJzaXplIjowLCJzaXplcyI6W119LCJpbm5lcl9zcGFjZSI6eyJ1bml0IjoicHgiLCJzaXplIjoxNSwic2l6ZXMiOltdfSwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIzMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9LCJfZWxlbWVudF93aWR0aF9tb2JpbGUiOiJpbmhlcml0In0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9pY29uX2JveCJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-15b34f8 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"15b34f8\\\" data-element_type=\\\"container\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-98ca70d e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"98ca70d\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-43ff422 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"43ff422\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImI2OThiYjQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2Fib3V0LWltZzEuanBnIiwiaWQiOjQ2Mywic2l6ZSI6IiIsImFsdCI6IiIsInNvdXJjZSI6ImxpYnJhcnkifSwiaW1hZ2VfdHlwZSI6ImJnIiwiaW1hZ2VfaGVpZ2h0Ijp7InVuaXQiOiJweCIsInNpemUiOjM5OSwic2l6ZXMiOltdfSwiYm9yZGVyX3JhZGl1cyI6eyJ1bml0IjoicHgiLCJ0b3AiOiIyMCIsInJpZ2h0IjoiMjAiLCJib3R0b20iOiIyMCIsImxlZnQiOiIyMCIsImlzTGlua2VkIjp0cnVlfSwicGFyYWxsYXhfdmFsdWUiOiI0MCIsIm1heF90aWx0IjoiMTAiLCJzcGVlZF90aWx0IjoiNDAwIiwicGVyc3BlY3RpdmVfdGlsdCI6IjEwMDAiLCJweGxfYW5pbWF0ZSI6IndvdyB6b29tSW5TbWFsbCIsInB4bF9hbmltYXRlX2RlbGF5IjoiMzAwIiwicHhsX2FuaW1hdGVfaW1nIjoid293IHNjYWxlSW4iLCJweGxfYW5pbWF0ZV9pbWdfZGVsYXkiOiIzMDAifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ltYWdlIn0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-4c3a639 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"4c3a639\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjNhMjZlY2QiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2Fib3V0LWltZzIuanBnIiwiaWQiOjQ2NCwic2l6ZSI6IiIsImFsdCI6IiIsInNvdXJjZSI6ImxpYnJhcnkifSwiaW1hZ2VfdHlwZSI6ImJnIiwiaW1hZ2VfaGVpZ2h0Ijp7InVuaXQiOiJweCIsInNpemUiOjM5OSwic2l6ZXMiOltdfSwiYm9yZGVyX3JhZGl1cyI6eyJ1bml0IjoicHgiLCJ0b3AiOiIyMCIsInJpZ2h0IjoiMjAiLCJib3R0b20iOiIyMCIsImxlZnQiOiIyMCIsImlzTGlua2VkIjp0cnVlfSwicGFyYWxsYXhfdmFsdWUiOiI0MCIsIm1heF90aWx0IjoiMTAiLCJzcGVlZF90aWx0IjoiNDAwIiwicGVyc3BlY3RpdmVfdGlsdCI6IjEwMDAiLCJweGxfYW5pbWF0ZSI6IndvdyB6b29tSW5TbWFsbCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNTAwIiwicHhsX2FuaW1hdGVfaW1nIjoid293IHNjYWxlSW4iLCJweGxfYW5pbWF0ZV9pbWdfZGVsYXkiOiI1MDAifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ltYWdlIn0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-9dd8e84 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"9dd8e84\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImIwMjk3YmYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDY0NVx1MDYyYVx1MDYyZVx1MDYzNVx1MDYzNVx1MDYyN1x1MDY0NiBcdTA2NDggXHUwNjJhXHUwNjM5XHUwNjI3XHUwNjQ0XHUwNmNjIFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2MzRcdTA2MmVcdTA2MzVcdTA2Y2MiLCJzdWJfdGl0bGUiOiJcdTA2MmZcdTA2MzFcdTA2MjhcdTA2MjdcdTA2MzFcdTA2NDcgXHUwNjQ1XHUwNjI3IiwiaF93aWR0aCI6eyJ1bml0IjoiJSIsInNpemUiOjgwLCJzaXplcyI6W119LCJoX3dpZHRoX2xhcHRvcCI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJoX3dpZHRoX3RhYmxldF9leHRyYSI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJoX3dpZHRoX3RhYmxldCI6eyJ1bml0IjoiJSIsInNpemUiOjEwMCwic2l6ZXMiOltdfSwiaF93aWR0aF9tb2JpbGVfZXh0cmEiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF9tb2JpbGUiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwidGl0bGVfdGFnIjoiaDIiLCJzdWJfdGl0bGVfc3BhY2VfYm90dG9tIjp7InVuaXQiOiJweCIsInNpemUiOjE3LCJzaXplcyI6W119LCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIyMCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjQwMCIsInB4bF9hbmltYXRlX3N1YiI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5X3N1YiI6IjMwMCIsInRpdGxlX3R5cG9ncmFwaHlfdHlwb2dyYXBoeSI6ImN1c3RvbSIsInRpdGxlX3R5cG9ncmFwaHlfZm9udF9zaXplX21vYmlsZSI6eyJ1bml0IjoicHgiLCJzaXplIjo0NSwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9oZWFkaW5nIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjZiYzg3ZTgiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjQ1XHUwNjI3IFx1MDYyZVx1MDYyZlx1MDY0NVx1MDYyN1x1MDYyYSBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDZcdTA2N2VcdTA2MzJcdTA2MzRcdTA2YTlcdTA2Y2MgXHUwNjI4XHUwNjI3IFx1MDZhOVx1MDZjY1x1MDY0MVx1MDZjY1x1MDYyYSBcdTA2MjhcdTA2MjdcdTA2NDRcdTA2MjcgXHUwNjQ4IFx1MDY0NVx1MDYyYVx1MDY0Nlx1MDYyN1x1MDYzM1x1MDYyOCBcdTA2MjhcdTA2MjcgXHUwNjQ2XHUwNmNjXHUwNjI3XHUwNjMyIFx1MDYyYVx1MDY0NVx1MDYyN1x1MDY0NSBcdTA2MjdcdTA2MzlcdTA2MzZcdTA2MjdcdTA2Y2MgXHUwNjJlXHUwNjI3XHUwNjQ2XHUwNjQ4XHUwNjI3XHUwNjJmXHUwNjQ3IFx1MDYyN1x1MDYzMVx1MDYyN1x1MDYyNlx1MDY0NyBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2MmZcdTA2NDdcdTA2Y2NcdTA2NDUuIFx1MDYyN1x1MDYzMiBcdTA2NDVcdTA2MzlcdTA2MjdcdTA2Y2NcdTA2NDZcdTA2MjdcdTA2MmEgXHUwNjMxXHUwNjQ4XHUwNjJhXHUwNmNjXHUwNjQ2IFx1MDZhZlx1MDYzMVx1MDY0MVx1MDYyYVx1MDY0NyBcdTA2MmFcdTA2MjcgXHUwNjJmXHUwNjMxXHUwNjQ1XHUwNjI3XHUwNjQ2XHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY3ZVx1MDZjY1x1MDYzNFx1MDYzMVx1MDY0MVx1MDYyYVx1MDY0N1x1MDYwYyBcdTA2MmFcdTA2Y2NcdTA2NDUgXHUwNjJmXHUwNjQ0XHUwNjMzXHUwNjQ4XHUwNjMyIFx1MDY0NVx1MDYyNyBcdTA2MmFcdTA2MzZcdTA2NDVcdTA2Y2NcdTA2NDYgXHUwNjQ1XHUwNmNjXHUyMDBjXHUwNmE5XHUwNjQ2XHUwNjJmIFx1MDZhOVx1MDY0NyBcdTA2NDRcdTA2MjhcdTA2MmVcdTA2NDZcdTA2MmYgXHUwNjM0XHUwNjQ1XHUwNjI3IFx1MDYzM1x1MDYyN1x1MDY0NFx1MDY0NSBcdTA2NDggXHUwNjI4XHUwNjI3IFx1MDYyN1x1MDYzOVx1MDYyYVx1MDY0NVx1MDYyN1x1MDYyZiBcdTA2MjhcdTA2NDcgXHUwNjQ2XHUwNjQxXHUwNjMzIFx1MDYyOFx1MDYyN1x1MDY0Mlx1MDZjYyBcdTA2MjhcdTA2NDVcdTA2MjdcdTA2NDZcdTA2MmYuPFwvcD4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNTAwIiwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIwIiwicmlnaHQiOiIwIiwiYm90dG9tIjoiMTciLCJsZWZ0IjoiMCIsImlzTGlua2VkIjpmYWxzZX19LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfdGV4dF9lZGl0b3IifQ==\\\"]<div class=\\\"elementor-element elementor-element-bb0da06 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"bb0da06\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-9028010 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"9028010\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjgyN2NkYzMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsaXN0cyI6W3siX2lkIjoiMjlmZGFjYiIsInB4bF9pY29uIjp7InZhbHVlIjoiZmFzIGZhLWNoZWNrIiwibGlicmFyeSI6ImZhLXNvbGlkIn0sInRleHQiOiJcdTA2MjhcdTA2MzFcdTA2NDZcdTA2MjdcdTA2NDVcdTA2NDdcdTIwMGNcdTA2NDdcdTA2MjdcdTA2Y2MgXHUwNjJmXHUwNjMxXHUwNjQ1XHUwNjI3XHUwNjQ2IFx1MDYzNFx1MDYyZVx1MDYzNVx1MDZjY1x1MjAwY1x1MDYzM1x1MDYyN1x1MDYzMlx1MDZjY1x1MjAwY1x1MDYzNFx1MDYyZlx1MDY0NyJ9LHsicHhsX2ljb24iOnsidmFsdWUiOiJmYXMgZmEtY2hlY2siLCJsaWJyYXJ5IjoiZmEtc29saWQifSwidGV4dCI6Ilx1MDY0NVx1MDYzMVx1MDYyN1x1MDY0Mlx1MDYyOFx1MDYyYSBcdTA2NDVcdTA2NDRcdTA2MjdcdTA2Y2NcdTA2NDUgXHUwNjI4XHUwNjMxXHUwNjI3XHUwNmNjIFx1MDZhOVx1MDY0OFx1MDYyZlx1MDZhOVx1MDYyN1x1MDY0NiBcdTA2NDggXHUwNjI4XHUwNjMyXHUwNjMxXHUwNmFmXHUwNjMzXHUwNjI3XHUwNjQ0XHUwNjI3XHUwNjQ2IiwiX2lkIjoiN2ZmNjQ3NSJ9XSwidGV4dF90eXBvZ3JhcGh5X3R5cG9ncmFwaHkiOiJjdXN0b20iLCJ0ZXh0X3R5cG9ncmFwaHlfZm9udF9zaXplX2xhcHRvcCI6eyJ1bml0IjoicHgiLCJzaXplIjoxNSwic2l6ZXMiOltdfSwiaWNvbl9jb2xvciI6IiM0QTdEQzIiLCJpY29uX3NwYWNlIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAzIiwiYm90dG9tIjoiMCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjYwMCIsImFsaWduX2l0ZW1zIjoic3RhcnQifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2xpc3QifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-6db1ff5 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"6db1ff5\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImZhNjQ5MGUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsaXN0cyI6W3siX2lkIjoiMjlmZGFjYiIsInB4bF9pY29uIjp7InZhbHVlIjoiZmFzIGZhLWNoZWNrIiwibGlicmFyeSI6ImZhLXNvbGlkIn0sInRleHQiOiJcdTA2NDFcdTA2NDZcdTA2MjdcdTA2NDhcdTA2MzFcdTA2Y2MgXHUwNjdlXHUwNmNjXHUwNjM0XHUwNjMxXHUwNjQxXHUwNjJhXHUwNjQ3In0seyJweGxfaWNvbiI6eyJ2YWx1ZSI6ImZhcyBmYS1jaGVjayIsImxpYnJhcnkiOiJmYS1zb2xpZCJ9LCJ0ZXh0IjoiXHUwNjI4XHUwNjMxXHUwNjQ2XHUwNjI3XHUwNjQ1XHUwNjQ3XHUyMDBjXHUwNjMxXHUwNmNjXHUwNjMyXHUwNmNjIFx1MDYyN1x1MDY0Nlx1MDYzOVx1MDYzN1x1MDYyN1x1MDY0MVx1MjAwY1x1MDY3ZVx1MDYzMFx1MDZjY1x1MDYzMSBcdTA2MjhcdTA2MzFcdTA2MjdcdTA2Y2MgXHUwNjQyXHUwNjMxXHUwNjI3XHUwNjMxIFx1MDY0NVx1MDY0NFx1MDYyN1x1MDY0Mlx1MDYyN1x1MDYyYSIsIl9pZCI6IjdmZjY0NzUifV0sInRleHRfdHlwb2dyYXBoeV90eXBvZ3JhcGh5IjoiY3VzdG9tIiwidGV4dF90eXBvZ3JhcGh5X2ZvbnRfc2l6ZV9sYXB0b3AiOnsidW5pdCI6InB4Iiwic2l6ZSI6MTUsInNpemVzIjpbXX0sImljb25fY29sb3IiOiIjNEE3REMyIiwiaWNvbl9zcGFjZSI6eyJ1bml0IjoicHgiLCJ0b3AiOiIwIiwicmlnaHQiOiIwMyIsImJvdHRvbSI6IjAiLCJsZWZ0IjoiMCIsImlzTGlua2VkIjpmYWxzZX0sInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI2MDAiLCJhbGlnbl9pdGVtcyI6InN0YXJ0In0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9saXN0In0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImYzODk3ZDkiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0IjoiXHUwNjMxXHUwNjMyXHUwNjMxXHUwNjQ4IFx1MDY0Nlx1MDY0OFx1MDYyOFx1MDYyYSIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI3MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjI4IiwicmlnaHQiOiIwIiwiYm90dG9tIjoiMCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9idXR0b24ifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-9f68bac e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"9f68bac\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-ac1ac70 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"ac1ac70\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImM3NGEzZWUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDY0NVx1MDYzMVx1MDYyN1x1MDY0Mlx1MDYyOFx1MDYyYSBcdTA2YTlcdTA2MjdcdTA2NDVcdTA2NDQgXHUwNjI4XHUwNjMxXHUwNjI3XHUwNmNjIFx1MDY0N1x1MDYzMSBcdTA2NDRcdTA2MjhcdTA2MmVcdTA2NDZcdTA2MmYiLCJzdWJfdGl0bGUiOiJcdTA2MmVcdTA2MmZcdTA2NDVcdTA2MjdcdTA2MmEgXHUwNjQ1XHUwNjI3IiwiaF93aWR0aCI6eyJ1bml0IjoiJSIsInNpemUiOjgwLCJzaXplcyI6W119LCJoX3dpZHRoX2xhcHRvcCI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJoX3dpZHRoX3RhYmxldF9leHRyYSI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJoX3dpZHRoX3RhYmxldCI6eyJ1bml0IjoiJSIsInNpemUiOjEwMCwic2l6ZXMiOltdfSwiaF93aWR0aF9tb2JpbGVfZXh0cmEiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF9tb2JpbGUiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwidGl0bGVfdGFnIjoiaDIiLCJzdWJfdGl0bGVfc3BhY2VfYm90dG9tIjp7InVuaXQiOiJweCIsInNpemUiOjE3LCJzaXplcyI6W119LCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIyMCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjQwMCIsInB4bF9hbmltYXRlX3N1YiI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5X3N1YiI6IjMwMCIsInRpdGxlX3R5cG9ncmFwaHlfdHlwb2dyYXBoeSI6ImN1c3RvbSIsInRpdGxlX3R5cG9ncmFwaHlfZm9udF9zaXplX21vYmlsZSI6eyJ1bml0IjoicHgiLCJzaXplIjo0NSwic2l6ZXMiOltdfSwiYWxpZ24iOiJjZW50ZXIifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2hlYWRpbmcifQ==\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjcyODQ3ZjkiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjI3XHUwNjMyIFx1MDYyYVx1MDY0NVx1MDZjY1x1MDYzMiBcdTA2YTlcdTA2MzFcdTA2MmZcdTA2NDZcdTIwMGNcdTA2NDdcdTA2MjdcdTA2Y2MgXHUwNjMxXHUwNjQ4XHUwNjJhXHUwNmNjXHUwNjQ2IFx1MDZhZlx1MDYzMVx1MDY0MVx1MDYyYVx1MDY0NyBcdTA2MmFcdTA2MjcgXHUwNjJhXHUwNjMxXHUwNjQ1XHUwNmNjXHUwNjQ1XHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY3ZVx1MDZjY1x1MDYzNFx1MDYzMVx1MDY0MVx1MDYyYVx1MDY0N1x1MDYwYyBcdTA2NDVcdTA2MjcgXHUwNjMxXHUwNjI3XHUwNjQ3XHUyMDBjXHUwNjJkXHUwNjQ0XHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2MzRcdTA2MmVcdTA2MzVcdTA2Y2NcdTIwMGNcdTA2MzNcdTA2MjdcdTA2MzJcdTA2Y2NcdTIwMGNcdTA2MzRcdTA2MmZcdTA2NDcgXHUwNjMxXHUwNjI3IFx1MDYyOFx1MDYzMVx1MDYyN1x1MDZjYyBcdTA2MjhcdTA2Y2NcdTA2NDVcdTA2MjdcdTA2MzFcdTA2MjdcdTA2NDYgXHUwNjJmXHUwNjMxIFx1MDY0N1x1MDYzMSBcdTA2MzNcdTA2NDZcdTA2Y2MgXHUwNjI3XHUwNjMxXHUwNjI3XHUwNjI2XHUwNjQ3IFx1MDY0NVx1MDZjY1x1MjAwY1x1MDYyZlx1MDY0N1x1MDZjY1x1MDY0NS48XC9wPiIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiI0MiIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwiYWxpZ24iOiJjZW50ZXIiLCJ0X3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjU2Mywic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]<div class=\\\"elementor-element elementor-element-7371f8b e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"7371f8b\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-37741dc e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"37741dc\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-5855528 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"5855528\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImZmMjgxZmEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIzIiwiaWNvbl90eXBlIjoiaW1hZ2UiLCJpY29uX2ltYWdlIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC93cC1jb250ZW50XC91cGxvYWRzXC8yMDI1XC8wOFwvdG9vdGgtMS5wbmciLCJpZCI6NjI2LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJ0aXRsZSI6Ilx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2MzlcdTA2NDVcdTA2NDhcdTA2NDVcdTA2Y2MiLCJkZXNjIjoiXHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhIFx1MDZhOVx1MDYyN1x1MDY0NVx1MDY0NCBcdTA2MmZcdTA2NDdcdTA2MjdcdTA2NDYgXHUwNjQ4IFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0NiBcdTA2MjhcdTA2MzFcdTA2MjdcdTA2Y2MgXHUwNjQ3XHUwNjMxIFx1MDY0NFx1MDYyOFx1MDYyZVx1MDY0Nlx1MDYyZlx1MDZjYyBcdTA2MjhcdTA2MjcgXHUwNjJjXHUwNjMxXHUwNjQ1XHUyMDBjXHUwNmFmXHUwNmNjXHUwNjMxXHUwNmNjXHUwNjBjIFx1MDY0NVx1MDYzOVx1MDYyN1x1MDZjY1x1MDY0Nlx1MDY0NyBcdTA2NDggXHUwNjQ1XHUwNjQ4XHUwNjI3XHUwNjMxXHUwNjJmIFx1MDYyZlx1MDZjY1x1MDZhZlx1MDYzMS4iLCJsaW5rIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC9zZXJ2aWNlXC9nZW5lcmFsLWRlbnRpc3RyeVwvIiwiaXNfZXh0ZXJuYWwiOiIiLCJub2ZvbGxvdyI6IiIsImN1c3RvbV9hdHRyaWJ1dGVzIjoiIn0sInRpdGxlX2J0biI6Ilx1MDYyN1x1MDYzN1x1MDY0NFx1MDYyN1x1MDYzOVx1MDYyN1x1MDYyYSBcdTA2MjhcdTA2Y2NcdTA2MzRcdTA2MmFcdTA2MzEiLCJweGxfYW5pbWF0ZSI6IndvdyBzY2FsZUluIiwicHhsX2FuaW1hdGVfZGVsYXkiOiIzMDAiLCJweGxfYW5pbWF0ZTIiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheTIiOiI1MDAiLCJ0aXRsZV9jb2xvciI6IiMxMDI0NEIiLCJiYWNrZ3JvdW5kX2NvbG9yIjoiI0ZGRkZGRiJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfaWNvbl9ib3gifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-62a7ae9 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"62a7ae9\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImM4ODAwODEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIzIiwiaWNvbl90eXBlIjoiaW1hZ2UiLCJpY29uX2ltYWdlIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC93cC1jb250ZW50XC91cGxvYWRzXC8yMDI1XC8wOFwvdG9vdGgtMi5wbmciLCJpZCI6NjI3LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJ0aXRsZSI6Ilx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOSBcdTA2MzJcdTA2Y2NcdTA2MjhcdTA2MjdcdTA2Y2NcdTA2Y2MiLCJkZXNjIjoiXHUwNjMyXHUwNmNjXHUwNjI4XHUwNjI3XHUwNmNjXHUwNmNjIFx1MDY0NFx1MDYyOFx1MDYyZVx1MDY0Nlx1MDYyZiBcdTA2MmVcdTA2NDhcdTA2MmYgXHUwNjMxXHUwNjI3IFx1MDYyOFx1MDYyNyBcdTA2MzNcdTA2NDFcdTA2Y2NcdTA2MmYgXHUwNmE5XHUwNjMxXHUwNjJmXHUwNjQ2IFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDYwYyBcdTA2NDhcdTA2NDZcdTA2Y2NcdTA2MzFcdTA2NDdcdTA2MjcgXHUwNjQ4IFx1MDY0NVx1MDY0OFx1MDYyN1x1MDYzMVx1MDYyZiBcdTA2MmZcdTA2Y2NcdTA2YWZcdTA2MzEgXHUwNjI3XHUwNjQxXHUwNjMyXHUwNjI3XHUwNmNjXHUwNjM0IFx1MDYyZlx1MDY0N1x1MDZjY1x1MDYyZi4iLCJsaW5rIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC9zZXJ2aWNlXC9jb3NtZXRpYy1kZW50aXN0cnlcLyIsImlzX2V4dGVybmFsIjoiIiwibm9mb2xsb3ciOiIiLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9LCJ0aXRsZV9idG4iOiJcdTA2MjdcdTA2MzdcdTA2NDRcdTA2MjdcdTA2MzlcdTA2MjdcdTA2MmEgXHUwNjI4XHUwNmNjXHUwNjM0XHUwNjJhXHUwNjMxIiwicHhsX2FuaW1hdGUiOiJ3b3cgc2NhbGVJbiIsInB4bF9hbmltYXRlX2RlbGF5IjoiMzAwIiwicHhsX2FuaW1hdGUyIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkyIjoiNTAwIiwidGl0bGVfY29sb3IiOiIjMTAyNDRCIiwiYmFja2dyb3VuZF9jb2xvciI6IiNGRkZGRkYifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ljb25fYm94In0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-964d2d6 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"964d2d6\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjMzNmJmNmYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIzIiwiaWNvbl90eXBlIjoiaW1hZ2UiLCJpY29uX2ltYWdlIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC93cC1jb250ZW50XC91cGxvYWRzXC8yMDI1XC8wOFwvdG9vdGgtMy5wbmciLCJpZCI6NjI4LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJ0aXRsZSI6Ilx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2YTlcdTA2NDhcdTA2MmZcdTA2YTlcdTA2MjdcdTA2NDYiLCJkZXNjIjoiXHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhXHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY0NVx1MDY0NFx1MDYyN1x1MDZjY1x1MDY0NSBcdTA2NDggXHUwNjMzXHUwNjMxXHUwNmFmXHUwNjMxXHUwNjQ1XHUyMDBjXHUwNmE5XHUwNjQ2XHUwNjQ2XHUwNjJmXHUwNjQ3IFx1MDYyN1x1MDYzMiBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDZcdTIwMGNcdTA2NDdcdTA2MjcgXHUwNjI4XHUwNjMxXHUwNjI3XHUwNmNjIFx1MDZhOVx1MDY0OFx1MDYyZlx1MDZhOVx1MDYyN1x1MDY0NiBcdTA2MmFcdTA2MjcgXHUwNjQ0XHUwNjI4XHUwNjJlXHUwNjQ2XHUwNjJmXHUwNmNjIFx1MDYzM1x1MDYyN1x1MDY0NFx1MDY0NSBcdTA2NDggXHUwNjM0XHUwNjI3XHUwNjJmIFx1MDYyZlx1MDYyN1x1MDYzNFx1MDYyYVx1MDY0NyBcdTA2MjhcdTA2MjdcdTA2MzRcdTA2NDZcdTA2MmYuIiwibGluayI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvc2VydmljZVwvcGVkaWF0cmljLWRlbnRpc3RyeVwvIiwiaXNfZXh0ZXJuYWwiOiIiLCJub2ZvbGxvdyI6IiIsImN1c3RvbV9hdHRyaWJ1dGVzIjoiIn0sInRpdGxlX2J0biI6Ilx1MDYyN1x1MDYzN1x1MDY0NFx1MDYyN1x1MDYzOVx1MDYyN1x1MDYyYSBcdTA2MjhcdTA2Y2NcdTA2MzRcdTA2MmFcdTA2MzEiLCJweGxfYW5pbWF0ZSI6IndvdyBzY2FsZUluIiwicHhsX2FuaW1hdGVfZGVsYXkiOiIzMDAiLCJweGxfYW5pbWF0ZTIiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheTIiOiI1MDAiLCJ0aXRsZV9jb2xvciI6IiMxMDI0NEIiLCJiYWNrZ3JvdW5kX2NvbG9yIjoiI0ZGRkZGRiJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfaWNvbl9ib3gifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-2e4cbee e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"2e4cbee\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjIwMjkyMzMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIzIiwiaWNvbl90eXBlIjoiaW1hZ2UiLCJpY29uX2ltYWdlIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC93cC1jb250ZW50XC91cGxvYWRzXC8yMDI1XC8wOFwvdG9vdGgtNC5wbmciLCJpZCI6NjI5LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJ0aXRsZSI6Ilx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2MmFcdTA2MzFcdTA2NDVcdTA2Y2NcdTA2NDVcdTA2Y2MiLCJkZXNjIjoiXHUwNjJmXHUwNjQ2XHUwNjJmXHUwNjI3XHUwNjQ2XHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDYzNFx1MDY0NVx1MDYyNyBcdTA2MzFcdTA2MjcgXHUwNjI4XHUwNjMxXHUwNjI3XHUwNmNjIFx1MDYzMVx1MDYyN1x1MDYyZFx1MDYyYVx1MDZjYyBcdTA2NDggXHUwNjM5XHUwNjQ1XHUwNjQ0XHUwNmE5XHUwNjMxXHUwNjJmIFx1MDY3ZVx1MDYyN1x1MDZjY1x1MDYyZlx1MDYyN1x1MDYzMSBcdTA2MmFcdTA2MzFcdTA2NDVcdTA2Y2NcdTA2NDUgXHUwNjQ4IFx1MDYyOFx1MDYyN1x1MDYzMlx1MDYzM1x1MDYyN1x1MDYzMlx1MDZjYyBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2YTlcdTA2NDZcdTA2MmYuXG4iLCJsaW5rIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC9zZXJ2aWNlXC9yZXN0b3JhdGl2ZS1kZW50aXN0cnlcLyIsImlzX2V4dGVybmFsIjoiIiwibm9mb2xsb3ciOiIiLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9LCJ0aXRsZV9idG4iOiJcdTA2MjdcdTA2MzdcdTA2NDRcdTA2MjdcdTA2MzlcdTA2MjdcdTA2MmEgXHUwNjI4XHUwNmNjXHUwNjM0XHUwNjJhXHUwNjMxIiwicHhsX2FuaW1hdGUiOiJ3b3cgc2NhbGVJbiIsInB4bF9hbmltYXRlX2RlbGF5IjoiMzAwIiwicHhsX2FuaW1hdGUyIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkyIjoiNTAwIiwidGl0bGVfY29sb3IiOiIjMTAyNDRCIiwiYmFja2dyb3VuZF9jb2xvciI6IiNGRkZGRkYifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ljb25fYm94In0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImU3MTQxM2EiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0IjoiXHUwNjQ1XHUwNjM0XHUwNjI3XHUwNjQ3XHUwNjJmXHUwNjQ3IFx1MDY0N1x1MDY0NVx1MDY0NyBcdTA2MmVcdTA2MmZcdTA2NDVcdTA2MjdcdTA2MmEiLCJsaW5rIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC9hbGwtc2VydmljZXNcLyIsImlzX2V4dGVybmFsIjoiIiwibm9mb2xsb3ciOiIiLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9LCJhbGlnbiI6ImNlbnRlciIsIl9tYXJnaW4iOnsidW5pdCI6InB4IiwidG9wIjoiNDgiLCJyaWdodCI6IjAiLCJib3R0b20iOiIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9fSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2J1dHRvbiJ9\\\"]\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-b92d7a4 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"b92d7a4\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-d408d83 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"d408d83\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImMwOGY2NzYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYyOFx1MDZjY1x1MDY0NVx1MDYyN1x1MDYzMVx1MDYyN1x1MDY0NiBcdTA2MzRcdTA2MjdcdTA2MmYiLCJzdGFydGluZ19udW1iZXIiOjUwMDAsImVuZGluZ19udW1iZXIiOjEwMDAwLCJzdWZmaXgiOiIrIiwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluUmlnaHQiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjMwMCJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfY291bnRlciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-3ffca2e e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"3ffca2e\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjE3ZjMwMTUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYzM1x1MDY0MVx1MDZjY1x1MDYyZiBcdTA2YTlcdTA2MzFcdTA2MmZcdTA2NDYgXHUwNjJmXHUwNjQ2XHUwNjJmXHUwNjI3XHUwNjQ2Iiwic3RhcnRpbmdfbnVtYmVyIjoyMDAwLCJlbmRpbmdfbnVtYmVyIjoyNTAwLCJzdWZmaXgiOiIrIiwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluUmlnaHQiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjQwMCJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfY291bnRlciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-5163797 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"5163797\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjM0NDQ3MmYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYyN1x1MDZjY1x1MDY0NVx1MDY3ZVx1MDY0NFx1MDY0Nlx1MDYyYSBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDYiLCJzdGFydGluZ19udW1iZXIiOjUwMCwiZW5kaW5nX251bWJlciI6ODAwLCJzdWZmaXgiOiIrIiwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluUmlnaHQiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjUwMCJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfY291bnRlciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-7ac7412 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"7ac7412\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjYyZDY3MmQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYzM1x1MDYyN1x1MDY0NCBcdTA2MmFcdTA2MmNcdTA2MzFcdTA2MjhcdTA2NDciLCJlbmRpbmdfbnVtYmVyIjoxNSwic3VmZml4IjoiKyIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblJpZ2h0IiwicHhsX2FuaW1hdGVfZGVsYXkiOiI2MDAifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2NvdW50ZXIifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-fc38de1 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"fc38de1\\\" data-element_type=\\\"container\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-931cd86 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"931cd86\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImM3ODU3ZGUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYyZVx1MDYyZlx1MDY0NVx1MDYyN1x1MDYyYSBcdTA2MjdcdTA2MzNcdTA2MmFcdTA2MmJcdTA2NDZcdTA2MjdcdTA2Y2NcdTA2Y2MgXHUwNjI4XHUwNjI3IFx1MDYzMVx1MDY0OFx1MDZjY1x1MDZhOVx1MDYzMVx1MDYyZlx1MDZjYyBcdTA2MzRcdTA2MmVcdTA2MzVcdTA2Y2MiLCJzdWJfdGl0bGUiOiJcdTA2ODZcdTA2MzFcdTA2MjcgXHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhXHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2NDVcdTA2MjcgXHUwNjMxXHUwNjI3IFx1MDYyN1x1MDY0Nlx1MDYyYVx1MDYyZVx1MDYyN1x1MDYyOCBcdTA2YTlcdTA2NDZcdTA2Y2NcdTA2MmYiLCJoX3dpZHRoIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sImhfd2lkdGhfbGFwdG9wIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sImhfd2lkdGhfdGFibGV0X2V4dHJhIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sImhfd2lkdGhfdGFibGV0Ijp7InVuaXQiOiIlIiwic2l6ZSI6MTAwLCJzaXplcyI6W119LCJoX3dpZHRoX21vYmlsZV9leHRyYSI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJoX3dpZHRoX21vYmlsZSI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJ0aXRsZV90YWciOiJoMiIsInN1Yl90aXRsZV9zcGFjZV9ib3R0b20iOnsidW5pdCI6InB4Iiwic2l6ZSI6MTcsInNpemVzIjpbXX0sIl9tYXJnaW4iOnsidW5pdCI6InB4IiwidG9wIjoiMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9LCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNDAwIiwicHhsX2FuaW1hdGVfc3ViIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXlfc3ViIjoiMzAwIiwidGl0bGVfdHlwb2dyYXBoeV90eXBvZ3JhcGh5IjoiY3VzdG9tIiwidGl0bGVfdHlwb2dyYXBoeV9mb250X3NpemVfbW9iaWxlIjp7InVuaXQiOiJweCIsInNpemUiOjQ1LCJzaXplcyI6W119fSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2hlYWRpbmcifQ==\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjYwMmVhOTMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjI3XHUwNjQ2XHUwNjJhXHUwNjJlXHUwNjI3XHUwNjI4IFx1MDYyN1x1MDYzMVx1MDYyN1x1MDYyNlx1MDY0NyBcdTA2MmZcdTA2NDdcdTA2NDZcdTA2MmZcdTA2NDcgXHUwNjJlXHUwNjJmXHUwNjQ1XHUwNjI3XHUwNjJhIFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2NDVcdTA2NDZcdTA2MjdcdTA2MzNcdTA2MjggXHUwNjI3XHUwNjQ3XHUwNjQ1XHUwNmNjXHUwNjJhIFx1MDYyZlx1MDYyN1x1MDYzMVx1MDYyZi4gXHUwNjQ1XHUwNjI3IFx1MDY0NVx1MDYzMVx1MDYyN1x1MDY0Mlx1MDYyOFx1MDYyYVx1MjAwY1x1MDY0N1x1MDYyN1x1MDZjYyBcdTA2MmFcdTA2MmVcdTA2MzVcdTA2MzVcdTA2Y2NcdTA2MGMgXHUwNjQxXHUwNjQ2XHUwNjI3XHUwNjQ4XHUwNjMxXHUwNmNjIFx1MDY3ZVx1MDZjY1x1MDYzNFx1MDYzMVx1MDY0MVx1MDYyYVx1MDY0NyBcdTA2NDggXHUwNjQxXHUwNjM2XHUwNjI3XHUwNmNjXHUwNmNjIFx1MDZhZlx1MDYzMVx1MDY0NSBcdTA2MzFcdTA2MjcgXHUwNjI4XHUwNjI3IFx1MDY0N1x1MDY0NSBcdTA2MmFcdTA2MzFcdTA2YTlcdTA2Y2NcdTA2MjggXHUwNjQ1XHUwNmNjXHUyMDBjXHUwNmE5XHUwNjQ2XHUwNmNjXHUwNjQ1IFx1MDYyYVx1MDYyNyBcdTA2MjdcdTA2MzdcdTA2NDVcdTA2Y2NcdTA2NDZcdTA2MjdcdTA2NDYgXHUwNjJkXHUwNjI3XHUwNjM1XHUwNjQ0IFx1MDZhOVx1MDY0Nlx1MDZjY1x1MDY0NSBcdTA2YTlcdTA2NDcgXHUwNjQ3XHUwNjMxIFx1MDY0OFx1MDZjY1x1MDYzMlx1MDZjY1x1MDYyYSBcdTA2MzFcdTA2MjdcdTA2MmRcdTA2MmFcdTA2MGMgXHUwNmE5XHUwNjI3XHUwNjMxXHUwNjIyXHUwNjQ1XHUwNjJmIFx1MDY0OCBcdTA2NDVcdTA2MmFcdTA2NDZcdTA2MjdcdTA2MzNcdTA2MjggXHUwNjI4XHUwNjI3IFx1MDY0Nlx1MDZjY1x1MDYyN1x1MDYzMlx1MDY0N1x1MDYyN1x1MDZjYyBcdTA2NDVcdTA2NDZcdTA2MmRcdTA2MzVcdTA2MzEgXHUwNjI4XHUwNjQ3IFx1MDY0MVx1MDYzMVx1MDYyZiBcdTA2MzRcdTA2NDVcdTA2MjcgXHUwNjJlXHUwNjQ4XHUwNjI3XHUwNjQ3XHUwNjJmIFx1MDYyOFx1MDY0OFx1MDYyZi48XC9wPiIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIyMSIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]<div class=\\\"elementor-element elementor-element-9f3be1f e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"9f3be1f\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-e4d5e10 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"e4d5e10\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-3f475ce e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"3f475ce\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImQ0MzdiMWMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGg1Plx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOSBcdTA2MjhcdTA2MjdcdTA2MmFcdTA2MmNcdTA2MzFcdTA2MjhcdTA2NDc8XC9oNT4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNDAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6Ijc4ZTZlMmIiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhXHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDYyYVx1MDYyZVx1MDYzNVx1MDYzNVx1MDZjYyBcdTA2MjhcdTA2MjcgXHUwNjdlXHUwNjM0XHUwNjJhXHUwNjQ4XHUwNjI3XHUwNjQ2XHUwNjQ3IFx1MDYzM1x1MDYyN1x1MDY0NFx1MjAwY1x1MDY0N1x1MDYyNyBcdTA2MmFcdTA2MmNcdTA2MzFcdTA2MjhcdTA2NDcgXHUwNjJmXHUwNjQ2XHUwNjJmXHUwNjI3XHUwNjQ2XHUwNjdlXHUwNjMyXHUwNjM0XHUwNmE5XHUwNmNjIFx1MDY0Mlx1MDYyN1x1MDYyOFx1MDY0NCBcdTA2MjdcdTA2MzlcdTA2MmFcdTA2NDVcdTA2MjdcdTA2MmYuPFwvcD4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNTAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-c548350 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"c548350\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjY1YzMxZjQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGg1Plx1MDYyZlx1MDYzMVx1MDY0NVx1MDYyN1x1MDY0NiBcdTA2MzRcdTA2MmVcdTA2MzVcdTA2Y2NcdTIwMGNcdTA2MzNcdTA2MjdcdTA2MzJcdTA2Y2NcdTIwMGNcdTA2MzRcdTA2MmZcdTA2NDc8XC9oNT4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNDAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjI0ZDQ0MDkiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjI4XHUwNjMxXHUwNjQ2XHUwNjI3XHUwNjQ1XHUwNjQ3XHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY0NVx1MDYzMVx1MDYyN1x1MDY0Mlx1MDYyOFx1MDYyYVx1MDZjYyBcdTA2MzNcdTA2NDFcdTA2MjdcdTA2MzFcdTA2MzRcdTA2Y2MgXHUwNmE5XHUwNjQ3IFx1MDY0NVx1MDYyYVx1MDY0Nlx1MDYyN1x1MDYzM1x1MDYyOCBcdTA2MjhcdTA2MjcgXHUwNjQ0XHUwNjI4XHUwNjJlXHUwNjQ2XHUwNjJmIFx1MDY0OCBcdTA2MzNcdTA2MjhcdTA2YTkgXHUwNjMyXHUwNjQ2XHUwNjJmXHUwNmFmXHUwNmNjIFx1MDYzNFx1MDY0NVx1MDYyNyBcdTA2MmFcdTA2NDdcdTA2Y2NcdTA2NDcgXHUwNjQ1XHUwNmNjXHUyMDBjXHUwNjM0XHUwNjQ4XHUwNjQ2XHUwNjJmLjxcL3A+IiwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjUwMCJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfdGV4dF9lZGl0b3IifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-64807c6 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"64807c6\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-0cb580b e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"0cb580b\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6Ijg5ZmJjZjUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGg1Plx1MDY0MVx1MDY0Nlx1MDYyN1x1MDY0OFx1MDYzMVx1MDZjYyBcdTA2N2VcdTA2Y2NcdTA2MzRcdTA2MzFcdTA2NDFcdTA2MmFcdTA2NDc8XC9oNT4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNDAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjFhMmNlMjgiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjI3XHUwNjI4XHUwNjMyXHUwNjI3XHUwNjMxXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY0NVx1MDYyZlx1MDYzMVx1MDY0Nlx1MDYwYyBcdTA2MmZcdTA2MzFcdTA2NDVcdTA2MjdcdTA2NDZcdTIwMGNcdTA2NDdcdTA2MjdcdTA2Y2MgXHUwNjJmXHUwNjQyXHUwNmNjXHUwNjQyIFx1MDY0OCBcdTA2YTlcdTA2MjdcdTA2MzFcdTA2MjJcdTA2NDVcdTA2MmYgXHUwNjMxXHUwNjI3IFx1MDYyYVx1MDYzNlx1MDY0NVx1MDZjY1x1MDY0NiBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2YTlcdTA2NDZcdTA2NDZcdTA2MmYuPFwvcD4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNTAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-5c18bec e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"5c18bec\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjAxMzk0MzAiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGg1Plx1MDY0NVx1MDY0Nlx1MDYyN1x1MDYzM1x1MDYyOCBcdTA2MmVcdTA2MjdcdTA2NDZcdTA2NDhcdTA2MjdcdTA2MmZcdTA2NDc8XC9oNT4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNDAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjNlOTMwOWMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjQxXHUwNjM2XHUwNjI3XHUwNmNjXHUwNmNjIFx1MDYyZlx1MDY0NFx1MDY0Nlx1MDYzNFx1MDZjY1x1MDY0NiBcdTA2MjhcdTA2MzFcdTA2MjdcdTA2Y2MgXHUwNmE5XHUwNjQ4XHUwNjJmXHUwNmE5XHUwNjI3XHUwNjQ2XHUwNjBjIFx1MDY0Nlx1MDY0OFx1MDYyY1x1MDY0OFx1MDYyN1x1MDY0Nlx1MDYyN1x1MDY0Nlx1MDYwYyBcdTA2MjhcdTA2MzJcdTA2MzFcdTA2YWZcdTA2MzNcdTA2MjdcdTA2NDRcdTA2MjdcdTA2NDYgXHUwNjQ4IFx1MDYzM1x1MDYyN1x1MDY0NFx1MDY0NVx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Ni48XC9wPiIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX3RleHRfZWRpdG9yIn0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-c0bac5e e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"c0bac5e\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-9ce2c5c e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"9ce2c5c\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImU1MzBjODEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2V4Y2VwdGlvbmFsMi5qcGciLCJpZCI6NjA3LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJpbWFnZV90eXBlIjoiYmciLCJpbWFnZV9oZWlnaHQiOnsidW5pdCI6InB4Iiwic2l6ZSI6MjM2LjgwMDAwMDAwMDAwMDAxMTM2ODY4Mzc3MjE2MTYwMjk3MzkzNzk4ODI4MTI1LCJzaXplcyI6W119LCJib3JkZXJfcmFkaXVzIjp7InVuaXQiOiJweCIsInRvcCI6IjIwIiwicmlnaHQiOiIyMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjIwIiwiaXNMaW5rZWQiOnRydWV9LCJwYXJhbGxheF92YWx1ZSI6IjQwIiwibWF4X3RpbHQiOiIxMCIsInNwZWVkX3RpbHQiOiI0MDAiLCJwZXJzcGVjdGl2ZV90aWx0IjoiMTAwMCIsInB4bF9hbmltYXRlIjoid293IHpvb21JblNtYWxsIiwicHhsX2FuaW1hdGVfZGVsYXkiOiIzMDAiLCJweGxfYW5pbWF0ZV9pbWciOiJ3b3cgc2NhbGVJbiIsInB4bF9hbmltYXRlX2ltZ19kZWxheSI6IjMwMCIsIl9wYWRkaW5nIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIwIiwibGVmdCI6IjYwIiwiaXNMaW5rZWQiOmZhbHNlfSwiX3BhZGRpbmdfdGFibGV0Ijp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9fSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ltYWdlIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjIxYmMyY2IiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2V4Y2VwdGlvbmFsMS5qcGciLCJpZCI6NjA2LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJpbWFnZV90eXBlIjoiYmciLCJpbWFnZV9oZWlnaHQiOnsidW5pdCI6InB4Iiwic2l6ZSI6Mjk2LCJzaXplcyI6W119LCJib3JkZXJfcmFkaXVzIjp7InVuaXQiOiJweCIsInRvcCI6IjIwIiwicmlnaHQiOiIyMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjIwIiwiaXNMaW5rZWQiOnRydWV9LCJwYXJhbGxheF92YWx1ZSI6IjQwIiwibWF4X3RpbHQiOiIxMCIsInNwZWVkX3RpbHQiOiI0MDAiLCJwZXJzcGVjdGl2ZV90aWx0IjoiMTAwMCIsInB4bF9hbmltYXRlIjoid293IHpvb21JblNtYWxsIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJweGxfYW5pbWF0ZV9pbWciOiJ3b3cgc2NhbGVJbiIsInB4bF9hbmltYXRlX2ltZ19kZWxheSI6IjUwMCJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfaW1hZ2UifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-2b3fb22 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"2b3fb22\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImE3YmU3YjkiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2V4Y2VwdGlvbmFsMy5qcGciLCJpZCI6NjA4LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJpbWFnZV90eXBlIjoiYmciLCJpbWFnZV9oZWlnaHQiOnsidW5pdCI6InB4Iiwic2l6ZSI6Mzk5LjYwMDAwMDAwMDAwMDAyMjczNzM2NzU0NDMyMzIwNTk0Nzg3NTk3NjU2MjUsInNpemVzIjpbXX0sImJvcmRlcl9yYWRpdXMiOnsidW5pdCI6InB4IiwidG9wIjoiMjAiLCJyaWdodCI6IjIwIiwiYm90dG9tIjoiMjAiLCJsZWZ0IjoiMjAiLCJpc0xpbmtlZCI6dHJ1ZX0sInBhcmFsbGF4X3ZhbHVlIjoiNDAiLCJtYXhfdGlsdCI6IjEwIiwic3BlZWRfdGlsdCI6IjQwMCIsInBlcnNwZWN0aXZlX3RpbHQiOiIxMDAwIiwicHhsX2FuaW1hdGUiOiJ3b3cgem9vbUluU21hbGwiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjQwMCIsInB4bF9hbmltYXRlX2ltZyI6IndvdyBzY2FsZUluIiwicHhsX2FuaW1hdGVfaW1nX2RlbGF5IjoiNDAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9pbWFnZSJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-d0d5540 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"d0d5540\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-964e490 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"964e490\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImQwNzU1OTUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDY0NVx1MDYyYVx1MDYzOVx1MDY0N1x1MDYyZiBcdTA2MjhcdTA2NDcgXHUwNjQ0XHUwNjI4XHUwNjJlXHUwNjQ2XHUwNjJmIFx1MDYzNFx1MDY0NVx1MDYyNyIsInN1Yl90aXRsZSI6IiBcdTA2MjhcdTA2MjcgXHUwNjJhXHUwNmNjXHUwNjQ1IFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2NDVcdTA2MjcgXHUwNjIyXHUwNjM0XHUwNjQ2XHUwNjI3IFx1MDYzNFx1MDY0OFx1MDZjY1x1MDYyZiIsImhfd2lkdGgiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF9sYXB0b3AiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF90YWJsZXRfZXh0cmEiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF90YWJsZXQiOnsidW5pdCI6IiUiLCJzaXplIjoxMDAsInNpemVzIjpbXX0sImhfd2lkdGhfbW9iaWxlX2V4dHJhIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sImhfd2lkdGhfbW9iaWxlIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sInRpdGxlX3RhZyI6ImgyIiwic3ViX3RpdGxlX3NwYWNlX2JvdHRvbSI6eyJ1bml0IjoicHgiLCJzaXplIjoxNywic2l6ZXMiOltdfSwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIwIiwicmlnaHQiOiIwIiwiYm90dG9tIjoiMjAiLCJsZWZ0IjoiMCIsImlzTGlua2VkIjpmYWxzZX0sInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI0MDAiLCJweGxfYW5pbWF0ZV9zdWIiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheV9zdWIiOiIzMDAiLCJhbGlnbiI6ImNlbnRlciIsInRpdGxlX3R5cG9ncmFwaHlfdHlwb2dyYXBoeSI6ImN1c3RvbSIsInRpdGxlX3R5cG9ncmFwaHlfZm9udF9zaXplX21vYmlsZSI6eyJ1bml0IjoicHgiLCJzaXplIjo0NSwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9oZWFkaW5nIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImFjZDdkYTQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHAgY2xhc3M9XCJ3b3cgZmFkZUluVXAgYW5pbWF0ZWRcIj5cdTA2MmFcdTA2Y2NcdTA2NDUgXHUwNjJmXHUwNjQ2XHUwNjJmXHUwNjI3XHUwNjQ2XHUwNjdlXHUwNjMyXHUwNjM0XHUwNmE5XHUwNmNjIFx1MDYyOFx1MDYyN1x1MDYyYVx1MDYyY1x1MDYzMVx1MDYyOFx1MDY0NyBcdTA2NDVcdTA2MjcgXHUwNjI3XHUwNmNjXHUwNjQ2XHUwNjJjXHUwNjI3IFx1MDY0N1x1MDYzM1x1MDYyYVx1MDY0Nlx1MDYyZiBcdTA2MmFcdTA2MjcgXHUwNjQ3XHUwNjMxIFx1MDY0OFx1MDZjY1x1MDYzMlx1MDZjY1x1MDYyYSBcdTA2MzFcdTA2MjcgXHUwNjQ1XHUwNjJiXHUwNjI4XHUwNjJhIFx1MDY0OCBcdTA2MzRcdTA2MmVcdTA2MzVcdTA2Y2NcdTIwMGNcdTA2MzNcdTA2MjdcdTA2MzJcdTA2Y2NcdTIwMGNcdTA2MzRcdTA2MmZcdTA2NDcgXHUwNmE5XHUwNjQ2XHUwNjQ2XHUwNjJmLiBcdTA2MjhcdTA2MjcgXHUwNjJmXHUwNjMzXHUwNjJhXHUwNjI3XHUwNjQ2XHUwNmNjIFx1MDY0NVx1MDY0N1x1MDYzMVx1MDYyOFx1MDYyN1x1MDY0NiBcdTA2NDggXHUwNjQyXHUwNjQ0XHUwNjI4XHUwNmNjIFx1MDY0NVx1MDY0N1x1MDYzMVx1MDYyOFx1MDYyN1x1MDY0Ni48XC9wPiIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIzNyIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwiYWxpZ24iOiJjZW50ZXIiLCJ0X3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjYyOCwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-8e36ff0 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"8e36ff0\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"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\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-07e3439 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"07e3439\\\" data-element_type=\\\"container\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-cabeee0 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"cabeee0\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjkyYTMwYzUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYzM1x1MDY0OFx1MDYyN1x1MDY0NFx1MDYyN1x1MDYyYSBcdTA2NDVcdTA2MmFcdTA2MmZcdTA2MjdcdTA2NDhcdTA2NDQiLCJzdWJfdGl0bGUiOiJcdTA2NDdcdTA2MzEgXHUwNjIyXHUwNjQ2XHUwNjg2XHUwNjQ3IFx1MDZhOVx1MDY0NyBcdTA2MjhcdTA2MjdcdTA2Y2NcdTA2MmYgXHUwNjI4XHUwNjJmXHUwNjI3XHUwNjQ2XHUwNmNjXHUwNjJmIiwidGl0bGVfdGFnIjoiaDIiLCJ0aXRsZV90eXBvZ3JhcGh5X3R5cG9ncmFwaHkiOiJjdXN0b20iLCJ0aXRsZV90eXBvZ3JhcGh5X2ZvbnRfc2l6ZV9tb2JpbGUiOnsidW5pdCI6InB4Iiwic2l6ZSI6NDUsInNpemVzIjpbXX0sInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJweGxfYW5pbWF0ZV9zdWIiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheV9zdWIiOiIzMDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIyMCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9oZWFkaW5nIn0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-cb0bd9f e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"cb0bd9f\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"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\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-faed713 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"faed713\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\"><div class=\\\"elementor-element elementor-element-ba2fc12 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"ba2fc12\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImNkNzE3MTYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDY0NVx1MDYzNFx1MDYyYVx1MDYzMVx1MDZjY1x1MDYyN1x1MDY0NiBcdTA2MzFcdTA2MjdcdTA2MzZcdTA2Y2MgXHUwNjQ1XHUwNjI3Iiwic3ViX3RpdGxlIjoiXHUwNjQ2XHUwNjM4XHUwNjMxXHUwNjI3XHUwNjJhIFx1MDY0NVx1MDYzNFx1MDYyYVx1MDYzMVx1MDZjY1x1MDYyN1x1MDY0NiIsImhfd2lkdGgiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF9sYXB0b3AiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF90YWJsZXRfZXh0cmEiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF90YWJsZXQiOnsidW5pdCI6IiUiLCJzaXplIjoxMDAsInNpemVzIjpbXX0sImhfd2lkdGhfbW9iaWxlX2V4dHJhIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sImhfd2lkdGhfbW9iaWxlIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sInRpdGxlX3RhZyI6ImgyIiwic3ViX3RpdGxlX3NwYWNlX2JvdHRvbSI6eyJ1bml0IjoicHgiLCJzaXplIjoxNywic2l6ZXMiOltdfSwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIwIiwicmlnaHQiOiIwIiwiYm90dG9tIjoiMjAiLCJsZWZ0IjoiMCIsImlzTGlua2VkIjpmYWxzZX0sInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI0MDAiLCJweGxfYW5pbWF0ZV9zdWIiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheV9zdWIiOiIzMDAiLCJhbGlnbiI6ImNlbnRlciIsInRpdGxlX3R5cG9ncmFwaHlfdHlwb2dyYXBoeSI6ImN1c3RvbSIsInRpdGxlX3R5cG9ncmFwaHlfZm9udF9zaXplX21vYmlsZSI6eyJ1bml0IjoicHgiLCJzaXplIjo0NSwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9oZWFkaW5nIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjE3ZWZiYjAiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHAgY2xhc3M9XCJ3b3cgZmFkZUluVXAgYW5pbWF0ZWRcIj5cdTA2MjhcdTA2NDcgXHUwNjQ3XHUwNjMyXHUwNjI3XHUwNjMxXHUwNjI3XHUwNjQ2IFx1MDYyOFx1MDZjY1x1MDY0NVx1MDYyN1x1MDYzMSBcdTA2MzFcdTA2MjdcdTA2MzZcdTA2Y2MgXHUwNjI4XHUwNjdlXHUwNmNjXHUwNjQ4XHUwNjQ2XHUwNjJmXHUwNmNjXHUwNjJmIFx1MDZhOVx1MDY0NyBcdTA2MjhcdTA2MzFcdTA2MjdcdTA2Y2MgXHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhXHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY0NVx1MDY0NFx1MDYyN1x1MDZjY1x1MDY0NSBcdTA2NDggXHUwNjJhXHUwNjJlXHUwNjM1XHUwNjM1XHUwNmNjIFx1MDY0OCBcdTA2NDRcdTA2MjhcdTA2MmVcdTA2NDZcdTA2MmZcdTA2NDdcdTA2MjdcdTA2Y2MgXHUwNjMyXHUwNmNjXHUwNjI4XHUwNjI3IFx1MDYyOFx1MDY0NyBcdTA2NDVcdTA2MjcgXHUwNjI3XHUwNjM5XHUwNjJhXHUwNjQ1XHUwNjI3XHUwNjJmIFx1MDY0NVx1MDZjY1x1MjAwY1x1MDZhOVx1MDY0Nlx1MDY0Nlx1MDYyZi4gXHUwNjJhXHUwNjJjXHUwNjMxXHUwNjI4XHUwNjQ3IFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2MjhcdTA2Y2NcdTIwMGNcdTA2NDZcdTA2MzhcdTA2Y2NcdTA2MzEgXHUwNjM0XHUwNjQ1XHUwNjI3IFx1MDYyN1x1MDYzMiBcdTA2MjdcdTA2Y2NcdTA2NDZcdTA2MmNcdTA2MjcgXHUwNjM0XHUwNjMxXHUwNjQ4XHUwNjM5IFx1MDY0NVx1MDZjY1x1MjAwY1x1MDYzNFx1MDY0OFx1MDYyZiE8XC9wPiIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiI1MCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwiYWxpZ24iOiJjZW50ZXIiLCJ0X3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjYyOCwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-6356f20 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"6356f20\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"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\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-d1c1cbb e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"d1c1cbb\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-8418409 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"8418409\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjBkMWM2YzIiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYyMlx1MDY0NVx1MDYyN1x1MDYyZlx1MDY0NyBcdTA2MzFcdTA2MzJcdTA2MzFcdTA2NDggXHUwNjQ2XHUwNjQ4XHUwNjI4XHUwNjJhIFx1MDYyZVx1MDY0OFx1MDYyZiBcdTA2NDdcdTA2MzNcdTA2MmFcdTA2Y2NcdTA2MmZcdTA2MWYiLCJ0aXRsZV9jb2xvciI6IiNGRkZGRkYiLCJ0aXRsZV90eXBvZ3JhcGh5X3R5cG9ncmFwaHkiOiJjdXN0b20iLCJ0aXRsZV90eXBvZ3JhcGh5X2ZvbnRfc2l6ZSI6eyJ1bml0IjoicHgiLCJzaXplIjozMiwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9oZWFkaW5nIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjNjZjdjNGIiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjQ3XHUwNjQ1XHUwNmNjXHUwNjQ2IFx1MDYyN1x1MDY0NVx1MDYzMVx1MDY0OFx1MDYzMiBcdTA2MjhcdTA2MjcgXHUwNjQ1XHUwNjI3IFx1MDYyYVx1MDY0NVx1MDYyN1x1MDYzMyBcdTA2MjhcdTA2YWZcdTA2Y2NcdTA2MzFcdTA2Y2NcdTA2MmYgXHUwNjJhXHUwNjI3IFx1MDY0OFx1MDY0Mlx1MDYyYSBcdTA2NDVcdTA2NDRcdTA2MjdcdTA2NDJcdTA2MjdcdTA2MmEgXHUwNjJlXHUwNjQ4XHUwNjJmIFx1MDYzMVx1MDYyNyBcdTA2MzFcdTA2MzJcdTA2MzFcdTA2NDggXHUwNmE5XHUwNjQ2XHUwNmNjXHUwNjJmIFx1MDY0OCBcdTA2MjdcdTA2NDhcdTA2NDRcdTA2Y2NcdTA2NDYgXHUwNjQyXHUwNjJmXHUwNjQ1IFx1MDYzMVx1MDYyNyBcdTA2MjhcdTA2MzFcdTA2MjdcdTA2Y2MgXHUwNjJmXHUwNjI3XHUwNjM0XHUwNjJhXHUwNjQ2IFx1MDY0NFx1MDYyOFx1MDYyZVx1MDY0Nlx1MDYyZlx1MDZjYyBcdTA2MzNcdTA2MjdcdTA2NDRcdTA2NDVcdTIwMGNcdTA2MmFcdTA2MzEgXHUwNjI4XHUwNjMxXHUwNjJmXHUwNjI3XHUwNjMxXHUwNmNjXHUwNjJmLjxcL3A+IiwidGV4dF9jb2xvciI6IiNGRkZGRkY5OSJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfdGV4dF9lZGl0b3IifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-97ded05 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"97ded05\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImI3YTczODEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0IjoiXHUwNjMxXHUwNjMyXHUwNjMxXHUwNjQ4IFx1MDY0Nlx1MDY0OFx1MDYyOFx1MDYyYSIsImFsaWduIjoibGVmdCIsImJvcmRlcl90eXBlIjoic29saWQiLCJib3JkZXJfd2lkdGgiOnsidW5pdCI6InB4IiwidG9wIjoiMSIsInJpZ2h0IjoiMSIsImJvdHRvbSI6IjEiLCJsZWZ0IjoiMSIsImlzTGlua2VkIjp0cnVlfSwiYm9yZGVyX2NvbG9yIjoiI0ZGRkZGRjgwIiwiYm9yZGVyX2NvbG9yX2hvdmVyIjoiIzEwMjQ0QiIsImxpbmsiOnsidXJsIjoiaHR0cHM6XC9cL2RlbnRpYS5zdW50aGVtZXMuaXJcL2Jvb2tpbmdcLyIsImlzX2V4dGVybmFsIjoiIiwibm9mb2xsb3ciOiIiLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9fSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2J1dHRvbiJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\",\"scripts\":[],\"styles\":[]}}\";}","auto-off");

INSERT IGNORE INTO `wp_options` VALUES 
("913","pxl_service_options","a:27:{s:17:\"_wp_page_template\";s:7:\"default\";s:13:\"header_layout\";s:4:\"1594\";s:20:\"header_layout_sticky\";s:2:\"-1\";s:6:\"logo_m\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:12:\"mobile_style\";s:7:\"inherit\";s:6:\"p_menu\";s:0:\"\";s:13:\"sticky_scroll\";s:2:\"-1\";s:7:\"pt_mode\";s:4:\"none\";s:13:\"custom_ptitle\";s:0:\"\";s:16:\"page_sidebar_pos\";s:1:\"0\";s:15:\"content_spacing\";a:3:{s:5:\"units\";s:2:\"px\";s:11:\"padding-top\";s:1:\"0\";s:14:\"padding-bottom\";s:1:\"0\";}s:13:\"footer_layout\";s:2:\"-1\";s:14:\"p_footer_fixed\";s:7:\"inherit\";s:13:\"body_bg_color\";s:0:\"\";s:13:\"primary_color\";s:0:\"\";s:15:\"secondary_color\";s:0:\"\";s:14:\"gradient_color\";a:2:{s:4:\"from\";s:0:\"\";s:2:\"to\";s:0:\"\";}s:17:\"body_custom_class\";s:0:\"\";s:20:\"_elementor_edit_mode\";s:7:\"builder\";s:24:\"_elementor_template_type\";s:7:\"wp-page\";s:18:\"_elementor_version\";s:6:\"3.32.0\";s:15:\"_elementor_data\";s:76806:\"[{\"id\":\"5161d23\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"slideshow\",\"background_slideshow_gallery\":[{\"id\":1485,\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/1-min-e1758004018967.jpg\"},{\"id\":1486,\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/2-min-e1758004028449.jpg\"}],\"background_slideshow_background_size\":\"cover\",\"background_slideshow_background_position\":\"center center\",\"background_slideshow_lazyload\":\"yes\",\"background_overlay_background\":\"gradient\",\"background_overlay_color\":\"#000A5B66\",\"background_overlay_color_stop\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"background_overlay_color_b\":\"#000A5B\",\"background_overlay_gradient_angle\":{\"unit\":\"deg\",\"size\":-90,\"sizes\":[]},\"background_overlay_opacity\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"padding\":{\"unit\":\"px\",\"top\":\"220\",\"right\":\"15\",\"bottom\":\"192\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"background_slideshow_slide_transition\":\"slide_right\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"73\",\"right\":\"15\",\"bottom\":\"70\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"0b31933\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"bd11b0a\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0644\\u0628\\u062e\\u0646\\u062f\\u0647\\u0627\\u06cc \\u0632\\u06cc\\u0628\\u0627\\u062a\\u0631 \\u0628\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u062a\\u062e\\u0635\\u0635\\u06cc \\u0648 \\u0644\\u0645\\u0633 \\u0645\\u0644\\u0627\\u06cc\\u0645\",\"sub_title\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647\",\"h_width\":{\"unit\":\"%\",\"size\":49,\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":55,\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h1\",\"title_color\":\"#FFFFFF\",\"sub_title_color\":\"#FFFFFF\",\"sub_title_typography_typography\":\"custom\",\"sub_title_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"sub_title_typography_font_weight\":\"600\",\"sub_title_typography_line_height\":{\"unit\":\"em\",\"size\":1.5,\"sizes\":[]},\"sub_title_typography_line_height_laptop\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"sub_title_typography_line_height_tablet_extra\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"sub_title_typography_line_height_mobile_extra\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\"},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"c162dc7\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0631\\u0632\\u0631\\u0648 \\u0646\\u0648\\u0628\\u062a\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/booking\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"btn_bg_color\":\"#02010100\",\"border_type\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"border_color\":\"#FFFFFF\",\"color_hover\":\"#FFFFFF\",\"btn_bg_color_hover\":\"#000A5B\",\"btn_bg_color_active\":\"#000A5B\",\"btn_bg_color_focus\":\"#000A5B\",\"border_color_hover\":\"#000A5B\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"30\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_button\"},{\"id\":\"9d1bee4\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_align_items\":\"center\",\"flex_gap\":{\"column\":\"15\",\"row\":\"15\",\"isLinked\":true,\"unit\":\"px\",\"size\":15},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"animation\":\"fadeInUp\",\"animation_delay\":600,\"flex_wrap\":\"wrap\"},\"elements\":[{\"id\":\"ac6b6cf\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<div class=\\\"me-3\\\">\\u0631\\u062a\\u0628\\u0647\\u200c\\u0628\\u0646\\u062f\\u06cc \\u06af\\u0648\\u06af\\u0644<\\/div>\",\"text_color\":\"#F8F9FA\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"05b35cf\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<div class=\\\"me-3\\\"><div class=\\\"me-3\\\">5.0<\\/div><\\/div>\",\"text_color\":\"#F8F9FA\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"bd513bf\",\"elType\":\"widget\",\"settings\":{\"icons\":[{\"_id\":\"e1ef7bc\",\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"}},{\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"},\"_id\":\"1fbf14e\"},{\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"},\"_id\":\"98ed77d\"},{\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"},\"_id\":\"1685a7b\"},{\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"},\"_id\":\"67aa573\"}],\"color\":\"#FEC42C\",\"icon_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"icon_space\":{\"unit\":\"px\",\"size\":2,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_icon\"},{\"id\":\"6531703\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<div class=\\\"me-3\\\"><div class=\\\"me-3\\\"><div class=\\\"me-3\\\">\\u0628\\u0631 \\u0627\\u0633\\u0627\\u0633 \\u06f2\\u06f3 \\u0647\\u0632\\u0627\\u0631 \\u0646\\u0642\\u062f \\u0648 \\u0628\\u0631\\u0631\\u0633\\u06cc<\\/div><\\/div><\\/div>\",\"text_color\":\"#F8F9FA\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false},{\"id\":\"af13e9f\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#000A5B\",\"padding\":{\"unit\":\"px\",\"top\":\"25\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_align_items\":\"center\",\"flex_direction_mobile_extra\":\"column\"},\"elements\":[{\"id\":\"f6f14ff\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"2f08b27\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"15\",\"bottom\":\"0\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_align_items\":\"center\",\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"3627c0a\",\"elType\":\"widget\",\"settings\":{\"layout\":\"2\",\"pxl_icon\":{\"value\":\"fas fa-phone-alt\",\"library\":\"fa-solid\"},\"title\":\"\\u0628\\u0647 \\u062e\\u062f\\u0645\\u0627\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0646\\u06cc\\u0627\\u0632 \\u062f\\u0627\\u0631\\u06cc\\u062f\\u061f\",\"desc\":\"\\u062a\\u0645\\u0627\\u0633: 021123456789\",\"title_color\":\"#FFFFFF\",\"icon_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_width\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"desc_color\":\"#FFFFFF99\",\"icon_color\":\"#4A7DC2\",\"icon_bg_color\":\"#02010100\",\"title_bottom\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"inner_space\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"4a79de0\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"0\",\"left\":\"1\",\"isLinked\":false},\"border_color\":\"#FFFFFF80\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"border_width_mobile_extra\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"1\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"91829d8\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"15\",\"bottom\":\"0\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"pxl_parallax_bg_position\":\"\",\"pxl_parallax_bg_position_laptop\":\"\",\"pxl_parallax_bg_position_tablet_extra\":\"\",\"pxl_parallax_bg_position_tablet\":\"\",\"pxl_parallax_bg_position_mobile_extra\":\"\",\"pxl_parallax_bg_position_mobile\":\"\",\"pxl_parallax_bg_pos_custom_x\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size\":\"\",\"pxl_parallax_bg_size_laptop\":\"\",\"pxl_parallax_bg_size_tablet_extra\":\"\",\"pxl_parallax_bg_size_tablet\":\"\",\"pxl_parallax_bg_size_mobile_extra\":\"\",\"pxl_parallax_bg_size_mobile\":\"\",\"pxl_parallax_bg_size_custom\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"pxl_parallax_bg_size_custom_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_overlay_img_position\":\"\",\"pxl_overlay_img_position_laptop\":\"\",\"pxl_overlay_img_position_tablet_extra\":\"\",\"pxl_overlay_img_position_tablet\":\"\",\"pxl_overlay_img_position_mobile_extra\":\"\",\"pxl_overlay_img_position_mobile\":\"\",\"pxl_overlay_img_right_position\":\"\",\"pxl_overlay_img_right_position_laptop\":\"\",\"pxl_overlay_img_right_position_tablet_extra\":\"\",\"pxl_overlay_img_right_position_tablet\":\"\",\"pxl_overlay_img_right_position_mobile_extra\":\"\",\"pxl_overlay_img_right_position_mobile\":\"\",\"row_effect_images\":[],\"flex_align_items\":\"center\"},\"elements\":[{\"id\":\"b6383c4\",\"elType\":\"widget\",\"settings\":{\"layout\":\"2\",\"pxl_icon\":{\"value\":\"fas fa-clock\",\"library\":\"fa-solid\"},\"title\":\"\\u0633\\u0627\\u0639\\u0627\\u062a \\u06a9\\u0627\\u0631\\u06cc\",\"desc\":\"\\u0647\\u0631 \\u0631\\u0648\\u0632 \\u0627\\u0632 08:00 \\u062a\\u0627 20:00\",\"title_color\":\"#FFFFFF\",\"icon_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_width\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"desc_color\":\"#FFFFFF99\",\"icon_color\":\"#4A7DC2\",\"icon_bg_color\":\"#02010100\",\"title_bottom\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"inner_space\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"_element_width_mobile\":\"inherit\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"6a5100f\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"4eaeb3c\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"15\",\"bottom\":\"0\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"pxl_parallax_bg_position\":\"\",\"pxl_parallax_bg_position_laptop\":\"\",\"pxl_parallax_bg_position_tablet_extra\":\"\",\"pxl_parallax_bg_position_tablet\":\"\",\"pxl_parallax_bg_position_mobile_extra\":\"\",\"pxl_parallax_bg_position_mobile\":\"\",\"pxl_parallax_bg_pos_custom_x\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size\":\"\",\"pxl_parallax_bg_size_laptop\":\"\",\"pxl_parallax_bg_size_tablet_extra\":\"\",\"pxl_parallax_bg_size_tablet\":\"\",\"pxl_parallax_bg_size_mobile_extra\":\"\",\"pxl_parallax_bg_size_mobile\":\"\",\"pxl_parallax_bg_size_custom\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"pxl_parallax_bg_size_custom_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_overlay_img_position\":\"\",\"pxl_overlay_img_position_laptop\":\"\",\"pxl_overlay_img_position_tablet_extra\":\"\",\"pxl_overlay_img_position_tablet\":\"\",\"pxl_overlay_img_position_mobile_extra\":\"\",\"pxl_overlay_img_position_mobile\":\"\",\"pxl_overlay_img_right_position\":\"\",\"pxl_overlay_img_right_position_laptop\":\"\",\"pxl_overlay_img_right_position_tablet_extra\":\"\",\"pxl_overlay_img_right_position_tablet\":\"\",\"pxl_overlay_img_right_position_mobile_extra\":\"\",\"pxl_overlay_img_right_position_mobile\":\"\",\"row_effect_images\":[],\"flex_align_items\":\"center\"},\"elements\":[{\"id\":\"ff38d6d\",\"elType\":\"widget\",\"settings\":{\"layout\":\"2\",\"pxl_icon\":{\"value\":\"fas fa-envelope\",\"library\":\"fa-solid\"},\"title\":\"\\u0627\\u06cc\\u0645\\u06cc\\u0644 \\u0645\\u0627\",\"desc\":\"contact@dentiaclinic.com\",\"title_color\":\"#FFFFFF\",\"icon_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_width\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"desc_color\":\"#FFFFFF99\",\"icon_color\":\"#4A7DC2\",\"icon_bg_color\":\"#02010100\",\"title_bottom\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"inner_space\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"_element_width_mobile\":\"inherit\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false},{\"id\":\"15b34f8\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":50,\"column\":\"50\",\"row\":\"50\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"135\",\"right\":\"15\",\"bottom\":\"130\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_gap_laptop\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"0\",\"bottom\":\"70\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"98ca70d\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"flex_gap\":{\"column\":\"22\",\"row\":\"22\",\"isLinked\":true,\"unit\":\"px\",\"size\":22},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_direction_tablet\":\"column\"},\"elements\":[{\"id\":\"43ff422\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"b698bb4\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/about-img1.jpg\",\"id\":463,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":399,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"300\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"300\"},\"elements\":[],\"widgetType\":\"pxl_image\"}],\"isInner\":true},{\"id\":\"4c3a639\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"padding\":{\"unit\":\"px\",\"top\":\"55\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"3a26ecd\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/about-img2.jpg\",\"id\":464,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":399,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"500\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_image\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"9dd8e84\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"b0297bf\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u062a\\u062e\\u0635\\u0635\\u0627\\u0646 \\u0648 \\u062a\\u0639\\u0627\\u0644\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0634\\u062e\\u0635\\u06cc\",\"sub_title\":\"\\u062f\\u0631\\u0628\\u0627\\u0631\\u0647 \\u0645\\u0627\",\"h_width\":{\"unit\":\"%\",\"size\":80,\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"6bc87e8\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0645\\u0627 \\u062e\\u062f\\u0645\\u0627\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0628\\u0627 \\u06a9\\u06cc\\u0641\\u06cc\\u062a \\u0628\\u0627\\u0644\\u0627 \\u0648 \\u0645\\u062a\\u0646\\u0627\\u0633\\u0628 \\u0628\\u0627 \\u0646\\u06cc\\u0627\\u0632 \\u062a\\u0645\\u0627\\u0645 \\u0627\\u0639\\u0636\\u0627\\u06cc \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647 \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645. \\u0627\\u0632 \\u0645\\u0639\\u0627\\u06cc\\u0646\\u0627\\u062a \\u0631\\u0648\\u062a\\u06cc\\u0646 \\u06af\\u0631\\u0641\\u062a\\u0647 \\u062a\\u0627 \\u062f\\u0631\\u0645\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647\\u060c \\u062a\\u06cc\\u0645 \\u062f\\u0644\\u0633\\u0648\\u0632 \\u0645\\u0627 \\u062a\\u0636\\u0645\\u06cc\\u0646 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u062f \\u06a9\\u0647 \\u0644\\u0628\\u062e\\u0646\\u062f \\u0634\\u0645\\u0627 \\u0633\\u0627\\u0644\\u0645 \\u0648 \\u0628\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f \\u0628\\u0647 \\u0646\\u0641\\u0633 \\u0628\\u0627\\u0642\\u06cc \\u0628\\u0645\\u0627\\u0646\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"17\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"bb0da06\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_gap\":{\"column\":\"35\",\"row\":\"35\",\"isLinked\":true,\"unit\":\"px\",\"size\":35},\"flex_gap_laptop\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_direction_tablet\":\"column\",\"flex_gap_tablet\":{\"column\":\"5\",\"row\":\"5\",\"isLinked\":true,\"unit\":\"px\",\"size\":5}},\"elements\":[{\"id\":\"9028010\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"827cdc3\",\"elType\":\"widget\",\"settings\":{\"lists\":[{\"_id\":\"29fdacb\",\"pxl_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"},\"text\":\"\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0631\\u0645\\u0627\\u0646 \\u0634\\u062e\\u0635\\u06cc\\u200c\\u0633\\u0627\\u0632\\u06cc\\u200c\\u0634\\u062f\\u0647\"},{\"pxl_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"},\"text\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u0645\\u0644\\u0627\\u06cc\\u0645 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646 \\u0648 \\u0628\\u0632\\u0631\\u06af\\u0633\\u0627\\u0644\\u0627\\u0646\",\"_id\":\"7ff6475\"}],\"text_typography_typography\":\"custom\",\"text_typography_font_size_laptop\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"icon_color\":\"#4A7DC2\",\"icon_space\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"03\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"600\",\"align_items\":\"start\"},\"elements\":[],\"widgetType\":\"pxl_list\"}],\"isInner\":true},{\"id\":\"6db1ff5\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"fa6490e\",\"elType\":\"widget\",\"settings\":{\"lists\":[{\"_id\":\"29fdacb\",\"pxl_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"},\"text\":\"\\u0641\\u0646\\u0627\\u0648\\u0631\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647\"},{\"pxl_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"},\"text\":\"\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647\\u200c\\u0631\\u06cc\\u0632\\u06cc \\u0627\\u0646\\u0639\\u0637\\u0627\\u0641\\u200c\\u067e\\u0630\\u06cc\\u0631 \\u0628\\u0631\\u0627\\u06cc \\u0642\\u0631\\u0627\\u0631 \\u0645\\u0644\\u0627\\u0642\\u0627\\u062a\",\"_id\":\"7ff6475\"}],\"text_typography_typography\":\"custom\",\"text_typography_font_size_laptop\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"icon_color\":\"#4A7DC2\",\"icon_space\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"03\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"600\",\"align_items\":\"start\"},\"elements\":[],\"widgetType\":\"pxl_list\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"f3897d9\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0631\\u0632\\u0631\\u0648 \\u0646\\u0648\\u0628\\u062a\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"700\",\"_margin\":{\"unit\":\"px\",\"top\":\"28\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_button\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"9f68bac\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#4A7CD21A\",\"padding\":{\"unit\":\"px\",\"top\":\"120\",\"right\":\"15\",\"bottom\":\"130\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"15\",\"bottom\":\"70\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"ac1ac70\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"c74a3ee\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u06a9\\u0627\\u0645\\u0644 \\u0628\\u0631\\u0627\\u06cc \\u0647\\u0631 \\u0644\\u0628\\u062e\\u0646\\u062f\",\"sub_title\":\"\\u062e\\u062f\\u0645\\u0627\\u062a \\u0645\\u0627\",\"h_width\":{\"unit\":\"%\",\"size\":80,\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]},\"align\":\"center\"},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"72847f9\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0627\\u0632 \\u062a\\u0645\\u06cc\\u0632 \\u06a9\\u0631\\u062f\\u0646\\u200c\\u0647\\u0627\\u06cc \\u0631\\u0648\\u062a\\u06cc\\u0646 \\u06af\\u0631\\u0641\\u062a\\u0647 \\u062a\\u0627 \\u062a\\u0631\\u0645\\u06cc\\u0645\\u200c\\u0647\\u0627\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647\\u060c \\u0645\\u0627 \\u0631\\u0627\\u0647\\u200c\\u062d\\u0644\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0634\\u062e\\u0635\\u06cc\\u200c\\u0633\\u0627\\u0632\\u06cc\\u200c\\u0634\\u062f\\u0647 \\u0631\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u0628\\u06cc\\u0645\\u0627\\u0631\\u0627\\u0646 \\u062f\\u0631 \\u0647\\u0631 \\u0633\\u0646\\u06cc \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"42\",\"left\":\"0\",\"isLinked\":false},\"align\":\"center\",\"t_width\":{\"unit\":\"px\",\"size\":563,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"7371f8b\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"pxl_parallax_bg_position\":\"\",\"pxl_parallax_bg_position_laptop\":\"\",\"pxl_parallax_bg_position_tablet_extra\":\"\",\"pxl_parallax_bg_position_tablet\":\"\",\"pxl_parallax_bg_position_mobile_extra\":\"\",\"pxl_parallax_bg_position_mobile\":\"\",\"pxl_parallax_bg_pos_custom_x\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size\":\"\",\"pxl_parallax_bg_size_laptop\":\"\",\"pxl_parallax_bg_size_tablet_extra\":\"\",\"pxl_parallax_bg_size_tablet\":\"\",\"pxl_parallax_bg_size_mobile_extra\":\"\",\"pxl_parallax_bg_size_mobile\":\"\",\"pxl_parallax_bg_size_custom\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"pxl_parallax_bg_size_custom_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_overlay_img_position\":\"\",\"pxl_overlay_img_position_laptop\":\"\",\"pxl_overlay_img_position_tablet_extra\":\"\",\"pxl_overlay_img_position_tablet\":\"\",\"pxl_overlay_img_position_mobile_extra\":\"\",\"pxl_overlay_img_position_mobile\":\"\",\"pxl_overlay_img_right_position\":\"\",\"pxl_overlay_img_right_position_laptop\":\"\",\"pxl_overlay_img_right_position_tablet_extra\":\"\",\"pxl_overlay_img_right_position_tablet\":\"\",\"pxl_overlay_img_right_position_mobile_extra\":\"\",\"pxl_overlay_img_right_position_mobile\":\"\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"37741dc\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"flex_gap\":{\"column\":\"24\",\"row\":\"24\",\"isLinked\":true,\"unit\":\"px\",\"size\":24},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_wrap_tablet_extra\":\"wrap\",\"flex_gap_laptop\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20}},\"elements\":[{\"id\":\"5855528\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet_extra\":{\"unit\":\"%\",\"size\":48.5,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":48,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"ff281fa\",\"elType\":\"widget\",\"settings\":{\"layout\":\"3\",\"icon_type\":\"image\",\"icon_image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/tooth-1.png\",\"id\":626,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0639\\u0645\\u0648\\u0645\\u06cc\",\"desc\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u06a9\\u0627\\u0645\\u0644 \\u062f\\u0647\\u0627\\u0646 \\u0648 \\u062f\\u0646\\u062f\\u0627\\u0646 \\u0628\\u0631\\u0627\\u06cc \\u0647\\u0631 \\u0644\\u0628\\u062e\\u0646\\u062f\\u06cc \\u0628\\u0627 \\u062c\\u0631\\u0645\\u200c\\u06af\\u06cc\\u0631\\u06cc\\u060c \\u0645\\u0639\\u0627\\u06cc\\u0646\\u0647 \\u0648 \\u0645\\u0648\\u0627\\u0631\\u062f \\u062f\\u06cc\\u06af\\u0631.\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/service\\/general-dentistry\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"title_btn\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"pxl_animate\":\"wow scaleIn\",\"pxl_animate_delay\":\"300\",\"pxl_animate2\":\"wow fadeInUp\",\"pxl_animate_delay2\":\"500\",\"title_color\":\"#10244B\",\"background_color\":\"#FFFFFF\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true},{\"id\":\"62a7ae9\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet_extra\":{\"unit\":\"%\",\"size\":49,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":48.5,\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"c880081\",\"elType\":\"widget\",\"settings\":{\"layout\":\"3\",\"icon_type\":\"image\",\"icon_image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/tooth-2.png\",\"id\":627,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0632\\u06cc\\u0628\\u0627\\u06cc\\u06cc\",\"desc\":\"\\u0632\\u06cc\\u0628\\u0627\\u06cc\\u06cc \\u0644\\u0628\\u062e\\u0646\\u062f \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0628\\u0627 \\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\\u060c \\u0648\\u0646\\u06cc\\u0631\\u0647\\u0627 \\u0648 \\u0645\\u0648\\u0627\\u0631\\u062f \\u062f\\u06cc\\u06af\\u0631 \\u0627\\u0641\\u0632\\u0627\\u06cc\\u0634 \\u062f\\u0647\\u06cc\\u062f.\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/service\\/cosmetic-dentistry\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"title_btn\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"pxl_animate\":\"wow scaleIn\",\"pxl_animate_delay\":\"300\",\"pxl_animate2\":\"wow fadeInUp\",\"pxl_animate_delay2\":\"500\",\"title_color\":\"#10244B\",\"background_color\":\"#FFFFFF\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true},{\"id\":\"964d2d6\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"background_background\":\"classic\",\"background_image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_position\":\"center center\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"width_tablet_extra\":{\"unit\":\"%\",\"size\":48.5,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":48,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"flex_justify_content\":\"center\"},\"elements\":[{\"id\":\"336bf6f\",\"elType\":\"widget\",\"settings\":{\"layout\":\"3\",\"icon_type\":\"image\",\"icon_image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/tooth-3.png\",\"id\":628,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646\",\"desc\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u0645\\u0644\\u0627\\u06cc\\u0645 \\u0648 \\u0633\\u0631\\u06af\\u0631\\u0645\\u200c\\u06a9\\u0646\\u0646\\u062f\\u0647 \\u0627\\u0632 \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646 \\u062a\\u0627 \\u0644\\u0628\\u062e\\u0646\\u062f\\u06cc \\u0633\\u0627\\u0644\\u0645 \\u0648 \\u0634\\u0627\\u062f \\u062f\\u0627\\u0634\\u062a\\u0647 \\u0628\\u0627\\u0634\\u0646\\u062f.\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/service\\/pediatric-dentistry\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"title_btn\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"pxl_animate\":\"wow scaleIn\",\"pxl_animate_delay\":\"300\",\"pxl_animate2\":\"wow fadeInUp\",\"pxl_animate_delay2\":\"500\",\"title_color\":\"#10244B\",\"background_color\":\"#FFFFFF\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true},{\"id\":\"2e4cbee\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet_extra\":{\"unit\":\"%\",\"size\":49,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":48.5,\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"2029233\",\"elType\":\"widget\",\"settings\":{\"layout\":\"3\",\"icon_type\":\"image\",\"icon_image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/tooth-4.png\",\"id\":629,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u062a\\u0631\\u0645\\u06cc\\u0645\\u06cc\",\"desc\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u0634\\u0645\\u0627 \\u0631\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u0631\\u0627\\u062d\\u062a\\u06cc \\u0648 \\u0639\\u0645\\u0644\\u06a9\\u0631\\u062f \\u067e\\u0627\\u06cc\\u062f\\u0627\\u0631 \\u062a\\u0631\\u0645\\u06cc\\u0645 \\u0648 \\u0628\\u0627\\u0632\\u0633\\u0627\\u0632\\u06cc \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u062f.\\n\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/service\\/restorative-dentistry\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"title_btn\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"pxl_animate\":\"wow scaleIn\",\"pxl_animate_delay\":\"300\",\"pxl_animate2\":\"wow fadeInUp\",\"pxl_animate_delay2\":\"500\",\"title_color\":\"#10244B\",\"background_color\":\"#FFFFFF\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true},{\"id\":\"e71413a\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u0647\\u0645\\u0647 \\u062e\\u062f\\u0645\\u0627\\u062a\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/all-services\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"align\":\"center\",\"_margin\":{\"unit\":\"px\",\"top\":\"48\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_button\"}],\"isInner\":false},{\"id\":\"b92d7a4\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#000A5B\",\"padding\":{\"unit\":\"px\",\"top\":\"60\",\"right\":\"15\",\"bottom\":\"60\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"d408d83\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"25\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"c08f676\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0628\\u06cc\\u0645\\u0627\\u0631\\u0627\\u0646 \\u0634\\u0627\\u062f\",\"starting_number\":5000,\"ending_number\":10000,\"suffix\":\"+\",\"pxl_animate\":\"wow fadeInRight\",\"pxl_animate_delay\":\"300\"},\"elements\":[],\"widgetType\":\"pxl_counter\"}],\"isInner\":true},{\"id\":\"3ffca2e\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"25\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"17f3015\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\",\"starting_number\":2000,\"ending_number\":2500,\"suffix\":\"+\",\"pxl_animate\":\"wow fadeInRight\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_counter\"}],\"isInner\":true},{\"id\":\"5163797\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"25\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"344472f\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u06cc\\u0645\\u067e\\u0644\\u0646\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\",\"starting_number\":500,\"ending_number\":800,\"suffix\":\"+\",\"pxl_animate\":\"wow fadeInRight\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_counter\"}],\"isInner\":true},{\"id\":\"7ac7412\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"25\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"62d672d\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0633\\u0627\\u0644 \\u062a\\u062c\\u0631\\u0628\\u0647\",\"ending_number\":15,\"suffix\":\"+\",\"pxl_animate\":\"wow fadeInRight\",\"pxl_animate_delay\":\"600\"},\"elements\":[],\"widgetType\":\"pxl_counter\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"fc38de1\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":50,\"column\":\"50\",\"row\":\"50\",\"isLinked\":true},\"flex_direction_mobile_extra\":\"column\",\"flex_gap_laptop\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"padding\":{\"unit\":\"px\",\"top\":\"120\",\"right\":\"15\",\"bottom\":\"155\",\"left\":\"15\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"0\",\"bottom\":\"70\",\"left\":\"0\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"931cd86\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"c7857de\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0633\\u062a\\u062b\\u0646\\u0627\\u06cc\\u06cc \\u0628\\u0627 \\u0631\\u0648\\u06cc\\u06a9\\u0631\\u062f\\u06cc \\u0634\\u062e\\u0635\\u06cc\",\"sub_title\":\"\\u0686\\u0631\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0645\\u0627 \\u0631\\u0627 \\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u06a9\\u0646\\u06cc\\u062f\",\"h_width\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"602ea93\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0627\\u0631\\u0627\\u0626\\u0647 \\u062f\\u0647\\u0646\\u062f\\u0647 \\u062e\\u062f\\u0645\\u0627\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0645\\u0646\\u0627\\u0633\\u0628 \\u0627\\u0647\\u0645\\u06cc\\u062a \\u062f\\u0627\\u0631\\u062f. \\u0645\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062a\\u062e\\u0635\\u0635\\u06cc\\u060c \\u0641\\u0646\\u0627\\u0648\\u0631\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647 \\u0648 \\u0641\\u0636\\u0627\\u06cc\\u06cc \\u06af\\u0631\\u0645 \\u0631\\u0627 \\u0628\\u0627 \\u0647\\u0645 \\u062a\\u0631\\u06a9\\u06cc\\u0628 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u06cc\\u0645 \\u062a\\u0627 \\u0627\\u0637\\u0645\\u06cc\\u0646\\u0627\\u0646 \\u062d\\u0627\\u0635\\u0644 \\u06a9\\u0646\\u06cc\\u0645 \\u06a9\\u0647 \\u0647\\u0631 \\u0648\\u06cc\\u0632\\u06cc\\u062a \\u0631\\u0627\\u062d\\u062a\\u060c \\u06a9\\u0627\\u0631\\u0622\\u0645\\u062f \\u0648 \\u0645\\u062a\\u0646\\u0627\\u0633\\u0628 \\u0628\\u0627 \\u0646\\u06cc\\u0627\\u0632\\u0647\\u0627\\u06cc \\u0645\\u0646\\u062d\\u0635\\u0631 \\u0628\\u0647 \\u0641\\u0631\\u062f \\u0634\\u0645\\u0627 \\u062e\\u0648\\u0627\\u0647\\u062f \\u0628\\u0648\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"21\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"9f3be1f\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_gap\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"flex_gap_laptop\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_direction_tablet\":\"column\",\"flex_gap_tablet\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"border_color\":\"#0000004D\",\"padding\":{\"unit\":\"px\",\"top\":\"22\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"e4d5e10\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_gap\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"flex_gap_tablet_extra\":{\"column\":\"15\",\"row\":\"15\",\"isLinked\":true,\"unit\":\"px\",\"size\":15}},\"elements\":[{\"id\":\"3f475ce\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"d437b1c\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<h5>\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0628\\u0627\\u062a\\u062c\\u0631\\u0628\\u0647<\\/h5>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"78e6e2b\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062a\\u062e\\u0635\\u0635\\u06cc \\u0628\\u0627 \\u067e\\u0634\\u062a\\u0648\\u0627\\u0646\\u0647 \\u0633\\u0627\\u0644\\u200c\\u0647\\u0627 \\u062a\\u062c\\u0631\\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0642\\u0627\\u0628\\u0644 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"c548350\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"65c31f4\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<h5>\\u062f\\u0631\\u0645\\u0627\\u0646 \\u0634\\u062e\\u0635\\u06cc\\u200c\\u0633\\u0627\\u0632\\u06cc\\u200c\\u0634\\u062f\\u0647<\\/h5>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"24d4409\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647\\u200c\\u0647\\u0627\\u06cc \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u06cc \\u0633\\u0641\\u0627\\u0631\\u0634\\u06cc \\u06a9\\u0647 \\u0645\\u062a\\u0646\\u0627\\u0633\\u0628 \\u0628\\u0627 \\u0644\\u0628\\u062e\\u0646\\u062f \\u0648 \\u0633\\u0628\\u06a9 \\u0632\\u0646\\u062f\\u06af\\u06cc \\u0634\\u0645\\u0627 \\u062a\\u0647\\u06cc\\u0647 \\u0645\\u06cc\\u200c\\u0634\\u0648\\u0646\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"64807c6\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_gap\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"flex_gap_tablet_extra\":{\"column\":\"15\",\"row\":\"15\",\"isLinked\":true,\"unit\":\"px\",\"size\":15}},\"elements\":[{\"id\":\"0cb580b\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"pxl_parallax_bg_position\":\"\",\"pxl_parallax_bg_position_laptop\":\"\",\"pxl_parallax_bg_position_tablet_extra\":\"\",\"pxl_parallax_bg_position_tablet\":\"\",\"pxl_parallax_bg_position_mobile_extra\":\"\",\"pxl_parallax_bg_position_mobile\":\"\",\"pxl_parallax_bg_pos_custom_x\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size\":\"\",\"pxl_parallax_bg_size_laptop\":\"\",\"pxl_parallax_bg_size_tablet_extra\":\"\",\"pxl_parallax_bg_size_tablet\":\"\",\"pxl_parallax_bg_size_mobile_extra\":\"\",\"pxl_parallax_bg_size_mobile\":\"\",\"pxl_parallax_bg_size_custom\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"pxl_parallax_bg_size_custom_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_overlay_img_position\":\"\",\"pxl_overlay_img_position_laptop\":\"\",\"pxl_overlay_img_position_tablet_extra\":\"\",\"pxl_overlay_img_position_tablet\":\"\",\"pxl_overlay_img_position_mobile_extra\":\"\",\"pxl_overlay_img_position_mobile\":\"\",\"pxl_overlay_img_right_position\":\"\",\"pxl_overlay_img_right_position_laptop\":\"\",\"pxl_overlay_img_right_position_tablet_extra\":\"\",\"pxl_overlay_img_right_position_tablet\":\"\",\"pxl_overlay_img_right_position_mobile_extra\":\"\",\"pxl_overlay_img_right_position_mobile\":\"\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"89fbcf5\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<h5>\\u0641\\u0646\\u0627\\u0648\\u0631\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647<\\/h5>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"1a2ce28\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0627\\u0628\\u0632\\u0627\\u0631\\u0647\\u0627\\u06cc \\u0645\\u062f\\u0631\\u0646\\u060c \\u062f\\u0631\\u0645\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0642\\u06cc\\u0642 \\u0648 \\u06a9\\u0627\\u0631\\u0622\\u0645\\u062f \\u0631\\u0627 \\u062a\\u0636\\u0645\\u06cc\\u0646 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0646\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"5c18bec\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"0139430\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<h5>\\u0645\\u0646\\u0627\\u0633\\u0628 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647<\\/h5>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"3e9309c\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0641\\u0636\\u0627\\u06cc\\u06cc \\u062f\\u0644\\u0646\\u0634\\u06cc\\u0646 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646\\u060c \\u0646\\u0648\\u062c\\u0648\\u0627\\u0646\\u0627\\u0646\\u060c \\u0628\\u0632\\u0631\\u06af\\u0633\\u0627\\u0644\\u0627\\u0646 \\u0648 \\u0633\\u0627\\u0644\\u0645\\u0646\\u062f\\u0627\\u0646.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true},{\"id\":\"c0bac5e\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"flex_align_items\":\"center\",\"flex_gap\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"9ce2c5c\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_gap\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"flex_gap_tablet_extra\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"e530c81\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/exceptional2.jpg\",\"id\":607,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":236.80000000000001136868377216160297393798828125,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"300\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"300\",\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"60\",\"isLinked\":false},\"_padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_image\"},{\"id\":\"21bc2cb\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/exceptional1.jpg\",\"id\":606,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":296,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"500\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_image\"}],\"isInner\":true},{\"id\":\"2b3fb22\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"a7be7b9\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/exceptional3.jpg\",\"id\":608,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":399.6000000000000227373675443232059478759765625,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"400\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_image\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false},{\"id\":\"d0d5540\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#4A7CD21A\",\"padding\":{\"unit\":\"px\",\"top\":\"120\",\"right\":\"15\",\"bottom\":\"108\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"15\",\"bottom\":\"70\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"964e490\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"d075595\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u062a\\u0639\\u0647\\u062f \\u0628\\u0647 \\u0644\\u0628\\u062e\\u0646\\u062f \\u0634\\u0645\\u0627\",\"sub_title\":\" \\u0628\\u0627 \\u062a\\u06cc\\u0645 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0645\\u0627 \\u0622\\u0634\\u0646\\u0627 \\u0634\\u0648\\u06cc\\u062f\",\"h_width\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"align\":\"center\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"acd7da4\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p class=\\\"wow fadeInUp animated\\\">\\u062a\\u06cc\\u0645 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0628\\u0627\\u062a\\u062c\\u0631\\u0628\\u0647 \\u0645\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0647\\u0633\\u062a\\u0646\\u062f \\u062a\\u0627 \\u0647\\u0631 \\u0648\\u06cc\\u0632\\u06cc\\u062a \\u0631\\u0627 \\u0645\\u062b\\u0628\\u062a \\u0648 \\u0634\\u062e\\u0635\\u06cc\\u200c\\u0633\\u0627\\u0632\\u06cc\\u200c\\u0634\\u062f\\u0647 \\u06a9\\u0646\\u0646\\u062f. \\u0628\\u0627 \\u062f\\u0633\\u062a\\u0627\\u0646\\u06cc \\u0645\\u0647\\u0631\\u0628\\u0627\\u0646 \\u0648 \\u0642\\u0644\\u0628\\u06cc \\u0645\\u0647\\u0631\\u0628\\u0627\\u0646.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"37\",\"left\":\"0\",\"isLinked\":false},\"align\":\"center\",\"t_width\":{\"unit\":\"px\",\"size\":628,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"8e36ff0\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"9c707a0\",\"elType\":\"widget\",\"settings\":{\"team\":[{\"_id\":\"836b840\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/dentists-img1.jpg\",\"id\":179,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u06a9\\u062a\\u0631 \\u0633\\u0627\\u0631\\u0627 \\u0645\\u06cc\\u0631\\u0632\\u0627\\u0626\\u06cc\",\"position\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0627\\u0631\\u0634\\u062f\"},{\"_id\":\"baa6cb5\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/dentists-img2.jpg\",\"id\":180,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u06a9\\u062a\\u0631 \\u0645\\u0631\\u06cc\\u0645 \\u0622\\u0642\\u0627\\u062c\\u0627\\u0646\\u06cc\",\"position\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0632\\u06cc\\u0628\\u0627\\u06cc\\u06cc\"},{\"_id\":\"3faca8d\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/dentists-img3.jpg\",\"id\":181,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u06a9\\u062a\\u0631 \\u0634\\u0647\\u0627\\u0628 \\u0637\\u0647\\u0645\\u0627\\u0633\\u0628\\u06cc\",\"position\":\"\\u0645\\u062a\\u062e\\u0635\\u0635 \\u0627\\u0637\\u0641\\u0627\\u0644\"},{\"_id\":\"33e5523\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/dentists-img4.jpg\",\"id\":182,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u06a9\\u062a\\u0631 \\u0627\\u0645\\u06cc\\u0631 \\u06a9\\u0631\\u0645\\u0627\\u0646\\u06cc\\u200c\\u0645\\u0642\\u062f\\u0645\",\"position\":\"\\u0628\\u0647\\u062f\\u0627\\u0634\\u062a\\u06a9\\u0627\\u0631 \\u062f\\u0647\\u0627\\u0646 \\u0648 \\u062f\\u0646\\u062f\\u0627\\u0646\"}],\"item_spacer\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"pxl_animate_img\":\"wow zoomInSmall\",\"pxl_animate_img2\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"600\",\"pxl_animate_content\":\"wow fadeInDown\",\"pxl_animate_ct_delay\":\"700\"},\"elements\":[],\"widgetType\":\"pxl_team_grid\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"07e3439\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":30,\"column\":\"30\",\"row\":\"30\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"123\",\"right\":\"15\",\"bottom\":\"120\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_direction_mobile_extra\":\"column\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"0\",\"bottom\":\"70\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"cabeee0\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_mobile_extra\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"92a30c5\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0633\\u0648\\u0627\\u0644\\u0627\\u062a \\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\",\"sub_title\":\"\\u0647\\u0631 \\u0622\\u0646\\u0686\\u0647 \\u06a9\\u0647 \\u0628\\u0627\\u06cc\\u062f \\u0628\\u062f\\u0627\\u0646\\u06cc\\u062f\",\"title_tag\":\"h2\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_heading\"}],\"isInner\":true},{\"id\":\"cb0bd9f\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":68.599999999999994315658113919198513031005859375},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_mobile_extra\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"eff6c82\",\"elType\":\"widget\",\"settings\":{\"active\":0,\"accordion\":[{\"_id\":\"324d3d2\",\"title\":\"\\u0686\\u0646\\u062f \\u0648\\u0642\\u062a \\u06cc\\u06a9\\u0628\\u0627\\u0631 \\u0628\\u0627\\u06cc\\u062f \\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0647 \\u06a9\\u0646\\u0645\\u061f \",\"desc\":\"\\u062a\\u0648\\u0635\\u06cc\\u0647 \\u0645\\u06cc\\u200c\\u0634\\u0648\\u062f \\u0647\\u0631 \\u06f6 \\u0645\\u0627\\u0647 \\u06cc\\u06a9\\u0628\\u0627\\u0631 \\u0628\\u0631\\u0627\\u06cc \\u0645\\u0639\\u0627\\u06cc\\u0646\\u0647 \\u0648 \\u062a\\u0645\\u06cc\\u0632 \\u06a9\\u0631\\u062f\\u0646 \\u0631\\u0648\\u062a\\u06cc\\u0646 \\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u062e\\u0648\\u062f \\u0645\\u0631\\u0627\\u062c\\u0639\\u0647 \\u06a9\\u0646\\u06cc\\u062f\\u060c \\u0645\\u06af\\u0631 \\u0627\\u06cc\\u0646\\u06a9\\u0647 \\u067e\\u0632\\u0634\\u06a9 \\u062a\\u0648\\u0635\\u06cc\\u0647 \\u062f\\u06cc\\u06af\\u0631\\u06cc \\u062f\\u0627\\u0634\\u062a\\u0647 \\u0628\\u0627\\u0634\\u062f. \"},{\"_id\":\"b063b10\",\"title\":\"\\u062f\\u0631 \\u0645\\u0648\\u0627\\u0642\\u0639 \\u0627\\u0648\\u0631\\u0698\\u0627\\u0646\\u0633 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0686\\u0647 \\u0628\\u0627\\u06cc\\u062f \\u0628\\u06a9\\u0646\\u0645\\u061f \",\"desc\":\"\\u0641\\u0648\\u0631\\u0627\\u064b \\u0628\\u0627 \\u0645\\u0637\\u0628 \\u0645\\u0627 \\u062a\\u0645\\u0627\\u0633 \\u0628\\u06af\\u06cc\\u0631\\u06cc\\u062f. \\u0645\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u0645\\u0648\\u0627\\u0631\\u062f\\u06cc \\u0645\\u0627\\u0646\\u0646\\u062f \\u062f\\u0631\\u062f \\u0634\\u062f\\u06cc\\u062f\\u060c \\u0634\\u06a9\\u0633\\u062a\\u06af\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646 \\u06cc\\u0627 \\u062a\\u0648\\u0631\\u0645\\u060c \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u0627\\u0648\\u0631\\u0698\\u0627\\u0646\\u0633\\u06cc \\u062f\\u0631 \\u0647\\u0645\\u0627\\u0646 \\u0631\\u0648\\u0632 \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645. \"},{\"_id\":\"8895a65\",\"title\":\"\\u0622\\u06cc\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u0628\\u0686\\u0647\\u200c\\u0647\\u0627 \\u062e\\u062f\\u0645\\u0627\\u062a\\u06cc \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u062f\\u061f \",\"desc\":\"\\u06a9\\u0627\\u0645\\u0644\\u0627\\u064b! \\u0645\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646 \\u0631\\u0627 \\u0628\\u0627 \\u0645\\u0644\\u0627\\u06cc\\u0645\\u062a \\u0648 \\u0628\\u0647 \\u0634\\u06a9\\u0644\\u06cc \\u062f\\u0648\\u0633\\u062a\\u0627\\u0646\\u0647 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646 \\u062f\\u0631 \\u062a\\u0645\\u0627\\u0645 \\u0633\\u0646\\u06cc\\u0646 \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645. \"},{\"_id\":\"40426f2\",\"title\":\"\\u06af\\u0632\\u06cc\\u0646\\u0647\\u200c\\u0647\\u0627\\u06cc \\u0645\\u0646 \\u0628\\u0631\\u0627\\u06cc \\u062c\\u0627\\u06cc\\u06af\\u0632\\u06cc\\u0646\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u0627\\u0632 \\u062f\\u0633\\u062a \\u0631\\u0641\\u062a\\u0647 \\u0686\\u06cc\\u0633\\u062a\\u061f \",\"desc\":\"\\u0645\\u0627 \\u0628\\u0633\\u062a\\u0647 \\u0628\\u0647 \\u0646\\u06cc\\u0627\\u0632\\u0647\\u0627 \\u0648 \\u062a\\u0631\\u062c\\u06cc\\u062d\\u0627\\u062a \\u0634\\u0645\\u0627\\u060c \\u0627\\u06cc\\u0645\\u067e\\u0644\\u0646\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u060c \\u0628\\u0631\\u06cc\\u062c \\u0648 \\u062f\\u0646\\u062f\\u0627\\u0646 \\u0645\\u0635\\u0646\\u0648\\u0639\\u06cc \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645. \"},{\"_id\":\"0d93a43\",\"title\":\"\\u0622\\u06cc\\u0627 \\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627 \\u0628\\u06cc\\u200c\\u062e\\u0637\\u0631 \\u0627\\u0633\\u062a\\u061f \",\"desc\":\"\\u0628\\u0644\\u0647\\u060c \\u0648\\u0642\\u062a\\u06cc \\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627 \\u062a\\u0648\\u0633\\u0637 \\u06cc\\u06a9 \\u0645\\u062a\\u062e\\u0635\\u0635 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0627\\u0646\\u062c\\u0627\\u0645 \\u0634\\u0648\\u062f\\u060c \\u0627\\u06cc\\u0645\\u0646 \\u0648 \\u0645\\u0624\\u062b\\u0631 \\u0627\\u0633\\u062a \\u0648 \\u0646\\u062a\\u0627\\u06cc\\u062c \\u0622\\u0646 \\u0645\\u0627\\u0646\\u062f\\u06af\\u0627\\u0631 \\u062e\\u0648\\u0627\\u0647\\u062f \\u0628\\u0648\\u062f. \"}],\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"300\"},\"elements\":[],\"widgetType\":\"pxl_accordion\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"faed713\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#4A7CD21A\",\"padding\":{\"unit\":\"px\",\"top\":\"115\",\"right\":\"0\",\"bottom\":\"105\",\"left\":\"0\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"content_width\":\"full\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"15\",\"bottom\":\"70\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"ba2fc12\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"15\",\"bottom\":\"0\",\"left\":\"15\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"cd71716\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646 \\u0631\\u0627\\u0636\\u06cc \\u0645\\u0627\",\"sub_title\":\"\\u0646\\u0638\\u0631\\u0627\\u062a \\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646\",\"h_width\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"align\":\"center\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"17efbb0\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p class=\\\"wow fadeInUp animated\\\">\\u0628\\u0647 \\u0647\\u0632\\u0627\\u0631\\u0627\\u0646 \\u0628\\u06cc\\u0645\\u0627\\u0631 \\u0631\\u0627\\u0636\\u06cc \\u0628\\u067e\\u06cc\\u0648\\u0646\\u062f\\u06cc\\u062f \\u06a9\\u0647 \\u0628\\u0631\\u0627\\u06cc \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u0645\\u0644\\u0627\\u06cc\\u0645 \\u0648 \\u062a\\u062e\\u0635\\u0635\\u06cc \\u0648 \\u0644\\u0628\\u062e\\u0646\\u062f\\u0647\\u0627\\u06cc \\u0632\\u06cc\\u0628\\u0627 \\u0628\\u0647 \\u0645\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0646\\u062f. \\u062a\\u062c\\u0631\\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0628\\u06cc\\u200c\\u0646\\u0638\\u06cc\\u0631 \\u0634\\u0645\\u0627 \\u0627\\u0632 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0634\\u0631\\u0648\\u0639 \\u0645\\u06cc\\u200c\\u0634\\u0648\\u062f!<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"50\",\"left\":\"0\",\"isLinked\":false},\"align\":\"center\",\"t_width\":{\"unit\":\"px\",\"size\":628,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"6356f20\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"a06f7d2\",\"elType\":\"widget\",\"settings\":{\"layout\":\"2\",\"testimonial\":[],\"testimonial_lv2\":[{\"_id\":\"8f77d95\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/author1.jpg\",\"id\":92,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0645\\u06cc\\u06a9\\u0627\\u0626\\u06cc\\u0644 \\u0634\\u0647\\u0627\\u0628\\u06cc\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0645\\u0646 \\u0647\\u0645\\u06cc\\u0634\\u0647 \\u0627\\u0632 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0647 \\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0646\\u06af\\u0631\\u0627\\u0646 \\u0628\\u0648\\u062f\\u0647\\u200c\\u0627\\u0645\\u060c \\u0627\\u0645\\u0627 \\u06a9\\u0627\\u0631\\u06a9\\u0646\\u0627\\u0646 \\u0628\\u0627\\u0639\\u062b \\u0634\\u062f\\u0646\\u062f \\u06a9\\u0627\\u0645\\u0644\\u0627\\u064b \\u0627\\u062d\\u0633\\u0627\\u0633 \\u0631\\u0627\\u062d\\u062a\\u06cc \\u06a9\\u0646\\u0645. \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u0645\\u0644\\u0627\\u06cc\\u0645 \\u0648 \\u062a\\u0648\\u062c\\u0647 \\u0622\\u0646\\u0647\\u0627 \\u0628\\u0647 \\u062c\\u0632\\u0626\\u06cc\\u0627\\u062a \\u0648\\u0627\\u0642\\u0639\\u0627\\u064b \\u0628\\u0631\\u062c\\u0633\\u062a\\u0647 \\u0627\\u0633\\u062a.\\\"\"},{\"_id\":\"4c80bef\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img3.jpg\",\"id\":218,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0631\\u0627\\u0645\\u06cc\\u0646 \\u0633\\u0647\\u0631\\u0627\\u0628\\u06cc\\u200c\\u0646\\u0698\\u0627\\u062f\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0645\\u0646 \\u0648 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647\\u200c\\u0627\\u0645 \\u0633\\u0627\\u0644\\u200c\\u0647\\u0627\\u0633\\u062a \\u06a9\\u0647 \\u0628\\u0647 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0645\\u06cc\\u200c\\u0622\\u06cc\\u0645. \\u062e\\u062f\\u0645\\u0627\\u062a \\u0641\\u0648\\u0642\\u200c\\u0627\\u0644\\u0639\\u0627\\u062f\\u0647 \\u0627\\u0633\\u062a \\u0648 \\u062a\\u06cc\\u0645 \\u0645\\u0627 \\u0647\\u0645\\u06cc\\u0634\\u0647 \\u062a\\u0645\\u0627\\u0645 \\u062a\\u0644\\u0627\\u0634 \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u062f \\u062a\\u0627 \\u0645\\u0637\\u0645\\u0626\\u0646 \\u0634\\u0648\\u062f \\u0645\\u0627 \\u0631\\u0627\\u0636\\u06cc \\u0647\\u0633\\u062a\\u06cc\\u0645 \\u0648 \\u0628\\u0647 \\u062e\\u0648\\u0628\\u06cc \\u0627\\u0632 \\u0645\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u0645\\u06cc\\u200c\\u0634\\u0648\\u062f.\\\"\"},{\"_id\":\"dd49806\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img4.jpg\",\"id\":219,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0622\\u0631\\u0627\\u062f \\u0627\\u0645\\u0627\\u0645\\u06cc\\u200c\\u0641\\u0631\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0645\\u0646 \\u0628\\u0631\\u0627\\u06cc \\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc\\u0645 \\u0628\\u0647 \\u0645\\u0637\\u0628 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0647 \\u06a9\\u0631\\u062f\\u0645 \\u0648 \\u0628\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f \\u0628\\u0647 \\u0646\\u0641\\u0633\\u06cc \\u06a9\\u0627\\u0645\\u0644\\u0627\\u064b \\u062c\\u062f\\u06cc\\u062f \\u0622\\u0646\\u062c\\u0627 \\u0631\\u0627 \\u062a\\u0631\\u06a9 \\u06a9\\u0631\\u062f\\u0645. \\u0646\\u062a\\u0627\\u06cc\\u062c \\u0634\\u06af\\u0641\\u062a\\u200c\\u0627\\u0646\\u06af\\u06cc\\u0632 \\u0628\\u0648\\u062f \\u0648 \\u06a9\\u0627\\u0631\\u06a9\\u0646\\u0627\\u0646\\u060c \\u0627\\u06cc\\u0646 \\u062a\\u062c\\u0631\\u0628\\u0647 \\u0631\\u0627 \\u0628\\u0647 \\u062a\\u062c\\u0631\\u0628\\u0647\\u200c\\u0627\\u06cc \\u0622\\u0631\\u0627\\u0645\\u0634\\u200c\\u0628\\u062e\\u0634 \\u062a\\u0628\\u062f\\u06cc\\u0644 \\u06a9\\u0631\\u062f\\u0646\\u062f.\\\"\"},{\"_id\":\"e16c281\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img5.jpg\",\"id\":220,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0633\\u06cc\\u0646\\u0627 \\u0641\\u0647\\u06cc\\u0645\\u06cc\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\\"\\u0622\\u0646\\u0647\\u0627 \\u062d\\u0631\\u0641\\u0647\\u200c\\u0627\\u06cc\\u060c \\u062f\\u0648\\u0633\\u062a\\u0627\\u0646\\u0647 \\u0648 \\u0648\\u0627\\u0642\\u0639\\u0627\\u064b \\u0628\\u0647 \\u0633\\u0644\\u0627\\u0645\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u0634\\u0645\\u0627 \\u0627\\u0647\\u0645\\u06cc\\u062a \\u0645\\u06cc\\u200c\\u062f\\u0647\\u0646\\u062f. \\u0645\\u0646 \\u06a9\\u0627\\u0645\\u0644\\u0627\\u064b \\u0628\\u0647 \\u0622\\u0646\\u0647\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f \\u062f\\u0627\\u0631\\u0645 \\u0648 \\u0622\\u0646\\u0647\\u0627 \\u0631\\u0627 \\u0628\\u0647 \\u0647\\u0631 \\u06a9\\u0633\\u06cc \\u06a9\\u0647 \\u0628\\u0647 \\u062f\\u0646\\u0628\\u0627\\u0644 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u0639\\u0627\\u0644\\u06cc \\u0627\\u0633\\u062a \\u062a\\u0648\\u0635\\u06cc\\u0647 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0645.\\\"\"},{\"_id\":\"99106f0\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img6.jpg\",\"id\":221,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0634\\u0627\\u0647\\u0648 \\u0622\\u0631\\u06cc\\u0627\\u0646\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0628\\u062f\\u0648\\u0646 \\u0634\\u06a9 \\u0628\\u0647\\u062a\\u0631\\u06cc\\u0646 \\u062a\\u062c\\u0631\\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u06a9\\u0647 \\u062a\\u0627 \\u0628\\u0647 \\u062d\\u0627\\u0644 \\u062f\\u0627\\u0634\\u062a\\u0647\\u200c\\u0627\\u0645. \\u0647\\u0645\\u0647 \\u0686\\u06cc\\u0632 \\u0627\\u0632 \\u062a\\u0639\\u06cc\\u06cc\\u0646 \\u0648\\u0642\\u062a \\u062a\\u0627 \\u062f\\u0631\\u0645\\u0627\\u0646 \\u0631\\u0648\\u0627\\u0646\\u060c \\u0631\\u0627\\u062d\\u062a \\u0648 \\u0628\\u0627 \\u0633\\u0644\\u06cc\\u0642\\u0647 \\u0634\\u062e\\u0635\\u06cc \\u0627\\u0646\\u062c\\u0627\\u0645 \\u0634\\u062f.\\\"\"},{\"_id\":\"69170d9\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img7.jpg\",\"id\":222,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u067e\\u06cc\\u0645\\u0627\\u0646 \\u0627\\u06a9\\u0628\\u0631\\u06cc\\u0627\\u0646\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0645\\u0646 \\u0647\\u0631\\u06af\\u0632 \\u062f\\u0631 \\u0645\\u0637\\u0628 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u062a\\u0627 \\u0627\\u06cc\\u0646 \\u062d\\u062f \\u0627\\u062d\\u0633\\u0627\\u0633 \\u0631\\u0627\\u062d\\u062a\\u06cc \\u0646\\u06a9\\u0631\\u062f\\u0647 \\u0628\\u0648\\u062f\\u0645. \\u062a\\u06cc\\u0645 \\u0622\\u0646\\u0647\\u0627 \\u0628\\u0633\\u06cc\\u0627\\u0631 \\u0645\\u0647\\u0631\\u0628\\u0627\\u0646\\u060c \\u062d\\u0631\\u0641\\u0647\\u200c\\u0627\\u06cc \\u0648 \\u062f\\u0642\\u06cc\\u0642 \\u0627\\u0633\\u062a. \\u0622\\u0646\\u0647\\u0627 \\u0647\\u0645\\u06cc\\u0634\\u0647 \\u0647\\u0645\\u0647 \\u0686\\u06cc\\u0632 \\u0631\\u0627 \\u0628\\u0627 \\u062c\\u0632\\u0626\\u06cc\\u0627\\u062a \\u062a\\u0648\\u0636\\u06cc\\u062d \\u0645\\u06cc\\u200c\\u062f\\u0647\\u0646\\u062f \\u0648 \\u0645\\u0646 \\u0647\\u0631 \\u0628\\u0627\\u0631 \\u0628\\u0627 \\u0644\\u0628\\u062e\\u0646\\u062f \\u0622\\u0646\\u062c\\u0627 \\u0631\\u0627 \\u062a\\u0631\\u06a9 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0645!\\\"\"},{\"_id\":\"2fd1679\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img8.jpg\",\"id\":223,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u062f\\u0627\\u0646\\u06cc\\u0627\\u0644 \\u0628\\u06cc\\u06af\\u06cc\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u062a\\u062c\\u0631\\u0628\\u0647 \\u0645\\u0646 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0641\\u0648\\u0642\\u200c\\u0627\\u0644\\u0639\\u0627\\u062f\\u0647 \\u0628\\u0648\\u062f\\u0647 \\u0627\\u0633\\u062a! \\u06a9\\u0627\\u0631\\u06a9\\u0646\\u0627\\u0646 \\u062e\\u0648\\u0634\\u200c\\u0628\\u0631\\u062e\\u0648\\u0631\\u062f \\u0647\\u0633\\u062a\\u0646\\u062f\\u060c \\u0645\\u0637\\u0628 \\u0628\\u06cc\\u200c\\u0639\\u06cc\\u0628 \\u0648 \\u0646\\u0642\\u0635 \\u0627\\u0633\\u062a \\u0648 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627 \\u062f\\u0631\\u062c\\u0647 \\u06cc\\u06a9 \\u0647\\u0633\\u062a\\u0646\\u062f. \\u0645\\u0646 \\u0647\\u0645\\u06cc\\u0634\\u0647 \\u0627\\u062d\\u0633\\u0627\\u0633 \\u0622\\u0631\\u0627\\u0645\\u0634 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0645 \\u0648 \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc\\u0645 \\u0647\\u0631\\u06af\\u0632 \\u0628\\u0647\\u062a\\u0631 \\u0627\\u0632 \\u0627\\u06cc\\u0646 \\u0628\\u0647 \\u0646\\u0638\\u0631 \\u0646\\u0631\\u0633\\u06cc\\u062f\\u0647\\u200c\\u0627\\u0646\\u062f!\\\"\"},{\"_id\":\"018e3c6\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img9.jpg\",\"id\":224,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0633\\u0627\\u0645\\u0627\\u0646 \\u0628\\u06cc\\u0631\\u0627\\u0645\\u06cc\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0627\\u0632 \\u0647\\u0645\\u0627\\u0646 \\u0644\\u062d\\u0638\\u0647 \\u0648\\u0631\\u0648\\u062f\\u060c \\u0627\\u062d\\u0633\\u0627\\u0633 \\u0631\\u0627\\u062d\\u062a\\u06cc \\u06a9\\u0631\\u062f\\u0645. \\u06a9\\u0627\\u0631\\u06a9\\u0646\\u0627\\u0646 \\u0637\\u0648\\u0631\\u06cc \\u0631\\u0641\\u062a\\u0627\\u0631 \\u06a9\\u0631\\u062f\\u0646\\u062f \\u06a9\\u0647 \\u0627\\u062d\\u0633\\u0627\\u0633 \\u06a9\\u0646\\u0645 \\u0645\\u062b\\u0644 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647\\u200c\\u0627\\u0645 \\u0647\\u0633\\u062a\\u0645 \\u0648 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u06cc \\u06a9\\u0647 \\u062f\\u0631\\u06cc\\u0627\\u0641\\u062a \\u06a9\\u0631\\u062f\\u0645 \\u0627\\u0633\\u062a\\u062b\\u0646\\u0627\\u06cc\\u06cc \\u0628\\u0648\\u062f. \\u0627\\u0632 \\u0644\\u0628\\u062e\\u0646\\u062f\\u0645 \\u062e\\u06cc\\u0644\\u06cc \\u0631\\u0627\\u0636\\u06cc \\u0647\\u0633\\u062a\\u0645. \\u0628\\u0627\\u0628\\u062a \\u0647\\u0645\\u0647 \\u0686\\u06cc\\u0632 \\u0645\\u0645\\u0646\\u0648\\u0646\\u0645!\\\"\"}],\"col_xxl\":\"5\",\"center\":\"true\",\"pagination\":\"true\",\"infinite\":\"true\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"600\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"-240\",\"bottom\":\"0\",\"left\":\"-240\",\"isLinked\":false},\"col_md\":\"2\",\"_margin_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_testimonial_carousel\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"d1c1cbb\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":30,\"column\":\"30\",\"row\":\"30\",\"isLinked\":true},\"flex_align_items\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#4A7CD2\",\"padding\":{\"unit\":\"px\",\"top\":\"50\",\"right\":\"15\",\"bottom\":\"50\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"8418409\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":60},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"0d1c6c2\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0622\\u0645\\u0627\\u062f\\u0647 \\u0631\\u0632\\u0631\\u0648 \\u0646\\u0648\\u0628\\u062a \\u062e\\u0648\\u062f \\u0647\\u0633\\u062a\\u06cc\\u062f\\u061f\",\"title_color\":\"#FFFFFF\",\"title_typography_typography\":\"custom\",\"title_typography_font_size\":{\"unit\":\"px\",\"size\":32,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"3cf7c4b\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0647\\u0645\\u06cc\\u0646 \\u0627\\u0645\\u0631\\u0648\\u0632 \\u0628\\u0627 \\u0645\\u0627 \\u062a\\u0645\\u0627\\u0633 \\u0628\\u06af\\u06cc\\u0631\\u06cc\\u062f \\u062a\\u0627 \\u0648\\u0642\\u062a \\u0645\\u0644\\u0627\\u0642\\u0627\\u062a \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0631\\u0632\\u0631\\u0648 \\u06a9\\u0646\\u06cc\\u062f \\u0648 \\u0627\\u0648\\u0644\\u06cc\\u0646 \\u0642\\u062f\\u0645 \\u0631\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u062f\\u0627\\u0634\\u062a\\u0646 \\u0644\\u0628\\u062e\\u0646\\u062f\\u06cc \\u0633\\u0627\\u0644\\u0645\\u200c\\u062a\\u0631 \\u0628\\u0631\\u062f\\u0627\\u0631\\u06cc\\u062f.<\\/p>\",\"text_color\":\"#FFFFFF99\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"97ded05\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":40},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"b7a7381\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0631\\u0632\\u0631\\u0648 \\u0646\\u0648\\u0628\\u062a\",\"align\":\"left\",\"border_type\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"border_color\":\"#FFFFFF80\",\"border_color_hover\":\"#10244B\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/booking\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"}},\"elements\":[],\"widgetType\":\"pxl_button\"}],\"isInner\":true}],\"isInner\":false}]\";s:10:\"_edit_lock\";s:12:\"1758147530:1\";s:10:\"_edit_last\";s:1:\"1\";s:22:\"_elementor_page_assets\";a:2:{s:7:\"scripts\";a:14:{i:0;s:18:\"elementor-frontend\";i:1;s:6:\"swiper\";i:2;s:19:\"elementor-waypoints\";i:3;s:16:\"jquery-numerator\";i:4;s:11:\"pxl-counter\";i:5;s:14:\"dentia-counter\";i:6;s:4:\"tilt\";i:7;s:12:\"pxl-tweenmax\";i:8;s:17:\"pxl-counter-slide\";i:9;s:12:\"imagesloaded\";i:10;s:7:\"isotope\";i:11;s:13:\"pxl-post-grid\";i:12;s:16:\"dentia-accordion\";i:13;s:10:\"pxl-swiper\";}s:6:\"styles\";a:2:{i:0;s:20:\"e-animation-fadeInUp\";i:1;s:8:\"e-swiper\";}}s:14:\"_elementor_css\";a:6:{s:4:\"time\";i:1758109738;s:5:\"fonts\";a:0:{}s:5:\"icons\";a:2:{i:0;s:0:\"\";i:1;s:8:\"fa-solid\";}s:20:\"dynamic_elements_ids\";a:0:{}s:6:\"status\";s:4:\"file\";i:0;s:0:\"\";}s:24:\"_elementor_element_cache\";s:90303:\"{\"timeout\":1758208738,\"value\":{\"content\":\"<div class=\\\"elementor-element elementor-element-5161d23 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"5161d23\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;slideshow&quot;,&quot;background_slideshow_gallery&quot;:[{&quot;id&quot;:1485,&quot;url&quot;:&quot;https:\\\\\\/\\\\\\/dentia.sunthemes.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/2025\\\\\\/08\\\\\\/1-min-e1758004018967.jpg&quot;},{&quot;id&quot;:1486,&quot;url&quot;:&quot;https:\\\\\\/\\\\\\/dentia.sunthemes.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/2025\\\\\\/08\\\\\\/2-min-e1758004028449.jpg&quot;}],&quot;background_slideshow_lazyload&quot;:&quot;yes&quot;,&quot;background_slideshow_slide_transition&quot;:&quot;slide_right&quot;,&quot;background_slideshow_loop&quot;:&quot;yes&quot;,&quot;background_slideshow_slide_duration&quot;:5000,&quot;background_slideshow_transition_duration&quot;:500}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-0b31933 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"0b31933\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"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\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImMxNjJkYzciLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0IjoiXHUwNjMxXHUwNjMyXHUwNjMxXHUwNjQ4IFx1MDY0Nlx1MDY0OFx1MDYyOFx1MDYyYSIsImxpbmsiOnsidXJsIjoiaHR0cHM6XC9cL2RlbnRpYS5zdW50aGVtZXMuaXJcL2Jvb2tpbmdcLyIsImlzX2V4dGVybmFsIjoiIiwibm9mb2xsb3ciOiIiLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9LCJidG5fYmdfY29sb3IiOiIjMDIwMTAxMDAiLCJib3JkZXJfdHlwZSI6InNvbGlkIiwiYm9yZGVyX3dpZHRoIjp7InVuaXQiOiJweCIsInRvcCI6IjEiLCJyaWdodCI6IjEiLCJib3R0b20iOiIxIiwibGVmdCI6IjEiLCJpc0xpbmtlZCI6dHJ1ZX0sImJvcmRlcl9jb2xvciI6IiNGRkZGRkYiLCJjb2xvcl9ob3ZlciI6IiNGRkZGRkYiLCJidG5fYmdfY29sb3JfaG92ZXIiOiIjMDAwQTVCIiwiYnRuX2JnX2NvbG9yX2FjdGl2ZSI6IiMwMDBBNUIiLCJidG5fYmdfY29sb3JfZm9jdXMiOiIjMDAwQTVCIiwiYm9yZGVyX2NvbG9yX2hvdmVyIjoiIzAwMEE1QiIsIl9tYXJnaW4iOnsidW5pdCI6InB4IiwidG9wIjoiMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjMwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9LCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNTAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9idXR0b24ifQ==\\\"]<div class=\\\"elementor-element elementor-element-9d1bee4 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none elementor-invisible e-con e-child \\\" data-id=\\\"9d1bee4\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;animation&quot;:&quot;fadeInUp&quot;,&quot;animation_delay&quot;:600}\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImFjNmI2Y2YiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGRpdiBjbGFzcz1cIm1lLTNcIj5cdTA2MzFcdTA2MmFcdTA2MjhcdTA2NDdcdTIwMGNcdTA2MjhcdTA2NDZcdTA2MmZcdTA2Y2MgXHUwNmFmXHUwNjQ4XHUwNmFmXHUwNjQ0PFwvZGl2PiIsInRleHRfY29sb3IiOiIjRjhGOUZBIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjA1YjM1Y2YiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGRpdiBjbGFzcz1cIm1lLTNcIj48ZGl2IGNsYXNzPVwibWUtM1wiPjUuMDxcL2Rpdj48XC9kaXY+IiwidGV4dF9jb2xvciI6IiNGOEY5RkEifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX3RleHRfZWRpdG9yIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImJkNTEzYmYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpY29ucyI6W3siX2lkIjoiZTFlZjdiYyIsInB4bF9pY29uIjp7InZhbHVlIjoiZmFzIGZhLXN0YXIiLCJsaWJyYXJ5IjoiZmEtc29saWQifX0seyJweGxfaWNvbiI6eyJ2YWx1ZSI6ImZhcyBmYS1zdGFyIiwibGlicmFyeSI6ImZhLXNvbGlkIn0sIl9pZCI6IjFmYmYxNGUifSx7InB4bF9pY29uIjp7InZhbHVlIjoiZmFzIGZhLXN0YXIiLCJsaWJyYXJ5IjoiZmEtc29saWQifSwiX2lkIjoiOThlZDc3ZCJ9LHsicHhsX2ljb24iOnsidmFsdWUiOiJmYXMgZmEtc3RhciIsImxpYnJhcnkiOiJmYS1zb2xpZCJ9LCJfaWQiOiIxNjg1YTdiIn0seyJweGxfaWNvbiI6eyJ2YWx1ZSI6ImZhcyBmYS1zdGFyIiwibGlicmFyeSI6ImZhLXNvbGlkIn0sIl9pZCI6IjY3YWE1NzMifV0sImNvbG9yIjoiI0ZFQzQyQyIsImljb25fZm9udF9zaXplIjp7InVuaXQiOiJweCIsInNpemUiOjE1LCJzaXplcyI6W119LCJpY29uX3NwYWNlIjp7InVuaXQiOiJweCIsInNpemUiOjIsInNpemVzIjpbXX19LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfaWNvbiJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjY1MzE3MDMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGRpdiBjbGFzcz1cIm1lLTNcIj48ZGl2IGNsYXNzPVwibWUtM1wiPjxkaXYgY2xhc3M9XCJtZS0zXCI+XHUwNjI4XHUwNjMxIFx1MDYyN1x1MDYzM1x1MDYyN1x1MDYzMyBcdTA2ZjJcdTA2ZjMgXHUwNjQ3XHUwNjMyXHUwNjI3XHUwNjMxIFx1MDY0Nlx1MDY0Mlx1MDYyZiBcdTA2NDggXHUwNjI4XHUwNjMxXHUwNjMxXHUwNjMzXHUwNmNjPFwvZGl2PjxcL2Rpdj48XC9kaXY+IiwidGV4dF9jb2xvciI6IiNGOEY5RkEifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX3RleHRfZWRpdG9yIn0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-af13e9f e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"af13e9f\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-f6f14ff e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"f6f14ff\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-2f08b27 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"2f08b27\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjM2MjdjMGEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIyIiwicHhsX2ljb24iOnsidmFsdWUiOiJmYXMgZmEtcGhvbmUtYWx0IiwibGlicmFyeSI6ImZhLXNvbGlkIn0sInRpdGxlIjoiXHUwNjI4XHUwNjQ3IFx1MDYyZVx1MDYyZlx1MDY0NVx1MDYyN1x1MDYyYSBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDZcdTA2N2VcdTA2MzJcdTA2MzRcdTA2YTlcdTA2Y2MgXHUwNjQ2XHUwNmNjXHUwNjI3XHUwNjMyIFx1MDYyZlx1MDYyN1x1MDYzMVx1MDZjY1x1MDYyZlx1MDYxZiIsImRlc2MiOiJcdTA2MmFcdTA2NDVcdTA2MjdcdTA2MzM6IDAyMTEyMzQ1Njc4OSIsInRpdGxlX2NvbG9yIjoiI0ZGRkZGRiIsImljb25fZm9udF9zaXplIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX2hlaWdodCI6eyJ1bml0IjoicHgiLCJzaXplIjo2MCwic2l6ZXMiOltdfSwiZGVzY19jb2xvciI6IiNGRkZGRkY5OSIsImljb25fY29sb3IiOiIjNEE3REMyIiwiaWNvbl9iZ19jb2xvciI6IiMwMjAxMDEwMCIsInRpdGxlX2JvdHRvbSI6eyJ1bml0IjoicHgiLCJzaXplIjowLCJzaXplcyI6W119LCJpbm5lcl9zcGFjZSI6eyJ1bml0IjoicHgiLCJzaXplIjoxNSwic2l6ZXMiOltdfSwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIzMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9fSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ljb25fYm94In0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-4a79de0 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"4a79de0\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-91829d8 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"91829d8\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImI2MzgzYzQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIyIiwicHhsX2ljb24iOnsidmFsdWUiOiJmYXMgZmEtY2xvY2siLCJsaWJyYXJ5IjoiZmEtc29saWQifSwidGl0bGUiOiJcdTA2MzNcdTA2MjdcdTA2MzlcdTA2MjdcdTA2MmEgXHUwNmE5XHUwNjI3XHUwNjMxXHUwNmNjIiwiZGVzYyI6Ilx1MDY0N1x1MDYzMSBcdTA2MzFcdTA2NDhcdTA2MzIgXHUwNjI3XHUwNjMyIDA4OjAwIFx1MDYyYVx1MDYyNyAyMDowMCIsInRpdGxlX2NvbG9yIjoiI0ZGRkZGRiIsImljb25fZm9udF9zaXplIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX2hlaWdodCI6eyJ1bml0IjoicHgiLCJzaXplIjo2MCwic2l6ZXMiOltdfSwiZGVzY19jb2xvciI6IiNGRkZGRkY5OSIsImljb25fY29sb3IiOiIjNEE3REMyIiwiaWNvbl9iZ19jb2xvciI6IiMwMjAxMDEwMCIsInRpdGxlX2JvdHRvbSI6eyJ1bml0IjoicHgiLCJzaXplIjowLCJzaXplcyI6W119LCJpbm5lcl9zcGFjZSI6eyJ1bml0IjoicHgiLCJzaXplIjoxNSwic2l6ZXMiOltdfSwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIzMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9LCJfZWxlbWVudF93aWR0aF9tb2JpbGUiOiJpbmhlcml0In0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9pY29uX2JveCJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-6a5100f e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"6a5100f\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-4eaeb3c e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"4eaeb3c\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImZmMzhkNmQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIyIiwicHhsX2ljb24iOnsidmFsdWUiOiJmYXMgZmEtZW52ZWxvcGUiLCJsaWJyYXJ5IjoiZmEtc29saWQifSwidGl0bGUiOiJcdTA2MjdcdTA2Y2NcdTA2NDVcdTA2Y2NcdTA2NDQgXHUwNjQ1XHUwNjI3IiwiZGVzYyI6ImNvbnRhY3RAZGVudGlhY2xpbmljLmNvbSIsInRpdGxlX2NvbG9yIjoiI0ZGRkZGRiIsImljb25fZm9udF9zaXplIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX2hlaWdodCI6eyJ1bml0IjoicHgiLCJzaXplIjo2MCwic2l6ZXMiOltdfSwiZGVzY19jb2xvciI6IiNGRkZGRkY5OSIsImljb25fY29sb3IiOiIjNEE3REMyIiwiaWNvbl9iZ19jb2xvciI6IiMwMjAxMDEwMCIsInRpdGxlX2JvdHRvbSI6eyJ1bml0IjoicHgiLCJzaXplIjowLCJzaXplcyI6W119LCJpbm5lcl9zcGFjZSI6eyJ1bml0IjoicHgiLCJzaXplIjoxNSwic2l6ZXMiOltdfSwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIzMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9LCJfZWxlbWVudF93aWR0aF9tb2JpbGUiOiJpbmhlcml0In0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9pY29uX2JveCJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-15b34f8 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"15b34f8\\\" data-element_type=\\\"container\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-98ca70d e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"98ca70d\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-43ff422 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"43ff422\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImI2OThiYjQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2Fib3V0LWltZzEuanBnIiwiaWQiOjQ2Mywic2l6ZSI6IiIsImFsdCI6IiIsInNvdXJjZSI6ImxpYnJhcnkifSwiaW1hZ2VfdHlwZSI6ImJnIiwiaW1hZ2VfaGVpZ2h0Ijp7InVuaXQiOiJweCIsInNpemUiOjM5OSwic2l6ZXMiOltdfSwiYm9yZGVyX3JhZGl1cyI6eyJ1bml0IjoicHgiLCJ0b3AiOiIyMCIsInJpZ2h0IjoiMjAiLCJib3R0b20iOiIyMCIsImxlZnQiOiIyMCIsImlzTGlua2VkIjp0cnVlfSwicGFyYWxsYXhfdmFsdWUiOiI0MCIsIm1heF90aWx0IjoiMTAiLCJzcGVlZF90aWx0IjoiNDAwIiwicGVyc3BlY3RpdmVfdGlsdCI6IjEwMDAiLCJweGxfYW5pbWF0ZSI6IndvdyB6b29tSW5TbWFsbCIsInB4bF9hbmltYXRlX2RlbGF5IjoiMzAwIiwicHhsX2FuaW1hdGVfaW1nIjoid293IHNjYWxlSW4iLCJweGxfYW5pbWF0ZV9pbWdfZGVsYXkiOiIzMDAifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ltYWdlIn0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-4c3a639 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"4c3a639\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjNhMjZlY2QiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2Fib3V0LWltZzIuanBnIiwiaWQiOjQ2NCwic2l6ZSI6IiIsImFsdCI6IiIsInNvdXJjZSI6ImxpYnJhcnkifSwiaW1hZ2VfdHlwZSI6ImJnIiwiaW1hZ2VfaGVpZ2h0Ijp7InVuaXQiOiJweCIsInNpemUiOjM5OSwic2l6ZXMiOltdfSwiYm9yZGVyX3JhZGl1cyI6eyJ1bml0IjoicHgiLCJ0b3AiOiIyMCIsInJpZ2h0IjoiMjAiLCJib3R0b20iOiIyMCIsImxlZnQiOiIyMCIsImlzTGlua2VkIjp0cnVlfSwicGFyYWxsYXhfdmFsdWUiOiI0MCIsIm1heF90aWx0IjoiMTAiLCJzcGVlZF90aWx0IjoiNDAwIiwicGVyc3BlY3RpdmVfdGlsdCI6IjEwMDAiLCJweGxfYW5pbWF0ZSI6IndvdyB6b29tSW5TbWFsbCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNTAwIiwicHhsX2FuaW1hdGVfaW1nIjoid293IHNjYWxlSW4iLCJweGxfYW5pbWF0ZV9pbWdfZGVsYXkiOiI1MDAifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ltYWdlIn0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-9dd8e84 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"9dd8e84\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImIwMjk3YmYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDY0NVx1MDYyYVx1MDYyZVx1MDYzNVx1MDYzNVx1MDYyN1x1MDY0NiBcdTA2NDggXHUwNjJhXHUwNjM5XHUwNjI3XHUwNjQ0XHUwNmNjIFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2MzRcdTA2MmVcdTA2MzVcdTA2Y2MiLCJzdWJfdGl0bGUiOiJcdTA2MmZcdTA2MzFcdTA2MjhcdTA2MjdcdTA2MzFcdTA2NDcgXHUwNjQ1XHUwNjI3IiwiaF93aWR0aCI6eyJ1bml0IjoiJSIsInNpemUiOjgwLCJzaXplcyI6W119LCJoX3dpZHRoX2xhcHRvcCI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJoX3dpZHRoX3RhYmxldF9leHRyYSI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJoX3dpZHRoX3RhYmxldCI6eyJ1bml0IjoiJSIsInNpemUiOjEwMCwic2l6ZXMiOltdfSwiaF93aWR0aF9tb2JpbGVfZXh0cmEiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF9tb2JpbGUiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwidGl0bGVfdGFnIjoiaDIiLCJzdWJfdGl0bGVfc3BhY2VfYm90dG9tIjp7InVuaXQiOiJweCIsInNpemUiOjE3LCJzaXplcyI6W119LCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIyMCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjQwMCIsInB4bF9hbmltYXRlX3N1YiI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5X3N1YiI6IjMwMCIsInRpdGxlX3R5cG9ncmFwaHlfdHlwb2dyYXBoeSI6ImN1c3RvbSIsInRpdGxlX3R5cG9ncmFwaHlfZm9udF9zaXplX21vYmlsZSI6eyJ1bml0IjoicHgiLCJzaXplIjo0NSwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9oZWFkaW5nIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjZiYzg3ZTgiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjQ1XHUwNjI3IFx1MDYyZVx1MDYyZlx1MDY0NVx1MDYyN1x1MDYyYSBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDZcdTA2N2VcdTA2MzJcdTA2MzRcdTA2YTlcdTA2Y2MgXHUwNjI4XHUwNjI3IFx1MDZhOVx1MDZjY1x1MDY0MVx1MDZjY1x1MDYyYSBcdTA2MjhcdTA2MjdcdTA2NDRcdTA2MjcgXHUwNjQ4IFx1MDY0NVx1MDYyYVx1MDY0Nlx1MDYyN1x1MDYzM1x1MDYyOCBcdTA2MjhcdTA2MjcgXHUwNjQ2XHUwNmNjXHUwNjI3XHUwNjMyIFx1MDYyYVx1MDY0NVx1MDYyN1x1MDY0NSBcdTA2MjdcdTA2MzlcdTA2MzZcdTA2MjdcdTA2Y2MgXHUwNjJlXHUwNjI3XHUwNjQ2XHUwNjQ4XHUwNjI3XHUwNjJmXHUwNjQ3IFx1MDYyN1x1MDYzMVx1MDYyN1x1MDYyNlx1MDY0NyBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2MmZcdTA2NDdcdTA2Y2NcdTA2NDUuIFx1MDYyN1x1MDYzMiBcdTA2NDVcdTA2MzlcdTA2MjdcdTA2Y2NcdTA2NDZcdTA2MjdcdTA2MmEgXHUwNjMxXHUwNjQ4XHUwNjJhXHUwNmNjXHUwNjQ2IFx1MDZhZlx1MDYzMVx1MDY0MVx1MDYyYVx1MDY0NyBcdTA2MmFcdTA2MjcgXHUwNjJmXHUwNjMxXHUwNjQ1XHUwNjI3XHUwNjQ2XHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY3ZVx1MDZjY1x1MDYzNFx1MDYzMVx1MDY0MVx1MDYyYVx1MDY0N1x1MDYwYyBcdTA2MmFcdTA2Y2NcdTA2NDUgXHUwNjJmXHUwNjQ0XHUwNjMzXHUwNjQ4XHUwNjMyIFx1MDY0NVx1MDYyNyBcdTA2MmFcdTA2MzZcdTA2NDVcdTA2Y2NcdTA2NDYgXHUwNjQ1XHUwNmNjXHUyMDBjXHUwNmE5XHUwNjQ2XHUwNjJmIFx1MDZhOVx1MDY0NyBcdTA2NDRcdTA2MjhcdTA2MmVcdTA2NDZcdTA2MmYgXHUwNjM0XHUwNjQ1XHUwNjI3IFx1MDYzM1x1MDYyN1x1MDY0NFx1MDY0NSBcdTA2NDggXHUwNjI4XHUwNjI3IFx1MDYyN1x1MDYzOVx1MDYyYVx1MDY0NVx1MDYyN1x1MDYyZiBcdTA2MjhcdTA2NDcgXHUwNjQ2XHUwNjQxXHUwNjMzIFx1MDYyOFx1MDYyN1x1MDY0Mlx1MDZjYyBcdTA2MjhcdTA2NDVcdTA2MjdcdTA2NDZcdTA2MmYuPFwvcD4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNTAwIiwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIwIiwicmlnaHQiOiIwIiwiYm90dG9tIjoiMTciLCJsZWZ0IjoiMCIsImlzTGlua2VkIjpmYWxzZX19LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfdGV4dF9lZGl0b3IifQ==\\\"]<div class=\\\"elementor-element elementor-element-bb0da06 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"bb0da06\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-9028010 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"9028010\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjgyN2NkYzMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsaXN0cyI6W3siX2lkIjoiMjlmZGFjYiIsInB4bF9pY29uIjp7InZhbHVlIjoiZmFzIGZhLWNoZWNrIiwibGlicmFyeSI6ImZhLXNvbGlkIn0sInRleHQiOiJcdTA2MjhcdTA2MzFcdTA2NDZcdTA2MjdcdTA2NDVcdTA2NDdcdTIwMGNcdTA2NDdcdTA2MjdcdTA2Y2MgXHUwNjJmXHUwNjMxXHUwNjQ1XHUwNjI3XHUwNjQ2IFx1MDYzNFx1MDYyZVx1MDYzNVx1MDZjY1x1MjAwY1x1MDYzM1x1MDYyN1x1MDYzMlx1MDZjY1x1MjAwY1x1MDYzNFx1MDYyZlx1MDY0NyJ9LHsicHhsX2ljb24iOnsidmFsdWUiOiJmYXMgZmEtY2hlY2siLCJsaWJyYXJ5IjoiZmEtc29saWQifSwidGV4dCI6Ilx1MDY0NVx1MDYzMVx1MDYyN1x1MDY0Mlx1MDYyOFx1MDYyYSBcdTA2NDVcdTA2NDRcdTA2MjdcdTA2Y2NcdTA2NDUgXHUwNjI4XHUwNjMxXHUwNjI3XHUwNmNjIFx1MDZhOVx1MDY0OFx1MDYyZlx1MDZhOVx1MDYyN1x1MDY0NiBcdTA2NDggXHUwNjI4XHUwNjMyXHUwNjMxXHUwNmFmXHUwNjMzXHUwNjI3XHUwNjQ0XHUwNjI3XHUwNjQ2IiwiX2lkIjoiN2ZmNjQ3NSJ9XSwidGV4dF90eXBvZ3JhcGh5X3R5cG9ncmFwaHkiOiJjdXN0b20iLCJ0ZXh0X3R5cG9ncmFwaHlfZm9udF9zaXplX2xhcHRvcCI6eyJ1bml0IjoicHgiLCJzaXplIjoxNSwic2l6ZXMiOltdfSwiaWNvbl9jb2xvciI6IiM0QTdEQzIiLCJpY29uX3NwYWNlIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAzIiwiYm90dG9tIjoiMCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjYwMCIsImFsaWduX2l0ZW1zIjoic3RhcnQifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2xpc3QifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-6db1ff5 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"6db1ff5\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImZhNjQ5MGUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsaXN0cyI6W3siX2lkIjoiMjlmZGFjYiIsInB4bF9pY29uIjp7InZhbHVlIjoiZmFzIGZhLWNoZWNrIiwibGlicmFyeSI6ImZhLXNvbGlkIn0sInRleHQiOiJcdTA2NDFcdTA2NDZcdTA2MjdcdTA2NDhcdTA2MzFcdTA2Y2MgXHUwNjdlXHUwNmNjXHUwNjM0XHUwNjMxXHUwNjQxXHUwNjJhXHUwNjQ3In0seyJweGxfaWNvbiI6eyJ2YWx1ZSI6ImZhcyBmYS1jaGVjayIsImxpYnJhcnkiOiJmYS1zb2xpZCJ9LCJ0ZXh0IjoiXHUwNjI4XHUwNjMxXHUwNjQ2XHUwNjI3XHUwNjQ1XHUwNjQ3XHUyMDBjXHUwNjMxXHUwNmNjXHUwNjMyXHUwNmNjIFx1MDYyN1x1MDY0Nlx1MDYzOVx1MDYzN1x1MDYyN1x1MDY0MVx1MjAwY1x1MDY3ZVx1MDYzMFx1MDZjY1x1MDYzMSBcdTA2MjhcdTA2MzFcdTA2MjdcdTA2Y2MgXHUwNjQyXHUwNjMxXHUwNjI3XHUwNjMxIFx1MDY0NVx1MDY0NFx1MDYyN1x1MDY0Mlx1MDYyN1x1MDYyYSIsIl9pZCI6IjdmZjY0NzUifV0sInRleHRfdHlwb2dyYXBoeV90eXBvZ3JhcGh5IjoiY3VzdG9tIiwidGV4dF90eXBvZ3JhcGh5X2ZvbnRfc2l6ZV9sYXB0b3AiOnsidW5pdCI6InB4Iiwic2l6ZSI6MTUsInNpemVzIjpbXX0sImljb25fY29sb3IiOiIjNEE3REMyIiwiaWNvbl9zcGFjZSI6eyJ1bml0IjoicHgiLCJ0b3AiOiIwIiwicmlnaHQiOiIwMyIsImJvdHRvbSI6IjAiLCJsZWZ0IjoiMCIsImlzTGlua2VkIjpmYWxzZX0sInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI2MDAiLCJhbGlnbl9pdGVtcyI6InN0YXJ0In0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9saXN0In0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImYzODk3ZDkiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0IjoiXHUwNjMxXHUwNjMyXHUwNjMxXHUwNjQ4IFx1MDY0Nlx1MDY0OFx1MDYyOFx1MDYyYSIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI3MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjI4IiwicmlnaHQiOiIwIiwiYm90dG9tIjoiMCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9idXR0b24ifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-9f68bac e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"9f68bac\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-ac1ac70 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"ac1ac70\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImM3NGEzZWUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDY0NVx1MDYzMVx1MDYyN1x1MDY0Mlx1MDYyOFx1MDYyYSBcdTA2YTlcdTA2MjdcdTA2NDVcdTA2NDQgXHUwNjI4XHUwNjMxXHUwNjI3XHUwNmNjIFx1MDY0N1x1MDYzMSBcdTA2NDRcdTA2MjhcdTA2MmVcdTA2NDZcdTA2MmYiLCJzdWJfdGl0bGUiOiJcdTA2MmVcdTA2MmZcdTA2NDVcdTA2MjdcdTA2MmEgXHUwNjQ1XHUwNjI3IiwiaF93aWR0aCI6eyJ1bml0IjoiJSIsInNpemUiOjgwLCJzaXplcyI6W119LCJoX3dpZHRoX2xhcHRvcCI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJoX3dpZHRoX3RhYmxldF9leHRyYSI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJoX3dpZHRoX3RhYmxldCI6eyJ1bml0IjoiJSIsInNpemUiOjEwMCwic2l6ZXMiOltdfSwiaF93aWR0aF9tb2JpbGVfZXh0cmEiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF9tb2JpbGUiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwidGl0bGVfdGFnIjoiaDIiLCJzdWJfdGl0bGVfc3BhY2VfYm90dG9tIjp7InVuaXQiOiJweCIsInNpemUiOjE3LCJzaXplcyI6W119LCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIyMCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjQwMCIsInB4bF9hbmltYXRlX3N1YiI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5X3N1YiI6IjMwMCIsInRpdGxlX3R5cG9ncmFwaHlfdHlwb2dyYXBoeSI6ImN1c3RvbSIsInRpdGxlX3R5cG9ncmFwaHlfZm9udF9zaXplX21vYmlsZSI6eyJ1bml0IjoicHgiLCJzaXplIjo0NSwic2l6ZXMiOltdfSwiYWxpZ24iOiJjZW50ZXIifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2hlYWRpbmcifQ==\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjcyODQ3ZjkiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjI3XHUwNjMyIFx1MDYyYVx1MDY0NVx1MDZjY1x1MDYzMiBcdTA2YTlcdTA2MzFcdTA2MmZcdTA2NDZcdTIwMGNcdTA2NDdcdTA2MjdcdTA2Y2MgXHUwNjMxXHUwNjQ4XHUwNjJhXHUwNmNjXHUwNjQ2IFx1MDZhZlx1MDYzMVx1MDY0MVx1MDYyYVx1MDY0NyBcdTA2MmFcdTA2MjcgXHUwNjJhXHUwNjMxXHUwNjQ1XHUwNmNjXHUwNjQ1XHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY3ZVx1MDZjY1x1MDYzNFx1MDYzMVx1MDY0MVx1MDYyYVx1MDY0N1x1MDYwYyBcdTA2NDVcdTA2MjcgXHUwNjMxXHUwNjI3XHUwNjQ3XHUyMDBjXHUwNjJkXHUwNjQ0XHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2MzRcdTA2MmVcdTA2MzVcdTA2Y2NcdTIwMGNcdTA2MzNcdTA2MjdcdTA2MzJcdTA2Y2NcdTIwMGNcdTA2MzRcdTA2MmZcdTA2NDcgXHUwNjMxXHUwNjI3IFx1MDYyOFx1MDYzMVx1MDYyN1x1MDZjYyBcdTA2MjhcdTA2Y2NcdTA2NDVcdTA2MjdcdTA2MzFcdTA2MjdcdTA2NDYgXHUwNjJmXHUwNjMxIFx1MDY0N1x1MDYzMSBcdTA2MzNcdTA2NDZcdTA2Y2MgXHUwNjI3XHUwNjMxXHUwNjI3XHUwNjI2XHUwNjQ3IFx1MDY0NVx1MDZjY1x1MjAwY1x1MDYyZlx1MDY0N1x1MDZjY1x1MDY0NS48XC9wPiIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiI0MiIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwiYWxpZ24iOiJjZW50ZXIiLCJ0X3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjU2Mywic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]<div class=\\\"elementor-element elementor-element-7371f8b e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"7371f8b\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-37741dc e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"37741dc\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-5855528 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"5855528\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImZmMjgxZmEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIzIiwiaWNvbl90eXBlIjoiaW1hZ2UiLCJpY29uX2ltYWdlIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC93cC1jb250ZW50XC91cGxvYWRzXC8yMDI1XC8wOFwvdG9vdGgtMS5wbmciLCJpZCI6NjI2LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJ0aXRsZSI6Ilx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2MzlcdTA2NDVcdTA2NDhcdTA2NDVcdTA2Y2MiLCJkZXNjIjoiXHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhIFx1MDZhOVx1MDYyN1x1MDY0NVx1MDY0NCBcdTA2MmZcdTA2NDdcdTA2MjdcdTA2NDYgXHUwNjQ4IFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0NiBcdTA2MjhcdTA2MzFcdTA2MjdcdTA2Y2MgXHUwNjQ3XHUwNjMxIFx1MDY0NFx1MDYyOFx1MDYyZVx1MDY0Nlx1MDYyZlx1MDZjYyBcdTA2MjhcdTA2MjcgXHUwNjJjXHUwNjMxXHUwNjQ1XHUyMDBjXHUwNmFmXHUwNmNjXHUwNjMxXHUwNmNjXHUwNjBjIFx1MDY0NVx1MDYzOVx1MDYyN1x1MDZjY1x1MDY0Nlx1MDY0NyBcdTA2NDggXHUwNjQ1XHUwNjQ4XHUwNjI3XHUwNjMxXHUwNjJmIFx1MDYyZlx1MDZjY1x1MDZhZlx1MDYzMS4iLCJsaW5rIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC9zZXJ2aWNlXC9nZW5lcmFsLWRlbnRpc3RyeVwvIiwiaXNfZXh0ZXJuYWwiOiIiLCJub2ZvbGxvdyI6IiIsImN1c3RvbV9hdHRyaWJ1dGVzIjoiIn0sInRpdGxlX2J0biI6Ilx1MDYyN1x1MDYzN1x1MDY0NFx1MDYyN1x1MDYzOVx1MDYyN1x1MDYyYSBcdTA2MjhcdTA2Y2NcdTA2MzRcdTA2MmFcdTA2MzEiLCJweGxfYW5pbWF0ZSI6IndvdyBzY2FsZUluIiwicHhsX2FuaW1hdGVfZGVsYXkiOiIzMDAiLCJweGxfYW5pbWF0ZTIiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheTIiOiI1MDAiLCJ0aXRsZV9jb2xvciI6IiMxMDI0NEIiLCJiYWNrZ3JvdW5kX2NvbG9yIjoiI0ZGRkZGRiJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfaWNvbl9ib3gifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-62a7ae9 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"62a7ae9\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImM4ODAwODEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIzIiwiaWNvbl90eXBlIjoiaW1hZ2UiLCJpY29uX2ltYWdlIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC93cC1jb250ZW50XC91cGxvYWRzXC8yMDI1XC8wOFwvdG9vdGgtMi5wbmciLCJpZCI6NjI3LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJ0aXRsZSI6Ilx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOSBcdTA2MzJcdTA2Y2NcdTA2MjhcdTA2MjdcdTA2Y2NcdTA2Y2MiLCJkZXNjIjoiXHUwNjMyXHUwNmNjXHUwNjI4XHUwNjI3XHUwNmNjXHUwNmNjIFx1MDY0NFx1MDYyOFx1MDYyZVx1MDY0Nlx1MDYyZiBcdTA2MmVcdTA2NDhcdTA2MmYgXHUwNjMxXHUwNjI3IFx1MDYyOFx1MDYyNyBcdTA2MzNcdTA2NDFcdTA2Y2NcdTA2MmYgXHUwNmE5XHUwNjMxXHUwNjJmXHUwNjQ2IFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDYwYyBcdTA2NDhcdTA2NDZcdTA2Y2NcdTA2MzFcdTA2NDdcdTA2MjcgXHUwNjQ4IFx1MDY0NVx1MDY0OFx1MDYyN1x1MDYzMVx1MDYyZiBcdTA2MmZcdTA2Y2NcdTA2YWZcdTA2MzEgXHUwNjI3XHUwNjQxXHUwNjMyXHUwNjI3XHUwNmNjXHUwNjM0IFx1MDYyZlx1MDY0N1x1MDZjY1x1MDYyZi4iLCJsaW5rIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC9zZXJ2aWNlXC9jb3NtZXRpYy1kZW50aXN0cnlcLyIsImlzX2V4dGVybmFsIjoiIiwibm9mb2xsb3ciOiIiLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9LCJ0aXRsZV9idG4iOiJcdTA2MjdcdTA2MzdcdTA2NDRcdTA2MjdcdTA2MzlcdTA2MjdcdTA2MmEgXHUwNjI4XHUwNmNjXHUwNjM0XHUwNjJhXHUwNjMxIiwicHhsX2FuaW1hdGUiOiJ3b3cgc2NhbGVJbiIsInB4bF9hbmltYXRlX2RlbGF5IjoiMzAwIiwicHhsX2FuaW1hdGUyIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkyIjoiNTAwIiwidGl0bGVfY29sb3IiOiIjMTAyNDRCIiwiYmFja2dyb3VuZF9jb2xvciI6IiNGRkZGRkYifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ljb25fYm94In0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-964d2d6 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"964d2d6\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjMzNmJmNmYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIzIiwiaWNvbl90eXBlIjoiaW1hZ2UiLCJpY29uX2ltYWdlIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC93cC1jb250ZW50XC91cGxvYWRzXC8yMDI1XC8wOFwvdG9vdGgtMy5wbmciLCJpZCI6NjI4LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJ0aXRsZSI6Ilx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2YTlcdTA2NDhcdTA2MmZcdTA2YTlcdTA2MjdcdTA2NDYiLCJkZXNjIjoiXHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhXHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY0NVx1MDY0NFx1MDYyN1x1MDZjY1x1MDY0NSBcdTA2NDggXHUwNjMzXHUwNjMxXHUwNmFmXHUwNjMxXHUwNjQ1XHUyMDBjXHUwNmE5XHUwNjQ2XHUwNjQ2XHUwNjJmXHUwNjQ3IFx1MDYyN1x1MDYzMiBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDZcdTIwMGNcdTA2NDdcdTA2MjcgXHUwNjI4XHUwNjMxXHUwNjI3XHUwNmNjIFx1MDZhOVx1MDY0OFx1MDYyZlx1MDZhOVx1MDYyN1x1MDY0NiBcdTA2MmFcdTA2MjcgXHUwNjQ0XHUwNjI4XHUwNjJlXHUwNjQ2XHUwNjJmXHUwNmNjIFx1MDYzM1x1MDYyN1x1MDY0NFx1MDY0NSBcdTA2NDggXHUwNjM0XHUwNjI3XHUwNjJmIFx1MDYyZlx1MDYyN1x1MDYzNFx1MDYyYVx1MDY0NyBcdTA2MjhcdTA2MjdcdTA2MzRcdTA2NDZcdTA2MmYuIiwibGluayI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvc2VydmljZVwvcGVkaWF0cmljLWRlbnRpc3RyeVwvIiwiaXNfZXh0ZXJuYWwiOiIiLCJub2ZvbGxvdyI6IiIsImN1c3RvbV9hdHRyaWJ1dGVzIjoiIn0sInRpdGxlX2J0biI6Ilx1MDYyN1x1MDYzN1x1MDY0NFx1MDYyN1x1MDYzOVx1MDYyN1x1MDYyYSBcdTA2MjhcdTA2Y2NcdTA2MzRcdTA2MmFcdTA2MzEiLCJweGxfYW5pbWF0ZSI6IndvdyBzY2FsZUluIiwicHhsX2FuaW1hdGVfZGVsYXkiOiIzMDAiLCJweGxfYW5pbWF0ZTIiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheTIiOiI1MDAiLCJ0aXRsZV9jb2xvciI6IiMxMDI0NEIiLCJiYWNrZ3JvdW5kX2NvbG9yIjoiI0ZGRkZGRiJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfaWNvbl9ib3gifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-2e4cbee e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"2e4cbee\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjIwMjkyMzMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIzIiwiaWNvbl90eXBlIjoiaW1hZ2UiLCJpY29uX2ltYWdlIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC93cC1jb250ZW50XC91cGxvYWRzXC8yMDI1XC8wOFwvdG9vdGgtNC5wbmciLCJpZCI6NjI5LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJ0aXRsZSI6Ilx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2MmFcdTA2MzFcdTA2NDVcdTA2Y2NcdTA2NDVcdTA2Y2MiLCJkZXNjIjoiXHUwNjJmXHUwNjQ2XHUwNjJmXHUwNjI3XHUwNjQ2XHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDYzNFx1MDY0NVx1MDYyNyBcdTA2MzFcdTA2MjcgXHUwNjI4XHUwNjMxXHUwNjI3XHUwNmNjIFx1MDYzMVx1MDYyN1x1MDYyZFx1MDYyYVx1MDZjYyBcdTA2NDggXHUwNjM5XHUwNjQ1XHUwNjQ0XHUwNmE5XHUwNjMxXHUwNjJmIFx1MDY3ZVx1MDYyN1x1MDZjY1x1MDYyZlx1MDYyN1x1MDYzMSBcdTA2MmFcdTA2MzFcdTA2NDVcdTA2Y2NcdTA2NDUgXHUwNjQ4IFx1MDYyOFx1MDYyN1x1MDYzMlx1MDYzM1x1MDYyN1x1MDYzMlx1MDZjYyBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2YTlcdTA2NDZcdTA2MmYuXG4iLCJsaW5rIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC9zZXJ2aWNlXC9yZXN0b3JhdGl2ZS1kZW50aXN0cnlcLyIsImlzX2V4dGVybmFsIjoiIiwibm9mb2xsb3ciOiIiLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9LCJ0aXRsZV9idG4iOiJcdTA2MjdcdTA2MzdcdTA2NDRcdTA2MjdcdTA2MzlcdTA2MjdcdTA2MmEgXHUwNjI4XHUwNmNjXHUwNjM0XHUwNjJhXHUwNjMxIiwicHhsX2FuaW1hdGUiOiJ3b3cgc2NhbGVJbiIsInB4bF9hbmltYXRlX2RlbGF5IjoiMzAwIiwicHhsX2FuaW1hdGUyIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkyIjoiNTAwIiwidGl0bGVfY29sb3IiOiIjMTAyNDRCIiwiYmFja2dyb3VuZF9jb2xvciI6IiNGRkZGRkYifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ljb25fYm94In0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImU3MTQxM2EiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0IjoiXHUwNjQ1XHUwNjM0XHUwNjI3XHUwNjQ3XHUwNjJmXHUwNjQ3IFx1MDY0N1x1MDY0NVx1MDY0NyBcdTA2MmVcdTA2MmZcdTA2NDVcdTA2MjdcdTA2MmEiLCJsaW5rIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC9hbGwtc2VydmljZXNcLyIsImlzX2V4dGVybmFsIjoiIiwibm9mb2xsb3ciOiIiLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9LCJhbGlnbiI6ImNlbnRlciIsIl9tYXJnaW4iOnsidW5pdCI6InB4IiwidG9wIjoiNDgiLCJyaWdodCI6IjAiLCJib3R0b20iOiIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9fSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2J1dHRvbiJ9\\\"]\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-b92d7a4 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"b92d7a4\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-d408d83 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"d408d83\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImMwOGY2NzYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYyOFx1MDZjY1x1MDY0NVx1MDYyN1x1MDYzMVx1MDYyN1x1MDY0NiBcdTA2MzRcdTA2MjdcdTA2MmYiLCJzdGFydGluZ19udW1iZXIiOjUwMDAsImVuZGluZ19udW1iZXIiOjEwMDAwLCJzdWZmaXgiOiIrIiwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluUmlnaHQiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjMwMCJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfY291bnRlciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-3ffca2e e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"3ffca2e\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjE3ZjMwMTUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYzM1x1MDY0MVx1MDZjY1x1MDYyZiBcdTA2YTlcdTA2MzFcdTA2MmZcdTA2NDYgXHUwNjJmXHUwNjQ2XHUwNjJmXHUwNjI3XHUwNjQ2Iiwic3RhcnRpbmdfbnVtYmVyIjoyMDAwLCJlbmRpbmdfbnVtYmVyIjoyNTAwLCJzdWZmaXgiOiIrIiwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluUmlnaHQiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjQwMCJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfY291bnRlciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-5163797 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"5163797\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjM0NDQ3MmYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYyN1x1MDZjY1x1MDY0NVx1MDY3ZVx1MDY0NFx1MDY0Nlx1MDYyYSBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDYiLCJzdGFydGluZ19udW1iZXIiOjUwMCwiZW5kaW5nX251bWJlciI6ODAwLCJzdWZmaXgiOiIrIiwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluUmlnaHQiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjUwMCJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfY291bnRlciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-7ac7412 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"7ac7412\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjYyZDY3MmQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYzM1x1MDYyN1x1MDY0NCBcdTA2MmFcdTA2MmNcdTA2MzFcdTA2MjhcdTA2NDciLCJlbmRpbmdfbnVtYmVyIjoxNSwic3VmZml4IjoiKyIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblJpZ2h0IiwicHhsX2FuaW1hdGVfZGVsYXkiOiI2MDAifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2NvdW50ZXIifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-fc38de1 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"fc38de1\\\" data-element_type=\\\"container\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-931cd86 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"931cd86\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImM3ODU3ZGUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYyZVx1MDYyZlx1MDY0NVx1MDYyN1x1MDYyYSBcdTA2MjdcdTA2MzNcdTA2MmFcdTA2MmJcdTA2NDZcdTA2MjdcdTA2Y2NcdTA2Y2MgXHUwNjI4XHUwNjI3IFx1MDYzMVx1MDY0OFx1MDZjY1x1MDZhOVx1MDYzMVx1MDYyZlx1MDZjYyBcdTA2MzRcdTA2MmVcdTA2MzVcdTA2Y2MiLCJzdWJfdGl0bGUiOiJcdTA2ODZcdTA2MzFcdTA2MjcgXHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhXHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2NDVcdTA2MjcgXHUwNjMxXHUwNjI3IFx1MDYyN1x1MDY0Nlx1MDYyYVx1MDYyZVx1MDYyN1x1MDYyOCBcdTA2YTlcdTA2NDZcdTA2Y2NcdTA2MmYiLCJoX3dpZHRoIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sImhfd2lkdGhfbGFwdG9wIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sImhfd2lkdGhfdGFibGV0X2V4dHJhIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sImhfd2lkdGhfdGFibGV0Ijp7InVuaXQiOiIlIiwic2l6ZSI6MTAwLCJzaXplcyI6W119LCJoX3dpZHRoX21vYmlsZV9leHRyYSI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJoX3dpZHRoX21vYmlsZSI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJ0aXRsZV90YWciOiJoMiIsInN1Yl90aXRsZV9zcGFjZV9ib3R0b20iOnsidW5pdCI6InB4Iiwic2l6ZSI6MTcsInNpemVzIjpbXX0sIl9tYXJnaW4iOnsidW5pdCI6InB4IiwidG9wIjoiMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9LCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNDAwIiwicHhsX2FuaW1hdGVfc3ViIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXlfc3ViIjoiMzAwIiwidGl0bGVfdHlwb2dyYXBoeV90eXBvZ3JhcGh5IjoiY3VzdG9tIiwidGl0bGVfdHlwb2dyYXBoeV9mb250X3NpemVfbW9iaWxlIjp7InVuaXQiOiJweCIsInNpemUiOjQ1LCJzaXplcyI6W119fSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2hlYWRpbmcifQ==\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjYwMmVhOTMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjI3XHUwNjQ2XHUwNjJhXHUwNjJlXHUwNjI3XHUwNjI4IFx1MDYyN1x1MDYzMVx1MDYyN1x1MDYyNlx1MDY0NyBcdTA2MmZcdTA2NDdcdTA2NDZcdTA2MmZcdTA2NDcgXHUwNjJlXHUwNjJmXHUwNjQ1XHUwNjI3XHUwNjJhIFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2NDVcdTA2NDZcdTA2MjdcdTA2MzNcdTA2MjggXHUwNjI3XHUwNjQ3XHUwNjQ1XHUwNmNjXHUwNjJhIFx1MDYyZlx1MDYyN1x1MDYzMVx1MDYyZi4gXHUwNjQ1XHUwNjI3IFx1MDY0NVx1MDYzMVx1MDYyN1x1MDY0Mlx1MDYyOFx1MDYyYVx1MjAwY1x1MDY0N1x1MDYyN1x1MDZjYyBcdTA2MmFcdTA2MmVcdTA2MzVcdTA2MzVcdTA2Y2NcdTA2MGMgXHUwNjQxXHUwNjQ2XHUwNjI3XHUwNjQ4XHUwNjMxXHUwNmNjIFx1MDY3ZVx1MDZjY1x1MDYzNFx1MDYzMVx1MDY0MVx1MDYyYVx1MDY0NyBcdTA2NDggXHUwNjQxXHUwNjM2XHUwNjI3XHUwNmNjXHUwNmNjIFx1MDZhZlx1MDYzMVx1MDY0NSBcdTA2MzFcdTA2MjcgXHUwNjI4XHUwNjI3IFx1MDY0N1x1MDY0NSBcdTA2MmFcdTA2MzFcdTA2YTlcdTA2Y2NcdTA2MjggXHUwNjQ1XHUwNmNjXHUyMDBjXHUwNmE5XHUwNjQ2XHUwNmNjXHUwNjQ1IFx1MDYyYVx1MDYyNyBcdTA2MjdcdTA2MzdcdTA2NDVcdTA2Y2NcdTA2NDZcdTA2MjdcdTA2NDYgXHUwNjJkXHUwNjI3XHUwNjM1XHUwNjQ0IFx1MDZhOVx1MDY0Nlx1MDZjY1x1MDY0NSBcdTA2YTlcdTA2NDcgXHUwNjQ3XHUwNjMxIFx1MDY0OFx1MDZjY1x1MDYzMlx1MDZjY1x1MDYyYSBcdTA2MzFcdTA2MjdcdTA2MmRcdTA2MmFcdTA2MGMgXHUwNmE5XHUwNjI3XHUwNjMxXHUwNjIyXHUwNjQ1XHUwNjJmIFx1MDY0OCBcdTA2NDVcdTA2MmFcdTA2NDZcdTA2MjdcdTA2MzNcdTA2MjggXHUwNjI4XHUwNjI3IFx1MDY0Nlx1MDZjY1x1MDYyN1x1MDYzMlx1MDY0N1x1MDYyN1x1MDZjYyBcdTA2NDVcdTA2NDZcdTA2MmRcdTA2MzVcdTA2MzEgXHUwNjI4XHUwNjQ3IFx1MDY0MVx1MDYzMVx1MDYyZiBcdTA2MzRcdTA2NDVcdTA2MjcgXHUwNjJlXHUwNjQ4XHUwNjI3XHUwNjQ3XHUwNjJmIFx1MDYyOFx1MDY0OFx1MDYyZi48XC9wPiIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIyMSIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]<div class=\\\"elementor-element elementor-element-9f3be1f e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"9f3be1f\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-e4d5e10 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"e4d5e10\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-3f475ce e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"3f475ce\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImQ0MzdiMWMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGg1Plx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOSBcdTA2MjhcdTA2MjdcdTA2MmFcdTA2MmNcdTA2MzFcdTA2MjhcdTA2NDc8XC9oNT4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNDAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6Ijc4ZTZlMmIiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhXHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDYyYVx1MDYyZVx1MDYzNVx1MDYzNVx1MDZjYyBcdTA2MjhcdTA2MjcgXHUwNjdlXHUwNjM0XHUwNjJhXHUwNjQ4XHUwNjI3XHUwNjQ2XHUwNjQ3IFx1MDYzM1x1MDYyN1x1MDY0NFx1MjAwY1x1MDY0N1x1MDYyNyBcdTA2MmFcdTA2MmNcdTA2MzFcdTA2MjhcdTA2NDcgXHUwNjJmXHUwNjQ2XHUwNjJmXHUwNjI3XHUwNjQ2XHUwNjdlXHUwNjMyXHUwNjM0XHUwNmE5XHUwNmNjIFx1MDY0Mlx1MDYyN1x1MDYyOFx1MDY0NCBcdTA2MjdcdTA2MzlcdTA2MmFcdTA2NDVcdTA2MjdcdTA2MmYuPFwvcD4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNTAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-c548350 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"c548350\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjY1YzMxZjQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGg1Plx1MDYyZlx1MDYzMVx1MDY0NVx1MDYyN1x1MDY0NiBcdTA2MzRcdTA2MmVcdTA2MzVcdTA2Y2NcdTIwMGNcdTA2MzNcdTA2MjdcdTA2MzJcdTA2Y2NcdTIwMGNcdTA2MzRcdTA2MmZcdTA2NDc8XC9oNT4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNDAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjI0ZDQ0MDkiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjI4XHUwNjMxXHUwNjQ2XHUwNjI3XHUwNjQ1XHUwNjQ3XHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY0NVx1MDYzMVx1MDYyN1x1MDY0Mlx1MDYyOFx1MDYyYVx1MDZjYyBcdTA2MzNcdTA2NDFcdTA2MjdcdTA2MzFcdTA2MzRcdTA2Y2MgXHUwNmE5XHUwNjQ3IFx1MDY0NVx1MDYyYVx1MDY0Nlx1MDYyN1x1MDYzM1x1MDYyOCBcdTA2MjhcdTA2MjcgXHUwNjQ0XHUwNjI4XHUwNjJlXHUwNjQ2XHUwNjJmIFx1MDY0OCBcdTA2MzNcdTA2MjhcdTA2YTkgXHUwNjMyXHUwNjQ2XHUwNjJmXHUwNmFmXHUwNmNjIFx1MDYzNFx1MDY0NVx1MDYyNyBcdTA2MmFcdTA2NDdcdTA2Y2NcdTA2NDcgXHUwNjQ1XHUwNmNjXHUyMDBjXHUwNjM0XHUwNjQ4XHUwNjQ2XHUwNjJmLjxcL3A+IiwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjUwMCJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfdGV4dF9lZGl0b3IifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-64807c6 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"64807c6\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-0cb580b e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"0cb580b\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6Ijg5ZmJjZjUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGg1Plx1MDY0MVx1MDY0Nlx1MDYyN1x1MDY0OFx1MDYzMVx1MDZjYyBcdTA2N2VcdTA2Y2NcdTA2MzRcdTA2MzFcdTA2NDFcdTA2MmFcdTA2NDc8XC9oNT4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNDAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjFhMmNlMjgiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjI3XHUwNjI4XHUwNjMyXHUwNjI3XHUwNjMxXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY0NVx1MDYyZlx1MDYzMVx1MDY0Nlx1MDYwYyBcdTA2MmZcdTA2MzFcdTA2NDVcdTA2MjdcdTA2NDZcdTIwMGNcdTA2NDdcdTA2MjdcdTA2Y2MgXHUwNjJmXHUwNjQyXHUwNmNjXHUwNjQyIFx1MDY0OCBcdTA2YTlcdTA2MjdcdTA2MzFcdTA2MjJcdTA2NDVcdTA2MmYgXHUwNjMxXHUwNjI3IFx1MDYyYVx1MDYzNlx1MDY0NVx1MDZjY1x1MDY0NiBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2YTlcdTA2NDZcdTA2NDZcdTA2MmYuPFwvcD4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNTAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-5c18bec e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"5c18bec\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjAxMzk0MzAiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGg1Plx1MDY0NVx1MDY0Nlx1MDYyN1x1MDYzM1x1MDYyOCBcdTA2MmVcdTA2MjdcdTA2NDZcdTA2NDhcdTA2MjdcdTA2MmZcdTA2NDc8XC9oNT4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNDAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjNlOTMwOWMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjQxXHUwNjM2XHUwNjI3XHUwNmNjXHUwNmNjIFx1MDYyZlx1MDY0NFx1MDY0Nlx1MDYzNFx1MDZjY1x1MDY0NiBcdTA2MjhcdTA2MzFcdTA2MjdcdTA2Y2MgXHUwNmE5XHUwNjQ4XHUwNjJmXHUwNmE5XHUwNjI3XHUwNjQ2XHUwNjBjIFx1MDY0Nlx1MDY0OFx1MDYyY1x1MDY0OFx1MDYyN1x1MDY0Nlx1MDYyN1x1MDY0Nlx1MDYwYyBcdTA2MjhcdTA2MzJcdTA2MzFcdTA2YWZcdTA2MzNcdTA2MjdcdTA2NDRcdTA2MjdcdTA2NDYgXHUwNjQ4IFx1MDYzM1x1MDYyN1x1MDY0NFx1MDY0NVx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Ni48XC9wPiIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX3RleHRfZWRpdG9yIn0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-c0bac5e e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"c0bac5e\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-9ce2c5c e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"9ce2c5c\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImU1MzBjODEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2V4Y2VwdGlvbmFsMi5qcGciLCJpZCI6NjA3LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJpbWFnZV90eXBlIjoiYmciLCJpbWFnZV9oZWlnaHQiOnsidW5pdCI6InB4Iiwic2l6ZSI6MjM2LjgwMDAwMDAwMDAwMDAxMTM2ODY4Mzc3MjE2MTYwMjk3MzkzNzk4ODI4MTI1LCJzaXplcyI6W119LCJib3JkZXJfcmFkaXVzIjp7InVuaXQiOiJweCIsInRvcCI6IjIwIiwicmlnaHQiOiIyMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjIwIiwiaXNMaW5rZWQiOnRydWV9LCJwYXJhbGxheF92YWx1ZSI6IjQwIiwibWF4X3RpbHQiOiIxMCIsInNwZWVkX3RpbHQiOiI0MDAiLCJwZXJzcGVjdGl2ZV90aWx0IjoiMTAwMCIsInB4bF9hbmltYXRlIjoid293IHpvb21JblNtYWxsIiwicHhsX2FuaW1hdGVfZGVsYXkiOiIzMDAiLCJweGxfYW5pbWF0ZV9pbWciOiJ3b3cgc2NhbGVJbiIsInB4bF9hbmltYXRlX2ltZ19kZWxheSI6IjMwMCIsIl9wYWRkaW5nIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIwIiwibGVmdCI6IjYwIiwiaXNMaW5rZWQiOmZhbHNlfSwiX3BhZGRpbmdfdGFibGV0Ijp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9fSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ltYWdlIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjIxYmMyY2IiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2V4Y2VwdGlvbmFsMS5qcGciLCJpZCI6NjA2LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJpbWFnZV90eXBlIjoiYmciLCJpbWFnZV9oZWlnaHQiOnsidW5pdCI6InB4Iiwic2l6ZSI6Mjk2LCJzaXplcyI6W119LCJib3JkZXJfcmFkaXVzIjp7InVuaXQiOiJweCIsInRvcCI6IjIwIiwicmlnaHQiOiIyMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjIwIiwiaXNMaW5rZWQiOnRydWV9LCJwYXJhbGxheF92YWx1ZSI6IjQwIiwibWF4X3RpbHQiOiIxMCIsInNwZWVkX3RpbHQiOiI0MDAiLCJwZXJzcGVjdGl2ZV90aWx0IjoiMTAwMCIsInB4bF9hbmltYXRlIjoid293IHpvb21JblNtYWxsIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJweGxfYW5pbWF0ZV9pbWciOiJ3b3cgc2NhbGVJbiIsInB4bF9hbmltYXRlX2ltZ19kZWxheSI6IjUwMCJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfaW1hZ2UifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-2b3fb22 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"2b3fb22\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImE3YmU3YjkiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2V4Y2VwdGlvbmFsMy5qcGciLCJpZCI6NjA4LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJpbWFnZV90eXBlIjoiYmciLCJpbWFnZV9oZWlnaHQiOnsidW5pdCI6InB4Iiwic2l6ZSI6Mzk5LjYwMDAwMDAwMDAwMDAyMjczNzM2NzU0NDMyMzIwNTk0Nzg3NTk3NjU2MjUsInNpemVzIjpbXX0sImJvcmRlcl9yYWRpdXMiOnsidW5pdCI6InB4IiwidG9wIjoiMjAiLCJyaWdodCI6IjIwIiwiYm90dG9tIjoiMjAiLCJsZWZ0IjoiMjAiLCJpc0xpbmtlZCI6dHJ1ZX0sInBhcmFsbGF4X3ZhbHVlIjoiNDAiLCJtYXhfdGlsdCI6IjEwIiwic3BlZWRfdGlsdCI6IjQwMCIsInBlcnNwZWN0aXZlX3RpbHQiOiIxMDAwIiwicHhsX2FuaW1hdGUiOiJ3b3cgem9vbUluU21hbGwiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjQwMCIsInB4bF9hbmltYXRlX2ltZyI6IndvdyBzY2FsZUluIiwicHhsX2FuaW1hdGVfaW1nX2RlbGF5IjoiNDAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9pbWFnZSJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-d0d5540 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"d0d5540\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-964e490 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"964e490\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImQwNzU1OTUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDY0NVx1MDYyYVx1MDYzOVx1MDY0N1x1MDYyZiBcdTA2MjhcdTA2NDcgXHUwNjQ0XHUwNjI4XHUwNjJlXHUwNjQ2XHUwNjJmIFx1MDYzNFx1MDY0NVx1MDYyNyIsInN1Yl90aXRsZSI6IiBcdTA2MjhcdTA2MjcgXHUwNjJhXHUwNmNjXHUwNjQ1IFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2NDVcdTA2MjcgXHUwNjIyXHUwNjM0XHUwNjQ2XHUwNjI3IFx1MDYzNFx1MDY0OFx1MDZjY1x1MDYyZiIsImhfd2lkdGgiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF9sYXB0b3AiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF90YWJsZXRfZXh0cmEiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF90YWJsZXQiOnsidW5pdCI6IiUiLCJzaXplIjoxMDAsInNpemVzIjpbXX0sImhfd2lkdGhfbW9iaWxlX2V4dHJhIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sImhfd2lkdGhfbW9iaWxlIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sInRpdGxlX3RhZyI6ImgyIiwic3ViX3RpdGxlX3NwYWNlX2JvdHRvbSI6eyJ1bml0IjoicHgiLCJzaXplIjoxNywic2l6ZXMiOltdfSwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIwIiwicmlnaHQiOiIwIiwiYm90dG9tIjoiMjAiLCJsZWZ0IjoiMCIsImlzTGlua2VkIjpmYWxzZX0sInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI0MDAiLCJweGxfYW5pbWF0ZV9zdWIiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheV9zdWIiOiIzMDAiLCJhbGlnbiI6ImNlbnRlciIsInRpdGxlX3R5cG9ncmFwaHlfdHlwb2dyYXBoeSI6ImN1c3RvbSIsInRpdGxlX3R5cG9ncmFwaHlfZm9udF9zaXplX21vYmlsZSI6eyJ1bml0IjoicHgiLCJzaXplIjo0NSwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9oZWFkaW5nIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImFjZDdkYTQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHAgY2xhc3M9XCJ3b3cgZmFkZUluVXAgYW5pbWF0ZWRcIj5cdTA2MmFcdTA2Y2NcdTA2NDUgXHUwNjJmXHUwNjQ2XHUwNjJmXHUwNjI3XHUwNjQ2XHUwNjdlXHUwNjMyXHUwNjM0XHUwNmE5XHUwNmNjIFx1MDYyOFx1MDYyN1x1MDYyYVx1MDYyY1x1MDYzMVx1MDYyOFx1MDY0NyBcdTA2NDVcdTA2MjcgXHUwNjI3XHUwNmNjXHUwNjQ2XHUwNjJjXHUwNjI3IFx1MDY0N1x1MDYzM1x1MDYyYVx1MDY0Nlx1MDYyZiBcdTA2MmFcdTA2MjcgXHUwNjQ3XHUwNjMxIFx1MDY0OFx1MDZjY1x1MDYzMlx1MDZjY1x1MDYyYSBcdTA2MzFcdTA2MjcgXHUwNjQ1XHUwNjJiXHUwNjI4XHUwNjJhIFx1MDY0OCBcdTA2MzRcdTA2MmVcdTA2MzVcdTA2Y2NcdTIwMGNcdTA2MzNcdTA2MjdcdTA2MzJcdTA2Y2NcdTIwMGNcdTA2MzRcdTA2MmZcdTA2NDcgXHUwNmE5XHUwNjQ2XHUwNjQ2XHUwNjJmLiBcdTA2MjhcdTA2MjcgXHUwNjJmXHUwNjMzXHUwNjJhXHUwNjI3XHUwNjQ2XHUwNmNjIFx1MDY0NVx1MDY0N1x1MDYzMVx1MDYyOFx1MDYyN1x1MDY0NiBcdTA2NDggXHUwNjQyXHUwNjQ0XHUwNjI4XHUwNmNjIFx1MDY0NVx1MDY0N1x1MDYzMVx1MDYyOFx1MDYyN1x1MDY0Ni48XC9wPiIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIzNyIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwiYWxpZ24iOiJjZW50ZXIiLCJ0X3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjYyOCwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-8e36ff0 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"8e36ff0\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"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\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-07e3439 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"07e3439\\\" data-element_type=\\\"container\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-cabeee0 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"cabeee0\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjkyYTMwYzUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYzM1x1MDY0OFx1MDYyN1x1MDY0NFx1MDYyN1x1MDYyYSBcdTA2NDVcdTA2MmFcdTA2MmZcdTA2MjdcdTA2NDhcdTA2NDQiLCJzdWJfdGl0bGUiOiJcdTA2NDdcdTA2MzEgXHUwNjIyXHUwNjQ2XHUwNjg2XHUwNjQ3IFx1MDZhOVx1MDY0NyBcdTA2MjhcdTA2MjdcdTA2Y2NcdTA2MmYgXHUwNjI4XHUwNjJmXHUwNjI3XHUwNjQ2XHUwNmNjXHUwNjJmIiwidGl0bGVfdGFnIjoiaDIiLCJ0aXRsZV90eXBvZ3JhcGh5X3R5cG9ncmFwaHkiOiJjdXN0b20iLCJ0aXRsZV90eXBvZ3JhcGh5X2ZvbnRfc2l6ZV9tb2JpbGUiOnsidW5pdCI6InB4Iiwic2l6ZSI6NDUsInNpemVzIjpbXX0sInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJweGxfYW5pbWF0ZV9zdWIiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheV9zdWIiOiIzMDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIyMCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9oZWFkaW5nIn0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-cb0bd9f e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"cb0bd9f\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"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\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-faed713 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"faed713\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\"><div class=\\\"elementor-element elementor-element-ba2fc12 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"ba2fc12\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImNkNzE3MTYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDY0NVx1MDYzNFx1MDYyYVx1MDYzMVx1MDZjY1x1MDYyN1x1MDY0NiBcdTA2MzFcdTA2MjdcdTA2MzZcdTA2Y2MgXHUwNjQ1XHUwNjI3Iiwic3ViX3RpdGxlIjoiXHUwNjQ2XHUwNjM4XHUwNjMxXHUwNjI3XHUwNjJhIFx1MDY0NVx1MDYzNFx1MDYyYVx1MDYzMVx1MDZjY1x1MDYyN1x1MDY0NiIsImhfd2lkdGgiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF9sYXB0b3AiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF90YWJsZXRfZXh0cmEiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF90YWJsZXQiOnsidW5pdCI6IiUiLCJzaXplIjoxMDAsInNpemVzIjpbXX0sImhfd2lkdGhfbW9iaWxlX2V4dHJhIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sImhfd2lkdGhfbW9iaWxlIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sInRpdGxlX3RhZyI6ImgyIiwic3ViX3RpdGxlX3NwYWNlX2JvdHRvbSI6eyJ1bml0IjoicHgiLCJzaXplIjoxNywic2l6ZXMiOltdfSwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIwIiwicmlnaHQiOiIwIiwiYm90dG9tIjoiMjAiLCJsZWZ0IjoiMCIsImlzTGlua2VkIjpmYWxzZX0sInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI0MDAiLCJweGxfYW5pbWF0ZV9zdWIiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheV9zdWIiOiIzMDAiLCJhbGlnbiI6ImNlbnRlciIsInRpdGxlX3R5cG9ncmFwaHlfdHlwb2dyYXBoeSI6ImN1c3RvbSIsInRpdGxlX3R5cG9ncmFwaHlfZm9udF9zaXplX21vYmlsZSI6eyJ1bml0IjoicHgiLCJzaXplIjo0NSwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9oZWFkaW5nIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjE3ZWZiYjAiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHAgY2xhc3M9XCJ3b3cgZmFkZUluVXAgYW5pbWF0ZWRcIj5cdTA2MjhcdTA2NDcgXHUwNjQ3XHUwNjMyXHUwNjI3XHUwNjMxXHUwNjI3XHUwNjQ2IFx1MDYyOFx1MDZjY1x1MDY0NVx1MDYyN1x1MDYzMSBcdTA2MzFcdTA2MjdcdTA2MzZcdTA2Y2MgXHUwNjI4XHUwNjdlXHUwNmNjXHUwNjQ4XHUwNjQ2XHUwNjJmXHUwNmNjXHUwNjJmIFx1MDZhOVx1MDY0NyBcdTA2MjhcdTA2MzFcdTA2MjdcdTA2Y2MgXHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhXHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY0NVx1MDY0NFx1MDYyN1x1MDZjY1x1MDY0NSBcdTA2NDggXHUwNjJhXHUwNjJlXHUwNjM1XHUwNjM1XHUwNmNjIFx1MDY0OCBcdTA2NDRcdTA2MjhcdTA2MmVcdTA2NDZcdTA2MmZcdTA2NDdcdTA2MjdcdTA2Y2MgXHUwNjMyXHUwNmNjXHUwNjI4XHUwNjI3IFx1MDYyOFx1MDY0NyBcdTA2NDVcdTA2MjcgXHUwNjI3XHUwNjM5XHUwNjJhXHUwNjQ1XHUwNjI3XHUwNjJmIFx1MDY0NVx1MDZjY1x1MjAwY1x1MDZhOVx1MDY0Nlx1MDY0Nlx1MDYyZi4gXHUwNjJhXHUwNjJjXHUwNjMxXHUwNjI4XHUwNjQ3IFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2MjhcdTA2Y2NcdTIwMGNcdTA2NDZcdTA2MzhcdTA2Y2NcdTA2MzEgXHUwNjM0XHUwNjQ1XHUwNjI3IFx1MDYyN1x1MDYzMiBcdTA2MjdcdTA2Y2NcdTA2NDZcdTA2MmNcdTA2MjcgXHUwNjM0XHUwNjMxXHUwNjQ4XHUwNjM5IFx1MDY0NVx1MDZjY1x1MjAwY1x1MDYzNFx1MDY0OFx1MDYyZiE8XC9wPiIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiI1MCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwiYWxpZ24iOiJjZW50ZXIiLCJ0X3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjYyOCwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-6356f20 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"6356f20\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImEwNmY3ZDIiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIyIiwidGVzdGltb25pYWwiOltdLCJ0ZXN0aW1vbmlhbF9sdjIiOlt7Il9pZCI6IjhmNzdkOTUiLCJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2F1dGhvcjEuanBnIiwiaWQiOjkyLCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJ0aXRsZV9sdjIiOiJcdTA2NDVcdTA2Y2NcdTA2YTlcdTA2MjdcdTA2MjZcdTA2Y2NcdTA2NDQgXHUwNjM0XHUwNjQ3XHUwNjI3XHUwNjI4XHUwNmNjIiwicG9zaXRpb24iOiJcdTA2NDVcdTA2MzRcdTA2MmFcdTA2MzFcdTA2Y2MiLCJkZXNjX2x2MiI6IlwiXHUwNjQ1XHUwNjQ2IFx1MDY0N1x1MDY0NVx1MDZjY1x1MDYzNFx1MDY0NyBcdTA2MjdcdTA2MzIgXHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjJjXHUwNjM5XHUwNjQ3IFx1MDYyOFx1MDY0NyBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDZcdTA2N2VcdTA2MzJcdTA2MzRcdTA2YTlcdTA2Y2MgXHUwNjQ2XHUwNmFmXHUwNjMxXHUwNjI3XHUwNjQ2IFx1MDYyOFx1MDY0OFx1MDYyZlx1MDY0N1x1MjAwY1x1MDYyN1x1MDY0NVx1MDYwYyBcdTA2MjdcdTA2NDVcdTA2MjcgXHUwNmE5XHUwNjI3XHUwNjMxXHUwNmE5XHUwNjQ2XHUwNjI3XHUwNjQ2IFx1MDYyOFx1MDYyN1x1MDYzOVx1MDYyYiBcdTA2MzRcdTA2MmZcdTA2NDZcdTA2MmYgXHUwNmE5XHUwNjI3XHUwNjQ1XHUwNjQ0XHUwNjI3XHUwNjRiIFx1MDYyN1x1MDYyZFx1MDYzM1x1MDYyN1x1MDYzMyBcdTA2MzFcdTA2MjdcdTA2MmRcdTA2MmFcdTA2Y2MgXHUwNmE5XHUwNjQ2XHUwNjQ1LiBcdTA2NDVcdTA2MzFcdTA2MjdcdTA2NDJcdTA2MjhcdTA2MmEgXHUwNjQ1XHUwNjQ0XHUwNjI3XHUwNmNjXHUwNjQ1IFx1MDY0OCBcdTA2MmFcdTA2NDhcdTA2MmNcdTA2NDcgXHUwNjIyXHUwNjQ2XHUwNjQ3XHUwNjI3IFx1MDYyOFx1MDY0NyBcdTA2MmNcdTA2MzJcdTA2MjZcdTA2Y2NcdTA2MjdcdTA2MmEgXHUwNjQ4XHUwNjI3XHUwNjQyXHUwNjM5XHUwNjI3XHUwNjRiIFx1MDYyOFx1MDYzMVx1MDYyY1x1MDYzM1x1MDYyYVx1MDY0NyBcdTA2MjdcdTA2MzNcdTA2MmEuXCIifSx7Il9pZCI6IjRjODBiZWYiLCJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL3Rlc3R0aW1vLWltZzMuanBnIiwiaWQiOjIxOCwic2l6ZSI6IiIsImFsdCI6IiIsInNvdXJjZSI6ImxpYnJhcnkifSwidGl0bGVfbHYyIjoiXHUwNjMxXHUwNjI3XHUwNjQ1XHUwNmNjXHUwNjQ2IFx1MDYzM1x1MDY0N1x1MDYzMVx1MDYyN1x1MDYyOFx1MDZjY1x1MjAwY1x1MDY0Nlx1MDY5OFx1MDYyN1x1MDYyZiIsInBvc2l0aW9uIjoiXHUwNjQ1XHUwNjM0XHUwNjJhXHUwNjMxXHUwNmNjIiwiZGVzY19sdjIiOiJcIlx1MDY0NVx1MDY0NiBcdTA2NDggXHUwNjJlXHUwNjI3XHUwNjQ2XHUwNjQ4XHUwNjI3XHUwNjJmXHUwNjQ3XHUyMDBjXHUwNjI3XHUwNjQ1IFx1MDYzM1x1MDYyN1x1MDY0NFx1MjAwY1x1MDY0N1x1MDYyN1x1MDYzM1x1MDYyYSBcdTA2YTlcdTA2NDcgXHUwNjI4XHUwNjQ3IFx1MDYyN1x1MDZjY1x1MDY0Nlx1MDYyY1x1MDYyNyBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2MjJcdTA2Y2NcdTA2NDUuIFx1MDYyZVx1MDYyZlx1MDY0NVx1MDYyN1x1MDYyYSBcdTA2NDFcdTA2NDhcdTA2NDJcdTIwMGNcdTA2MjdcdTA2NDRcdTA2MzlcdTA2MjdcdTA2MmZcdTA2NDcgXHUwNjI3XHUwNjMzXHUwNjJhIFx1MDY0OCBcdTA2MmFcdTA2Y2NcdTA2NDUgXHUwNjQ1XHUwNjI3IFx1MDY0N1x1MDY0NVx1MDZjY1x1MDYzNFx1MDY0NyBcdTA2MmFcdTA2NDVcdTA2MjdcdTA2NDUgXHUwNjJhXHUwNjQ0XHUwNjI3XHUwNjM0IFx1MDYyZVx1MDY0OFx1MDYyZiBcdTA2MzFcdTA2MjcgXHUwNjQ1XHUwNmNjXHUyMDBjXHUwNmE5XHUwNjQ2XHUwNjJmIFx1MDYyYVx1MDYyNyBcdTA2NDVcdTA2MzdcdTA2NDVcdTA2MjZcdTA2NDYgXHUwNjM0XHUwNjQ4XHUwNjJmIFx1MDY0NVx1MDYyNyBcdTA2MzFcdTA2MjdcdTA2MzZcdTA2Y2MgXHUwNjQ3XHUwNjMzXHUwNjJhXHUwNmNjXHUwNjQ1IFx1MDY0OCBcdTA2MjhcdTA2NDcgXHUwNjJlXHUwNjQ4XHUwNjI4XHUwNmNjIFx1MDYyN1x1MDYzMiBcdTA2NDVcdTA2MjcgXHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhIFx1MDY0NVx1MDZjY1x1MjAwY1x1MDYzNFx1MDY0OFx1MDYyZi5cIiJ9LHsiX2lkIjoiZGQ0OTgwNiIsImltYWdlIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC93cC1jb250ZW50XC91cGxvYWRzXC8yMDI1XC8wOFwvdGVzdHRpbW8taW1nNC5qcGciLCJpZCI6MjE5LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJ0aXRsZV9sdjIiOiJcdTA2MjJcdTA2MzFcdTA2MjdcdTA2MmYgXHUwNjI3XHUwNjQ1XHUwNjI3XHUwNjQ1XHUwNmNjXHUyMDBjXHUwNjQxXHUwNjMxIiwicG9zaXRpb24iOiJcdTA2NDVcdTA2MzRcdTA2MmFcdTA2MzFcdTA2Y2MiLCJkZXNjX2x2MiI6IlwiXHUwNjQ1XHUwNjQ2IFx1MDYyOFx1MDYzMVx1MDYyN1x1MDZjYyBcdTA2MzNcdTA2NDFcdTA2Y2NcdTA2MmYgXHUwNmE5XHUwNjMxXHUwNjJmXHUwNjQ2IFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MjAwY1x1MDY0N1x1MDYyN1x1MDZjY1x1MDY0NSBcdTA2MjhcdTA2NDcgXHUwNjQ1XHUwNjM3XHUwNjI4IFx1MDY0NVx1MDYzMVx1MDYyN1x1MDYyY1x1MDYzOVx1MDY0NyBcdTA2YTlcdTA2MzFcdTA2MmZcdTA2NDUgXHUwNjQ4IFx1MDYyOFx1MDYyNyBcdTA2MjdcdTA2MzlcdTA2MmFcdTA2NDVcdTA2MjdcdTA2MmYgXHUwNjI4XHUwNjQ3IFx1MDY0Nlx1MDY0MVx1MDYzM1x1MDZjYyBcdTA2YTlcdTA2MjdcdTA2NDVcdTA2NDRcdTA2MjdcdTA2NGIgXHUwNjJjXHUwNjJmXHUwNmNjXHUwNjJmIFx1MDYyMlx1MDY0Nlx1MDYyY1x1MDYyNyBcdTA2MzFcdTA2MjcgXHUwNjJhXHUwNjMxXHUwNmE5IFx1MDZhOVx1MDYzMVx1MDYyZlx1MDY0NS4gXHUwNjQ2XHUwNjJhXHUwNjI3XHUwNmNjXHUwNjJjIFx1MDYzNFx1MDZhZlx1MDY0MVx1MDYyYVx1MjAwY1x1MDYyN1x1MDY0Nlx1MDZhZlx1MDZjY1x1MDYzMiBcdTA2MjhcdTA2NDhcdTA2MmYgXHUwNjQ4IFx1MDZhOVx1MDYyN1x1MDYzMVx1MDZhOVx1MDY0Nlx1MDYyN1x1MDY0Nlx1MDYwYyBcdTA2MjdcdTA2Y2NcdTA2NDYgXHUwNjJhXHUwNjJjXHUwNjMxXHUwNjI4XHUwNjQ3IFx1MDYzMVx1MDYyNyBcdTA2MjhcdTA2NDcgXHUwNjJhXHUwNjJjXHUwNjMxXHUwNjI4XHUwNjQ3XHUyMDBjXHUwNjI3XHUwNmNjIFx1MDYyMlx1MDYzMVx1MDYyN1x1MDY0NVx1MDYzNFx1MjAwY1x1MDYyOFx1MDYyZVx1MDYzNCBcdTA2MmFcdTA2MjhcdTA2MmZcdTA2Y2NcdTA2NDQgXHUwNmE5XHUwNjMxXHUwNjJmXHUwNjQ2XHUwNjJmLlwiIn0seyJfaWQiOiJlMTZjMjgxIiwiaW1hZ2UiOnsidXJsIjoiaHR0cHM6XC9cL2RlbnRpYS5zdW50aGVtZXMuaXJcL3dwLWNvbnRlbnRcL3VwbG9hZHNcLzIwMjVcLzA4XC90ZXN0dGltby1pbWc1LmpwZyIsImlkIjoyMjAsInNpemUiOiIiLCJhbHQiOiIiLCJzb3VyY2UiOiJsaWJyYXJ5In0sInRpdGxlX2x2MiI6Ilx1MDYzM1x1MDZjY1x1MDY0Nlx1MDYyNyBcdTA2NDFcdTA2NDdcdTA2Y2NcdTA2NDVcdTA2Y2MiLCJwb3NpdGlvbiI6Ilx1MDY0NVx1MDYzNFx1MDYyYVx1MDYzMVx1MDZjYyIsImRlc2NfbHYyIjoiXCJcIlx1MDYyMlx1MDY0Nlx1MDY0N1x1MDYyNyBcdTA2MmRcdTA2MzFcdTA2NDFcdTA2NDdcdTIwMGNcdTA2MjdcdTA2Y2NcdTA2MGMgXHUwNjJmXHUwNjQ4XHUwNjMzXHUwNjJhXHUwNjI3XHUwNjQ2XHUwNjQ3IFx1MDY0OCBcdTA2NDhcdTA2MjdcdTA2NDJcdTA2MzlcdTA2MjdcdTA2NGIgXHUwNjI4XHUwNjQ3IFx1MDYzM1x1MDY0NFx1MDYyN1x1MDY0NVx1MDYyYSBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDZcdTIwMGNcdTA2NDdcdTA2MjdcdTA2Y2MgXHUwNjM0XHUwNjQ1XHUwNjI3IFx1MDYyN1x1MDY0N1x1MDY0NVx1MDZjY1x1MDYyYSBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2MmZcdTA2NDdcdTA2NDZcdTA2MmYuIFx1MDY0NVx1MDY0NiBcdTA2YTlcdTA2MjdcdTA2NDVcdTA2NDRcdTA2MjdcdTA2NGIgXHUwNjI4XHUwNjQ3IFx1MDYyMlx1MDY0Nlx1MDY0N1x1MDYyNyBcdTA2MjdcdTA2MzlcdTA2MmFcdTA2NDVcdTA2MjdcdTA2MmYgXHUwNjJmXHUwNjI3XHUwNjMxXHUwNjQ1IFx1MDY0OCBcdTA2MjJcdTA2NDZcdTA2NDdcdTA2MjcgXHUwNjMxXHUwNjI3IFx1MDYyOFx1MDY0NyBcdTA2NDdcdTA2MzEgXHUwNmE5XHUwNjMzXHUwNmNjIFx1MDZhOVx1MDY0NyBcdTA2MjhcdTA2NDcgXHUwNjJmXHUwNjQ2XHUwNjI4XHUwNjI3XHUwNjQ0IFx1MDY0NVx1MDYzMVx1MDYyN1x1MDY0Mlx1MDYyOFx1MDYyYSBcdTA2MzlcdTA2MjdcdTA2NDRcdTA2Y2MgXHUwNjI3XHUwNjMzXHUwNjJhIFx1MDYyYVx1MDY0OFx1MDYzNVx1MDZjY1x1MDY0NyBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2YTlcdTA2NDZcdTA2NDUuXCIifSx7Il9pZCI6Ijk5MTA2ZjAiLCJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL3Rlc3R0aW1vLWltZzYuanBnIiwiaWQiOjIyMSwic2l6ZSI6IiIsImFsdCI6IiIsInNvdXJjZSI6ImxpYnJhcnkifSwidGl0bGVfbHYyIjoiXHUwNjM0XHUwNjI3XHUwNjQ3XHUwNjQ4IFx1MDYyMlx1MDYzMVx1MDZjY1x1MDYyN1x1MDY0NiIsInBvc2l0aW9uIjoiXHUwNjQ1XHUwNjM0XHUwNjJhXHUwNjMxXHUwNmNjIiwiZGVzY19sdjIiOiJcIlx1MDYyOFx1MDYyZlx1MDY0OFx1MDY0NiBcdTA2MzRcdTA2YTkgXHUwNjI4XHUwNjQ3XHUwNjJhXHUwNjMxXHUwNmNjXHUwNjQ2IFx1MDYyYVx1MDYyY1x1MDYzMVx1MDYyOFx1MDY0NyBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDZcdTA2N2VcdTA2MzJcdTA2MzRcdTA2YTlcdTA2Y2MgXHUwNmE5XHUwNjQ3IFx1MDYyYVx1MDYyNyBcdTA2MjhcdTA2NDcgXHUwNjJkXHUwNjI3XHUwNjQ0IFx1MDYyZlx1MDYyN1x1MDYzNFx1MDYyYVx1MDY0N1x1MjAwY1x1MDYyN1x1MDY0NS4gXHUwNjQ3XHUwNjQ1XHUwNjQ3IFx1MDY4Nlx1MDZjY1x1MDYzMiBcdTA2MjdcdTA2MzIgXHUwNjJhXHUwNjM5XHUwNmNjXHUwNmNjXHUwNjQ2IFx1MDY0OFx1MDY0Mlx1MDYyYSBcdTA2MmFcdTA2MjcgXHUwNjJmXHUwNjMxXHUwNjQ1XHUwNjI3XHUwNjQ2IFx1MDYzMVx1MDY0OFx1MDYyN1x1MDY0Nlx1MDYwYyBcdTA2MzFcdTA2MjdcdTA2MmRcdTA2MmEgXHUwNjQ4IFx1MDYyOFx1MDYyNyBcdTA2MzNcdTA2NDRcdTA2Y2NcdTA2NDJcdTA2NDcgXHUwNjM0XHUwNjJlXHUwNjM1XHUwNmNjIFx1MDYyN1x1MDY0Nlx1MDYyY1x1MDYyN1x1MDY0NSBcdTA2MzRcdTA2MmYuXCIifSx7Il9pZCI6IjY5MTcwZDkiLCJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL3Rlc3R0aW1vLWltZzcuanBnIiwiaWQiOjIyMiwic2l6ZSI6IiIsImFsdCI6IiIsInNvdXJjZSI6ImxpYnJhcnkifSwidGl0bGVfbHYyIjoiXHUwNjdlXHUwNmNjXHUwNjQ1XHUwNjI3XHUwNjQ2IFx1MDYyN1x1MDZhOVx1MDYyOFx1MDYzMVx1MDZjY1x1MDYyN1x1MDY0NiIsInBvc2l0aW9uIjoiXHUwNjQ1XHUwNjM0XHUwNjJhXHUwNjMxXHUwNmNjIiwiZGVzY19sdjIiOiJcIlx1MDY0NVx1MDY0NiBcdTA2NDdcdTA2MzFcdTA2YWZcdTA2MzIgXHUwNjJmXHUwNjMxIFx1MDY0NVx1MDYzN1x1MDYyOCBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDZcdTA2N2VcdTA2MzJcdTA2MzRcdTA2YTlcdTA2Y2MgXHUwNjJhXHUwNjI3IFx1MDYyN1x1MDZjY1x1MDY0NiBcdTA2MmRcdTA2MmYgXHUwNjI3XHUwNjJkXHUwNjMzXHUwNjI3XHUwNjMzIFx1MDYzMVx1MDYyN1x1MDYyZFx1MDYyYVx1MDZjYyBcdTA2NDZcdTA2YTlcdTA2MzFcdTA2MmZcdTA2NDcgXHUwNjI4XHUwNjQ4XHUwNjJmXHUwNjQ1LiBcdTA2MmFcdTA2Y2NcdTA2NDUgXHUwNjIyXHUwNjQ2XHUwNjQ3XHUwNjI3IFx1MDYyOFx1MDYzM1x1MDZjY1x1MDYyN1x1MDYzMSBcdTA2NDVcdTA2NDdcdTA2MzFcdTA2MjhcdTA2MjdcdTA2NDZcdTA2MGMgXHUwNjJkXHUwNjMxXHUwNjQxXHUwNjQ3XHUyMDBjXHUwNjI3XHUwNmNjIFx1MDY0OCBcdTA2MmZcdTA2NDJcdTA2Y2NcdTA2NDIgXHUwNjI3XHUwNjMzXHUwNjJhLiBcdTA2MjJcdTA2NDZcdTA2NDdcdTA2MjcgXHUwNjQ3XHUwNjQ1XHUwNmNjXHUwNjM0XHUwNjQ3IFx1MDY0N1x1MDY0NVx1MDY0NyBcdTA2ODZcdTA2Y2NcdTA2MzIgXHUwNjMxXHUwNjI3IFx1MDYyOFx1MDYyNyBcdTA2MmNcdTA2MzJcdTA2MjZcdTA2Y2NcdTA2MjdcdTA2MmEgXHUwNjJhXHUwNjQ4XHUwNjM2XHUwNmNjXHUwNjJkIFx1MDY0NVx1MDZjY1x1MjAwY1x1MDYyZlx1MDY0N1x1MDY0Nlx1MDYyZiBcdTA2NDggXHUwNjQ1XHUwNjQ2IFx1MDY0N1x1MDYzMSBcdTA2MjhcdTA2MjdcdTA2MzEgXHUwNjI4XHUwNjI3IFx1MDY0NFx1MDYyOFx1MDYyZVx1MDY0Nlx1MDYyZiBcdTA2MjJcdTA2NDZcdTA2MmNcdTA2MjcgXHUwNjMxXHUwNjI3IFx1MDYyYVx1MDYzMVx1MDZhOSBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2YTlcdTA2NDZcdTA2NDUhXCIifSx7Il9pZCI6IjJmZDE2NzkiLCJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL3Rlc3R0aW1vLWltZzguanBnIiwiaWQiOjIyMywic2l6ZSI6IiIsImFsdCI6IiIsInNvdXJjZSI6ImxpYnJhcnkifSwidGl0bGVfbHYyIjoiXHUwNjJmXHUwNjI3XHUwNjQ2XHUwNmNjXHUwNjI3XHUwNjQ0IFx1MDYyOFx1MDZjY1x1MDZhZlx1MDZjYyIsInBvc2l0aW9uIjoiXHUwNjQ1XHUwNjM0XHUwNjJhXHUwNjMxXHUwNmNjIiwiZGVzY19sdjIiOiJcIlx1MDYyYVx1MDYyY1x1MDYzMVx1MDYyOFx1MDY0NyBcdTA2NDVcdTA2NDYgXHUwNjI3XHUwNmNjXHUwNjQ2XHUwNjJjXHUwNjI3IFx1MDY0MVx1MDY0OFx1MDY0Mlx1MjAwY1x1MDYyN1x1MDY0NFx1MDYzOVx1MDYyN1x1MDYyZlx1MDY0NyBcdTA2MjhcdTA2NDhcdTA2MmZcdTA2NDcgXHUwNjI3XHUwNjMzXHUwNjJhISBcdTA2YTlcdTA2MjdcdTA2MzFcdTA2YTlcdTA2NDZcdTA2MjdcdTA2NDYgXHUwNjJlXHUwNjQ4XHUwNjM0XHUyMDBjXHUwNjI4XHUwNjMxXHUwNjJlXHUwNjQ4XHUwNjMxXHUwNjJmIFx1MDY0N1x1MDYzM1x1MDYyYVx1MDY0Nlx1MDYyZlx1MDYwYyBcdTA2NDVcdTA2MzdcdTA2MjggXHUwNjI4XHUwNmNjXHUyMDBjXHUwNjM5XHUwNmNjXHUwNjI4IFx1MDY0OCBcdTA2NDZcdTA2NDJcdTA2MzUgXHUwNjI3XHUwNjMzXHUwNjJhIFx1MDY0OCBcdTA2NDVcdTA2MzFcdTA2MjdcdTA2NDJcdTA2MjhcdTA2MmFcdTIwMGNcdTA2NDdcdTA2MjcgXHUwNjJmXHUwNjMxXHUwNjJjXHUwNjQ3IFx1MDZjY1x1MDZhOSBcdTA2NDdcdTA2MzNcdTA2MmFcdTA2NDZcdTA2MmYuIFx1MDY0NVx1MDY0NiBcdTA2NDdcdTA2NDVcdTA2Y2NcdTA2MzRcdTA2NDcgXHUwNjI3XHUwNjJkXHUwNjMzXHUwNjI3XHUwNjMzIFx1MDYyMlx1MDYzMVx1MDYyN1x1MDY0NVx1MDYzNCBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2YTlcdTA2NDZcdTA2NDUgXHUwNjQ4IFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MjAwY1x1MDY0N1x1MDYyN1x1MDZjY1x1MDY0NSBcdTA2NDdcdTA2MzFcdTA2YWZcdTA2MzIgXHUwNjI4XHUwNjQ3XHUwNjJhXHUwNjMxIFx1MDYyN1x1MDYzMiBcdTA2MjdcdTA2Y2NcdTA2NDYgXHUwNjI4XHUwNjQ3IFx1MDY0Nlx1MDYzOFx1MDYzMSBcdTA2NDZcdTA2MzFcdTA2MzNcdTA2Y2NcdTA2MmZcdTA2NDdcdTIwMGNcdTA2MjdcdTA2NDZcdTA2MmYhXCIifSx7Il9pZCI6IjAxOGUzYzYiLCJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL3Rlc3R0aW1vLWltZzkuanBnIiwiaWQiOjIyNCwic2l6ZSI6IiIsImFsdCI6IiIsInNvdXJjZSI6ImxpYnJhcnkifSwidGl0bGVfbHYyIjoiXHUwNjMzXHUwNjI3XHUwNjQ1XHUwNjI3XHUwNjQ2IFx1MDYyOFx1MDZjY1x1MDYzMVx1MDYyN1x1MDY0NVx1MDZjYyIsInBvc2l0aW9uIjoiXHUwNjQ1XHUwNjM0XHUwNjJhXHUwNjMxXHUwNmNjIiwiZGVzY19sdjIiOiJcIlx1MDYyN1x1MDYzMiBcdTA2NDdcdTA2NDVcdTA2MjdcdTA2NDYgXHUwNjQ0XHUwNjJkXHUwNjM4XHUwNjQ3IFx1MDY0OFx1MDYzMVx1MDY0OFx1MDYyZlx1MDYwYyBcdTA2MjdcdTA2MmRcdTA2MzNcdTA2MjdcdTA2MzMgXHUwNjMxXHUwNjI3XHUwNjJkXHUwNjJhXHUwNmNjIFx1MDZhOVx1MDYzMVx1MDYyZlx1MDY0NS4gXHUwNmE5XHUwNjI3XHUwNjMxXHUwNmE5XHUwNjQ2XHUwNjI3XHUwNjQ2IFx1MDYzN1x1MDY0OFx1MDYzMVx1MDZjYyBcdTA2MzFcdTA2NDFcdTA2MmFcdTA2MjdcdTA2MzEgXHUwNmE5XHUwNjMxXHUwNjJmXHUwNjQ2XHUwNjJmIFx1MDZhOVx1MDY0NyBcdTA2MjdcdTA2MmRcdTA2MzNcdTA2MjdcdTA2MzMgXHUwNmE5XHUwNjQ2XHUwNjQ1IFx1MDY0NVx1MDYyYlx1MDY0NCBcdTA2MmVcdTA2MjdcdTA2NDZcdTA2NDhcdTA2MjdcdTA2MmZcdTA2NDdcdTIwMGNcdTA2MjdcdTA2NDUgXHUwNjQ3XHUwNjMzXHUwNjJhXHUwNjQ1IFx1MDY0OCBcdTA2NDVcdTA2MzFcdTA2MjdcdTA2NDJcdTA2MjhcdTA2MmFcdTA2Y2MgXHUwNmE5XHUwNjQ3IFx1MDYyZlx1MDYzMVx1MDZjY1x1MDYyN1x1MDY0MVx1MDYyYSBcdTA2YTlcdTA2MzFcdTA2MmZcdTA2NDUgXHUwNjI3XHUwNjMzXHUwNjJhXHUwNjJiXHUwNjQ2XHUwNjI3XHUwNmNjXHUwNmNjIFx1MDYyOFx1MDY0OFx1MDYyZi4gXHUwNjI3XHUwNjMyIFx1MDY0NFx1MDYyOFx1MDYyZVx1MDY0Nlx1MDYyZlx1MDY0NSBcdTA2MmVcdTA2Y2NcdTA2NDRcdTA2Y2MgXHUwNjMxXHUwNjI3XHUwNjM2XHUwNmNjIFx1MDY0N1x1MDYzM1x1MDYyYVx1MDY0NS4gXHUwNjI4XHUwNjI3XHUwNjI4XHUwNjJhIFx1MDY0N1x1MDY0NVx1MDY0NyBcdTA2ODZcdTA2Y2NcdTA2MzIgXHUwNjQ1XHUwNjQ1XHUwNjQ2XHUwNjQ4XHUwNjQ2XHUwNjQ1IVwiIn1dLCJjb2xfeHhsIjoiNSIsImNlbnRlciI6InRydWUiLCJwYWdpbmF0aW9uIjoidHJ1ZSIsImluZmluaXRlIjoidHJ1ZSIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI2MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6Ii0yNDAiLCJib3R0b20iOiIwIiwibGVmdCI6Ii0yNDAiLCJpc0xpbmtlZCI6ZmFsc2V9LCJjb2xfbWQiOiIyIiwiX21hcmdpbl90YWJsZXQiOnsidW5pdCI6InB4IiwidG9wIjoiMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjAiLCJsZWZ0IjoiMCIsImlzTGlua2VkIjpmYWxzZX19LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfdGVzdGltb25pYWxfY2Fyb3VzZWwifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-d1c1cbb e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"d1c1cbb\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-8418409 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"8418409\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjBkMWM2YzIiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYyMlx1MDY0NVx1MDYyN1x1MDYyZlx1MDY0NyBcdTA2MzFcdTA2MzJcdTA2MzFcdTA2NDggXHUwNjQ2XHUwNjQ4XHUwNjI4XHUwNjJhIFx1MDYyZVx1MDY0OFx1MDYyZiBcdTA2NDdcdTA2MzNcdTA2MmFcdTA2Y2NcdTA2MmZcdTA2MWYiLCJ0aXRsZV9jb2xvciI6IiNGRkZGRkYiLCJ0aXRsZV90eXBvZ3JhcGh5X3R5cG9ncmFwaHkiOiJjdXN0b20iLCJ0aXRsZV90eXBvZ3JhcGh5X2ZvbnRfc2l6ZSI6eyJ1bml0IjoicHgiLCJzaXplIjozMiwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9oZWFkaW5nIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjNjZjdjNGIiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjQ3XHUwNjQ1XHUwNmNjXHUwNjQ2IFx1MDYyN1x1MDY0NVx1MDYzMVx1MDY0OFx1MDYzMiBcdTA2MjhcdTA2MjcgXHUwNjQ1XHUwNjI3IFx1MDYyYVx1MDY0NVx1MDYyN1x1MDYzMyBcdTA2MjhcdTA2YWZcdTA2Y2NcdTA2MzFcdTA2Y2NcdTA2MmYgXHUwNjJhXHUwNjI3IFx1MDY0OFx1MDY0Mlx1MDYyYSBcdTA2NDVcdTA2NDRcdTA2MjdcdTA2NDJcdTA2MjdcdTA2MmEgXHUwNjJlXHUwNjQ4XHUwNjJmIFx1MDYzMVx1MDYyNyBcdTA2MzFcdTA2MzJcdTA2MzFcdTA2NDggXHUwNmE5XHUwNjQ2XHUwNmNjXHUwNjJmIFx1MDY0OCBcdTA2MjdcdTA2NDhcdTA2NDRcdTA2Y2NcdTA2NDYgXHUwNjQyXHUwNjJmXHUwNjQ1IFx1MDYzMVx1MDYyNyBcdTA2MjhcdTA2MzFcdTA2MjdcdTA2Y2MgXHUwNjJmXHUwNjI3XHUwNjM0XHUwNjJhXHUwNjQ2IFx1MDY0NFx1MDYyOFx1MDYyZVx1MDY0Nlx1MDYyZlx1MDZjYyBcdTA2MzNcdTA2MjdcdTA2NDRcdTA2NDVcdTIwMGNcdTA2MmFcdTA2MzEgXHUwNjI4XHUwNjMxXHUwNjJmXHUwNjI3XHUwNjMxXHUwNmNjXHUwNjJmLjxcL3A+IiwidGV4dF9jb2xvciI6IiNGRkZGRkY5OSJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfdGV4dF9lZGl0b3IifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-97ded05 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"97ded05\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImI3YTczODEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0IjoiXHUwNjMxXHUwNjMyXHUwNjMxXHUwNjQ4IFx1MDY0Nlx1MDY0OFx1MDYyOFx1MDYyYSIsImFsaWduIjoibGVmdCIsImJvcmRlcl90eXBlIjoic29saWQiLCJib3JkZXJfd2lkdGgiOnsidW5pdCI6InB4IiwidG9wIjoiMSIsInJpZ2h0IjoiMSIsImJvdHRvbSI6IjEiLCJsZWZ0IjoiMSIsImlzTGlua2VkIjp0cnVlfSwiYm9yZGVyX2NvbG9yIjoiI0ZGRkZGRjgwIiwiYm9yZGVyX2NvbG9yX2hvdmVyIjoiIzEwMjQ0QiIsImxpbmsiOnsidXJsIjoiaHR0cHM6XC9cL2RlbnRpYS5zdW50aGVtZXMuaXJcL2Jvb2tpbmdcLyIsImlzX2V4dGVybmFsIjoiIiwibm9mb2xsb3ciOiIiLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9fSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2J1dHRvbiJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\",\"scripts\":[],\"styles\":[]}}\";}","auto-off");

INSERT IGNORE INTO `wp_options` VALUES 
("914","pxl_hidden_template_options","a:27:{s:17:\"_wp_page_template\";s:7:\"default\";s:13:\"header_layout\";s:4:\"1594\";s:20:\"header_layout_sticky\";s:2:\"-1\";s:6:\"logo_m\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:12:\"mobile_style\";s:7:\"inherit\";s:6:\"p_menu\";s:0:\"\";s:13:\"sticky_scroll\";s:2:\"-1\";s:7:\"pt_mode\";s:4:\"none\";s:13:\"custom_ptitle\";s:0:\"\";s:16:\"page_sidebar_pos\";s:1:\"0\";s:15:\"content_spacing\";a:3:{s:5:\"units\";s:2:\"px\";s:11:\"padding-top\";s:1:\"0\";s:14:\"padding-bottom\";s:1:\"0\";}s:13:\"footer_layout\";s:2:\"-1\";s:14:\"p_footer_fixed\";s:7:\"inherit\";s:13:\"body_bg_color\";s:0:\"\";s:13:\"primary_color\";s:0:\"\";s:15:\"secondary_color\";s:0:\"\";s:14:\"gradient_color\";a:2:{s:4:\"from\";s:0:\"\";s:2:\"to\";s:0:\"\";}s:17:\"body_custom_class\";s:0:\"\";s:20:\"_elementor_edit_mode\";s:7:\"builder\";s:24:\"_elementor_template_type\";s:7:\"wp-page\";s:18:\"_elementor_version\";s:6:\"3.32.0\";s:15:\"_elementor_data\";s:76806:\"[{\"id\":\"5161d23\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"slideshow\",\"background_slideshow_gallery\":[{\"id\":1485,\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/1-min-e1758004018967.jpg\"},{\"id\":1486,\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/2-min-e1758004028449.jpg\"}],\"background_slideshow_background_size\":\"cover\",\"background_slideshow_background_position\":\"center center\",\"background_slideshow_lazyload\":\"yes\",\"background_overlay_background\":\"gradient\",\"background_overlay_color\":\"#000A5B66\",\"background_overlay_color_stop\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"background_overlay_color_b\":\"#000A5B\",\"background_overlay_gradient_angle\":{\"unit\":\"deg\",\"size\":-90,\"sizes\":[]},\"background_overlay_opacity\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"padding\":{\"unit\":\"px\",\"top\":\"220\",\"right\":\"15\",\"bottom\":\"192\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"background_slideshow_slide_transition\":\"slide_right\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"73\",\"right\":\"15\",\"bottom\":\"70\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"0b31933\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"bd11b0a\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0644\\u0628\\u062e\\u0646\\u062f\\u0647\\u0627\\u06cc \\u0632\\u06cc\\u0628\\u0627\\u062a\\u0631 \\u0628\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u062a\\u062e\\u0635\\u0635\\u06cc \\u0648 \\u0644\\u0645\\u0633 \\u0645\\u0644\\u0627\\u06cc\\u0645\",\"sub_title\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647\",\"h_width\":{\"unit\":\"%\",\"size\":49,\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":55,\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h1\",\"title_color\":\"#FFFFFF\",\"sub_title_color\":\"#FFFFFF\",\"sub_title_typography_typography\":\"custom\",\"sub_title_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"sub_title_typography_font_weight\":\"600\",\"sub_title_typography_line_height\":{\"unit\":\"em\",\"size\":1.5,\"sizes\":[]},\"sub_title_typography_line_height_laptop\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"sub_title_typography_line_height_tablet_extra\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"sub_title_typography_line_height_mobile_extra\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\"},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"c162dc7\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0631\\u0632\\u0631\\u0648 \\u0646\\u0648\\u0628\\u062a\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/booking\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"btn_bg_color\":\"#02010100\",\"border_type\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"border_color\":\"#FFFFFF\",\"color_hover\":\"#FFFFFF\",\"btn_bg_color_hover\":\"#000A5B\",\"btn_bg_color_active\":\"#000A5B\",\"btn_bg_color_focus\":\"#000A5B\",\"border_color_hover\":\"#000A5B\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"30\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_button\"},{\"id\":\"9d1bee4\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_align_items\":\"center\",\"flex_gap\":{\"column\":\"15\",\"row\":\"15\",\"isLinked\":true,\"unit\":\"px\",\"size\":15},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"animation\":\"fadeInUp\",\"animation_delay\":600,\"flex_wrap\":\"wrap\"},\"elements\":[{\"id\":\"ac6b6cf\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<div class=\\\"me-3\\\">\\u0631\\u062a\\u0628\\u0647\\u200c\\u0628\\u0646\\u062f\\u06cc \\u06af\\u0648\\u06af\\u0644<\\/div>\",\"text_color\":\"#F8F9FA\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"05b35cf\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<div class=\\\"me-3\\\"><div class=\\\"me-3\\\">5.0<\\/div><\\/div>\",\"text_color\":\"#F8F9FA\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"bd513bf\",\"elType\":\"widget\",\"settings\":{\"icons\":[{\"_id\":\"e1ef7bc\",\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"}},{\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"},\"_id\":\"1fbf14e\"},{\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"},\"_id\":\"98ed77d\"},{\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"},\"_id\":\"1685a7b\"},{\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"},\"_id\":\"67aa573\"}],\"color\":\"#FEC42C\",\"icon_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"icon_space\":{\"unit\":\"px\",\"size\":2,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_icon\"},{\"id\":\"6531703\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<div class=\\\"me-3\\\"><div class=\\\"me-3\\\"><div class=\\\"me-3\\\">\\u0628\\u0631 \\u0627\\u0633\\u0627\\u0633 \\u06f2\\u06f3 \\u0647\\u0632\\u0627\\u0631 \\u0646\\u0642\\u062f \\u0648 \\u0628\\u0631\\u0631\\u0633\\u06cc<\\/div><\\/div><\\/div>\",\"text_color\":\"#F8F9FA\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false},{\"id\":\"af13e9f\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#000A5B\",\"padding\":{\"unit\":\"px\",\"top\":\"25\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_align_items\":\"center\",\"flex_direction_mobile_extra\":\"column\"},\"elements\":[{\"id\":\"f6f14ff\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"2f08b27\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"15\",\"bottom\":\"0\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_align_items\":\"center\",\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"3627c0a\",\"elType\":\"widget\",\"settings\":{\"layout\":\"2\",\"pxl_icon\":{\"value\":\"fas fa-phone-alt\",\"library\":\"fa-solid\"},\"title\":\"\\u0628\\u0647 \\u062e\\u062f\\u0645\\u0627\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0646\\u06cc\\u0627\\u0632 \\u062f\\u0627\\u0631\\u06cc\\u062f\\u061f\",\"desc\":\"\\u062a\\u0645\\u0627\\u0633: 021123456789\",\"title_color\":\"#FFFFFF\",\"icon_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_width\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"desc_color\":\"#FFFFFF99\",\"icon_color\":\"#4A7DC2\",\"icon_bg_color\":\"#02010100\",\"title_bottom\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"inner_space\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"4a79de0\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"0\",\"left\":\"1\",\"isLinked\":false},\"border_color\":\"#FFFFFF80\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"border_width_mobile_extra\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"1\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"91829d8\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"15\",\"bottom\":\"0\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"pxl_parallax_bg_position\":\"\",\"pxl_parallax_bg_position_laptop\":\"\",\"pxl_parallax_bg_position_tablet_extra\":\"\",\"pxl_parallax_bg_position_tablet\":\"\",\"pxl_parallax_bg_position_mobile_extra\":\"\",\"pxl_parallax_bg_position_mobile\":\"\",\"pxl_parallax_bg_pos_custom_x\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size\":\"\",\"pxl_parallax_bg_size_laptop\":\"\",\"pxl_parallax_bg_size_tablet_extra\":\"\",\"pxl_parallax_bg_size_tablet\":\"\",\"pxl_parallax_bg_size_mobile_extra\":\"\",\"pxl_parallax_bg_size_mobile\":\"\",\"pxl_parallax_bg_size_custom\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"pxl_parallax_bg_size_custom_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_overlay_img_position\":\"\",\"pxl_overlay_img_position_laptop\":\"\",\"pxl_overlay_img_position_tablet_extra\":\"\",\"pxl_overlay_img_position_tablet\":\"\",\"pxl_overlay_img_position_mobile_extra\":\"\",\"pxl_overlay_img_position_mobile\":\"\",\"pxl_overlay_img_right_position\":\"\",\"pxl_overlay_img_right_position_laptop\":\"\",\"pxl_overlay_img_right_position_tablet_extra\":\"\",\"pxl_overlay_img_right_position_tablet\":\"\",\"pxl_overlay_img_right_position_mobile_extra\":\"\",\"pxl_overlay_img_right_position_mobile\":\"\",\"row_effect_images\":[],\"flex_align_items\":\"center\"},\"elements\":[{\"id\":\"b6383c4\",\"elType\":\"widget\",\"settings\":{\"layout\":\"2\",\"pxl_icon\":{\"value\":\"fas fa-clock\",\"library\":\"fa-solid\"},\"title\":\"\\u0633\\u0627\\u0639\\u0627\\u062a \\u06a9\\u0627\\u0631\\u06cc\",\"desc\":\"\\u0647\\u0631 \\u0631\\u0648\\u0632 \\u0627\\u0632 08:00 \\u062a\\u0627 20:00\",\"title_color\":\"#FFFFFF\",\"icon_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_width\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"desc_color\":\"#FFFFFF99\",\"icon_color\":\"#4A7DC2\",\"icon_bg_color\":\"#02010100\",\"title_bottom\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"inner_space\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"_element_width_mobile\":\"inherit\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"6a5100f\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"4eaeb3c\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"15\",\"bottom\":\"0\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"pxl_parallax_bg_position\":\"\",\"pxl_parallax_bg_position_laptop\":\"\",\"pxl_parallax_bg_position_tablet_extra\":\"\",\"pxl_parallax_bg_position_tablet\":\"\",\"pxl_parallax_bg_position_mobile_extra\":\"\",\"pxl_parallax_bg_position_mobile\":\"\",\"pxl_parallax_bg_pos_custom_x\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size\":\"\",\"pxl_parallax_bg_size_laptop\":\"\",\"pxl_parallax_bg_size_tablet_extra\":\"\",\"pxl_parallax_bg_size_tablet\":\"\",\"pxl_parallax_bg_size_mobile_extra\":\"\",\"pxl_parallax_bg_size_mobile\":\"\",\"pxl_parallax_bg_size_custom\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"pxl_parallax_bg_size_custom_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_overlay_img_position\":\"\",\"pxl_overlay_img_position_laptop\":\"\",\"pxl_overlay_img_position_tablet_extra\":\"\",\"pxl_overlay_img_position_tablet\":\"\",\"pxl_overlay_img_position_mobile_extra\":\"\",\"pxl_overlay_img_position_mobile\":\"\",\"pxl_overlay_img_right_position\":\"\",\"pxl_overlay_img_right_position_laptop\":\"\",\"pxl_overlay_img_right_position_tablet_extra\":\"\",\"pxl_overlay_img_right_position_tablet\":\"\",\"pxl_overlay_img_right_position_mobile_extra\":\"\",\"pxl_overlay_img_right_position_mobile\":\"\",\"row_effect_images\":[],\"flex_align_items\":\"center\"},\"elements\":[{\"id\":\"ff38d6d\",\"elType\":\"widget\",\"settings\":{\"layout\":\"2\",\"pxl_icon\":{\"value\":\"fas fa-envelope\",\"library\":\"fa-solid\"},\"title\":\"\\u0627\\u06cc\\u0645\\u06cc\\u0644 \\u0645\\u0627\",\"desc\":\"contact@dentiaclinic.com\",\"title_color\":\"#FFFFFF\",\"icon_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_width\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"desc_color\":\"#FFFFFF99\",\"icon_color\":\"#4A7DC2\",\"icon_bg_color\":\"#02010100\",\"title_bottom\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"inner_space\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"_element_width_mobile\":\"inherit\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false},{\"id\":\"15b34f8\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":50,\"column\":\"50\",\"row\":\"50\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"135\",\"right\":\"15\",\"bottom\":\"130\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_gap_laptop\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"0\",\"bottom\":\"70\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"98ca70d\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"flex_gap\":{\"column\":\"22\",\"row\":\"22\",\"isLinked\":true,\"unit\":\"px\",\"size\":22},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_direction_tablet\":\"column\"},\"elements\":[{\"id\":\"43ff422\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"b698bb4\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/about-img1.jpg\",\"id\":463,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":399,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"300\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"300\"},\"elements\":[],\"widgetType\":\"pxl_image\"}],\"isInner\":true},{\"id\":\"4c3a639\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"padding\":{\"unit\":\"px\",\"top\":\"55\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"3a26ecd\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/about-img2.jpg\",\"id\":464,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":399,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"500\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_image\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"9dd8e84\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"b0297bf\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u062a\\u062e\\u0635\\u0635\\u0627\\u0646 \\u0648 \\u062a\\u0639\\u0627\\u0644\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0634\\u062e\\u0635\\u06cc\",\"sub_title\":\"\\u062f\\u0631\\u0628\\u0627\\u0631\\u0647 \\u0645\\u0627\",\"h_width\":{\"unit\":\"%\",\"size\":80,\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"6bc87e8\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0645\\u0627 \\u062e\\u062f\\u0645\\u0627\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0628\\u0627 \\u06a9\\u06cc\\u0641\\u06cc\\u062a \\u0628\\u0627\\u0644\\u0627 \\u0648 \\u0645\\u062a\\u0646\\u0627\\u0633\\u0628 \\u0628\\u0627 \\u0646\\u06cc\\u0627\\u0632 \\u062a\\u0645\\u0627\\u0645 \\u0627\\u0639\\u0636\\u0627\\u06cc \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647 \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645. \\u0627\\u0632 \\u0645\\u0639\\u0627\\u06cc\\u0646\\u0627\\u062a \\u0631\\u0648\\u062a\\u06cc\\u0646 \\u06af\\u0631\\u0641\\u062a\\u0647 \\u062a\\u0627 \\u062f\\u0631\\u0645\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647\\u060c \\u062a\\u06cc\\u0645 \\u062f\\u0644\\u0633\\u0648\\u0632 \\u0645\\u0627 \\u062a\\u0636\\u0645\\u06cc\\u0646 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u062f \\u06a9\\u0647 \\u0644\\u0628\\u062e\\u0646\\u062f \\u0634\\u0645\\u0627 \\u0633\\u0627\\u0644\\u0645 \\u0648 \\u0628\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f \\u0628\\u0647 \\u0646\\u0641\\u0633 \\u0628\\u0627\\u0642\\u06cc \\u0628\\u0645\\u0627\\u0646\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"17\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"bb0da06\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_gap\":{\"column\":\"35\",\"row\":\"35\",\"isLinked\":true,\"unit\":\"px\",\"size\":35},\"flex_gap_laptop\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_direction_tablet\":\"column\",\"flex_gap_tablet\":{\"column\":\"5\",\"row\":\"5\",\"isLinked\":true,\"unit\":\"px\",\"size\":5}},\"elements\":[{\"id\":\"9028010\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"827cdc3\",\"elType\":\"widget\",\"settings\":{\"lists\":[{\"_id\":\"29fdacb\",\"pxl_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"},\"text\":\"\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0631\\u0645\\u0627\\u0646 \\u0634\\u062e\\u0635\\u06cc\\u200c\\u0633\\u0627\\u0632\\u06cc\\u200c\\u0634\\u062f\\u0647\"},{\"pxl_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"},\"text\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u0645\\u0644\\u0627\\u06cc\\u0645 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646 \\u0648 \\u0628\\u0632\\u0631\\u06af\\u0633\\u0627\\u0644\\u0627\\u0646\",\"_id\":\"7ff6475\"}],\"text_typography_typography\":\"custom\",\"text_typography_font_size_laptop\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"icon_color\":\"#4A7DC2\",\"icon_space\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"03\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"600\",\"align_items\":\"start\"},\"elements\":[],\"widgetType\":\"pxl_list\"}],\"isInner\":true},{\"id\":\"6db1ff5\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"fa6490e\",\"elType\":\"widget\",\"settings\":{\"lists\":[{\"_id\":\"29fdacb\",\"pxl_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"},\"text\":\"\\u0641\\u0646\\u0627\\u0648\\u0631\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647\"},{\"pxl_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"},\"text\":\"\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647\\u200c\\u0631\\u06cc\\u0632\\u06cc \\u0627\\u0646\\u0639\\u0637\\u0627\\u0641\\u200c\\u067e\\u0630\\u06cc\\u0631 \\u0628\\u0631\\u0627\\u06cc \\u0642\\u0631\\u0627\\u0631 \\u0645\\u0644\\u0627\\u0642\\u0627\\u062a\",\"_id\":\"7ff6475\"}],\"text_typography_typography\":\"custom\",\"text_typography_font_size_laptop\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"icon_color\":\"#4A7DC2\",\"icon_space\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"03\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"600\",\"align_items\":\"start\"},\"elements\":[],\"widgetType\":\"pxl_list\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"f3897d9\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0631\\u0632\\u0631\\u0648 \\u0646\\u0648\\u0628\\u062a\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"700\",\"_margin\":{\"unit\":\"px\",\"top\":\"28\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_button\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"9f68bac\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#4A7CD21A\",\"padding\":{\"unit\":\"px\",\"top\":\"120\",\"right\":\"15\",\"bottom\":\"130\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"15\",\"bottom\":\"70\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"ac1ac70\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"c74a3ee\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u06a9\\u0627\\u0645\\u0644 \\u0628\\u0631\\u0627\\u06cc \\u0647\\u0631 \\u0644\\u0628\\u062e\\u0646\\u062f\",\"sub_title\":\"\\u062e\\u062f\\u0645\\u0627\\u062a \\u0645\\u0627\",\"h_width\":{\"unit\":\"%\",\"size\":80,\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]},\"align\":\"center\"},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"72847f9\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0627\\u0632 \\u062a\\u0645\\u06cc\\u0632 \\u06a9\\u0631\\u062f\\u0646\\u200c\\u0647\\u0627\\u06cc \\u0631\\u0648\\u062a\\u06cc\\u0646 \\u06af\\u0631\\u0641\\u062a\\u0647 \\u062a\\u0627 \\u062a\\u0631\\u0645\\u06cc\\u0645\\u200c\\u0647\\u0627\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647\\u060c \\u0645\\u0627 \\u0631\\u0627\\u0647\\u200c\\u062d\\u0644\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0634\\u062e\\u0635\\u06cc\\u200c\\u0633\\u0627\\u0632\\u06cc\\u200c\\u0634\\u062f\\u0647 \\u0631\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u0628\\u06cc\\u0645\\u0627\\u0631\\u0627\\u0646 \\u062f\\u0631 \\u0647\\u0631 \\u0633\\u0646\\u06cc \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"42\",\"left\":\"0\",\"isLinked\":false},\"align\":\"center\",\"t_width\":{\"unit\":\"px\",\"size\":563,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"7371f8b\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"pxl_parallax_bg_position\":\"\",\"pxl_parallax_bg_position_laptop\":\"\",\"pxl_parallax_bg_position_tablet_extra\":\"\",\"pxl_parallax_bg_position_tablet\":\"\",\"pxl_parallax_bg_position_mobile_extra\":\"\",\"pxl_parallax_bg_position_mobile\":\"\",\"pxl_parallax_bg_pos_custom_x\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size\":\"\",\"pxl_parallax_bg_size_laptop\":\"\",\"pxl_parallax_bg_size_tablet_extra\":\"\",\"pxl_parallax_bg_size_tablet\":\"\",\"pxl_parallax_bg_size_mobile_extra\":\"\",\"pxl_parallax_bg_size_mobile\":\"\",\"pxl_parallax_bg_size_custom\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"pxl_parallax_bg_size_custom_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_overlay_img_position\":\"\",\"pxl_overlay_img_position_laptop\":\"\",\"pxl_overlay_img_position_tablet_extra\":\"\",\"pxl_overlay_img_position_tablet\":\"\",\"pxl_overlay_img_position_mobile_extra\":\"\",\"pxl_overlay_img_position_mobile\":\"\",\"pxl_overlay_img_right_position\":\"\",\"pxl_overlay_img_right_position_laptop\":\"\",\"pxl_overlay_img_right_position_tablet_extra\":\"\",\"pxl_overlay_img_right_position_tablet\":\"\",\"pxl_overlay_img_right_position_mobile_extra\":\"\",\"pxl_overlay_img_right_position_mobile\":\"\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"37741dc\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"flex_gap\":{\"column\":\"24\",\"row\":\"24\",\"isLinked\":true,\"unit\":\"px\",\"size\":24},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_wrap_tablet_extra\":\"wrap\",\"flex_gap_laptop\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20}},\"elements\":[{\"id\":\"5855528\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet_extra\":{\"unit\":\"%\",\"size\":48.5,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":48,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"ff281fa\",\"elType\":\"widget\",\"settings\":{\"layout\":\"3\",\"icon_type\":\"image\",\"icon_image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/tooth-1.png\",\"id\":626,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0639\\u0645\\u0648\\u0645\\u06cc\",\"desc\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u06a9\\u0627\\u0645\\u0644 \\u062f\\u0647\\u0627\\u0646 \\u0648 \\u062f\\u0646\\u062f\\u0627\\u0646 \\u0628\\u0631\\u0627\\u06cc \\u0647\\u0631 \\u0644\\u0628\\u062e\\u0646\\u062f\\u06cc \\u0628\\u0627 \\u062c\\u0631\\u0645\\u200c\\u06af\\u06cc\\u0631\\u06cc\\u060c \\u0645\\u0639\\u0627\\u06cc\\u0646\\u0647 \\u0648 \\u0645\\u0648\\u0627\\u0631\\u062f \\u062f\\u06cc\\u06af\\u0631.\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/service\\/general-dentistry\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"title_btn\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"pxl_animate\":\"wow scaleIn\",\"pxl_animate_delay\":\"300\",\"pxl_animate2\":\"wow fadeInUp\",\"pxl_animate_delay2\":\"500\",\"title_color\":\"#10244B\",\"background_color\":\"#FFFFFF\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true},{\"id\":\"62a7ae9\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet_extra\":{\"unit\":\"%\",\"size\":49,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":48.5,\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"c880081\",\"elType\":\"widget\",\"settings\":{\"layout\":\"3\",\"icon_type\":\"image\",\"icon_image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/tooth-2.png\",\"id\":627,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0632\\u06cc\\u0628\\u0627\\u06cc\\u06cc\",\"desc\":\"\\u0632\\u06cc\\u0628\\u0627\\u06cc\\u06cc \\u0644\\u0628\\u062e\\u0646\\u062f \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0628\\u0627 \\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\\u060c \\u0648\\u0646\\u06cc\\u0631\\u0647\\u0627 \\u0648 \\u0645\\u0648\\u0627\\u0631\\u062f \\u062f\\u06cc\\u06af\\u0631 \\u0627\\u0641\\u0632\\u0627\\u06cc\\u0634 \\u062f\\u0647\\u06cc\\u062f.\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/service\\/cosmetic-dentistry\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"title_btn\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"pxl_animate\":\"wow scaleIn\",\"pxl_animate_delay\":\"300\",\"pxl_animate2\":\"wow fadeInUp\",\"pxl_animate_delay2\":\"500\",\"title_color\":\"#10244B\",\"background_color\":\"#FFFFFF\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true},{\"id\":\"964d2d6\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"background_background\":\"classic\",\"background_image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_position\":\"center center\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"width_tablet_extra\":{\"unit\":\"%\",\"size\":48.5,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":48,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"flex_justify_content\":\"center\"},\"elements\":[{\"id\":\"336bf6f\",\"elType\":\"widget\",\"settings\":{\"layout\":\"3\",\"icon_type\":\"image\",\"icon_image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/tooth-3.png\",\"id\":628,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646\",\"desc\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u0645\\u0644\\u0627\\u06cc\\u0645 \\u0648 \\u0633\\u0631\\u06af\\u0631\\u0645\\u200c\\u06a9\\u0646\\u0646\\u062f\\u0647 \\u0627\\u0632 \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646 \\u062a\\u0627 \\u0644\\u0628\\u062e\\u0646\\u062f\\u06cc \\u0633\\u0627\\u0644\\u0645 \\u0648 \\u0634\\u0627\\u062f \\u062f\\u0627\\u0634\\u062a\\u0647 \\u0628\\u0627\\u0634\\u0646\\u062f.\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/service\\/pediatric-dentistry\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"title_btn\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"pxl_animate\":\"wow scaleIn\",\"pxl_animate_delay\":\"300\",\"pxl_animate2\":\"wow fadeInUp\",\"pxl_animate_delay2\":\"500\",\"title_color\":\"#10244B\",\"background_color\":\"#FFFFFF\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true},{\"id\":\"2e4cbee\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet_extra\":{\"unit\":\"%\",\"size\":49,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":48.5,\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"2029233\",\"elType\":\"widget\",\"settings\":{\"layout\":\"3\",\"icon_type\":\"image\",\"icon_image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/tooth-4.png\",\"id\":629,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u062a\\u0631\\u0645\\u06cc\\u0645\\u06cc\",\"desc\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u0634\\u0645\\u0627 \\u0631\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u0631\\u0627\\u062d\\u062a\\u06cc \\u0648 \\u0639\\u0645\\u0644\\u06a9\\u0631\\u062f \\u067e\\u0627\\u06cc\\u062f\\u0627\\u0631 \\u062a\\u0631\\u0645\\u06cc\\u0645 \\u0648 \\u0628\\u0627\\u0632\\u0633\\u0627\\u0632\\u06cc \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u062f.\\n\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/service\\/restorative-dentistry\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"title_btn\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"pxl_animate\":\"wow scaleIn\",\"pxl_animate_delay\":\"300\",\"pxl_animate2\":\"wow fadeInUp\",\"pxl_animate_delay2\":\"500\",\"title_color\":\"#10244B\",\"background_color\":\"#FFFFFF\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true},{\"id\":\"e71413a\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u0647\\u0645\\u0647 \\u062e\\u062f\\u0645\\u0627\\u062a\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/all-services\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"align\":\"center\",\"_margin\":{\"unit\":\"px\",\"top\":\"48\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_button\"}],\"isInner\":false},{\"id\":\"b92d7a4\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#000A5B\",\"padding\":{\"unit\":\"px\",\"top\":\"60\",\"right\":\"15\",\"bottom\":\"60\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"d408d83\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"25\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"c08f676\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0628\\u06cc\\u0645\\u0627\\u0631\\u0627\\u0646 \\u0634\\u0627\\u062f\",\"starting_number\":5000,\"ending_number\":10000,\"suffix\":\"+\",\"pxl_animate\":\"wow fadeInRight\",\"pxl_animate_delay\":\"300\"},\"elements\":[],\"widgetType\":\"pxl_counter\"}],\"isInner\":true},{\"id\":\"3ffca2e\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"25\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"17f3015\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\",\"starting_number\":2000,\"ending_number\":2500,\"suffix\":\"+\",\"pxl_animate\":\"wow fadeInRight\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_counter\"}],\"isInner\":true},{\"id\":\"5163797\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"25\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"344472f\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u06cc\\u0645\\u067e\\u0644\\u0646\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\",\"starting_number\":500,\"ending_number\":800,\"suffix\":\"+\",\"pxl_animate\":\"wow fadeInRight\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_counter\"}],\"isInner\":true},{\"id\":\"7ac7412\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"25\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"62d672d\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0633\\u0627\\u0644 \\u062a\\u062c\\u0631\\u0628\\u0647\",\"ending_number\":15,\"suffix\":\"+\",\"pxl_animate\":\"wow fadeInRight\",\"pxl_animate_delay\":\"600\"},\"elements\":[],\"widgetType\":\"pxl_counter\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"fc38de1\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":50,\"column\":\"50\",\"row\":\"50\",\"isLinked\":true},\"flex_direction_mobile_extra\":\"column\",\"flex_gap_laptop\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"padding\":{\"unit\":\"px\",\"top\":\"120\",\"right\":\"15\",\"bottom\":\"155\",\"left\":\"15\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"0\",\"bottom\":\"70\",\"left\":\"0\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"931cd86\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"c7857de\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0633\\u062a\\u062b\\u0646\\u0627\\u06cc\\u06cc \\u0628\\u0627 \\u0631\\u0648\\u06cc\\u06a9\\u0631\\u062f\\u06cc \\u0634\\u062e\\u0635\\u06cc\",\"sub_title\":\"\\u0686\\u0631\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0645\\u0627 \\u0631\\u0627 \\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u06a9\\u0646\\u06cc\\u062f\",\"h_width\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"602ea93\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0627\\u0631\\u0627\\u0626\\u0647 \\u062f\\u0647\\u0646\\u062f\\u0647 \\u062e\\u062f\\u0645\\u0627\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0645\\u0646\\u0627\\u0633\\u0628 \\u0627\\u0647\\u0645\\u06cc\\u062a \\u062f\\u0627\\u0631\\u062f. \\u0645\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062a\\u062e\\u0635\\u0635\\u06cc\\u060c \\u0641\\u0646\\u0627\\u0648\\u0631\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647 \\u0648 \\u0641\\u0636\\u0627\\u06cc\\u06cc \\u06af\\u0631\\u0645 \\u0631\\u0627 \\u0628\\u0627 \\u0647\\u0645 \\u062a\\u0631\\u06a9\\u06cc\\u0628 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u06cc\\u0645 \\u062a\\u0627 \\u0627\\u0637\\u0645\\u06cc\\u0646\\u0627\\u0646 \\u062d\\u0627\\u0635\\u0644 \\u06a9\\u0646\\u06cc\\u0645 \\u06a9\\u0647 \\u0647\\u0631 \\u0648\\u06cc\\u0632\\u06cc\\u062a \\u0631\\u0627\\u062d\\u062a\\u060c \\u06a9\\u0627\\u0631\\u0622\\u0645\\u062f \\u0648 \\u0645\\u062a\\u0646\\u0627\\u0633\\u0628 \\u0628\\u0627 \\u0646\\u06cc\\u0627\\u0632\\u0647\\u0627\\u06cc \\u0645\\u0646\\u062d\\u0635\\u0631 \\u0628\\u0647 \\u0641\\u0631\\u062f \\u0634\\u0645\\u0627 \\u062e\\u0648\\u0627\\u0647\\u062f \\u0628\\u0648\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"21\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"9f3be1f\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_gap\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"flex_gap_laptop\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_direction_tablet\":\"column\",\"flex_gap_tablet\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"border_color\":\"#0000004D\",\"padding\":{\"unit\":\"px\",\"top\":\"22\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"e4d5e10\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_gap\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"flex_gap_tablet_extra\":{\"column\":\"15\",\"row\":\"15\",\"isLinked\":true,\"unit\":\"px\",\"size\":15}},\"elements\":[{\"id\":\"3f475ce\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"d437b1c\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<h5>\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0628\\u0627\\u062a\\u062c\\u0631\\u0628\\u0647<\\/h5>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"78e6e2b\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062a\\u062e\\u0635\\u0635\\u06cc \\u0628\\u0627 \\u067e\\u0634\\u062a\\u0648\\u0627\\u0646\\u0647 \\u0633\\u0627\\u0644\\u200c\\u0647\\u0627 \\u062a\\u062c\\u0631\\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0642\\u0627\\u0628\\u0644 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"c548350\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"65c31f4\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<h5>\\u062f\\u0631\\u0645\\u0627\\u0646 \\u0634\\u062e\\u0635\\u06cc\\u200c\\u0633\\u0627\\u0632\\u06cc\\u200c\\u0634\\u062f\\u0647<\\/h5>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"24d4409\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647\\u200c\\u0647\\u0627\\u06cc \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u06cc \\u0633\\u0641\\u0627\\u0631\\u0634\\u06cc \\u06a9\\u0647 \\u0645\\u062a\\u0646\\u0627\\u0633\\u0628 \\u0628\\u0627 \\u0644\\u0628\\u062e\\u0646\\u062f \\u0648 \\u0633\\u0628\\u06a9 \\u0632\\u0646\\u062f\\u06af\\u06cc \\u0634\\u0645\\u0627 \\u062a\\u0647\\u06cc\\u0647 \\u0645\\u06cc\\u200c\\u0634\\u0648\\u0646\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"64807c6\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_gap\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"flex_gap_tablet_extra\":{\"column\":\"15\",\"row\":\"15\",\"isLinked\":true,\"unit\":\"px\",\"size\":15}},\"elements\":[{\"id\":\"0cb580b\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"pxl_parallax_bg_position\":\"\",\"pxl_parallax_bg_position_laptop\":\"\",\"pxl_parallax_bg_position_tablet_extra\":\"\",\"pxl_parallax_bg_position_tablet\":\"\",\"pxl_parallax_bg_position_mobile_extra\":\"\",\"pxl_parallax_bg_position_mobile\":\"\",\"pxl_parallax_bg_pos_custom_x\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size\":\"\",\"pxl_parallax_bg_size_laptop\":\"\",\"pxl_parallax_bg_size_tablet_extra\":\"\",\"pxl_parallax_bg_size_tablet\":\"\",\"pxl_parallax_bg_size_mobile_extra\":\"\",\"pxl_parallax_bg_size_mobile\":\"\",\"pxl_parallax_bg_size_custom\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"pxl_parallax_bg_size_custom_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_overlay_img_position\":\"\",\"pxl_overlay_img_position_laptop\":\"\",\"pxl_overlay_img_position_tablet_extra\":\"\",\"pxl_overlay_img_position_tablet\":\"\",\"pxl_overlay_img_position_mobile_extra\":\"\",\"pxl_overlay_img_position_mobile\":\"\",\"pxl_overlay_img_right_position\":\"\",\"pxl_overlay_img_right_position_laptop\":\"\",\"pxl_overlay_img_right_position_tablet_extra\":\"\",\"pxl_overlay_img_right_position_tablet\":\"\",\"pxl_overlay_img_right_position_mobile_extra\":\"\",\"pxl_overlay_img_right_position_mobile\":\"\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"89fbcf5\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<h5>\\u0641\\u0646\\u0627\\u0648\\u0631\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647<\\/h5>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"1a2ce28\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0627\\u0628\\u0632\\u0627\\u0631\\u0647\\u0627\\u06cc \\u0645\\u062f\\u0631\\u0646\\u060c \\u062f\\u0631\\u0645\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0642\\u06cc\\u0642 \\u0648 \\u06a9\\u0627\\u0631\\u0622\\u0645\\u062f \\u0631\\u0627 \\u062a\\u0636\\u0645\\u06cc\\u0646 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0646\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"5c18bec\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"0139430\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<h5>\\u0645\\u0646\\u0627\\u0633\\u0628 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647<\\/h5>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"3e9309c\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0641\\u0636\\u0627\\u06cc\\u06cc \\u062f\\u0644\\u0646\\u0634\\u06cc\\u0646 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646\\u060c \\u0646\\u0648\\u062c\\u0648\\u0627\\u0646\\u0627\\u0646\\u060c \\u0628\\u0632\\u0631\\u06af\\u0633\\u0627\\u0644\\u0627\\u0646 \\u0648 \\u0633\\u0627\\u0644\\u0645\\u0646\\u062f\\u0627\\u0646.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true},{\"id\":\"c0bac5e\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"flex_align_items\":\"center\",\"flex_gap\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"9ce2c5c\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_gap\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"flex_gap_tablet_extra\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"e530c81\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/exceptional2.jpg\",\"id\":607,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":236.80000000000001136868377216160297393798828125,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"300\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"300\",\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"60\",\"isLinked\":false},\"_padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_image\"},{\"id\":\"21bc2cb\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/exceptional1.jpg\",\"id\":606,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":296,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"500\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_image\"}],\"isInner\":true},{\"id\":\"2b3fb22\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"a7be7b9\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/exceptional3.jpg\",\"id\":608,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":399.6000000000000227373675443232059478759765625,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"400\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_image\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false},{\"id\":\"d0d5540\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#4A7CD21A\",\"padding\":{\"unit\":\"px\",\"top\":\"120\",\"right\":\"15\",\"bottom\":\"108\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"15\",\"bottom\":\"70\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"964e490\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"d075595\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u062a\\u0639\\u0647\\u062f \\u0628\\u0647 \\u0644\\u0628\\u062e\\u0646\\u062f \\u0634\\u0645\\u0627\",\"sub_title\":\" \\u0628\\u0627 \\u062a\\u06cc\\u0645 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0645\\u0627 \\u0622\\u0634\\u0646\\u0627 \\u0634\\u0648\\u06cc\\u062f\",\"h_width\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"align\":\"center\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"acd7da4\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p class=\\\"wow fadeInUp animated\\\">\\u062a\\u06cc\\u0645 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0628\\u0627\\u062a\\u062c\\u0631\\u0628\\u0647 \\u0645\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0647\\u0633\\u062a\\u0646\\u062f \\u062a\\u0627 \\u0647\\u0631 \\u0648\\u06cc\\u0632\\u06cc\\u062a \\u0631\\u0627 \\u0645\\u062b\\u0628\\u062a \\u0648 \\u0634\\u062e\\u0635\\u06cc\\u200c\\u0633\\u0627\\u0632\\u06cc\\u200c\\u0634\\u062f\\u0647 \\u06a9\\u0646\\u0646\\u062f. \\u0628\\u0627 \\u062f\\u0633\\u062a\\u0627\\u0646\\u06cc \\u0645\\u0647\\u0631\\u0628\\u0627\\u0646 \\u0648 \\u0642\\u0644\\u0628\\u06cc \\u0645\\u0647\\u0631\\u0628\\u0627\\u0646.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"37\",\"left\":\"0\",\"isLinked\":false},\"align\":\"center\",\"t_width\":{\"unit\":\"px\",\"size\":628,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"8e36ff0\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"9c707a0\",\"elType\":\"widget\",\"settings\":{\"team\":[{\"_id\":\"836b840\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/dentists-img1.jpg\",\"id\":179,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u06a9\\u062a\\u0631 \\u0633\\u0627\\u0631\\u0627 \\u0645\\u06cc\\u0631\\u0632\\u0627\\u0626\\u06cc\",\"position\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0627\\u0631\\u0634\\u062f\"},{\"_id\":\"baa6cb5\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/dentists-img2.jpg\",\"id\":180,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u06a9\\u062a\\u0631 \\u0645\\u0631\\u06cc\\u0645 \\u0622\\u0642\\u0627\\u062c\\u0627\\u0646\\u06cc\",\"position\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0632\\u06cc\\u0628\\u0627\\u06cc\\u06cc\"},{\"_id\":\"3faca8d\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/dentists-img3.jpg\",\"id\":181,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u06a9\\u062a\\u0631 \\u0634\\u0647\\u0627\\u0628 \\u0637\\u0647\\u0645\\u0627\\u0633\\u0628\\u06cc\",\"position\":\"\\u0645\\u062a\\u062e\\u0635\\u0635 \\u0627\\u0637\\u0641\\u0627\\u0644\"},{\"_id\":\"33e5523\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/dentists-img4.jpg\",\"id\":182,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u06a9\\u062a\\u0631 \\u0627\\u0645\\u06cc\\u0631 \\u06a9\\u0631\\u0645\\u0627\\u0646\\u06cc\\u200c\\u0645\\u0642\\u062f\\u0645\",\"position\":\"\\u0628\\u0647\\u062f\\u0627\\u0634\\u062a\\u06a9\\u0627\\u0631 \\u062f\\u0647\\u0627\\u0646 \\u0648 \\u062f\\u0646\\u062f\\u0627\\u0646\"}],\"item_spacer\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"pxl_animate_img\":\"wow zoomInSmall\",\"pxl_animate_img2\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"600\",\"pxl_animate_content\":\"wow fadeInDown\",\"pxl_animate_ct_delay\":\"700\"},\"elements\":[],\"widgetType\":\"pxl_team_grid\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"07e3439\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":30,\"column\":\"30\",\"row\":\"30\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"123\",\"right\":\"15\",\"bottom\":\"120\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_direction_mobile_extra\":\"column\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"0\",\"bottom\":\"70\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"cabeee0\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_mobile_extra\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"92a30c5\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0633\\u0648\\u0627\\u0644\\u0627\\u062a \\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\",\"sub_title\":\"\\u0647\\u0631 \\u0622\\u0646\\u0686\\u0647 \\u06a9\\u0647 \\u0628\\u0627\\u06cc\\u062f \\u0628\\u062f\\u0627\\u0646\\u06cc\\u062f\",\"title_tag\":\"h2\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_heading\"}],\"isInner\":true},{\"id\":\"cb0bd9f\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":68.599999999999994315658113919198513031005859375},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_mobile_extra\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"eff6c82\",\"elType\":\"widget\",\"settings\":{\"active\":0,\"accordion\":[{\"_id\":\"324d3d2\",\"title\":\"\\u0686\\u0646\\u062f \\u0648\\u0642\\u062a \\u06cc\\u06a9\\u0628\\u0627\\u0631 \\u0628\\u0627\\u06cc\\u062f \\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0647 \\u06a9\\u0646\\u0645\\u061f \",\"desc\":\"\\u062a\\u0648\\u0635\\u06cc\\u0647 \\u0645\\u06cc\\u200c\\u0634\\u0648\\u062f \\u0647\\u0631 \\u06f6 \\u0645\\u0627\\u0647 \\u06cc\\u06a9\\u0628\\u0627\\u0631 \\u0628\\u0631\\u0627\\u06cc \\u0645\\u0639\\u0627\\u06cc\\u0646\\u0647 \\u0648 \\u062a\\u0645\\u06cc\\u0632 \\u06a9\\u0631\\u062f\\u0646 \\u0631\\u0648\\u062a\\u06cc\\u0646 \\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u062e\\u0648\\u062f \\u0645\\u0631\\u0627\\u062c\\u0639\\u0647 \\u06a9\\u0646\\u06cc\\u062f\\u060c \\u0645\\u06af\\u0631 \\u0627\\u06cc\\u0646\\u06a9\\u0647 \\u067e\\u0632\\u0634\\u06a9 \\u062a\\u0648\\u0635\\u06cc\\u0647 \\u062f\\u06cc\\u06af\\u0631\\u06cc \\u062f\\u0627\\u0634\\u062a\\u0647 \\u0628\\u0627\\u0634\\u062f. \"},{\"_id\":\"b063b10\",\"title\":\"\\u062f\\u0631 \\u0645\\u0648\\u0627\\u0642\\u0639 \\u0627\\u0648\\u0631\\u0698\\u0627\\u0646\\u0633 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0686\\u0647 \\u0628\\u0627\\u06cc\\u062f \\u0628\\u06a9\\u0646\\u0645\\u061f \",\"desc\":\"\\u0641\\u0648\\u0631\\u0627\\u064b \\u0628\\u0627 \\u0645\\u0637\\u0628 \\u0645\\u0627 \\u062a\\u0645\\u0627\\u0633 \\u0628\\u06af\\u06cc\\u0631\\u06cc\\u062f. \\u0645\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u0645\\u0648\\u0627\\u0631\\u062f\\u06cc \\u0645\\u0627\\u0646\\u0646\\u062f \\u062f\\u0631\\u062f \\u0634\\u062f\\u06cc\\u062f\\u060c \\u0634\\u06a9\\u0633\\u062a\\u06af\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646 \\u06cc\\u0627 \\u062a\\u0648\\u0631\\u0645\\u060c \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u0627\\u0648\\u0631\\u0698\\u0627\\u0646\\u0633\\u06cc \\u062f\\u0631 \\u0647\\u0645\\u0627\\u0646 \\u0631\\u0648\\u0632 \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645. \"},{\"_id\":\"8895a65\",\"title\":\"\\u0622\\u06cc\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u0628\\u0686\\u0647\\u200c\\u0647\\u0627 \\u062e\\u062f\\u0645\\u0627\\u062a\\u06cc \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u062f\\u061f \",\"desc\":\"\\u06a9\\u0627\\u0645\\u0644\\u0627\\u064b! \\u0645\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646 \\u0631\\u0627 \\u0628\\u0627 \\u0645\\u0644\\u0627\\u06cc\\u0645\\u062a \\u0648 \\u0628\\u0647 \\u0634\\u06a9\\u0644\\u06cc \\u062f\\u0648\\u0633\\u062a\\u0627\\u0646\\u0647 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646 \\u062f\\u0631 \\u062a\\u0645\\u0627\\u0645 \\u0633\\u0646\\u06cc\\u0646 \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645. \"},{\"_id\":\"40426f2\",\"title\":\"\\u06af\\u0632\\u06cc\\u0646\\u0647\\u200c\\u0647\\u0627\\u06cc \\u0645\\u0646 \\u0628\\u0631\\u0627\\u06cc \\u062c\\u0627\\u06cc\\u06af\\u0632\\u06cc\\u0646\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u0627\\u0632 \\u062f\\u0633\\u062a \\u0631\\u0641\\u062a\\u0647 \\u0686\\u06cc\\u0633\\u062a\\u061f \",\"desc\":\"\\u0645\\u0627 \\u0628\\u0633\\u062a\\u0647 \\u0628\\u0647 \\u0646\\u06cc\\u0627\\u0632\\u0647\\u0627 \\u0648 \\u062a\\u0631\\u062c\\u06cc\\u062d\\u0627\\u062a \\u0634\\u0645\\u0627\\u060c \\u0627\\u06cc\\u0645\\u067e\\u0644\\u0646\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u060c \\u0628\\u0631\\u06cc\\u062c \\u0648 \\u062f\\u0646\\u062f\\u0627\\u0646 \\u0645\\u0635\\u0646\\u0648\\u0639\\u06cc \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645. \"},{\"_id\":\"0d93a43\",\"title\":\"\\u0622\\u06cc\\u0627 \\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627 \\u0628\\u06cc\\u200c\\u062e\\u0637\\u0631 \\u0627\\u0633\\u062a\\u061f \",\"desc\":\"\\u0628\\u0644\\u0647\\u060c \\u0648\\u0642\\u062a\\u06cc \\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627 \\u062a\\u0648\\u0633\\u0637 \\u06cc\\u06a9 \\u0645\\u062a\\u062e\\u0635\\u0635 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0627\\u0646\\u062c\\u0627\\u0645 \\u0634\\u0648\\u062f\\u060c \\u0627\\u06cc\\u0645\\u0646 \\u0648 \\u0645\\u0624\\u062b\\u0631 \\u0627\\u0633\\u062a \\u0648 \\u0646\\u062a\\u0627\\u06cc\\u062c \\u0622\\u0646 \\u0645\\u0627\\u0646\\u062f\\u06af\\u0627\\u0631 \\u062e\\u0648\\u0627\\u0647\\u062f \\u0628\\u0648\\u062f. \"}],\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"300\"},\"elements\":[],\"widgetType\":\"pxl_accordion\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"faed713\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#4A7CD21A\",\"padding\":{\"unit\":\"px\",\"top\":\"115\",\"right\":\"0\",\"bottom\":\"105\",\"left\":\"0\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"content_width\":\"full\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"15\",\"bottom\":\"70\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"ba2fc12\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"15\",\"bottom\":\"0\",\"left\":\"15\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"cd71716\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646 \\u0631\\u0627\\u0636\\u06cc \\u0645\\u0627\",\"sub_title\":\"\\u0646\\u0638\\u0631\\u0627\\u062a \\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646\",\"h_width\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"align\":\"center\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"17efbb0\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p class=\\\"wow fadeInUp animated\\\">\\u0628\\u0647 \\u0647\\u0632\\u0627\\u0631\\u0627\\u0646 \\u0628\\u06cc\\u0645\\u0627\\u0631 \\u0631\\u0627\\u0636\\u06cc \\u0628\\u067e\\u06cc\\u0648\\u0646\\u062f\\u06cc\\u062f \\u06a9\\u0647 \\u0628\\u0631\\u0627\\u06cc \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u0645\\u0644\\u0627\\u06cc\\u0645 \\u0648 \\u062a\\u062e\\u0635\\u0635\\u06cc \\u0648 \\u0644\\u0628\\u062e\\u0646\\u062f\\u0647\\u0627\\u06cc \\u0632\\u06cc\\u0628\\u0627 \\u0628\\u0647 \\u0645\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0646\\u062f. \\u062a\\u062c\\u0631\\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0628\\u06cc\\u200c\\u0646\\u0638\\u06cc\\u0631 \\u0634\\u0645\\u0627 \\u0627\\u0632 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0634\\u0631\\u0648\\u0639 \\u0645\\u06cc\\u200c\\u0634\\u0648\\u062f!<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"50\",\"left\":\"0\",\"isLinked\":false},\"align\":\"center\",\"t_width\":{\"unit\":\"px\",\"size\":628,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"6356f20\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"a06f7d2\",\"elType\":\"widget\",\"settings\":{\"layout\":\"2\",\"testimonial\":[],\"testimonial_lv2\":[{\"_id\":\"8f77d95\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/author1.jpg\",\"id\":92,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0645\\u06cc\\u06a9\\u0627\\u0626\\u06cc\\u0644 \\u0634\\u0647\\u0627\\u0628\\u06cc\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0645\\u0646 \\u0647\\u0645\\u06cc\\u0634\\u0647 \\u0627\\u0632 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0647 \\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0646\\u06af\\u0631\\u0627\\u0646 \\u0628\\u0648\\u062f\\u0647\\u200c\\u0627\\u0645\\u060c \\u0627\\u0645\\u0627 \\u06a9\\u0627\\u0631\\u06a9\\u0646\\u0627\\u0646 \\u0628\\u0627\\u0639\\u062b \\u0634\\u062f\\u0646\\u062f \\u06a9\\u0627\\u0645\\u0644\\u0627\\u064b \\u0627\\u062d\\u0633\\u0627\\u0633 \\u0631\\u0627\\u062d\\u062a\\u06cc \\u06a9\\u0646\\u0645. \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u0645\\u0644\\u0627\\u06cc\\u0645 \\u0648 \\u062a\\u0648\\u062c\\u0647 \\u0622\\u0646\\u0647\\u0627 \\u0628\\u0647 \\u062c\\u0632\\u0626\\u06cc\\u0627\\u062a \\u0648\\u0627\\u0642\\u0639\\u0627\\u064b \\u0628\\u0631\\u062c\\u0633\\u062a\\u0647 \\u0627\\u0633\\u062a.\\\"\"},{\"_id\":\"4c80bef\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img3.jpg\",\"id\":218,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0631\\u0627\\u0645\\u06cc\\u0646 \\u0633\\u0647\\u0631\\u0627\\u0628\\u06cc\\u200c\\u0646\\u0698\\u0627\\u062f\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0645\\u0646 \\u0648 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647\\u200c\\u0627\\u0645 \\u0633\\u0627\\u0644\\u200c\\u0647\\u0627\\u0633\\u062a \\u06a9\\u0647 \\u0628\\u0647 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0645\\u06cc\\u200c\\u0622\\u06cc\\u0645. \\u062e\\u062f\\u0645\\u0627\\u062a \\u0641\\u0648\\u0642\\u200c\\u0627\\u0644\\u0639\\u0627\\u062f\\u0647 \\u0627\\u0633\\u062a \\u0648 \\u062a\\u06cc\\u0645 \\u0645\\u0627 \\u0647\\u0645\\u06cc\\u0634\\u0647 \\u062a\\u0645\\u0627\\u0645 \\u062a\\u0644\\u0627\\u0634 \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u062f \\u062a\\u0627 \\u0645\\u0637\\u0645\\u0626\\u0646 \\u0634\\u0648\\u062f \\u0645\\u0627 \\u0631\\u0627\\u0636\\u06cc \\u0647\\u0633\\u062a\\u06cc\\u0645 \\u0648 \\u0628\\u0647 \\u062e\\u0648\\u0628\\u06cc \\u0627\\u0632 \\u0645\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u0645\\u06cc\\u200c\\u0634\\u0648\\u062f.\\\"\"},{\"_id\":\"dd49806\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img4.jpg\",\"id\":219,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0622\\u0631\\u0627\\u062f \\u0627\\u0645\\u0627\\u0645\\u06cc\\u200c\\u0641\\u0631\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0645\\u0646 \\u0628\\u0631\\u0627\\u06cc \\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc\\u0645 \\u0628\\u0647 \\u0645\\u0637\\u0628 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0647 \\u06a9\\u0631\\u062f\\u0645 \\u0648 \\u0628\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f \\u0628\\u0647 \\u0646\\u0641\\u0633\\u06cc \\u06a9\\u0627\\u0645\\u0644\\u0627\\u064b \\u062c\\u062f\\u06cc\\u062f \\u0622\\u0646\\u062c\\u0627 \\u0631\\u0627 \\u062a\\u0631\\u06a9 \\u06a9\\u0631\\u062f\\u0645. \\u0646\\u062a\\u0627\\u06cc\\u062c \\u0634\\u06af\\u0641\\u062a\\u200c\\u0627\\u0646\\u06af\\u06cc\\u0632 \\u0628\\u0648\\u062f \\u0648 \\u06a9\\u0627\\u0631\\u06a9\\u0646\\u0627\\u0646\\u060c \\u0627\\u06cc\\u0646 \\u062a\\u062c\\u0631\\u0628\\u0647 \\u0631\\u0627 \\u0628\\u0647 \\u062a\\u062c\\u0631\\u0628\\u0647\\u200c\\u0627\\u06cc \\u0622\\u0631\\u0627\\u0645\\u0634\\u200c\\u0628\\u062e\\u0634 \\u062a\\u0628\\u062f\\u06cc\\u0644 \\u06a9\\u0631\\u062f\\u0646\\u062f.\\\"\"},{\"_id\":\"e16c281\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img5.jpg\",\"id\":220,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0633\\u06cc\\u0646\\u0627 \\u0641\\u0647\\u06cc\\u0645\\u06cc\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\\"\\u0622\\u0646\\u0647\\u0627 \\u062d\\u0631\\u0641\\u0647\\u200c\\u0627\\u06cc\\u060c \\u062f\\u0648\\u0633\\u062a\\u0627\\u0646\\u0647 \\u0648 \\u0648\\u0627\\u0642\\u0639\\u0627\\u064b \\u0628\\u0647 \\u0633\\u0644\\u0627\\u0645\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u0634\\u0645\\u0627 \\u0627\\u0647\\u0645\\u06cc\\u062a \\u0645\\u06cc\\u200c\\u062f\\u0647\\u0646\\u062f. \\u0645\\u0646 \\u06a9\\u0627\\u0645\\u0644\\u0627\\u064b \\u0628\\u0647 \\u0622\\u0646\\u0647\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f \\u062f\\u0627\\u0631\\u0645 \\u0648 \\u0622\\u0646\\u0647\\u0627 \\u0631\\u0627 \\u0628\\u0647 \\u0647\\u0631 \\u06a9\\u0633\\u06cc \\u06a9\\u0647 \\u0628\\u0647 \\u062f\\u0646\\u0628\\u0627\\u0644 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u0639\\u0627\\u0644\\u06cc \\u0627\\u0633\\u062a \\u062a\\u0648\\u0635\\u06cc\\u0647 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0645.\\\"\"},{\"_id\":\"99106f0\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img6.jpg\",\"id\":221,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0634\\u0627\\u0647\\u0648 \\u0622\\u0631\\u06cc\\u0627\\u0646\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0628\\u062f\\u0648\\u0646 \\u0634\\u06a9 \\u0628\\u0647\\u062a\\u0631\\u06cc\\u0646 \\u062a\\u062c\\u0631\\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u06a9\\u0647 \\u062a\\u0627 \\u0628\\u0647 \\u062d\\u0627\\u0644 \\u062f\\u0627\\u0634\\u062a\\u0647\\u200c\\u0627\\u0645. \\u0647\\u0645\\u0647 \\u0686\\u06cc\\u0632 \\u0627\\u0632 \\u062a\\u0639\\u06cc\\u06cc\\u0646 \\u0648\\u0642\\u062a \\u062a\\u0627 \\u062f\\u0631\\u0645\\u0627\\u0646 \\u0631\\u0648\\u0627\\u0646\\u060c \\u0631\\u0627\\u062d\\u062a \\u0648 \\u0628\\u0627 \\u0633\\u0644\\u06cc\\u0642\\u0647 \\u0634\\u062e\\u0635\\u06cc \\u0627\\u0646\\u062c\\u0627\\u0645 \\u0634\\u062f.\\\"\"},{\"_id\":\"69170d9\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img7.jpg\",\"id\":222,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u067e\\u06cc\\u0645\\u0627\\u0646 \\u0627\\u06a9\\u0628\\u0631\\u06cc\\u0627\\u0646\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0645\\u0646 \\u0647\\u0631\\u06af\\u0632 \\u062f\\u0631 \\u0645\\u0637\\u0628 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u062a\\u0627 \\u0627\\u06cc\\u0646 \\u062d\\u062f \\u0627\\u062d\\u0633\\u0627\\u0633 \\u0631\\u0627\\u062d\\u062a\\u06cc \\u0646\\u06a9\\u0631\\u062f\\u0647 \\u0628\\u0648\\u062f\\u0645. \\u062a\\u06cc\\u0645 \\u0622\\u0646\\u0647\\u0627 \\u0628\\u0633\\u06cc\\u0627\\u0631 \\u0645\\u0647\\u0631\\u0628\\u0627\\u0646\\u060c \\u062d\\u0631\\u0641\\u0647\\u200c\\u0627\\u06cc \\u0648 \\u062f\\u0642\\u06cc\\u0642 \\u0627\\u0633\\u062a. \\u0622\\u0646\\u0647\\u0627 \\u0647\\u0645\\u06cc\\u0634\\u0647 \\u0647\\u0645\\u0647 \\u0686\\u06cc\\u0632 \\u0631\\u0627 \\u0628\\u0627 \\u062c\\u0632\\u0626\\u06cc\\u0627\\u062a \\u062a\\u0648\\u0636\\u06cc\\u062d \\u0645\\u06cc\\u200c\\u062f\\u0647\\u0646\\u062f \\u0648 \\u0645\\u0646 \\u0647\\u0631 \\u0628\\u0627\\u0631 \\u0628\\u0627 \\u0644\\u0628\\u062e\\u0646\\u062f \\u0622\\u0646\\u062c\\u0627 \\u0631\\u0627 \\u062a\\u0631\\u06a9 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0645!\\\"\"},{\"_id\":\"2fd1679\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img8.jpg\",\"id\":223,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u062f\\u0627\\u0646\\u06cc\\u0627\\u0644 \\u0628\\u06cc\\u06af\\u06cc\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u062a\\u062c\\u0631\\u0628\\u0647 \\u0645\\u0646 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0641\\u0648\\u0642\\u200c\\u0627\\u0644\\u0639\\u0627\\u062f\\u0647 \\u0628\\u0648\\u062f\\u0647 \\u0627\\u0633\\u062a! \\u06a9\\u0627\\u0631\\u06a9\\u0646\\u0627\\u0646 \\u062e\\u0648\\u0634\\u200c\\u0628\\u0631\\u062e\\u0648\\u0631\\u062f \\u0647\\u0633\\u062a\\u0646\\u062f\\u060c \\u0645\\u0637\\u0628 \\u0628\\u06cc\\u200c\\u0639\\u06cc\\u0628 \\u0648 \\u0646\\u0642\\u0635 \\u0627\\u0633\\u062a \\u0648 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627 \\u062f\\u0631\\u062c\\u0647 \\u06cc\\u06a9 \\u0647\\u0633\\u062a\\u0646\\u062f. \\u0645\\u0646 \\u0647\\u0645\\u06cc\\u0634\\u0647 \\u0627\\u062d\\u0633\\u0627\\u0633 \\u0622\\u0631\\u0627\\u0645\\u0634 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0645 \\u0648 \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc\\u0645 \\u0647\\u0631\\u06af\\u0632 \\u0628\\u0647\\u062a\\u0631 \\u0627\\u0632 \\u0627\\u06cc\\u0646 \\u0628\\u0647 \\u0646\\u0638\\u0631 \\u0646\\u0631\\u0633\\u06cc\\u062f\\u0647\\u200c\\u0627\\u0646\\u062f!\\\"\"},{\"_id\":\"018e3c6\",\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/testtimo-img9.jpg\",\"id\":224,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title_lv2\":\"\\u0633\\u0627\\u0645\\u0627\\u0646 \\u0628\\u06cc\\u0631\\u0627\\u0645\\u06cc\",\"position\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\",\"desc_lv2\":\"\\\"\\u0627\\u0632 \\u0647\\u0645\\u0627\\u0646 \\u0644\\u062d\\u0638\\u0647 \\u0648\\u0631\\u0648\\u062f\\u060c \\u0627\\u062d\\u0633\\u0627\\u0633 \\u0631\\u0627\\u062d\\u062a\\u06cc \\u06a9\\u0631\\u062f\\u0645. \\u06a9\\u0627\\u0631\\u06a9\\u0646\\u0627\\u0646 \\u0637\\u0648\\u0631\\u06cc \\u0631\\u0641\\u062a\\u0627\\u0631 \\u06a9\\u0631\\u062f\\u0646\\u062f \\u06a9\\u0647 \\u0627\\u062d\\u0633\\u0627\\u0633 \\u06a9\\u0646\\u0645 \\u0645\\u062b\\u0644 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647\\u200c\\u0627\\u0645 \\u0647\\u0633\\u062a\\u0645 \\u0648 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u06cc \\u06a9\\u0647 \\u062f\\u0631\\u06cc\\u0627\\u0641\\u062a \\u06a9\\u0631\\u062f\\u0645 \\u0627\\u0633\\u062a\\u062b\\u0646\\u0627\\u06cc\\u06cc \\u0628\\u0648\\u062f. \\u0627\\u0632 \\u0644\\u0628\\u062e\\u0646\\u062f\\u0645 \\u062e\\u06cc\\u0644\\u06cc \\u0631\\u0627\\u0636\\u06cc \\u0647\\u0633\\u062a\\u0645. \\u0628\\u0627\\u0628\\u062a \\u0647\\u0645\\u0647 \\u0686\\u06cc\\u0632 \\u0645\\u0645\\u0646\\u0648\\u0646\\u0645!\\\"\"}],\"col_xxl\":\"5\",\"center\":\"true\",\"pagination\":\"true\",\"infinite\":\"true\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"600\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"-240\",\"bottom\":\"0\",\"left\":\"-240\",\"isLinked\":false},\"col_md\":\"2\",\"_margin_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_testimonial_carousel\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"d1c1cbb\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":30,\"column\":\"30\",\"row\":\"30\",\"isLinked\":true},\"flex_align_items\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#4A7CD2\",\"padding\":{\"unit\":\"px\",\"top\":\"50\",\"right\":\"15\",\"bottom\":\"50\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"8418409\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":60},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"0d1c6c2\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0622\\u0645\\u0627\\u062f\\u0647 \\u0631\\u0632\\u0631\\u0648 \\u0646\\u0648\\u0628\\u062a \\u062e\\u0648\\u062f \\u0647\\u0633\\u062a\\u06cc\\u062f\\u061f\",\"title_color\":\"#FFFFFF\",\"title_typography_typography\":\"custom\",\"title_typography_font_size\":{\"unit\":\"px\",\"size\":32,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"3cf7c4b\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0647\\u0645\\u06cc\\u0646 \\u0627\\u0645\\u0631\\u0648\\u0632 \\u0628\\u0627 \\u0645\\u0627 \\u062a\\u0645\\u0627\\u0633 \\u0628\\u06af\\u06cc\\u0631\\u06cc\\u062f \\u062a\\u0627 \\u0648\\u0642\\u062a \\u0645\\u0644\\u0627\\u0642\\u0627\\u062a \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0631\\u0632\\u0631\\u0648 \\u06a9\\u0646\\u06cc\\u062f \\u0648 \\u0627\\u0648\\u0644\\u06cc\\u0646 \\u0642\\u062f\\u0645 \\u0631\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u062f\\u0627\\u0634\\u062a\\u0646 \\u0644\\u0628\\u062e\\u0646\\u062f\\u06cc \\u0633\\u0627\\u0644\\u0645\\u200c\\u062a\\u0631 \\u0628\\u0631\\u062f\\u0627\\u0631\\u06cc\\u062f.<\\/p>\",\"text_color\":\"#FFFFFF99\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"97ded05\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":40},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"b7a7381\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0631\\u0632\\u0631\\u0648 \\u0646\\u0648\\u0628\\u062a\",\"align\":\"left\",\"border_type\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"border_color\":\"#FFFFFF80\",\"border_color_hover\":\"#10244B\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/booking\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"}},\"elements\":[],\"widgetType\":\"pxl_button\"}],\"isInner\":true}],\"isInner\":false}]\";s:10:\"_edit_lock\";s:12:\"1758147530:1\";s:10:\"_edit_last\";s:1:\"1\";s:22:\"_elementor_page_assets\";a:2:{s:7:\"scripts\";a:14:{i:0;s:18:\"elementor-frontend\";i:1;s:6:\"swiper\";i:2;s:19:\"elementor-waypoints\";i:3;s:16:\"jquery-numerator\";i:4;s:11:\"pxl-counter\";i:5;s:14:\"dentia-counter\";i:6;s:4:\"tilt\";i:7;s:12:\"pxl-tweenmax\";i:8;s:17:\"pxl-counter-slide\";i:9;s:12:\"imagesloaded\";i:10;s:7:\"isotope\";i:11;s:13:\"pxl-post-grid\";i:12;s:16:\"dentia-accordion\";i:13;s:10:\"pxl-swiper\";}s:6:\"styles\";a:2:{i:0;s:20:\"e-animation-fadeInUp\";i:1;s:8:\"e-swiper\";}}s:14:\"_elementor_css\";a:6:{s:4:\"time\";i:1758109738;s:5:\"fonts\";a:0:{}s:5:\"icons\";a:2:{i:0;s:0:\"\";i:1;s:8:\"fa-solid\";}s:20:\"dynamic_elements_ids\";a:0:{}s:6:\"status\";s:4:\"file\";i:0;s:0:\"\";}s:24:\"_elementor_element_cache\";s:90303:\"{\"timeout\":1758208738,\"value\":{\"content\":\"<div class=\\\"elementor-element elementor-element-5161d23 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"5161d23\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;slideshow&quot;,&quot;background_slideshow_gallery&quot;:[{&quot;id&quot;:1485,&quot;url&quot;:&quot;https:\\\\\\/\\\\\\/dentia.sunthemes.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/2025\\\\\\/08\\\\\\/1-min-e1758004018967.jpg&quot;},{&quot;id&quot;:1486,&quot;url&quot;:&quot;https:\\\\\\/\\\\\\/dentia.sunthemes.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/2025\\\\\\/08\\\\\\/2-min-e1758004028449.jpg&quot;}],&quot;background_slideshow_lazyload&quot;:&quot;yes&quot;,&quot;background_slideshow_slide_transition&quot;:&quot;slide_right&quot;,&quot;background_slideshow_loop&quot;:&quot;yes&quot;,&quot;background_slideshow_slide_duration&quot;:5000,&quot;background_slideshow_transition_duration&quot;:500}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-0b31933 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"0b31933\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"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\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImMxNjJkYzciLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0IjoiXHUwNjMxXHUwNjMyXHUwNjMxXHUwNjQ4IFx1MDY0Nlx1MDY0OFx1MDYyOFx1MDYyYSIsImxpbmsiOnsidXJsIjoiaHR0cHM6XC9cL2RlbnRpYS5zdW50aGVtZXMuaXJcL2Jvb2tpbmdcLyIsImlzX2V4dGVybmFsIjoiIiwibm9mb2xsb3ciOiIiLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9LCJidG5fYmdfY29sb3IiOiIjMDIwMTAxMDAiLCJib3JkZXJfdHlwZSI6InNvbGlkIiwiYm9yZGVyX3dpZHRoIjp7InVuaXQiOiJweCIsInRvcCI6IjEiLCJyaWdodCI6IjEiLCJib3R0b20iOiIxIiwibGVmdCI6IjEiLCJpc0xpbmtlZCI6dHJ1ZX0sImJvcmRlcl9jb2xvciI6IiNGRkZGRkYiLCJjb2xvcl9ob3ZlciI6IiNGRkZGRkYiLCJidG5fYmdfY29sb3JfaG92ZXIiOiIjMDAwQTVCIiwiYnRuX2JnX2NvbG9yX2FjdGl2ZSI6IiMwMDBBNUIiLCJidG5fYmdfY29sb3JfZm9jdXMiOiIjMDAwQTVCIiwiYm9yZGVyX2NvbG9yX2hvdmVyIjoiIzAwMEE1QiIsIl9tYXJnaW4iOnsidW5pdCI6InB4IiwidG9wIjoiMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjMwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9LCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNTAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9idXR0b24ifQ==\\\"]<div class=\\\"elementor-element elementor-element-9d1bee4 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none elementor-invisible e-con e-child \\\" data-id=\\\"9d1bee4\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;animation&quot;:&quot;fadeInUp&quot;,&quot;animation_delay&quot;:600}\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImFjNmI2Y2YiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGRpdiBjbGFzcz1cIm1lLTNcIj5cdTA2MzFcdTA2MmFcdTA2MjhcdTA2NDdcdTIwMGNcdTA2MjhcdTA2NDZcdTA2MmZcdTA2Y2MgXHUwNmFmXHUwNjQ4XHUwNmFmXHUwNjQ0PFwvZGl2PiIsInRleHRfY29sb3IiOiIjRjhGOUZBIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjA1YjM1Y2YiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGRpdiBjbGFzcz1cIm1lLTNcIj48ZGl2IGNsYXNzPVwibWUtM1wiPjUuMDxcL2Rpdj48XC9kaXY+IiwidGV4dF9jb2xvciI6IiNGOEY5RkEifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX3RleHRfZWRpdG9yIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImJkNTEzYmYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpY29ucyI6W3siX2lkIjoiZTFlZjdiYyIsInB4bF9pY29uIjp7InZhbHVlIjoiZmFzIGZhLXN0YXIiLCJsaWJyYXJ5IjoiZmEtc29saWQifX0seyJweGxfaWNvbiI6eyJ2YWx1ZSI6ImZhcyBmYS1zdGFyIiwibGlicmFyeSI6ImZhLXNvbGlkIn0sIl9pZCI6IjFmYmYxNGUifSx7InB4bF9pY29uIjp7InZhbHVlIjoiZmFzIGZhLXN0YXIiLCJsaWJyYXJ5IjoiZmEtc29saWQifSwiX2lkIjoiOThlZDc3ZCJ9LHsicHhsX2ljb24iOnsidmFsdWUiOiJmYXMgZmEtc3RhciIsImxpYnJhcnkiOiJmYS1zb2xpZCJ9LCJfaWQiOiIxNjg1YTdiIn0seyJweGxfaWNvbiI6eyJ2YWx1ZSI6ImZhcyBmYS1zdGFyIiwibGlicmFyeSI6ImZhLXNvbGlkIn0sIl9pZCI6IjY3YWE1NzMifV0sImNvbG9yIjoiI0ZFQzQyQyIsImljb25fZm9udF9zaXplIjp7InVuaXQiOiJweCIsInNpemUiOjE1LCJzaXplcyI6W119LCJpY29uX3NwYWNlIjp7InVuaXQiOiJweCIsInNpemUiOjIsInNpemVzIjpbXX19LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfaWNvbiJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjY1MzE3MDMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGRpdiBjbGFzcz1cIm1lLTNcIj48ZGl2IGNsYXNzPVwibWUtM1wiPjxkaXYgY2xhc3M9XCJtZS0zXCI+XHUwNjI4XHUwNjMxIFx1MDYyN1x1MDYzM1x1MDYyN1x1MDYzMyBcdTA2ZjJcdTA2ZjMgXHUwNjQ3XHUwNjMyXHUwNjI3XHUwNjMxIFx1MDY0Nlx1MDY0Mlx1MDYyZiBcdTA2NDggXHUwNjI4XHUwNjMxXHUwNjMxXHUwNjMzXHUwNmNjPFwvZGl2PjxcL2Rpdj48XC9kaXY+IiwidGV4dF9jb2xvciI6IiNGOEY5RkEifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX3RleHRfZWRpdG9yIn0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-af13e9f e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"af13e9f\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-f6f14ff e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"f6f14ff\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-2f08b27 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"2f08b27\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjM2MjdjMGEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIyIiwicHhsX2ljb24iOnsidmFsdWUiOiJmYXMgZmEtcGhvbmUtYWx0IiwibGlicmFyeSI6ImZhLXNvbGlkIn0sInRpdGxlIjoiXHUwNjI4XHUwNjQ3IFx1MDYyZVx1MDYyZlx1MDY0NVx1MDYyN1x1MDYyYSBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDZcdTA2N2VcdTA2MzJcdTA2MzRcdTA2YTlcdTA2Y2MgXHUwNjQ2XHUwNmNjXHUwNjI3XHUwNjMyIFx1MDYyZlx1MDYyN1x1MDYzMVx1MDZjY1x1MDYyZlx1MDYxZiIsImRlc2MiOiJcdTA2MmFcdTA2NDVcdTA2MjdcdTA2MzM6IDAyMTEyMzQ1Njc4OSIsInRpdGxlX2NvbG9yIjoiI0ZGRkZGRiIsImljb25fZm9udF9zaXplIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX2hlaWdodCI6eyJ1bml0IjoicHgiLCJzaXplIjo2MCwic2l6ZXMiOltdfSwiZGVzY19jb2xvciI6IiNGRkZGRkY5OSIsImljb25fY29sb3IiOiIjNEE3REMyIiwiaWNvbl9iZ19jb2xvciI6IiMwMjAxMDEwMCIsInRpdGxlX2JvdHRvbSI6eyJ1bml0IjoicHgiLCJzaXplIjowLCJzaXplcyI6W119LCJpbm5lcl9zcGFjZSI6eyJ1bml0IjoicHgiLCJzaXplIjoxNSwic2l6ZXMiOltdfSwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIzMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9fSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ljb25fYm94In0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-4a79de0 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"4a79de0\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-91829d8 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"91829d8\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImI2MzgzYzQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIyIiwicHhsX2ljb24iOnsidmFsdWUiOiJmYXMgZmEtY2xvY2siLCJsaWJyYXJ5IjoiZmEtc29saWQifSwidGl0bGUiOiJcdTA2MzNcdTA2MjdcdTA2MzlcdTA2MjdcdTA2MmEgXHUwNmE5XHUwNjI3XHUwNjMxXHUwNmNjIiwiZGVzYyI6Ilx1MDY0N1x1MDYzMSBcdTA2MzFcdTA2NDhcdTA2MzIgXHUwNjI3XHUwNjMyIDA4OjAwIFx1MDYyYVx1MDYyNyAyMDowMCIsInRpdGxlX2NvbG9yIjoiI0ZGRkZGRiIsImljb25fZm9udF9zaXplIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX2hlaWdodCI6eyJ1bml0IjoicHgiLCJzaXplIjo2MCwic2l6ZXMiOltdfSwiZGVzY19jb2xvciI6IiNGRkZGRkY5OSIsImljb25fY29sb3IiOiIjNEE3REMyIiwiaWNvbl9iZ19jb2xvciI6IiMwMjAxMDEwMCIsInRpdGxlX2JvdHRvbSI6eyJ1bml0IjoicHgiLCJzaXplIjowLCJzaXplcyI6W119LCJpbm5lcl9zcGFjZSI6eyJ1bml0IjoicHgiLCJzaXplIjoxNSwic2l6ZXMiOltdfSwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIzMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9LCJfZWxlbWVudF93aWR0aF9tb2JpbGUiOiJpbmhlcml0In0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9pY29uX2JveCJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-6a5100f e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"6a5100f\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-4eaeb3c e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"4eaeb3c\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImZmMzhkNmQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIyIiwicHhsX2ljb24iOnsidmFsdWUiOiJmYXMgZmEtZW52ZWxvcGUiLCJsaWJyYXJ5IjoiZmEtc29saWQifSwidGl0bGUiOiJcdTA2MjdcdTA2Y2NcdTA2NDVcdTA2Y2NcdTA2NDQgXHUwNjQ1XHUwNjI3IiwiZGVzYyI6ImNvbnRhY3RAZGVudGlhY2xpbmljLmNvbSIsInRpdGxlX2NvbG9yIjoiI0ZGRkZGRiIsImljb25fZm9udF9zaXplIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjYwLCJzaXplcyI6W119LCJpY29uX2hlaWdodCI6eyJ1bml0IjoicHgiLCJzaXplIjo2MCwic2l6ZXMiOltdfSwiZGVzY19jb2xvciI6IiNGRkZGRkY5OSIsImljb25fY29sb3IiOiIjNEE3REMyIiwiaWNvbl9iZ19jb2xvciI6IiMwMjAxMDEwMCIsInRpdGxlX2JvdHRvbSI6eyJ1bml0IjoicHgiLCJzaXplIjowLCJzaXplcyI6W119LCJpbm5lcl9zcGFjZSI6eyJ1bml0IjoicHgiLCJzaXplIjoxNSwic2l6ZXMiOltdfSwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIzMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9LCJfZWxlbWVudF93aWR0aF9tb2JpbGUiOiJpbmhlcml0In0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9pY29uX2JveCJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-15b34f8 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"15b34f8\\\" data-element_type=\\\"container\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-98ca70d e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"98ca70d\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-43ff422 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"43ff422\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImI2OThiYjQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2Fib3V0LWltZzEuanBnIiwiaWQiOjQ2Mywic2l6ZSI6IiIsImFsdCI6IiIsInNvdXJjZSI6ImxpYnJhcnkifSwiaW1hZ2VfdHlwZSI6ImJnIiwiaW1hZ2VfaGVpZ2h0Ijp7InVuaXQiOiJweCIsInNpemUiOjM5OSwic2l6ZXMiOltdfSwiYm9yZGVyX3JhZGl1cyI6eyJ1bml0IjoicHgiLCJ0b3AiOiIyMCIsInJpZ2h0IjoiMjAiLCJib3R0b20iOiIyMCIsImxlZnQiOiIyMCIsImlzTGlua2VkIjp0cnVlfSwicGFyYWxsYXhfdmFsdWUiOiI0MCIsIm1heF90aWx0IjoiMTAiLCJzcGVlZF90aWx0IjoiNDAwIiwicGVyc3BlY3RpdmVfdGlsdCI6IjEwMDAiLCJweGxfYW5pbWF0ZSI6IndvdyB6b29tSW5TbWFsbCIsInB4bF9hbmltYXRlX2RlbGF5IjoiMzAwIiwicHhsX2FuaW1hdGVfaW1nIjoid293IHNjYWxlSW4iLCJweGxfYW5pbWF0ZV9pbWdfZGVsYXkiOiIzMDAifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ltYWdlIn0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-4c3a639 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"4c3a639\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjNhMjZlY2QiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2Fib3V0LWltZzIuanBnIiwiaWQiOjQ2NCwic2l6ZSI6IiIsImFsdCI6IiIsInNvdXJjZSI6ImxpYnJhcnkifSwiaW1hZ2VfdHlwZSI6ImJnIiwiaW1hZ2VfaGVpZ2h0Ijp7InVuaXQiOiJweCIsInNpemUiOjM5OSwic2l6ZXMiOltdfSwiYm9yZGVyX3JhZGl1cyI6eyJ1bml0IjoicHgiLCJ0b3AiOiIyMCIsInJpZ2h0IjoiMjAiLCJib3R0b20iOiIyMCIsImxlZnQiOiIyMCIsImlzTGlua2VkIjp0cnVlfSwicGFyYWxsYXhfdmFsdWUiOiI0MCIsIm1heF90aWx0IjoiMTAiLCJzcGVlZF90aWx0IjoiNDAwIiwicGVyc3BlY3RpdmVfdGlsdCI6IjEwMDAiLCJweGxfYW5pbWF0ZSI6IndvdyB6b29tSW5TbWFsbCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNTAwIiwicHhsX2FuaW1hdGVfaW1nIjoid293IHNjYWxlSW4iLCJweGxfYW5pbWF0ZV9pbWdfZGVsYXkiOiI1MDAifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ltYWdlIn0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-9dd8e84 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"9dd8e84\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImIwMjk3YmYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDY0NVx1MDYyYVx1MDYyZVx1MDYzNVx1MDYzNVx1MDYyN1x1MDY0NiBcdTA2NDggXHUwNjJhXHUwNjM5XHUwNjI3XHUwNjQ0XHUwNmNjIFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2MzRcdTA2MmVcdTA2MzVcdTA2Y2MiLCJzdWJfdGl0bGUiOiJcdTA2MmZcdTA2MzFcdTA2MjhcdTA2MjdcdTA2MzFcdTA2NDcgXHUwNjQ1XHUwNjI3IiwiaF93aWR0aCI6eyJ1bml0IjoiJSIsInNpemUiOjgwLCJzaXplcyI6W119LCJoX3dpZHRoX2xhcHRvcCI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJoX3dpZHRoX3RhYmxldF9leHRyYSI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJoX3dpZHRoX3RhYmxldCI6eyJ1bml0IjoiJSIsInNpemUiOjEwMCwic2l6ZXMiOltdfSwiaF93aWR0aF9tb2JpbGVfZXh0cmEiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF9tb2JpbGUiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwidGl0bGVfdGFnIjoiaDIiLCJzdWJfdGl0bGVfc3BhY2VfYm90dG9tIjp7InVuaXQiOiJweCIsInNpemUiOjE3LCJzaXplcyI6W119LCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIyMCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjQwMCIsInB4bF9hbmltYXRlX3N1YiI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5X3N1YiI6IjMwMCIsInRpdGxlX3R5cG9ncmFwaHlfdHlwb2dyYXBoeSI6ImN1c3RvbSIsInRpdGxlX3R5cG9ncmFwaHlfZm9udF9zaXplX21vYmlsZSI6eyJ1bml0IjoicHgiLCJzaXplIjo0NSwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9oZWFkaW5nIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjZiYzg3ZTgiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjQ1XHUwNjI3IFx1MDYyZVx1MDYyZlx1MDY0NVx1MDYyN1x1MDYyYSBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDZcdTA2N2VcdTA2MzJcdTA2MzRcdTA2YTlcdTA2Y2MgXHUwNjI4XHUwNjI3IFx1MDZhOVx1MDZjY1x1MDY0MVx1MDZjY1x1MDYyYSBcdTA2MjhcdTA2MjdcdTA2NDRcdTA2MjcgXHUwNjQ4IFx1MDY0NVx1MDYyYVx1MDY0Nlx1MDYyN1x1MDYzM1x1MDYyOCBcdTA2MjhcdTA2MjcgXHUwNjQ2XHUwNmNjXHUwNjI3XHUwNjMyIFx1MDYyYVx1MDY0NVx1MDYyN1x1MDY0NSBcdTA2MjdcdTA2MzlcdTA2MzZcdTA2MjdcdTA2Y2MgXHUwNjJlXHUwNjI3XHUwNjQ2XHUwNjQ4XHUwNjI3XHUwNjJmXHUwNjQ3IFx1MDYyN1x1MDYzMVx1MDYyN1x1MDYyNlx1MDY0NyBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2MmZcdTA2NDdcdTA2Y2NcdTA2NDUuIFx1MDYyN1x1MDYzMiBcdTA2NDVcdTA2MzlcdTA2MjdcdTA2Y2NcdTA2NDZcdTA2MjdcdTA2MmEgXHUwNjMxXHUwNjQ4XHUwNjJhXHUwNmNjXHUwNjQ2IFx1MDZhZlx1MDYzMVx1MDY0MVx1MDYyYVx1MDY0NyBcdTA2MmFcdTA2MjcgXHUwNjJmXHUwNjMxXHUwNjQ1XHUwNjI3XHUwNjQ2XHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY3ZVx1MDZjY1x1MDYzNFx1MDYzMVx1MDY0MVx1MDYyYVx1MDY0N1x1MDYwYyBcdTA2MmFcdTA2Y2NcdTA2NDUgXHUwNjJmXHUwNjQ0XHUwNjMzXHUwNjQ4XHUwNjMyIFx1MDY0NVx1MDYyNyBcdTA2MmFcdTA2MzZcdTA2NDVcdTA2Y2NcdTA2NDYgXHUwNjQ1XHUwNmNjXHUyMDBjXHUwNmE5XHUwNjQ2XHUwNjJmIFx1MDZhOVx1MDY0NyBcdTA2NDRcdTA2MjhcdTA2MmVcdTA2NDZcdTA2MmYgXHUwNjM0XHUwNjQ1XHUwNjI3IFx1MDYzM1x1MDYyN1x1MDY0NFx1MDY0NSBcdTA2NDggXHUwNjI4XHUwNjI3IFx1MDYyN1x1MDYzOVx1MDYyYVx1MDY0NVx1MDYyN1x1MDYyZiBcdTA2MjhcdTA2NDcgXHUwNjQ2XHUwNjQxXHUwNjMzIFx1MDYyOFx1MDYyN1x1MDY0Mlx1MDZjYyBcdTA2MjhcdTA2NDVcdTA2MjdcdTA2NDZcdTA2MmYuPFwvcD4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNTAwIiwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIwIiwicmlnaHQiOiIwIiwiYm90dG9tIjoiMTciLCJsZWZ0IjoiMCIsImlzTGlua2VkIjpmYWxzZX19LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfdGV4dF9lZGl0b3IifQ==\\\"]<div class=\\\"elementor-element elementor-element-bb0da06 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"bb0da06\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-9028010 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"9028010\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjgyN2NkYzMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsaXN0cyI6W3siX2lkIjoiMjlmZGFjYiIsInB4bF9pY29uIjp7InZhbHVlIjoiZmFzIGZhLWNoZWNrIiwibGlicmFyeSI6ImZhLXNvbGlkIn0sInRleHQiOiJcdTA2MjhcdTA2MzFcdTA2NDZcdTA2MjdcdTA2NDVcdTA2NDdcdTIwMGNcdTA2NDdcdTA2MjdcdTA2Y2MgXHUwNjJmXHUwNjMxXHUwNjQ1XHUwNjI3XHUwNjQ2IFx1MDYzNFx1MDYyZVx1MDYzNVx1MDZjY1x1MjAwY1x1MDYzM1x1MDYyN1x1MDYzMlx1MDZjY1x1MjAwY1x1MDYzNFx1MDYyZlx1MDY0NyJ9LHsicHhsX2ljb24iOnsidmFsdWUiOiJmYXMgZmEtY2hlY2siLCJsaWJyYXJ5IjoiZmEtc29saWQifSwidGV4dCI6Ilx1MDY0NVx1MDYzMVx1MDYyN1x1MDY0Mlx1MDYyOFx1MDYyYSBcdTA2NDVcdTA2NDRcdTA2MjdcdTA2Y2NcdTA2NDUgXHUwNjI4XHUwNjMxXHUwNjI3XHUwNmNjIFx1MDZhOVx1MDY0OFx1MDYyZlx1MDZhOVx1MDYyN1x1MDY0NiBcdTA2NDggXHUwNjI4XHUwNjMyXHUwNjMxXHUwNmFmXHUwNjMzXHUwNjI3XHUwNjQ0XHUwNjI3XHUwNjQ2IiwiX2lkIjoiN2ZmNjQ3NSJ9XSwidGV4dF90eXBvZ3JhcGh5X3R5cG9ncmFwaHkiOiJjdXN0b20iLCJ0ZXh0X3R5cG9ncmFwaHlfZm9udF9zaXplX2xhcHRvcCI6eyJ1bml0IjoicHgiLCJzaXplIjoxNSwic2l6ZXMiOltdfSwiaWNvbl9jb2xvciI6IiM0QTdEQzIiLCJpY29uX3NwYWNlIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAzIiwiYm90dG9tIjoiMCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjYwMCIsImFsaWduX2l0ZW1zIjoic3RhcnQifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2xpc3QifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-6db1ff5 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"6db1ff5\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImZhNjQ5MGUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsaXN0cyI6W3siX2lkIjoiMjlmZGFjYiIsInB4bF9pY29uIjp7InZhbHVlIjoiZmFzIGZhLWNoZWNrIiwibGlicmFyeSI6ImZhLXNvbGlkIn0sInRleHQiOiJcdTA2NDFcdTA2NDZcdTA2MjdcdTA2NDhcdTA2MzFcdTA2Y2MgXHUwNjdlXHUwNmNjXHUwNjM0XHUwNjMxXHUwNjQxXHUwNjJhXHUwNjQ3In0seyJweGxfaWNvbiI6eyJ2YWx1ZSI6ImZhcyBmYS1jaGVjayIsImxpYnJhcnkiOiJmYS1zb2xpZCJ9LCJ0ZXh0IjoiXHUwNjI4XHUwNjMxXHUwNjQ2XHUwNjI3XHUwNjQ1XHUwNjQ3XHUyMDBjXHUwNjMxXHUwNmNjXHUwNjMyXHUwNmNjIFx1MDYyN1x1MDY0Nlx1MDYzOVx1MDYzN1x1MDYyN1x1MDY0MVx1MjAwY1x1MDY3ZVx1MDYzMFx1MDZjY1x1MDYzMSBcdTA2MjhcdTA2MzFcdTA2MjdcdTA2Y2MgXHUwNjQyXHUwNjMxXHUwNjI3XHUwNjMxIFx1MDY0NVx1MDY0NFx1MDYyN1x1MDY0Mlx1MDYyN1x1MDYyYSIsIl9pZCI6IjdmZjY0NzUifV0sInRleHRfdHlwb2dyYXBoeV90eXBvZ3JhcGh5IjoiY3VzdG9tIiwidGV4dF90eXBvZ3JhcGh5X2ZvbnRfc2l6ZV9sYXB0b3AiOnsidW5pdCI6InB4Iiwic2l6ZSI6MTUsInNpemVzIjpbXX0sImljb25fY29sb3IiOiIjNEE3REMyIiwiaWNvbl9zcGFjZSI6eyJ1bml0IjoicHgiLCJ0b3AiOiIwIiwicmlnaHQiOiIwMyIsImJvdHRvbSI6IjAiLCJsZWZ0IjoiMCIsImlzTGlua2VkIjpmYWxzZX0sInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI2MDAiLCJhbGlnbl9pdGVtcyI6InN0YXJ0In0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9saXN0In0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImYzODk3ZDkiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0IjoiXHUwNjMxXHUwNjMyXHUwNjMxXHUwNjQ4IFx1MDY0Nlx1MDY0OFx1MDYyOFx1MDYyYSIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI3MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjI4IiwicmlnaHQiOiIwIiwiYm90dG9tIjoiMCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9idXR0b24ifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-9f68bac e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"9f68bac\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-ac1ac70 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"ac1ac70\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImM3NGEzZWUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDY0NVx1MDYzMVx1MDYyN1x1MDY0Mlx1MDYyOFx1MDYyYSBcdTA2YTlcdTA2MjdcdTA2NDVcdTA2NDQgXHUwNjI4XHUwNjMxXHUwNjI3XHUwNmNjIFx1MDY0N1x1MDYzMSBcdTA2NDRcdTA2MjhcdTA2MmVcdTA2NDZcdTA2MmYiLCJzdWJfdGl0bGUiOiJcdTA2MmVcdTA2MmZcdTA2NDVcdTA2MjdcdTA2MmEgXHUwNjQ1XHUwNjI3IiwiaF93aWR0aCI6eyJ1bml0IjoiJSIsInNpemUiOjgwLCJzaXplcyI6W119LCJoX3dpZHRoX2xhcHRvcCI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJoX3dpZHRoX3RhYmxldF9leHRyYSI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJoX3dpZHRoX3RhYmxldCI6eyJ1bml0IjoiJSIsInNpemUiOjEwMCwic2l6ZXMiOltdfSwiaF93aWR0aF9tb2JpbGVfZXh0cmEiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF9tb2JpbGUiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwidGl0bGVfdGFnIjoiaDIiLCJzdWJfdGl0bGVfc3BhY2VfYm90dG9tIjp7InVuaXQiOiJweCIsInNpemUiOjE3LCJzaXplcyI6W119LCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIyMCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjQwMCIsInB4bF9hbmltYXRlX3N1YiI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5X3N1YiI6IjMwMCIsInRpdGxlX3R5cG9ncmFwaHlfdHlwb2dyYXBoeSI6ImN1c3RvbSIsInRpdGxlX3R5cG9ncmFwaHlfZm9udF9zaXplX21vYmlsZSI6eyJ1bml0IjoicHgiLCJzaXplIjo0NSwic2l6ZXMiOltdfSwiYWxpZ24iOiJjZW50ZXIifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2hlYWRpbmcifQ==\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjcyODQ3ZjkiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjI3XHUwNjMyIFx1MDYyYVx1MDY0NVx1MDZjY1x1MDYzMiBcdTA2YTlcdTA2MzFcdTA2MmZcdTA2NDZcdTIwMGNcdTA2NDdcdTA2MjdcdTA2Y2MgXHUwNjMxXHUwNjQ4XHUwNjJhXHUwNmNjXHUwNjQ2IFx1MDZhZlx1MDYzMVx1MDY0MVx1MDYyYVx1MDY0NyBcdTA2MmFcdTA2MjcgXHUwNjJhXHUwNjMxXHUwNjQ1XHUwNmNjXHUwNjQ1XHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY3ZVx1MDZjY1x1MDYzNFx1MDYzMVx1MDY0MVx1MDYyYVx1MDY0N1x1MDYwYyBcdTA2NDVcdTA2MjcgXHUwNjMxXHUwNjI3XHUwNjQ3XHUyMDBjXHUwNjJkXHUwNjQ0XHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2MzRcdTA2MmVcdTA2MzVcdTA2Y2NcdTIwMGNcdTA2MzNcdTA2MjdcdTA2MzJcdTA2Y2NcdTIwMGNcdTA2MzRcdTA2MmZcdTA2NDcgXHUwNjMxXHUwNjI3IFx1MDYyOFx1MDYzMVx1MDYyN1x1MDZjYyBcdTA2MjhcdTA2Y2NcdTA2NDVcdTA2MjdcdTA2MzFcdTA2MjdcdTA2NDYgXHUwNjJmXHUwNjMxIFx1MDY0N1x1MDYzMSBcdTA2MzNcdTA2NDZcdTA2Y2MgXHUwNjI3XHUwNjMxXHUwNjI3XHUwNjI2XHUwNjQ3IFx1MDY0NVx1MDZjY1x1MjAwY1x1MDYyZlx1MDY0N1x1MDZjY1x1MDY0NS48XC9wPiIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiI0MiIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwiYWxpZ24iOiJjZW50ZXIiLCJ0X3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjU2Mywic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]<div class=\\\"elementor-element elementor-element-7371f8b e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"7371f8b\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-37741dc e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"37741dc\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-5855528 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"5855528\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImZmMjgxZmEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIzIiwiaWNvbl90eXBlIjoiaW1hZ2UiLCJpY29uX2ltYWdlIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC93cC1jb250ZW50XC91cGxvYWRzXC8yMDI1XC8wOFwvdG9vdGgtMS5wbmciLCJpZCI6NjI2LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJ0aXRsZSI6Ilx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2MzlcdTA2NDVcdTA2NDhcdTA2NDVcdTA2Y2MiLCJkZXNjIjoiXHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhIFx1MDZhOVx1MDYyN1x1MDY0NVx1MDY0NCBcdTA2MmZcdTA2NDdcdTA2MjdcdTA2NDYgXHUwNjQ4IFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0NiBcdTA2MjhcdTA2MzFcdTA2MjdcdTA2Y2MgXHUwNjQ3XHUwNjMxIFx1MDY0NFx1MDYyOFx1MDYyZVx1MDY0Nlx1MDYyZlx1MDZjYyBcdTA2MjhcdTA2MjcgXHUwNjJjXHUwNjMxXHUwNjQ1XHUyMDBjXHUwNmFmXHUwNmNjXHUwNjMxXHUwNmNjXHUwNjBjIFx1MDY0NVx1MDYzOVx1MDYyN1x1MDZjY1x1MDY0Nlx1MDY0NyBcdTA2NDggXHUwNjQ1XHUwNjQ4XHUwNjI3XHUwNjMxXHUwNjJmIFx1MDYyZlx1MDZjY1x1MDZhZlx1MDYzMS4iLCJsaW5rIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC9zZXJ2aWNlXC9nZW5lcmFsLWRlbnRpc3RyeVwvIiwiaXNfZXh0ZXJuYWwiOiIiLCJub2ZvbGxvdyI6IiIsImN1c3RvbV9hdHRyaWJ1dGVzIjoiIn0sInRpdGxlX2J0biI6Ilx1MDYyN1x1MDYzN1x1MDY0NFx1MDYyN1x1MDYzOVx1MDYyN1x1MDYyYSBcdTA2MjhcdTA2Y2NcdTA2MzRcdTA2MmFcdTA2MzEiLCJweGxfYW5pbWF0ZSI6IndvdyBzY2FsZUluIiwicHhsX2FuaW1hdGVfZGVsYXkiOiIzMDAiLCJweGxfYW5pbWF0ZTIiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheTIiOiI1MDAiLCJ0aXRsZV9jb2xvciI6IiMxMDI0NEIiLCJiYWNrZ3JvdW5kX2NvbG9yIjoiI0ZGRkZGRiJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfaWNvbl9ib3gifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-62a7ae9 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"62a7ae9\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImM4ODAwODEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIzIiwiaWNvbl90eXBlIjoiaW1hZ2UiLCJpY29uX2ltYWdlIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC93cC1jb250ZW50XC91cGxvYWRzXC8yMDI1XC8wOFwvdG9vdGgtMi5wbmciLCJpZCI6NjI3LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJ0aXRsZSI6Ilx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOSBcdTA2MzJcdTA2Y2NcdTA2MjhcdTA2MjdcdTA2Y2NcdTA2Y2MiLCJkZXNjIjoiXHUwNjMyXHUwNmNjXHUwNjI4XHUwNjI3XHUwNmNjXHUwNmNjIFx1MDY0NFx1MDYyOFx1MDYyZVx1MDY0Nlx1MDYyZiBcdTA2MmVcdTA2NDhcdTA2MmYgXHUwNjMxXHUwNjI3IFx1MDYyOFx1MDYyNyBcdTA2MzNcdTA2NDFcdTA2Y2NcdTA2MmYgXHUwNmE5XHUwNjMxXHUwNjJmXHUwNjQ2IFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDYwYyBcdTA2NDhcdTA2NDZcdTA2Y2NcdTA2MzFcdTA2NDdcdTA2MjcgXHUwNjQ4IFx1MDY0NVx1MDY0OFx1MDYyN1x1MDYzMVx1MDYyZiBcdTA2MmZcdTA2Y2NcdTA2YWZcdTA2MzEgXHUwNjI3XHUwNjQxXHUwNjMyXHUwNjI3XHUwNmNjXHUwNjM0IFx1MDYyZlx1MDY0N1x1MDZjY1x1MDYyZi4iLCJsaW5rIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC9zZXJ2aWNlXC9jb3NtZXRpYy1kZW50aXN0cnlcLyIsImlzX2V4dGVybmFsIjoiIiwibm9mb2xsb3ciOiIiLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9LCJ0aXRsZV9idG4iOiJcdTA2MjdcdTA2MzdcdTA2NDRcdTA2MjdcdTA2MzlcdTA2MjdcdTA2MmEgXHUwNjI4XHUwNmNjXHUwNjM0XHUwNjJhXHUwNjMxIiwicHhsX2FuaW1hdGUiOiJ3b3cgc2NhbGVJbiIsInB4bF9hbmltYXRlX2RlbGF5IjoiMzAwIiwicHhsX2FuaW1hdGUyIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkyIjoiNTAwIiwidGl0bGVfY29sb3IiOiIjMTAyNDRCIiwiYmFja2dyb3VuZF9jb2xvciI6IiNGRkZGRkYifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ljb25fYm94In0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-964d2d6 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"964d2d6\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjMzNmJmNmYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIzIiwiaWNvbl90eXBlIjoiaW1hZ2UiLCJpY29uX2ltYWdlIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC93cC1jb250ZW50XC91cGxvYWRzXC8yMDI1XC8wOFwvdG9vdGgtMy5wbmciLCJpZCI6NjI4LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJ0aXRsZSI6Ilx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2YTlcdTA2NDhcdTA2MmZcdTA2YTlcdTA2MjdcdTA2NDYiLCJkZXNjIjoiXHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhXHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY0NVx1MDY0NFx1MDYyN1x1MDZjY1x1MDY0NSBcdTA2NDggXHUwNjMzXHUwNjMxXHUwNmFmXHUwNjMxXHUwNjQ1XHUyMDBjXHUwNmE5XHUwNjQ2XHUwNjQ2XHUwNjJmXHUwNjQ3IFx1MDYyN1x1MDYzMiBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDZcdTIwMGNcdTA2NDdcdTA2MjcgXHUwNjI4XHUwNjMxXHUwNjI3XHUwNmNjIFx1MDZhOVx1MDY0OFx1MDYyZlx1MDZhOVx1MDYyN1x1MDY0NiBcdTA2MmFcdTA2MjcgXHUwNjQ0XHUwNjI4XHUwNjJlXHUwNjQ2XHUwNjJmXHUwNmNjIFx1MDYzM1x1MDYyN1x1MDY0NFx1MDY0NSBcdTA2NDggXHUwNjM0XHUwNjI3XHUwNjJmIFx1MDYyZlx1MDYyN1x1MDYzNFx1MDYyYVx1MDY0NyBcdTA2MjhcdTA2MjdcdTA2MzRcdTA2NDZcdTA2MmYuIiwibGluayI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvc2VydmljZVwvcGVkaWF0cmljLWRlbnRpc3RyeVwvIiwiaXNfZXh0ZXJuYWwiOiIiLCJub2ZvbGxvdyI6IiIsImN1c3RvbV9hdHRyaWJ1dGVzIjoiIn0sInRpdGxlX2J0biI6Ilx1MDYyN1x1MDYzN1x1MDY0NFx1MDYyN1x1MDYzOVx1MDYyN1x1MDYyYSBcdTA2MjhcdTA2Y2NcdTA2MzRcdTA2MmFcdTA2MzEiLCJweGxfYW5pbWF0ZSI6IndvdyBzY2FsZUluIiwicHhsX2FuaW1hdGVfZGVsYXkiOiIzMDAiLCJweGxfYW5pbWF0ZTIiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheTIiOiI1MDAiLCJ0aXRsZV9jb2xvciI6IiMxMDI0NEIiLCJiYWNrZ3JvdW5kX2NvbG9yIjoiI0ZGRkZGRiJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfaWNvbl9ib3gifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-2e4cbee e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"2e4cbee\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjIwMjkyMzMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIzIiwiaWNvbl90eXBlIjoiaW1hZ2UiLCJpY29uX2ltYWdlIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC93cC1jb250ZW50XC91cGxvYWRzXC8yMDI1XC8wOFwvdG9vdGgtNC5wbmciLCJpZCI6NjI5LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJ0aXRsZSI6Ilx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2MmFcdTA2MzFcdTA2NDVcdTA2Y2NcdTA2NDVcdTA2Y2MiLCJkZXNjIjoiXHUwNjJmXHUwNjQ2XHUwNjJmXHUwNjI3XHUwNjQ2XHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDYzNFx1MDY0NVx1MDYyNyBcdTA2MzFcdTA2MjcgXHUwNjI4XHUwNjMxXHUwNjI3XHUwNmNjIFx1MDYzMVx1MDYyN1x1MDYyZFx1MDYyYVx1MDZjYyBcdTA2NDggXHUwNjM5XHUwNjQ1XHUwNjQ0XHUwNmE5XHUwNjMxXHUwNjJmIFx1MDY3ZVx1MDYyN1x1MDZjY1x1MDYyZlx1MDYyN1x1MDYzMSBcdTA2MmFcdTA2MzFcdTA2NDVcdTA2Y2NcdTA2NDUgXHUwNjQ4IFx1MDYyOFx1MDYyN1x1MDYzMlx1MDYzM1x1MDYyN1x1MDYzMlx1MDZjYyBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2YTlcdTA2NDZcdTA2MmYuXG4iLCJsaW5rIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC9zZXJ2aWNlXC9yZXN0b3JhdGl2ZS1kZW50aXN0cnlcLyIsImlzX2V4dGVybmFsIjoiIiwibm9mb2xsb3ciOiIiLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9LCJ0aXRsZV9idG4iOiJcdTA2MjdcdTA2MzdcdTA2NDRcdTA2MjdcdTA2MzlcdTA2MjdcdTA2MmEgXHUwNjI4XHUwNmNjXHUwNjM0XHUwNjJhXHUwNjMxIiwicHhsX2FuaW1hdGUiOiJ3b3cgc2NhbGVJbiIsInB4bF9hbmltYXRlX2RlbGF5IjoiMzAwIiwicHhsX2FuaW1hdGUyIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkyIjoiNTAwIiwidGl0bGVfY29sb3IiOiIjMTAyNDRCIiwiYmFja2dyb3VuZF9jb2xvciI6IiNGRkZGRkYifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ljb25fYm94In0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImU3MTQxM2EiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0IjoiXHUwNjQ1XHUwNjM0XHUwNjI3XHUwNjQ3XHUwNjJmXHUwNjQ3IFx1MDY0N1x1MDY0NVx1MDY0NyBcdTA2MmVcdTA2MmZcdTA2NDVcdTA2MjdcdTA2MmEiLCJsaW5rIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC9hbGwtc2VydmljZXNcLyIsImlzX2V4dGVybmFsIjoiIiwibm9mb2xsb3ciOiIiLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9LCJhbGlnbiI6ImNlbnRlciIsIl9tYXJnaW4iOnsidW5pdCI6InB4IiwidG9wIjoiNDgiLCJyaWdodCI6IjAiLCJib3R0b20iOiIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9fSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2J1dHRvbiJ9\\\"]\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-b92d7a4 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"b92d7a4\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-d408d83 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"d408d83\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImMwOGY2NzYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYyOFx1MDZjY1x1MDY0NVx1MDYyN1x1MDYzMVx1MDYyN1x1MDY0NiBcdTA2MzRcdTA2MjdcdTA2MmYiLCJzdGFydGluZ19udW1iZXIiOjUwMDAsImVuZGluZ19udW1iZXIiOjEwMDAwLCJzdWZmaXgiOiIrIiwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluUmlnaHQiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjMwMCJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfY291bnRlciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-3ffca2e e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"3ffca2e\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjE3ZjMwMTUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYzM1x1MDY0MVx1MDZjY1x1MDYyZiBcdTA2YTlcdTA2MzFcdTA2MmZcdTA2NDYgXHUwNjJmXHUwNjQ2XHUwNjJmXHUwNjI3XHUwNjQ2Iiwic3RhcnRpbmdfbnVtYmVyIjoyMDAwLCJlbmRpbmdfbnVtYmVyIjoyNTAwLCJzdWZmaXgiOiIrIiwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluUmlnaHQiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjQwMCJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfY291bnRlciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-5163797 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"5163797\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjM0NDQ3MmYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYyN1x1MDZjY1x1MDY0NVx1MDY3ZVx1MDY0NFx1MDY0Nlx1MDYyYSBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDYiLCJzdGFydGluZ19udW1iZXIiOjUwMCwiZW5kaW5nX251bWJlciI6ODAwLCJzdWZmaXgiOiIrIiwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluUmlnaHQiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjUwMCJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfY291bnRlciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-7ac7412 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"7ac7412\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjYyZDY3MmQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYzM1x1MDYyN1x1MDY0NCBcdTA2MmFcdTA2MmNcdTA2MzFcdTA2MjhcdTA2NDciLCJlbmRpbmdfbnVtYmVyIjoxNSwic3VmZml4IjoiKyIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblJpZ2h0IiwicHhsX2FuaW1hdGVfZGVsYXkiOiI2MDAifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2NvdW50ZXIifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-fc38de1 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"fc38de1\\\" data-element_type=\\\"container\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-931cd86 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"931cd86\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImM3ODU3ZGUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYyZVx1MDYyZlx1MDY0NVx1MDYyN1x1MDYyYSBcdTA2MjdcdTA2MzNcdTA2MmFcdTA2MmJcdTA2NDZcdTA2MjdcdTA2Y2NcdTA2Y2MgXHUwNjI4XHUwNjI3IFx1MDYzMVx1MDY0OFx1MDZjY1x1MDZhOVx1MDYzMVx1MDYyZlx1MDZjYyBcdTA2MzRcdTA2MmVcdTA2MzVcdTA2Y2MiLCJzdWJfdGl0bGUiOiJcdTA2ODZcdTA2MzFcdTA2MjcgXHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhXHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2NDVcdTA2MjcgXHUwNjMxXHUwNjI3IFx1MDYyN1x1MDY0Nlx1MDYyYVx1MDYyZVx1MDYyN1x1MDYyOCBcdTA2YTlcdTA2NDZcdTA2Y2NcdTA2MmYiLCJoX3dpZHRoIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sImhfd2lkdGhfbGFwdG9wIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sImhfd2lkdGhfdGFibGV0X2V4dHJhIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sImhfd2lkdGhfdGFibGV0Ijp7InVuaXQiOiIlIiwic2l6ZSI6MTAwLCJzaXplcyI6W119LCJoX3dpZHRoX21vYmlsZV9leHRyYSI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJoX3dpZHRoX21vYmlsZSI6eyJ1bml0IjoiJSIsInNpemUiOiIiLCJzaXplcyI6W119LCJ0aXRsZV90YWciOiJoMiIsInN1Yl90aXRsZV9zcGFjZV9ib3R0b20iOnsidW5pdCI6InB4Iiwic2l6ZSI6MTcsInNpemVzIjpbXX0sIl9tYXJnaW4iOnsidW5pdCI6InB4IiwidG9wIjoiMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9LCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNDAwIiwicHhsX2FuaW1hdGVfc3ViIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXlfc3ViIjoiMzAwIiwidGl0bGVfdHlwb2dyYXBoeV90eXBvZ3JhcGh5IjoiY3VzdG9tIiwidGl0bGVfdHlwb2dyYXBoeV9mb250X3NpemVfbW9iaWxlIjp7InVuaXQiOiJweCIsInNpemUiOjQ1LCJzaXplcyI6W119fSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2hlYWRpbmcifQ==\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjYwMmVhOTMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjI3XHUwNjQ2XHUwNjJhXHUwNjJlXHUwNjI3XHUwNjI4IFx1MDYyN1x1MDYzMVx1MDYyN1x1MDYyNlx1MDY0NyBcdTA2MmZcdTA2NDdcdTA2NDZcdTA2MmZcdTA2NDcgXHUwNjJlXHUwNjJmXHUwNjQ1XHUwNjI3XHUwNjJhIFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2NDVcdTA2NDZcdTA2MjdcdTA2MzNcdTA2MjggXHUwNjI3XHUwNjQ3XHUwNjQ1XHUwNmNjXHUwNjJhIFx1MDYyZlx1MDYyN1x1MDYzMVx1MDYyZi4gXHUwNjQ1XHUwNjI3IFx1MDY0NVx1MDYzMVx1MDYyN1x1MDY0Mlx1MDYyOFx1MDYyYVx1MjAwY1x1MDY0N1x1MDYyN1x1MDZjYyBcdTA2MmFcdTA2MmVcdTA2MzVcdTA2MzVcdTA2Y2NcdTA2MGMgXHUwNjQxXHUwNjQ2XHUwNjI3XHUwNjQ4XHUwNjMxXHUwNmNjIFx1MDY3ZVx1MDZjY1x1MDYzNFx1MDYzMVx1MDY0MVx1MDYyYVx1MDY0NyBcdTA2NDggXHUwNjQxXHUwNjM2XHUwNjI3XHUwNmNjXHUwNmNjIFx1MDZhZlx1MDYzMVx1MDY0NSBcdTA2MzFcdTA2MjcgXHUwNjI4XHUwNjI3IFx1MDY0N1x1MDY0NSBcdTA2MmFcdTA2MzFcdTA2YTlcdTA2Y2NcdTA2MjggXHUwNjQ1XHUwNmNjXHUyMDBjXHUwNmE5XHUwNjQ2XHUwNmNjXHUwNjQ1IFx1MDYyYVx1MDYyNyBcdTA2MjdcdTA2MzdcdTA2NDVcdTA2Y2NcdTA2NDZcdTA2MjdcdTA2NDYgXHUwNjJkXHUwNjI3XHUwNjM1XHUwNjQ0IFx1MDZhOVx1MDY0Nlx1MDZjY1x1MDY0NSBcdTA2YTlcdTA2NDcgXHUwNjQ3XHUwNjMxIFx1MDY0OFx1MDZjY1x1MDYzMlx1MDZjY1x1MDYyYSBcdTA2MzFcdTA2MjdcdTA2MmRcdTA2MmFcdTA2MGMgXHUwNmE5XHUwNjI3XHUwNjMxXHUwNjIyXHUwNjQ1XHUwNjJmIFx1MDY0OCBcdTA2NDVcdTA2MmFcdTA2NDZcdTA2MjdcdTA2MzNcdTA2MjggXHUwNjI4XHUwNjI3IFx1MDY0Nlx1MDZjY1x1MDYyN1x1MDYzMlx1MDY0N1x1MDYyN1x1MDZjYyBcdTA2NDVcdTA2NDZcdTA2MmRcdTA2MzVcdTA2MzEgXHUwNjI4XHUwNjQ3IFx1MDY0MVx1MDYzMVx1MDYyZiBcdTA2MzRcdTA2NDVcdTA2MjcgXHUwNjJlXHUwNjQ4XHUwNjI3XHUwNjQ3XHUwNjJmIFx1MDYyOFx1MDY0OFx1MDYyZi48XC9wPiIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIyMSIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]<div class=\\\"elementor-element elementor-element-9f3be1f e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"9f3be1f\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-e4d5e10 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"e4d5e10\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-3f475ce e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"3f475ce\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImQ0MzdiMWMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGg1Plx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOSBcdTA2MjhcdTA2MjdcdTA2MmFcdTA2MmNcdTA2MzFcdTA2MjhcdTA2NDc8XC9oNT4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNDAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6Ijc4ZTZlMmIiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhXHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDYyYVx1MDYyZVx1MDYzNVx1MDYzNVx1MDZjYyBcdTA2MjhcdTA2MjcgXHUwNjdlXHUwNjM0XHUwNjJhXHUwNjQ4XHUwNjI3XHUwNjQ2XHUwNjQ3IFx1MDYzM1x1MDYyN1x1MDY0NFx1MjAwY1x1MDY0N1x1MDYyNyBcdTA2MmFcdTA2MmNcdTA2MzFcdTA2MjhcdTA2NDcgXHUwNjJmXHUwNjQ2XHUwNjJmXHUwNjI3XHUwNjQ2XHUwNjdlXHUwNjMyXHUwNjM0XHUwNmE5XHUwNmNjIFx1MDY0Mlx1MDYyN1x1MDYyOFx1MDY0NCBcdTA2MjdcdTA2MzlcdTA2MmFcdTA2NDVcdTA2MjdcdTA2MmYuPFwvcD4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNTAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-c548350 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"c548350\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjY1YzMxZjQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGg1Plx1MDYyZlx1MDYzMVx1MDY0NVx1MDYyN1x1MDY0NiBcdTA2MzRcdTA2MmVcdTA2MzVcdTA2Y2NcdTIwMGNcdTA2MzNcdTA2MjdcdTA2MzJcdTA2Y2NcdTIwMGNcdTA2MzRcdTA2MmZcdTA2NDc8XC9oNT4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNDAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjI0ZDQ0MDkiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjI4XHUwNjMxXHUwNjQ2XHUwNjI3XHUwNjQ1XHUwNjQ3XHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY0NVx1MDYzMVx1MDYyN1x1MDY0Mlx1MDYyOFx1MDYyYVx1MDZjYyBcdTA2MzNcdTA2NDFcdTA2MjdcdTA2MzFcdTA2MzRcdTA2Y2MgXHUwNmE5XHUwNjQ3IFx1MDY0NVx1MDYyYVx1MDY0Nlx1MDYyN1x1MDYzM1x1MDYyOCBcdTA2MjhcdTA2MjcgXHUwNjQ0XHUwNjI4XHUwNjJlXHUwNjQ2XHUwNjJmIFx1MDY0OCBcdTA2MzNcdTA2MjhcdTA2YTkgXHUwNjMyXHUwNjQ2XHUwNjJmXHUwNmFmXHUwNmNjIFx1MDYzNFx1MDY0NVx1MDYyNyBcdTA2MmFcdTA2NDdcdTA2Y2NcdTA2NDcgXHUwNjQ1XHUwNmNjXHUyMDBjXHUwNjM0XHUwNjQ4XHUwNjQ2XHUwNjJmLjxcL3A+IiwicHhsX2FuaW1hdGUiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjUwMCJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfdGV4dF9lZGl0b3IifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-64807c6 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"64807c6\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-0cb580b e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"0cb580b\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6Ijg5ZmJjZjUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGg1Plx1MDY0MVx1MDY0Nlx1MDYyN1x1MDY0OFx1MDYzMVx1MDZjYyBcdTA2N2VcdTA2Y2NcdTA2MzRcdTA2MzFcdTA2NDFcdTA2MmFcdTA2NDc8XC9oNT4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNDAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjFhMmNlMjgiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjI3XHUwNjI4XHUwNjMyXHUwNjI3XHUwNjMxXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY0NVx1MDYyZlx1MDYzMVx1MDY0Nlx1MDYwYyBcdTA2MmZcdTA2MzFcdTA2NDVcdTA2MjdcdTA2NDZcdTIwMGNcdTA2NDdcdTA2MjdcdTA2Y2MgXHUwNjJmXHUwNjQyXHUwNmNjXHUwNjQyIFx1MDY0OCBcdTA2YTlcdTA2MjdcdTA2MzFcdTA2MjJcdTA2NDVcdTA2MmYgXHUwNjMxXHUwNjI3IFx1MDYyYVx1MDYzNlx1MDY0NVx1MDZjY1x1MDY0NiBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2YTlcdTA2NDZcdTA2NDZcdTA2MmYuPFwvcD4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNTAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-5c18bec e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"5c18bec\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjAxMzk0MzAiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPGg1Plx1MDY0NVx1MDY0Nlx1MDYyN1x1MDYzM1x1MDYyOCBcdTA2MmVcdTA2MjdcdTA2NDZcdTA2NDhcdTA2MjdcdTA2MmZcdTA2NDc8XC9oNT4iLCJweGxfYW5pbWF0ZSI6IndvdyBmYWRlSW5VcCIsInB4bF9hbmltYXRlX2RlbGF5IjoiNDAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjNlOTMwOWMiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjQxXHUwNjM2XHUwNjI3XHUwNmNjXHUwNmNjIFx1MDYyZlx1MDY0NFx1MDY0Nlx1MDYzNFx1MDZjY1x1MDY0NiBcdTA2MjhcdTA2MzFcdTA2MjdcdTA2Y2MgXHUwNmE5XHUwNjQ4XHUwNjJmXHUwNmE5XHUwNjI3XHUwNjQ2XHUwNjBjIFx1MDY0Nlx1MDY0OFx1MDYyY1x1MDY0OFx1MDYyN1x1MDY0Nlx1MDYyN1x1MDY0Nlx1MDYwYyBcdTA2MjhcdTA2MzJcdTA2MzFcdTA2YWZcdTA2MzNcdTA2MjdcdTA2NDRcdTA2MjdcdTA2NDYgXHUwNjQ4IFx1MDYzM1x1MDYyN1x1MDY0NFx1MDY0NVx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Ni48XC9wPiIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAifSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX3RleHRfZWRpdG9yIn0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-c0bac5e e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"c0bac5e\\\" data-element_type=\\\"container\\\"><div class=\\\"elementor-element elementor-element-9ce2c5c e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"9ce2c5c\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImU1MzBjODEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2V4Y2VwdGlvbmFsMi5qcGciLCJpZCI6NjA3LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJpbWFnZV90eXBlIjoiYmciLCJpbWFnZV9oZWlnaHQiOnsidW5pdCI6InB4Iiwic2l6ZSI6MjM2LjgwMDAwMDAwMDAwMDAxMTM2ODY4Mzc3MjE2MTYwMjk3MzkzNzk4ODI4MTI1LCJzaXplcyI6W119LCJib3JkZXJfcmFkaXVzIjp7InVuaXQiOiJweCIsInRvcCI6IjIwIiwicmlnaHQiOiIyMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjIwIiwiaXNMaW5rZWQiOnRydWV9LCJwYXJhbGxheF92YWx1ZSI6IjQwIiwibWF4X3RpbHQiOiIxMCIsInNwZWVkX3RpbHQiOiI0MDAiLCJwZXJzcGVjdGl2ZV90aWx0IjoiMTAwMCIsInB4bF9hbmltYXRlIjoid293IHpvb21JblNtYWxsIiwicHhsX2FuaW1hdGVfZGVsYXkiOiIzMDAiLCJweGxfYW5pbWF0ZV9pbWciOiJ3b3cgc2NhbGVJbiIsInB4bF9hbmltYXRlX2ltZ19kZWxheSI6IjMwMCIsIl9wYWRkaW5nIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIwIiwibGVmdCI6IjYwIiwiaXNMaW5rZWQiOmZhbHNlfSwiX3BhZGRpbmdfdGFibGV0Ijp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIwIiwibGVmdCI6IjAiLCJpc0xpbmtlZCI6ZmFsc2V9fSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2ltYWdlIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjIxYmMyY2IiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2V4Y2VwdGlvbmFsMS5qcGciLCJpZCI6NjA2LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJpbWFnZV90eXBlIjoiYmciLCJpbWFnZV9oZWlnaHQiOnsidW5pdCI6InB4Iiwic2l6ZSI6Mjk2LCJzaXplcyI6W119LCJib3JkZXJfcmFkaXVzIjp7InVuaXQiOiJweCIsInRvcCI6IjIwIiwicmlnaHQiOiIyMCIsImJvdHRvbSI6IjIwIiwibGVmdCI6IjIwIiwiaXNMaW5rZWQiOnRydWV9LCJwYXJhbGxheF92YWx1ZSI6IjQwIiwibWF4X3RpbHQiOiIxMCIsInNwZWVkX3RpbHQiOiI0MDAiLCJwZXJzcGVjdGl2ZV90aWx0IjoiMTAwMCIsInB4bF9hbmltYXRlIjoid293IHpvb21JblNtYWxsIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJweGxfYW5pbWF0ZV9pbWciOiJ3b3cgc2NhbGVJbiIsInB4bF9hbmltYXRlX2ltZ19kZWxheSI6IjUwMCJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfaW1hZ2UifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-2b3fb22 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"2b3fb22\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImE3YmU3YjkiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2V4Y2VwdGlvbmFsMy5qcGciLCJpZCI6NjA4LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJpbWFnZV90eXBlIjoiYmciLCJpbWFnZV9oZWlnaHQiOnsidW5pdCI6InB4Iiwic2l6ZSI6Mzk5LjYwMDAwMDAwMDAwMDAyMjczNzM2NzU0NDMyMzIwNTk0Nzg3NTk3NjU2MjUsInNpemVzIjpbXX0sImJvcmRlcl9yYWRpdXMiOnsidW5pdCI6InB4IiwidG9wIjoiMjAiLCJyaWdodCI6IjIwIiwiYm90dG9tIjoiMjAiLCJsZWZ0IjoiMjAiLCJpc0xpbmtlZCI6dHJ1ZX0sInBhcmFsbGF4X3ZhbHVlIjoiNDAiLCJtYXhfdGlsdCI6IjEwIiwic3BlZWRfdGlsdCI6IjQwMCIsInBlcnNwZWN0aXZlX3RpbHQiOiIxMDAwIiwicHhsX2FuaW1hdGUiOiJ3b3cgem9vbUluU21hbGwiLCJweGxfYW5pbWF0ZV9kZWxheSI6IjQwMCIsInB4bF9hbmltYXRlX2ltZyI6IndvdyBzY2FsZUluIiwicHhsX2FuaW1hdGVfaW1nX2RlbGF5IjoiNDAwIn0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9pbWFnZSJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-d0d5540 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"d0d5540\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-964e490 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"964e490\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImQwNzU1OTUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDY0NVx1MDYyYVx1MDYzOVx1MDY0N1x1MDYyZiBcdTA2MjhcdTA2NDcgXHUwNjQ0XHUwNjI4XHUwNjJlXHUwNjQ2XHUwNjJmIFx1MDYzNFx1MDY0NVx1MDYyNyIsInN1Yl90aXRsZSI6IiBcdTA2MjhcdTA2MjcgXHUwNjJhXHUwNmNjXHUwNjQ1IFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2NDVcdTA2MjcgXHUwNjIyXHUwNjM0XHUwNjQ2XHUwNjI3IFx1MDYzNFx1MDY0OFx1MDZjY1x1MDYyZiIsImhfd2lkdGgiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF9sYXB0b3AiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF90YWJsZXRfZXh0cmEiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF90YWJsZXQiOnsidW5pdCI6IiUiLCJzaXplIjoxMDAsInNpemVzIjpbXX0sImhfd2lkdGhfbW9iaWxlX2V4dHJhIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sImhfd2lkdGhfbW9iaWxlIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sInRpdGxlX3RhZyI6ImgyIiwic3ViX3RpdGxlX3NwYWNlX2JvdHRvbSI6eyJ1bml0IjoicHgiLCJzaXplIjoxNywic2l6ZXMiOltdfSwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIwIiwicmlnaHQiOiIwIiwiYm90dG9tIjoiMjAiLCJsZWZ0IjoiMCIsImlzTGlua2VkIjpmYWxzZX0sInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI0MDAiLCJweGxfYW5pbWF0ZV9zdWIiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheV9zdWIiOiIzMDAiLCJhbGlnbiI6ImNlbnRlciIsInRpdGxlX3R5cG9ncmFwaHlfdHlwb2dyYXBoeSI6ImN1c3RvbSIsInRpdGxlX3R5cG9ncmFwaHlfZm9udF9zaXplX21vYmlsZSI6eyJ1bml0IjoicHgiLCJzaXplIjo0NSwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9oZWFkaW5nIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImFjZDdkYTQiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHAgY2xhc3M9XCJ3b3cgZmFkZUluVXAgYW5pbWF0ZWRcIj5cdTA2MmFcdTA2Y2NcdTA2NDUgXHUwNjJmXHUwNjQ2XHUwNjJmXHUwNjI3XHUwNjQ2XHUwNjdlXHUwNjMyXHUwNjM0XHUwNmE5XHUwNmNjIFx1MDYyOFx1MDYyN1x1MDYyYVx1MDYyY1x1MDYzMVx1MDYyOFx1MDY0NyBcdTA2NDVcdTA2MjcgXHUwNjI3XHUwNmNjXHUwNjQ2XHUwNjJjXHUwNjI3IFx1MDY0N1x1MDYzM1x1MDYyYVx1MDY0Nlx1MDYyZiBcdTA2MmFcdTA2MjcgXHUwNjQ3XHUwNjMxIFx1MDY0OFx1MDZjY1x1MDYzMlx1MDZjY1x1MDYyYSBcdTA2MzFcdTA2MjcgXHUwNjQ1XHUwNjJiXHUwNjI4XHUwNjJhIFx1MDY0OCBcdTA2MzRcdTA2MmVcdTA2MzVcdTA2Y2NcdTIwMGNcdTA2MzNcdTA2MjdcdTA2MzJcdTA2Y2NcdTIwMGNcdTA2MzRcdTA2MmZcdTA2NDcgXHUwNmE5XHUwNjQ2XHUwNjQ2XHUwNjJmLiBcdTA2MjhcdTA2MjcgXHUwNjJmXHUwNjMzXHUwNjJhXHUwNjI3XHUwNjQ2XHUwNmNjIFx1MDY0NVx1MDY0N1x1MDYzMVx1MDYyOFx1MDYyN1x1MDY0NiBcdTA2NDggXHUwNjQyXHUwNjQ0XHUwNjI4XHUwNmNjIFx1MDY0NVx1MDY0N1x1MDYzMVx1MDYyOFx1MDYyN1x1MDY0Ni48XC9wPiIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIzNyIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwiYWxpZ24iOiJjZW50ZXIiLCJ0X3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjYyOCwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-8e36ff0 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"8e36ff0\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"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\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-07e3439 e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"07e3439\\\" data-element_type=\\\"container\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-cabeee0 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"cabeee0\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjkyYTMwYzUiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYzM1x1MDY0OFx1MDYyN1x1MDY0NFx1MDYyN1x1MDYyYSBcdTA2NDVcdTA2MmFcdTA2MmZcdTA2MjdcdTA2NDhcdTA2NDQiLCJzdWJfdGl0bGUiOiJcdTA2NDdcdTA2MzEgXHUwNjIyXHUwNjQ2XHUwNjg2XHUwNjQ3IFx1MDZhOVx1MDY0NyBcdTA2MjhcdTA2MjdcdTA2Y2NcdTA2MmYgXHUwNjI4XHUwNjJmXHUwNjI3XHUwNjQ2XHUwNmNjXHUwNjJmIiwidGl0bGVfdGFnIjoiaDIiLCJ0aXRsZV90eXBvZ3JhcGh5X3R5cG9ncmFwaHkiOiJjdXN0b20iLCJ0aXRsZV90eXBvZ3JhcGh5X2ZvbnRfc2l6ZV9tb2JpbGUiOnsidW5pdCI6InB4Iiwic2l6ZSI6NDUsInNpemVzIjpbXX0sInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJweGxfYW5pbWF0ZV9zdWIiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheV9zdWIiOiIzMDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiIyMCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9oZWFkaW5nIn0=\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-cb0bd9f e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"cb0bd9f\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"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\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-faed713 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"faed713\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\"><div class=\\\"elementor-element elementor-element-ba2fc12 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"ba2fc12\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImNkNzE3MTYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDY0NVx1MDYzNFx1MDYyYVx1MDYzMVx1MDZjY1x1MDYyN1x1MDY0NiBcdTA2MzFcdTA2MjdcdTA2MzZcdTA2Y2MgXHUwNjQ1XHUwNjI3Iiwic3ViX3RpdGxlIjoiXHUwNjQ2XHUwNjM4XHUwNjMxXHUwNjI3XHUwNjJhIFx1MDY0NVx1MDYzNFx1MDYyYVx1MDYzMVx1MDZjY1x1MDYyN1x1MDY0NiIsImhfd2lkdGgiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF9sYXB0b3AiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF90YWJsZXRfZXh0cmEiOnsidW5pdCI6IiUiLCJzaXplIjoiIiwic2l6ZXMiOltdfSwiaF93aWR0aF90YWJsZXQiOnsidW5pdCI6IiUiLCJzaXplIjoxMDAsInNpemVzIjpbXX0sImhfd2lkdGhfbW9iaWxlX2V4dHJhIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sImhfd2lkdGhfbW9iaWxlIjp7InVuaXQiOiIlIiwic2l6ZSI6IiIsInNpemVzIjpbXX0sInRpdGxlX3RhZyI6ImgyIiwic3ViX3RpdGxlX3NwYWNlX2JvdHRvbSI6eyJ1bml0IjoicHgiLCJzaXplIjoxNywic2l6ZXMiOltdfSwiX21hcmdpbiI6eyJ1bml0IjoicHgiLCJ0b3AiOiIwIiwicmlnaHQiOiIwIiwiYm90dG9tIjoiMjAiLCJsZWZ0IjoiMCIsImlzTGlua2VkIjpmYWxzZX0sInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI0MDAiLCJweGxfYW5pbWF0ZV9zdWIiOiJ3b3cgZmFkZUluVXAiLCJweGxfYW5pbWF0ZV9kZWxheV9zdWIiOiIzMDAiLCJhbGlnbiI6ImNlbnRlciIsInRpdGxlX3R5cG9ncmFwaHlfdHlwb2dyYXBoeSI6ImN1c3RvbSIsInRpdGxlX3R5cG9ncmFwaHlfZm9udF9zaXplX21vYmlsZSI6eyJ1bml0IjoicHgiLCJzaXplIjo0NSwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9oZWFkaW5nIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjE3ZWZiYjAiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHAgY2xhc3M9XCJ3b3cgZmFkZUluVXAgYW5pbWF0ZWRcIj5cdTA2MjhcdTA2NDcgXHUwNjQ3XHUwNjMyXHUwNjI3XHUwNjMxXHUwNjI3XHUwNjQ2IFx1MDYyOFx1MDZjY1x1MDY0NVx1MDYyN1x1MDYzMSBcdTA2MzFcdTA2MjdcdTA2MzZcdTA2Y2MgXHUwNjI4XHUwNjdlXHUwNmNjXHUwNjQ4XHUwNjQ2XHUwNjJmXHUwNmNjXHUwNjJmIFx1MDZhOVx1MDY0NyBcdTA2MjhcdTA2MzFcdTA2MjdcdTA2Y2MgXHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhXHUyMDBjXHUwNjQ3XHUwNjI3XHUwNmNjIFx1MDY0NVx1MDY0NFx1MDYyN1x1MDZjY1x1MDY0NSBcdTA2NDggXHUwNjJhXHUwNjJlXHUwNjM1XHUwNjM1XHUwNmNjIFx1MDY0OCBcdTA2NDRcdTA2MjhcdTA2MmVcdTA2NDZcdTA2MmZcdTA2NDdcdTA2MjdcdTA2Y2MgXHUwNjMyXHUwNmNjXHUwNjI4XHUwNjI3IFx1MDYyOFx1MDY0NyBcdTA2NDVcdTA2MjcgXHUwNjI3XHUwNjM5XHUwNjJhXHUwNjQ1XHUwNjI3XHUwNjJmIFx1MDY0NVx1MDZjY1x1MjAwY1x1MDZhOVx1MDY0Nlx1MDY0Nlx1MDYyZi4gXHUwNjJhXHUwNjJjXHUwNjMxXHUwNjI4XHUwNjQ3IFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MDY3ZVx1MDYzMlx1MDYzNFx1MDZhOVx1MDZjYyBcdTA2MjhcdTA2Y2NcdTIwMGNcdTA2NDZcdTA2MzhcdTA2Y2NcdTA2MzEgXHUwNjM0XHUwNjQ1XHUwNjI3IFx1MDYyN1x1MDYzMiBcdTA2MjdcdTA2Y2NcdTA2NDZcdTA2MmNcdTA2MjcgXHUwNjM0XHUwNjMxXHUwNjQ4XHUwNjM5IFx1MDY0NVx1MDZjY1x1MjAwY1x1MDYzNFx1MDY0OFx1MDYyZiE8XC9wPiIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI1MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6IjAiLCJib3R0b20iOiI1MCIsImxlZnQiOiIwIiwiaXNMaW5rZWQiOmZhbHNlfSwiYWxpZ24iOiJjZW50ZXIiLCJ0X3dpZHRoIjp7InVuaXQiOiJweCIsInNpemUiOjYyOCwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF90ZXh0X2VkaXRvciJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-6356f20 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"6356f20\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImEwNmY3ZDIiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsYXlvdXQiOiIyIiwidGVzdGltb25pYWwiOltdLCJ0ZXN0aW1vbmlhbF9sdjIiOlt7Il9pZCI6IjhmNzdkOTUiLCJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL2F1dGhvcjEuanBnIiwiaWQiOjkyLCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJ0aXRsZV9sdjIiOiJcdTA2NDVcdTA2Y2NcdTA2YTlcdTA2MjdcdTA2MjZcdTA2Y2NcdTA2NDQgXHUwNjM0XHUwNjQ3XHUwNjI3XHUwNjI4XHUwNmNjIiwicG9zaXRpb24iOiJcdTA2NDVcdTA2MzRcdTA2MmFcdTA2MzFcdTA2Y2MiLCJkZXNjX2x2MiI6IlwiXHUwNjQ1XHUwNjQ2IFx1MDY0N1x1MDY0NVx1MDZjY1x1MDYzNFx1MDY0NyBcdTA2MjdcdTA2MzIgXHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjJjXHUwNjM5XHUwNjQ3IFx1MDYyOFx1MDY0NyBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDZcdTA2N2VcdTA2MzJcdTA2MzRcdTA2YTlcdTA2Y2MgXHUwNjQ2XHUwNmFmXHUwNjMxXHUwNjI3XHUwNjQ2IFx1MDYyOFx1MDY0OFx1MDYyZlx1MDY0N1x1MjAwY1x1MDYyN1x1MDY0NVx1MDYwYyBcdTA2MjdcdTA2NDVcdTA2MjcgXHUwNmE5XHUwNjI3XHUwNjMxXHUwNmE5XHUwNjQ2XHUwNjI3XHUwNjQ2IFx1MDYyOFx1MDYyN1x1MDYzOVx1MDYyYiBcdTA2MzRcdTA2MmZcdTA2NDZcdTA2MmYgXHUwNmE5XHUwNjI3XHUwNjQ1XHUwNjQ0XHUwNjI3XHUwNjRiIFx1MDYyN1x1MDYyZFx1MDYzM1x1MDYyN1x1MDYzMyBcdTA2MzFcdTA2MjdcdTA2MmRcdTA2MmFcdTA2Y2MgXHUwNmE5XHUwNjQ2XHUwNjQ1LiBcdTA2NDVcdTA2MzFcdTA2MjdcdTA2NDJcdTA2MjhcdTA2MmEgXHUwNjQ1XHUwNjQ0XHUwNjI3XHUwNmNjXHUwNjQ1IFx1MDY0OCBcdTA2MmFcdTA2NDhcdTA2MmNcdTA2NDcgXHUwNjIyXHUwNjQ2XHUwNjQ3XHUwNjI3IFx1MDYyOFx1MDY0NyBcdTA2MmNcdTA2MzJcdTA2MjZcdTA2Y2NcdTA2MjdcdTA2MmEgXHUwNjQ4XHUwNjI3XHUwNjQyXHUwNjM5XHUwNjI3XHUwNjRiIFx1MDYyOFx1MDYzMVx1MDYyY1x1MDYzM1x1MDYyYVx1MDY0NyBcdTA2MjdcdTA2MzNcdTA2MmEuXCIifSx7Il9pZCI6IjRjODBiZWYiLCJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL3Rlc3R0aW1vLWltZzMuanBnIiwiaWQiOjIxOCwic2l6ZSI6IiIsImFsdCI6IiIsInNvdXJjZSI6ImxpYnJhcnkifSwidGl0bGVfbHYyIjoiXHUwNjMxXHUwNjI3XHUwNjQ1XHUwNmNjXHUwNjQ2IFx1MDYzM1x1MDY0N1x1MDYzMVx1MDYyN1x1MDYyOFx1MDZjY1x1MjAwY1x1MDY0Nlx1MDY5OFx1MDYyN1x1MDYyZiIsInBvc2l0aW9uIjoiXHUwNjQ1XHUwNjM0XHUwNjJhXHUwNjMxXHUwNmNjIiwiZGVzY19sdjIiOiJcIlx1MDY0NVx1MDY0NiBcdTA2NDggXHUwNjJlXHUwNjI3XHUwNjQ2XHUwNjQ4XHUwNjI3XHUwNjJmXHUwNjQ3XHUyMDBjXHUwNjI3XHUwNjQ1IFx1MDYzM1x1MDYyN1x1MDY0NFx1MjAwY1x1MDY0N1x1MDYyN1x1MDYzM1x1MDYyYSBcdTA2YTlcdTA2NDcgXHUwNjI4XHUwNjQ3IFx1MDYyN1x1MDZjY1x1MDY0Nlx1MDYyY1x1MDYyNyBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2MjJcdTA2Y2NcdTA2NDUuIFx1MDYyZVx1MDYyZlx1MDY0NVx1MDYyN1x1MDYyYSBcdTA2NDFcdTA2NDhcdTA2NDJcdTIwMGNcdTA2MjdcdTA2NDRcdTA2MzlcdTA2MjdcdTA2MmZcdTA2NDcgXHUwNjI3XHUwNjMzXHUwNjJhIFx1MDY0OCBcdTA2MmFcdTA2Y2NcdTA2NDUgXHUwNjQ1XHUwNjI3IFx1MDY0N1x1MDY0NVx1MDZjY1x1MDYzNFx1MDY0NyBcdTA2MmFcdTA2NDVcdTA2MjdcdTA2NDUgXHUwNjJhXHUwNjQ0XHUwNjI3XHUwNjM0IFx1MDYyZVx1MDY0OFx1MDYyZiBcdTA2MzFcdTA2MjcgXHUwNjQ1XHUwNmNjXHUyMDBjXHUwNmE5XHUwNjQ2XHUwNjJmIFx1MDYyYVx1MDYyNyBcdTA2NDVcdTA2MzdcdTA2NDVcdTA2MjZcdTA2NDYgXHUwNjM0XHUwNjQ4XHUwNjJmIFx1MDY0NVx1MDYyNyBcdTA2MzFcdTA2MjdcdTA2MzZcdTA2Y2MgXHUwNjQ3XHUwNjMzXHUwNjJhXHUwNmNjXHUwNjQ1IFx1MDY0OCBcdTA2MjhcdTA2NDcgXHUwNjJlXHUwNjQ4XHUwNjI4XHUwNmNjIFx1MDYyN1x1MDYzMiBcdTA2NDVcdTA2MjcgXHUwNjQ1XHUwNjMxXHUwNjI3XHUwNjQyXHUwNjI4XHUwNjJhIFx1MDY0NVx1MDZjY1x1MjAwY1x1MDYzNFx1MDY0OFx1MDYyZi5cIiJ9LHsiX2lkIjoiZGQ0OTgwNiIsImltYWdlIjp7InVybCI6Imh0dHBzOlwvXC9kZW50aWEuc3VudGhlbWVzLmlyXC93cC1jb250ZW50XC91cGxvYWRzXC8yMDI1XC8wOFwvdGVzdHRpbW8taW1nNC5qcGciLCJpZCI6MjE5LCJzaXplIjoiIiwiYWx0IjoiIiwic291cmNlIjoibGlicmFyeSJ9LCJ0aXRsZV9sdjIiOiJcdTA2MjJcdTA2MzFcdTA2MjdcdTA2MmYgXHUwNjI3XHUwNjQ1XHUwNjI3XHUwNjQ1XHUwNmNjXHUyMDBjXHUwNjQxXHUwNjMxIiwicG9zaXRpb24iOiJcdTA2NDVcdTA2MzRcdTA2MmFcdTA2MzFcdTA2Y2MiLCJkZXNjX2x2MiI6IlwiXHUwNjQ1XHUwNjQ2IFx1MDYyOFx1MDYzMVx1MDYyN1x1MDZjYyBcdTA2MzNcdTA2NDFcdTA2Y2NcdTA2MmYgXHUwNmE5XHUwNjMxXHUwNjJmXHUwNjQ2IFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MjAwY1x1MDY0N1x1MDYyN1x1MDZjY1x1MDY0NSBcdTA2MjhcdTA2NDcgXHUwNjQ1XHUwNjM3XHUwNjI4IFx1MDY0NVx1MDYzMVx1MDYyN1x1MDYyY1x1MDYzOVx1MDY0NyBcdTA2YTlcdTA2MzFcdTA2MmZcdTA2NDUgXHUwNjQ4IFx1MDYyOFx1MDYyNyBcdTA2MjdcdTA2MzlcdTA2MmFcdTA2NDVcdTA2MjdcdTA2MmYgXHUwNjI4XHUwNjQ3IFx1MDY0Nlx1MDY0MVx1MDYzM1x1MDZjYyBcdTA2YTlcdTA2MjdcdTA2NDVcdTA2NDRcdTA2MjdcdTA2NGIgXHUwNjJjXHUwNjJmXHUwNmNjXHUwNjJmIFx1MDYyMlx1MDY0Nlx1MDYyY1x1MDYyNyBcdTA2MzFcdTA2MjcgXHUwNjJhXHUwNjMxXHUwNmE5IFx1MDZhOVx1MDYzMVx1MDYyZlx1MDY0NS4gXHUwNjQ2XHUwNjJhXHUwNjI3XHUwNmNjXHUwNjJjIFx1MDYzNFx1MDZhZlx1MDY0MVx1MDYyYVx1MjAwY1x1MDYyN1x1MDY0Nlx1MDZhZlx1MDZjY1x1MDYzMiBcdTA2MjhcdTA2NDhcdTA2MmYgXHUwNjQ4IFx1MDZhOVx1MDYyN1x1MDYzMVx1MDZhOVx1MDY0Nlx1MDYyN1x1MDY0Nlx1MDYwYyBcdTA2MjdcdTA2Y2NcdTA2NDYgXHUwNjJhXHUwNjJjXHUwNjMxXHUwNjI4XHUwNjQ3IFx1MDYzMVx1MDYyNyBcdTA2MjhcdTA2NDcgXHUwNjJhXHUwNjJjXHUwNjMxXHUwNjI4XHUwNjQ3XHUyMDBjXHUwNjI3XHUwNmNjIFx1MDYyMlx1MDYzMVx1MDYyN1x1MDY0NVx1MDYzNFx1MjAwY1x1MDYyOFx1MDYyZVx1MDYzNCBcdTA2MmFcdTA2MjhcdTA2MmZcdTA2Y2NcdTA2NDQgXHUwNmE5XHUwNjMxXHUwNjJmXHUwNjQ2XHUwNjJmLlwiIn0seyJfaWQiOiJlMTZjMjgxIiwiaW1hZ2UiOnsidXJsIjoiaHR0cHM6XC9cL2RlbnRpYS5zdW50aGVtZXMuaXJcL3dwLWNvbnRlbnRcL3VwbG9hZHNcLzIwMjVcLzA4XC90ZXN0dGltby1pbWc1LmpwZyIsImlkIjoyMjAsInNpemUiOiIiLCJhbHQiOiIiLCJzb3VyY2UiOiJsaWJyYXJ5In0sInRpdGxlX2x2MiI6Ilx1MDYzM1x1MDZjY1x1MDY0Nlx1MDYyNyBcdTA2NDFcdTA2NDdcdTA2Y2NcdTA2NDVcdTA2Y2MiLCJwb3NpdGlvbiI6Ilx1MDY0NVx1MDYzNFx1MDYyYVx1MDYzMVx1MDZjYyIsImRlc2NfbHYyIjoiXCJcIlx1MDYyMlx1MDY0Nlx1MDY0N1x1MDYyNyBcdTA2MmRcdTA2MzFcdTA2NDFcdTA2NDdcdTIwMGNcdTA2MjdcdTA2Y2NcdTA2MGMgXHUwNjJmXHUwNjQ4XHUwNjMzXHUwNjJhXHUwNjI3XHUwNjQ2XHUwNjQ3IFx1MDY0OCBcdTA2NDhcdTA2MjdcdTA2NDJcdTA2MzlcdTA2MjdcdTA2NGIgXHUwNjI4XHUwNjQ3IFx1MDYzM1x1MDY0NFx1MDYyN1x1MDY0NVx1MDYyYSBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDZcdTIwMGNcdTA2NDdcdTA2MjdcdTA2Y2MgXHUwNjM0XHUwNjQ1XHUwNjI3IFx1MDYyN1x1MDY0N1x1MDY0NVx1MDZjY1x1MDYyYSBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2MmZcdTA2NDdcdTA2NDZcdTA2MmYuIFx1MDY0NVx1MDY0NiBcdTA2YTlcdTA2MjdcdTA2NDVcdTA2NDRcdTA2MjdcdTA2NGIgXHUwNjI4XHUwNjQ3IFx1MDYyMlx1MDY0Nlx1MDY0N1x1MDYyNyBcdTA2MjdcdTA2MzlcdTA2MmFcdTA2NDVcdTA2MjdcdTA2MmYgXHUwNjJmXHUwNjI3XHUwNjMxXHUwNjQ1IFx1MDY0OCBcdTA2MjJcdTA2NDZcdTA2NDdcdTA2MjcgXHUwNjMxXHUwNjI3IFx1MDYyOFx1MDY0NyBcdTA2NDdcdTA2MzEgXHUwNmE5XHUwNjMzXHUwNmNjIFx1MDZhOVx1MDY0NyBcdTA2MjhcdTA2NDcgXHUwNjJmXHUwNjQ2XHUwNjI4XHUwNjI3XHUwNjQ0IFx1MDY0NVx1MDYzMVx1MDYyN1x1MDY0Mlx1MDYyOFx1MDYyYSBcdTA2MzlcdTA2MjdcdTA2NDRcdTA2Y2MgXHUwNjI3XHUwNjMzXHUwNjJhIFx1MDYyYVx1MDY0OFx1MDYzNVx1MDZjY1x1MDY0NyBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2YTlcdTA2NDZcdTA2NDUuXCIifSx7Il9pZCI6Ijk5MTA2ZjAiLCJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL3Rlc3R0aW1vLWltZzYuanBnIiwiaWQiOjIyMSwic2l6ZSI6IiIsImFsdCI6IiIsInNvdXJjZSI6ImxpYnJhcnkifSwidGl0bGVfbHYyIjoiXHUwNjM0XHUwNjI3XHUwNjQ3XHUwNjQ4IFx1MDYyMlx1MDYzMVx1MDZjY1x1MDYyN1x1MDY0NiIsInBvc2l0aW9uIjoiXHUwNjQ1XHUwNjM0XHUwNjJhXHUwNjMxXHUwNmNjIiwiZGVzY19sdjIiOiJcIlx1MDYyOFx1MDYyZlx1MDY0OFx1MDY0NiBcdTA2MzRcdTA2YTkgXHUwNjI4XHUwNjQ3XHUwNjJhXHUwNjMxXHUwNmNjXHUwNjQ2IFx1MDYyYVx1MDYyY1x1MDYzMVx1MDYyOFx1MDY0NyBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDZcdTA2N2VcdTA2MzJcdTA2MzRcdTA2YTlcdTA2Y2MgXHUwNmE5XHUwNjQ3IFx1MDYyYVx1MDYyNyBcdTA2MjhcdTA2NDcgXHUwNjJkXHUwNjI3XHUwNjQ0IFx1MDYyZlx1MDYyN1x1MDYzNFx1MDYyYVx1MDY0N1x1MjAwY1x1MDYyN1x1MDY0NS4gXHUwNjQ3XHUwNjQ1XHUwNjQ3IFx1MDY4Nlx1MDZjY1x1MDYzMiBcdTA2MjdcdTA2MzIgXHUwNjJhXHUwNjM5XHUwNmNjXHUwNmNjXHUwNjQ2IFx1MDY0OFx1MDY0Mlx1MDYyYSBcdTA2MmFcdTA2MjcgXHUwNjJmXHUwNjMxXHUwNjQ1XHUwNjI3XHUwNjQ2IFx1MDYzMVx1MDY0OFx1MDYyN1x1MDY0Nlx1MDYwYyBcdTA2MzFcdTA2MjdcdTA2MmRcdTA2MmEgXHUwNjQ4IFx1MDYyOFx1MDYyNyBcdTA2MzNcdTA2NDRcdTA2Y2NcdTA2NDJcdTA2NDcgXHUwNjM0XHUwNjJlXHUwNjM1XHUwNmNjIFx1MDYyN1x1MDY0Nlx1MDYyY1x1MDYyN1x1MDY0NSBcdTA2MzRcdTA2MmYuXCIifSx7Il9pZCI6IjY5MTcwZDkiLCJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL3Rlc3R0aW1vLWltZzcuanBnIiwiaWQiOjIyMiwic2l6ZSI6IiIsImFsdCI6IiIsInNvdXJjZSI6ImxpYnJhcnkifSwidGl0bGVfbHYyIjoiXHUwNjdlXHUwNmNjXHUwNjQ1XHUwNjI3XHUwNjQ2IFx1MDYyN1x1MDZhOVx1MDYyOFx1MDYzMVx1MDZjY1x1MDYyN1x1MDY0NiIsInBvc2l0aW9uIjoiXHUwNjQ1XHUwNjM0XHUwNjJhXHUwNjMxXHUwNmNjIiwiZGVzY19sdjIiOiJcIlx1MDY0NVx1MDY0NiBcdTA2NDdcdTA2MzFcdTA2YWZcdTA2MzIgXHUwNjJmXHUwNjMxIFx1MDY0NVx1MDYzN1x1MDYyOCBcdTA2MmZcdTA2NDZcdTA2MmZcdTA2MjdcdTA2NDZcdTA2N2VcdTA2MzJcdTA2MzRcdTA2YTlcdTA2Y2MgXHUwNjJhXHUwNjI3IFx1MDYyN1x1MDZjY1x1MDY0NiBcdTA2MmRcdTA2MmYgXHUwNjI3XHUwNjJkXHUwNjMzXHUwNjI3XHUwNjMzIFx1MDYzMVx1MDYyN1x1MDYyZFx1MDYyYVx1MDZjYyBcdTA2NDZcdTA2YTlcdTA2MzFcdTA2MmZcdTA2NDcgXHUwNjI4XHUwNjQ4XHUwNjJmXHUwNjQ1LiBcdTA2MmFcdTA2Y2NcdTA2NDUgXHUwNjIyXHUwNjQ2XHUwNjQ3XHUwNjI3IFx1MDYyOFx1MDYzM1x1MDZjY1x1MDYyN1x1MDYzMSBcdTA2NDVcdTA2NDdcdTA2MzFcdTA2MjhcdTA2MjdcdTA2NDZcdTA2MGMgXHUwNjJkXHUwNjMxXHUwNjQxXHUwNjQ3XHUyMDBjXHUwNjI3XHUwNmNjIFx1MDY0OCBcdTA2MmZcdTA2NDJcdTA2Y2NcdTA2NDIgXHUwNjI3XHUwNjMzXHUwNjJhLiBcdTA2MjJcdTA2NDZcdTA2NDdcdTA2MjcgXHUwNjQ3XHUwNjQ1XHUwNmNjXHUwNjM0XHUwNjQ3IFx1MDY0N1x1MDY0NVx1MDY0NyBcdTA2ODZcdTA2Y2NcdTA2MzIgXHUwNjMxXHUwNjI3IFx1MDYyOFx1MDYyNyBcdTA2MmNcdTA2MzJcdTA2MjZcdTA2Y2NcdTA2MjdcdTA2MmEgXHUwNjJhXHUwNjQ4XHUwNjM2XHUwNmNjXHUwNjJkIFx1MDY0NVx1MDZjY1x1MjAwY1x1MDYyZlx1MDY0N1x1MDY0Nlx1MDYyZiBcdTA2NDggXHUwNjQ1XHUwNjQ2IFx1MDY0N1x1MDYzMSBcdTA2MjhcdTA2MjdcdTA2MzEgXHUwNjI4XHUwNjI3IFx1MDY0NFx1MDYyOFx1MDYyZVx1MDY0Nlx1MDYyZiBcdTA2MjJcdTA2NDZcdTA2MmNcdTA2MjcgXHUwNjMxXHUwNjI3IFx1MDYyYVx1MDYzMVx1MDZhOSBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2YTlcdTA2NDZcdTA2NDUhXCIifSx7Il9pZCI6IjJmZDE2NzkiLCJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL3Rlc3R0aW1vLWltZzguanBnIiwiaWQiOjIyMywic2l6ZSI6IiIsImFsdCI6IiIsInNvdXJjZSI6ImxpYnJhcnkifSwidGl0bGVfbHYyIjoiXHUwNjJmXHUwNjI3XHUwNjQ2XHUwNmNjXHUwNjI3XHUwNjQ0IFx1MDYyOFx1MDZjY1x1MDZhZlx1MDZjYyIsInBvc2l0aW9uIjoiXHUwNjQ1XHUwNjM0XHUwNjJhXHUwNjMxXHUwNmNjIiwiZGVzY19sdjIiOiJcIlx1MDYyYVx1MDYyY1x1MDYzMVx1MDYyOFx1MDY0NyBcdTA2NDVcdTA2NDYgXHUwNjI3XHUwNmNjXHUwNjQ2XHUwNjJjXHUwNjI3IFx1MDY0MVx1MDY0OFx1MDY0Mlx1MjAwY1x1MDYyN1x1MDY0NFx1MDYzOVx1MDYyN1x1MDYyZlx1MDY0NyBcdTA2MjhcdTA2NDhcdTA2MmZcdTA2NDcgXHUwNjI3XHUwNjMzXHUwNjJhISBcdTA2YTlcdTA2MjdcdTA2MzFcdTA2YTlcdTA2NDZcdTA2MjdcdTA2NDYgXHUwNjJlXHUwNjQ4XHUwNjM0XHUyMDBjXHUwNjI4XHUwNjMxXHUwNjJlXHUwNjQ4XHUwNjMxXHUwNjJmIFx1MDY0N1x1MDYzM1x1MDYyYVx1MDY0Nlx1MDYyZlx1MDYwYyBcdTA2NDVcdTA2MzdcdTA2MjggXHUwNjI4XHUwNmNjXHUyMDBjXHUwNjM5XHUwNmNjXHUwNjI4IFx1MDY0OCBcdTA2NDZcdTA2NDJcdTA2MzUgXHUwNjI3XHUwNjMzXHUwNjJhIFx1MDY0OCBcdTA2NDVcdTA2MzFcdTA2MjdcdTA2NDJcdTA2MjhcdTA2MmFcdTIwMGNcdTA2NDdcdTA2MjcgXHUwNjJmXHUwNjMxXHUwNjJjXHUwNjQ3IFx1MDZjY1x1MDZhOSBcdTA2NDdcdTA2MzNcdTA2MmFcdTA2NDZcdTA2MmYuIFx1MDY0NVx1MDY0NiBcdTA2NDdcdTA2NDVcdTA2Y2NcdTA2MzRcdTA2NDcgXHUwNjI3XHUwNjJkXHUwNjMzXHUwNjI3XHUwNjMzIFx1MDYyMlx1MDYzMVx1MDYyN1x1MDY0NVx1MDYzNCBcdTA2NDVcdTA2Y2NcdTIwMGNcdTA2YTlcdTA2NDZcdTA2NDUgXHUwNjQ4IFx1MDYyZlx1MDY0Nlx1MDYyZlx1MDYyN1x1MDY0Nlx1MjAwY1x1MDY0N1x1MDYyN1x1MDZjY1x1MDY0NSBcdTA2NDdcdTA2MzFcdTA2YWZcdTA2MzIgXHUwNjI4XHUwNjQ3XHUwNjJhXHUwNjMxIFx1MDYyN1x1MDYzMiBcdTA2MjdcdTA2Y2NcdTA2NDYgXHUwNjI4XHUwNjQ3IFx1MDY0Nlx1MDYzOFx1MDYzMSBcdTA2NDZcdTA2MzFcdTA2MzNcdTA2Y2NcdTA2MmZcdTA2NDdcdTIwMGNcdTA2MjdcdTA2NDZcdTA2MmYhXCIifSx7Il9pZCI6IjAxOGUzYzYiLCJpbWFnZSI6eyJ1cmwiOiJodHRwczpcL1wvZGVudGlhLnN1bnRoZW1lcy5pclwvd3AtY29udGVudFwvdXBsb2Fkc1wvMjAyNVwvMDhcL3Rlc3R0aW1vLWltZzkuanBnIiwiaWQiOjIyNCwic2l6ZSI6IiIsImFsdCI6IiIsInNvdXJjZSI6ImxpYnJhcnkifSwidGl0bGVfbHYyIjoiXHUwNjMzXHUwNjI3XHUwNjQ1XHUwNjI3XHUwNjQ2IFx1MDYyOFx1MDZjY1x1MDYzMVx1MDYyN1x1MDY0NVx1MDZjYyIsInBvc2l0aW9uIjoiXHUwNjQ1XHUwNjM0XHUwNjJhXHUwNjMxXHUwNmNjIiwiZGVzY19sdjIiOiJcIlx1MDYyN1x1MDYzMiBcdTA2NDdcdTA2NDVcdTA2MjdcdTA2NDYgXHUwNjQ0XHUwNjJkXHUwNjM4XHUwNjQ3IFx1MDY0OFx1MDYzMVx1MDY0OFx1MDYyZlx1MDYwYyBcdTA2MjdcdTA2MmRcdTA2MzNcdTA2MjdcdTA2MzMgXHUwNjMxXHUwNjI3XHUwNjJkXHUwNjJhXHUwNmNjIFx1MDZhOVx1MDYzMVx1MDYyZlx1MDY0NS4gXHUwNmE5XHUwNjI3XHUwNjMxXHUwNmE5XHUwNjQ2XHUwNjI3XHUwNjQ2IFx1MDYzN1x1MDY0OFx1MDYzMVx1MDZjYyBcdTA2MzFcdTA2NDFcdTA2MmFcdTA2MjdcdTA2MzEgXHUwNmE5XHUwNjMxXHUwNjJmXHUwNjQ2XHUwNjJmIFx1MDZhOVx1MDY0NyBcdTA2MjdcdTA2MmRcdTA2MzNcdTA2MjdcdTA2MzMgXHUwNmE5XHUwNjQ2XHUwNjQ1IFx1MDY0NVx1MDYyYlx1MDY0NCBcdTA2MmVcdTA2MjdcdTA2NDZcdTA2NDhcdTA2MjdcdTA2MmZcdTA2NDdcdTIwMGNcdTA2MjdcdTA2NDUgXHUwNjQ3XHUwNjMzXHUwNjJhXHUwNjQ1IFx1MDY0OCBcdTA2NDVcdTA2MzFcdTA2MjdcdTA2NDJcdTA2MjhcdTA2MmFcdTA2Y2MgXHUwNmE5XHUwNjQ3IFx1MDYyZlx1MDYzMVx1MDZjY1x1MDYyN1x1MDY0MVx1MDYyYSBcdTA2YTlcdTA2MzFcdTA2MmZcdTA2NDUgXHUwNjI3XHUwNjMzXHUwNjJhXHUwNjJiXHUwNjQ2XHUwNjI3XHUwNmNjXHUwNmNjIFx1MDYyOFx1MDY0OFx1MDYyZi4gXHUwNjI3XHUwNjMyIFx1MDY0NFx1MDYyOFx1MDYyZVx1MDY0Nlx1MDYyZlx1MDY0NSBcdTA2MmVcdTA2Y2NcdTA2NDRcdTA2Y2MgXHUwNjMxXHUwNjI3XHUwNjM2XHUwNmNjIFx1MDY0N1x1MDYzM1x1MDYyYVx1MDY0NS4gXHUwNjI4XHUwNjI3XHUwNjI4XHUwNjJhIFx1MDY0N1x1MDY0NVx1MDY0NyBcdTA2ODZcdTA2Y2NcdTA2MzIgXHUwNjQ1XHUwNjQ1XHUwNjQ2XHUwNjQ4XHUwNjQ2XHUwNjQ1IVwiIn1dLCJjb2xfeHhsIjoiNSIsImNlbnRlciI6InRydWUiLCJwYWdpbmF0aW9uIjoidHJ1ZSIsImluZmluaXRlIjoidHJ1ZSIsInB4bF9hbmltYXRlIjoid293IGZhZGVJblVwIiwicHhsX2FuaW1hdGVfZGVsYXkiOiI2MDAiLCJfbWFyZ2luIjp7InVuaXQiOiJweCIsInRvcCI6IjAiLCJyaWdodCI6Ii0yNDAiLCJib3R0b20iOiIwIiwibGVmdCI6Ii0yNDAiLCJpc0xpbmtlZCI6ZmFsc2V9LCJjb2xfbWQiOiIyIiwiX21hcmdpbl90YWJsZXQiOnsidW5pdCI6InB4IiwidG9wIjoiMCIsInJpZ2h0IjoiMCIsImJvdHRvbSI6IjAiLCJsZWZ0IjoiMCIsImlzTGlua2VkIjpmYWxzZX19LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfdGVzdGltb25pYWxfY2Fyb3VzZWwifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-d1c1cbb e-flex e-con-boxed pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-parent \\\" data-id=\\\"d1c1cbb\\\" data-element_type=\\\"container\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\t\\t\\t<div class=\\\"e-con-inner\\\">\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-8418409 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"8418409\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjBkMWM2YzIiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0aXRsZSI6Ilx1MDYyMlx1MDY0NVx1MDYyN1x1MDYyZlx1MDY0NyBcdTA2MzFcdTA2MzJcdTA2MzFcdTA2NDggXHUwNjQ2XHUwNjQ4XHUwNjI4XHUwNjJhIFx1MDYyZVx1MDY0OFx1MDYyZiBcdTA2NDdcdTA2MzNcdTA2MmFcdTA2Y2NcdTA2MmZcdTA2MWYiLCJ0aXRsZV9jb2xvciI6IiNGRkZGRkYiLCJ0aXRsZV90eXBvZ3JhcGh5X3R5cG9ncmFwaHkiOiJjdXN0b20iLCJ0aXRsZV90eXBvZ3JhcGh5X2ZvbnRfc2l6ZSI6eyJ1bml0IjoicHgiLCJzaXplIjozMiwic2l6ZXMiOltdfX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InB4bF9oZWFkaW5nIn0=\\\"][elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6IjNjZjdjNGIiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0X2VkIjoiPHA+XHUwNjQ3XHUwNjQ1XHUwNmNjXHUwNjQ2IFx1MDYyN1x1MDY0NVx1MDYzMVx1MDY0OFx1MDYzMiBcdTA2MjhcdTA2MjcgXHUwNjQ1XHUwNjI3IFx1MDYyYVx1MDY0NVx1MDYyN1x1MDYzMyBcdTA2MjhcdTA2YWZcdTA2Y2NcdTA2MzFcdTA2Y2NcdTA2MmYgXHUwNjJhXHUwNjI3IFx1MDY0OFx1MDY0Mlx1MDYyYSBcdTA2NDVcdTA2NDRcdTA2MjdcdTA2NDJcdTA2MjdcdTA2MmEgXHUwNjJlXHUwNjQ4XHUwNjJmIFx1MDYzMVx1MDYyNyBcdTA2MzFcdTA2MzJcdTA2MzFcdTA2NDggXHUwNmE5XHUwNjQ2XHUwNmNjXHUwNjJmIFx1MDY0OCBcdTA2MjdcdTA2NDhcdTA2NDRcdTA2Y2NcdTA2NDYgXHUwNjQyXHUwNjJmXHUwNjQ1IFx1MDYzMVx1MDYyNyBcdTA2MjhcdTA2MzFcdTA2MjdcdTA2Y2MgXHUwNjJmXHUwNjI3XHUwNjM0XHUwNjJhXHUwNjQ2IFx1MDY0NFx1MDYyOFx1MDYyZVx1MDY0Nlx1MDYyZlx1MDZjYyBcdTA2MzNcdTA2MjdcdTA2NDRcdTA2NDVcdTIwMGNcdTA2MmFcdTA2MzEgXHUwNjI4XHUwNjMxXHUwNjJmXHUwNjI3XHUwNjMxXHUwNmNjXHUwNjJmLjxcL3A+IiwidGV4dF9jb2xvciI6IiNGRkZGRkY5OSJ9LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJweGxfdGV4dF9lZGl0b3IifQ==\\\"]\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\\"elementor-element elementor-element-97ded05 e-con-full e-flex pxl-column-none pxl-row-scroll-none pxl-zoom-point-false pxl-section-overflow-visible pxl-section-fix-none pxl-full-content-with-space-none pxl-bg-color-none pxl-section-overlay-none e-con e-child \\\" data-id=\\\"97ded05\\\" data-element_type=\\\"container\\\">[elementor-element k=\\\"9f9b7b4eca1f2faa99bc308d2bca713d\\\" data=\\\"eyJpZCI6ImI3YTczODEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJ0ZXh0IjoiXHUwNjMxXHUwNjMyXHUwNjMxXHUwNjQ4IFx1MDY0Nlx1MDY0OFx1MDYyOFx1MDYyYSIsImFsaWduIjoibGVmdCIsImJvcmRlcl90eXBlIjoic29saWQiLCJib3JkZXJfd2lkdGgiOnsidW5pdCI6InB4IiwidG9wIjoiMSIsInJpZ2h0IjoiMSIsImJvdHRvbSI6IjEiLCJsZWZ0IjoiMSIsImlzTGlua2VkIjp0cnVlfSwiYm9yZGVyX2NvbG9yIjoiI0ZGRkZGRjgwIiwiYm9yZGVyX2NvbG9yX2hvdmVyIjoiIzEwMjQ0QiIsImxpbmsiOnsidXJsIjoiaHR0cHM6XC9cL2RlbnRpYS5zdW50aGVtZXMuaXJcL2Jvb2tpbmdcLyIsImlzX2V4dGVybmFsIjoiIiwibm9mb2xsb3ciOiIiLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9fSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoicHhsX2J1dHRvbiJ9\\\"]\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\\t\\t<\\/div>\\r\\n\\t\\t\",\"scripts\":[],\"styles\":[]}}\";}","auto-off");

INSERT IGNORE INTO `wp_options` VALUES 
("915","post_option","a:27:{s:17:\"_wp_page_template\";s:7:\"default\";s:13:\"header_layout\";s:4:\"1594\";s:20:\"header_layout_sticky\";s:2:\"-1\";s:6:\"logo_m\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:12:\"mobile_style\";s:7:\"inherit\";s:6:\"p_menu\";s:0:\"\";s:13:\"sticky_scroll\";s:2:\"-1\";s:7:\"pt_mode\";s:4:\"none\";s:13:\"custom_ptitle\";s:0:\"\";s:16:\"page_sidebar_pos\";s:1:\"0\";s:15:\"content_spacing\";a:3:{s:5:\"units\";s:2:\"px\";s:11:\"padding-top\";s:1:\"0\";s:14:\"padding-bottom\";s:1:\"0\";}s:13:\"footer_layout\";s:2:\"-1\";s:14:\"p_footer_fixed\";s:7:\"inherit\";s:13:\"body_bg_color\";s:0:\"\";s:13:\"primary_color\";s:0:\"\";s:15:\"secondary_color\";s:0:\"\";s:14:\"gradient_color\";a:2:{s:4:\"from\";s:0:\"\";s:2:\"to\";s:0:\"\";}s:17:\"body_custom_class\";s:0:\"\";s:20:\"_elementor_edit_mode\";s:7:\"builder\";s:24:\"_elementor_template_type\";s:7:\"wp-page\";s:18:\"_elementor_version\";s:6:\"3.32.0\";s:15:\"_elementor_data\";s:76806:\"[{\"id\":\"5161d23\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"slideshow\",\"background_slideshow_gallery\":[{\"id\":1485,\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/1-min-e1758004018967.jpg\"},{\"id\":1486,\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/2-min-e1758004028449.jpg\"}],\"background_slideshow_background_size\":\"cover\",\"background_slideshow_background_position\":\"center center\",\"background_slideshow_lazyload\":\"yes\",\"background_overlay_background\":\"gradient\",\"background_overlay_color\":\"#000A5B66\",\"background_overlay_color_stop\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"background_overlay_color_b\":\"#000A5B\",\"background_overlay_gradient_angle\":{\"unit\":\"deg\",\"size\":-90,\"sizes\":[]},\"background_overlay_opacity\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"padding\":{\"unit\":\"px\",\"top\":\"220\",\"right\":\"15\",\"bottom\":\"192\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"background_slideshow_slide_transition\":\"slide_right\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"73\",\"right\":\"15\",\"bottom\":\"70\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"0b31933\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"bd11b0a\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0644\\u0628\\u062e\\u0646\\u062f\\u0647\\u0627\\u06cc \\u0632\\u06cc\\u0628\\u0627\\u062a\\u0631 \\u0628\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u062a\\u062e\\u0635\\u0635\\u06cc \\u0648 \\u0644\\u0645\\u0633 \\u0645\\u0644\\u0627\\u06cc\\u0645\",\"sub_title\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647\",\"h_width\":{\"unit\":\"%\",\"size\":49,\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":55,\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h1\",\"title_color\":\"#FFFFFF\",\"sub_title_color\":\"#FFFFFF\",\"sub_title_typography_typography\":\"custom\",\"sub_title_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"sub_title_typography_font_weight\":\"600\",\"sub_title_typography_line_height\":{\"unit\":\"em\",\"size\":1.5,\"sizes\":[]},\"sub_title_typography_line_height_laptop\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"sub_title_typography_line_height_tablet_extra\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"sub_title_typography_line_height_mobile_extra\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\"},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"c162dc7\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0631\\u0632\\u0631\\u0648 \\u0646\\u0648\\u0628\\u062a\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/booking\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"btn_bg_color\":\"#02010100\",\"border_type\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"border_color\":\"#FFFFFF\",\"color_hover\":\"#FFFFFF\",\"btn_bg_color_hover\":\"#000A5B\",\"btn_bg_color_active\":\"#000A5B\",\"btn_bg_color_focus\":\"#000A5B\",\"border_color_hover\":\"#000A5B\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"30\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_button\"},{\"id\":\"9d1bee4\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_align_items\":\"center\",\"flex_gap\":{\"column\":\"15\",\"row\":\"15\",\"isLinked\":true,\"unit\":\"px\",\"size\":15},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"animation\":\"fadeInUp\",\"animation_delay\":600,\"flex_wrap\":\"wrap\"},\"elements\":[{\"id\":\"ac6b6cf\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<div class=\\\"me-3\\\">\\u0631\\u062a\\u0628\\u0647\\u200c\\u0628\\u0646\\u062f\\u06cc \\u06af\\u0648\\u06af\\u0644<\\/div>\",\"text_color\":\"#F8F9FA\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"05b35cf\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<div class=\\\"me-3\\\"><div class=\\\"me-3\\\">5.0<\\/div><\\/div>\",\"text_color\":\"#F8F9FA\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"bd513bf\",\"elType\":\"widget\",\"settings\":{\"icons\":[{\"_id\":\"e1ef7bc\",\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"}},{\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"},\"_id\":\"1fbf14e\"},{\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"},\"_id\":\"98ed77d\"},{\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"},\"_id\":\"1685a7b\"},{\"pxl_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"},\"_id\":\"67aa573\"}],\"color\":\"#FEC42C\",\"icon_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"icon_space\":{\"unit\":\"px\",\"size\":2,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_icon\"},{\"id\":\"6531703\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<div class=\\\"me-3\\\"><div class=\\\"me-3\\\"><div class=\\\"me-3\\\">\\u0628\\u0631 \\u0627\\u0633\\u0627\\u0633 \\u06f2\\u06f3 \\u0647\\u0632\\u0627\\u0631 \\u0646\\u0642\\u062f \\u0648 \\u0628\\u0631\\u0631\\u0633\\u06cc<\\/div><\\/div><\\/div>\",\"text_color\":\"#F8F9FA\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false},{\"id\":\"af13e9f\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#000A5B\",\"padding\":{\"unit\":\"px\",\"top\":\"25\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_align_items\":\"center\",\"flex_direction_mobile_extra\":\"column\"},\"elements\":[{\"id\":\"f6f14ff\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"2f08b27\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"15\",\"bottom\":\"0\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_align_items\":\"center\",\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"3627c0a\",\"elType\":\"widget\",\"settings\":{\"layout\":\"2\",\"pxl_icon\":{\"value\":\"fas fa-phone-alt\",\"library\":\"fa-solid\"},\"title\":\"\\u0628\\u0647 \\u062e\\u062f\\u0645\\u0627\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0646\\u06cc\\u0627\\u0632 \\u062f\\u0627\\u0631\\u06cc\\u062f\\u061f\",\"desc\":\"\\u062a\\u0645\\u0627\\u0633: 021123456789\",\"title_color\":\"#FFFFFF\",\"icon_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_width\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"desc_color\":\"#FFFFFF99\",\"icon_color\":\"#4A7DC2\",\"icon_bg_color\":\"#02010100\",\"title_bottom\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"inner_space\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"4a79de0\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"0\",\"left\":\"1\",\"isLinked\":false},\"border_color\":\"#FFFFFF80\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"border_width_mobile_extra\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"1\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"91829d8\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"15\",\"bottom\":\"0\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"pxl_parallax_bg_position\":\"\",\"pxl_parallax_bg_position_laptop\":\"\",\"pxl_parallax_bg_position_tablet_extra\":\"\",\"pxl_parallax_bg_position_tablet\":\"\",\"pxl_parallax_bg_position_mobile_extra\":\"\",\"pxl_parallax_bg_position_mobile\":\"\",\"pxl_parallax_bg_pos_custom_x\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size\":\"\",\"pxl_parallax_bg_size_laptop\":\"\",\"pxl_parallax_bg_size_tablet_extra\":\"\",\"pxl_parallax_bg_size_tablet\":\"\",\"pxl_parallax_bg_size_mobile_extra\":\"\",\"pxl_parallax_bg_size_mobile\":\"\",\"pxl_parallax_bg_size_custom\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"pxl_parallax_bg_size_custom_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_overlay_img_position\":\"\",\"pxl_overlay_img_position_laptop\":\"\",\"pxl_overlay_img_position_tablet_extra\":\"\",\"pxl_overlay_img_position_tablet\":\"\",\"pxl_overlay_img_position_mobile_extra\":\"\",\"pxl_overlay_img_position_mobile\":\"\",\"pxl_overlay_img_right_position\":\"\",\"pxl_overlay_img_right_position_laptop\":\"\",\"pxl_overlay_img_right_position_tablet_extra\":\"\",\"pxl_overlay_img_right_position_tablet\":\"\",\"pxl_overlay_img_right_position_mobile_extra\":\"\",\"pxl_overlay_img_right_position_mobile\":\"\",\"row_effect_images\":[],\"flex_align_items\":\"center\"},\"elements\":[{\"id\":\"b6383c4\",\"elType\":\"widget\",\"settings\":{\"layout\":\"2\",\"pxl_icon\":{\"value\":\"fas fa-clock\",\"library\":\"fa-solid\"},\"title\":\"\\u0633\\u0627\\u0639\\u0627\\u062a \\u06a9\\u0627\\u0631\\u06cc\",\"desc\":\"\\u0647\\u0631 \\u0631\\u0648\\u0632 \\u0627\\u0632 08:00 \\u062a\\u0627 20:00\",\"title_color\":\"#FFFFFF\",\"icon_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_width\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"desc_color\":\"#FFFFFF99\",\"icon_color\":\"#4A7DC2\",\"icon_bg_color\":\"#02010100\",\"title_bottom\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"inner_space\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"_element_width_mobile\":\"inherit\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"6a5100f\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"4eaeb3c\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"15\",\"bottom\":\"0\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"pxl_parallax_bg_position\":\"\",\"pxl_parallax_bg_position_laptop\":\"\",\"pxl_parallax_bg_position_tablet_extra\":\"\",\"pxl_parallax_bg_position_tablet\":\"\",\"pxl_parallax_bg_position_mobile_extra\":\"\",\"pxl_parallax_bg_position_mobile\":\"\",\"pxl_parallax_bg_pos_custom_x\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size\":\"\",\"pxl_parallax_bg_size_laptop\":\"\",\"pxl_parallax_bg_size_tablet_extra\":\"\",\"pxl_parallax_bg_size_tablet\":\"\",\"pxl_parallax_bg_size_mobile_extra\":\"\",\"pxl_parallax_bg_size_mobile\":\"\",\"pxl_parallax_bg_size_custom\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"pxl_parallax_bg_size_custom_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_overlay_img_position\":\"\",\"pxl_overlay_img_position_laptop\":\"\",\"pxl_overlay_img_position_tablet_extra\":\"\",\"pxl_overlay_img_position_tablet\":\"\",\"pxl_overlay_img_position_mobile_extra\":\"\",\"pxl_overlay_img_position_mobile\":\"\",\"pxl_overlay_img_right_position\":\"\",\"pxl_overlay_img_right_position_laptop\":\"\",\"pxl_overlay_img_right_position_tablet_extra\":\"\",\"pxl_overlay_img_right_position_tablet\":\"\",\"pxl_overlay_img_right_position_mobile_extra\":\"\",\"pxl_overlay_img_right_position_mobile\":\"\",\"row_effect_images\":[],\"flex_align_items\":\"center\"},\"elements\":[{\"id\":\"ff38d6d\",\"elType\":\"widget\",\"settings\":{\"layout\":\"2\",\"pxl_icon\":{\"value\":\"fas fa-envelope\",\"library\":\"fa-solid\"},\"title\":\"\\u0627\\u06cc\\u0645\\u06cc\\u0644 \\u0645\\u0627\",\"desc\":\"contact@dentiaclinic.com\",\"title_color\":\"#FFFFFF\",\"icon_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_width\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"desc_color\":\"#FFFFFF99\",\"icon_color\":\"#4A7DC2\",\"icon_bg_color\":\"#02010100\",\"title_bottom\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"inner_space\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"_element_width_mobile\":\"inherit\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false},{\"id\":\"15b34f8\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":50,\"column\":\"50\",\"row\":\"50\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"135\",\"right\":\"15\",\"bottom\":\"130\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_gap_laptop\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"0\",\"bottom\":\"70\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"98ca70d\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"flex_gap\":{\"column\":\"22\",\"row\":\"22\",\"isLinked\":true,\"unit\":\"px\",\"size\":22},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_direction_tablet\":\"column\"},\"elements\":[{\"id\":\"43ff422\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"b698bb4\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/about-img1.jpg\",\"id\":463,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":399,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"300\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"300\"},\"elements\":[],\"widgetType\":\"pxl_image\"}],\"isInner\":true},{\"id\":\"4c3a639\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"padding\":{\"unit\":\"px\",\"top\":\"55\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"3a26ecd\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/about-img2.jpg\",\"id\":464,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":399,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"500\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_image\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"9dd8e84\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"b0297bf\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u062a\\u062e\\u0635\\u0635\\u0627\\u0646 \\u0648 \\u062a\\u0639\\u0627\\u0644\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0634\\u062e\\u0635\\u06cc\",\"sub_title\":\"\\u062f\\u0631\\u0628\\u0627\\u0631\\u0647 \\u0645\\u0627\",\"h_width\":{\"unit\":\"%\",\"size\":80,\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"6bc87e8\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0645\\u0627 \\u062e\\u062f\\u0645\\u0627\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0628\\u0627 \\u06a9\\u06cc\\u0641\\u06cc\\u062a \\u0628\\u0627\\u0644\\u0627 \\u0648 \\u0645\\u062a\\u0646\\u0627\\u0633\\u0628 \\u0628\\u0627 \\u0646\\u06cc\\u0627\\u0632 \\u062a\\u0645\\u0627\\u0645 \\u0627\\u0639\\u0636\\u0627\\u06cc \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647 \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645. \\u0627\\u0632 \\u0645\\u0639\\u0627\\u06cc\\u0646\\u0627\\u062a \\u0631\\u0648\\u062a\\u06cc\\u0646 \\u06af\\u0631\\u0641\\u062a\\u0647 \\u062a\\u0627 \\u062f\\u0631\\u0645\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647\\u060c \\u062a\\u06cc\\u0645 \\u062f\\u0644\\u0633\\u0648\\u0632 \\u0645\\u0627 \\u062a\\u0636\\u0645\\u06cc\\u0646 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u062f \\u06a9\\u0647 \\u0644\\u0628\\u062e\\u0646\\u062f \\u0634\\u0645\\u0627 \\u0633\\u0627\\u0644\\u0645 \\u0648 \\u0628\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f \\u0628\\u0647 \\u0646\\u0641\\u0633 \\u0628\\u0627\\u0642\\u06cc \\u0628\\u0645\\u0627\\u0646\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"17\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"bb0da06\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_gap\":{\"column\":\"35\",\"row\":\"35\",\"isLinked\":true,\"unit\":\"px\",\"size\":35},\"flex_gap_laptop\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_direction_tablet\":\"column\",\"flex_gap_tablet\":{\"column\":\"5\",\"row\":\"5\",\"isLinked\":true,\"unit\":\"px\",\"size\":5}},\"elements\":[{\"id\":\"9028010\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"827cdc3\",\"elType\":\"widget\",\"settings\":{\"lists\":[{\"_id\":\"29fdacb\",\"pxl_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"},\"text\":\"\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0631\\u0645\\u0627\\u0646 \\u0634\\u062e\\u0635\\u06cc\\u200c\\u0633\\u0627\\u0632\\u06cc\\u200c\\u0634\\u062f\\u0647\"},{\"pxl_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"},\"text\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u0645\\u0644\\u0627\\u06cc\\u0645 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646 \\u0648 \\u0628\\u0632\\u0631\\u06af\\u0633\\u0627\\u0644\\u0627\\u0646\",\"_id\":\"7ff6475\"}],\"text_typography_typography\":\"custom\",\"text_typography_font_size_laptop\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"icon_color\":\"#4A7DC2\",\"icon_space\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"03\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"600\",\"align_items\":\"start\"},\"elements\":[],\"widgetType\":\"pxl_list\"}],\"isInner\":true},{\"id\":\"6db1ff5\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"fa6490e\",\"elType\":\"widget\",\"settings\":{\"lists\":[{\"_id\":\"29fdacb\",\"pxl_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"},\"text\":\"\\u0641\\u0646\\u0627\\u0648\\u0631\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647\"},{\"pxl_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"},\"text\":\"\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647\\u200c\\u0631\\u06cc\\u0632\\u06cc \\u0627\\u0646\\u0639\\u0637\\u0627\\u0641\\u200c\\u067e\\u0630\\u06cc\\u0631 \\u0628\\u0631\\u0627\\u06cc \\u0642\\u0631\\u0627\\u0631 \\u0645\\u0644\\u0627\\u0642\\u0627\\u062a\",\"_id\":\"7ff6475\"}],\"text_typography_typography\":\"custom\",\"text_typography_font_size_laptop\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"icon_color\":\"#4A7DC2\",\"icon_space\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"03\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"600\",\"align_items\":\"start\"},\"elements\":[],\"widgetType\":\"pxl_list\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"f3897d9\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0631\\u0632\\u0631\\u0648 \\u0646\\u0648\\u0628\\u062a\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"700\",\"_margin\":{\"unit\":\"px\",\"top\":\"28\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_button\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"9f68bac\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#4A7CD21A\",\"padding\":{\"unit\":\"px\",\"top\":\"120\",\"right\":\"15\",\"bottom\":\"130\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"15\",\"bottom\":\"70\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"ac1ac70\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"c74a3ee\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u06a9\\u0627\\u0645\\u0644 \\u0628\\u0631\\u0627\\u06cc \\u0647\\u0631 \\u0644\\u0628\\u062e\\u0646\\u062f\",\"sub_title\":\"\\u062e\\u062f\\u0645\\u0627\\u062a \\u0645\\u0627\",\"h_width\":{\"unit\":\"%\",\"size\":80,\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]},\"align\":\"center\"},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"72847f9\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0627\\u0632 \\u062a\\u0645\\u06cc\\u0632 \\u06a9\\u0631\\u062f\\u0646\\u200c\\u0647\\u0627\\u06cc \\u0631\\u0648\\u062a\\u06cc\\u0646 \\u06af\\u0631\\u0641\\u062a\\u0647 \\u062a\\u0627 \\u062a\\u0631\\u0645\\u06cc\\u0645\\u200c\\u0647\\u0627\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647\\u060c \\u0645\\u0627 \\u0631\\u0627\\u0647\\u200c\\u062d\\u0644\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0634\\u062e\\u0635\\u06cc\\u200c\\u0633\\u0627\\u0632\\u06cc\\u200c\\u0634\\u062f\\u0647 \\u0631\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u0628\\u06cc\\u0645\\u0627\\u0631\\u0627\\u0646 \\u062f\\u0631 \\u0647\\u0631 \\u0633\\u0646\\u06cc \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"42\",\"left\":\"0\",\"isLinked\":false},\"align\":\"center\",\"t_width\":{\"unit\":\"px\",\"size\":563,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"7371f8b\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"pxl_parallax_bg_position\":\"\",\"pxl_parallax_bg_position_laptop\":\"\",\"pxl_parallax_bg_position_tablet_extra\":\"\",\"pxl_parallax_bg_position_tablet\":\"\",\"pxl_parallax_bg_position_mobile_extra\":\"\",\"pxl_parallax_bg_position_mobile\":\"\",\"pxl_parallax_bg_pos_custom_x\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size\":\"\",\"pxl_parallax_bg_size_laptop\":\"\",\"pxl_parallax_bg_size_tablet_extra\":\"\",\"pxl_parallax_bg_size_tablet\":\"\",\"pxl_parallax_bg_size_mobile_extra\":\"\",\"pxl_parallax_bg_size_mobile\":\"\",\"pxl_parallax_bg_size_custom\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"pxl_parallax_bg_size_custom_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_overlay_img_position\":\"\",\"pxl_overlay_img_position_laptop\":\"\",\"pxl_overlay_img_position_tablet_extra\":\"\",\"pxl_overlay_img_position_tablet\":\"\",\"pxl_overlay_img_position_mobile_extra\":\"\",\"pxl_overlay_img_position_mobile\":\"\",\"pxl_overlay_img_right_position\":\"\",\"pxl_overlay_img_right_position_laptop\":\"\",\"pxl_overlay_img_right_position_tablet_extra\":\"\",\"pxl_overlay_img_right_position_tablet\":\"\",\"pxl_overlay_img_right_position_mobile_extra\":\"\",\"pxl_overlay_img_right_position_mobile\":\"\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"37741dc\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"flex_gap\":{\"column\":\"24\",\"row\":\"24\",\"isLinked\":true,\"unit\":\"px\",\"size\":24},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_wrap_tablet_extra\":\"wrap\",\"flex_gap_laptop\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20}},\"elements\":[{\"id\":\"5855528\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet_extra\":{\"unit\":\"%\",\"size\":48.5,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":48,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"ff281fa\",\"elType\":\"widget\",\"settings\":{\"layout\":\"3\",\"icon_type\":\"image\",\"icon_image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/tooth-1.png\",\"id\":626,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0639\\u0645\\u0648\\u0645\\u06cc\",\"desc\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a \\u06a9\\u0627\\u0645\\u0644 \\u062f\\u0647\\u0627\\u0646 \\u0648 \\u062f\\u0646\\u062f\\u0627\\u0646 \\u0628\\u0631\\u0627\\u06cc \\u0647\\u0631 \\u0644\\u0628\\u062e\\u0646\\u062f\\u06cc \\u0628\\u0627 \\u062c\\u0631\\u0645\\u200c\\u06af\\u06cc\\u0631\\u06cc\\u060c \\u0645\\u0639\\u0627\\u06cc\\u0646\\u0647 \\u0648 \\u0645\\u0648\\u0627\\u0631\\u062f \\u062f\\u06cc\\u06af\\u0631.\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/service\\/general-dentistry\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"title_btn\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"pxl_animate\":\"wow scaleIn\",\"pxl_animate_delay\":\"300\",\"pxl_animate2\":\"wow fadeInUp\",\"pxl_animate_delay2\":\"500\",\"title_color\":\"#10244B\",\"background_color\":\"#FFFFFF\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true},{\"id\":\"62a7ae9\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet_extra\":{\"unit\":\"%\",\"size\":49,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":48.5,\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"c880081\",\"elType\":\"widget\",\"settings\":{\"layout\":\"3\",\"icon_type\":\"image\",\"icon_image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/tooth-2.png\",\"id\":627,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0632\\u06cc\\u0628\\u0627\\u06cc\\u06cc\",\"desc\":\"\\u0632\\u06cc\\u0628\\u0627\\u06cc\\u06cc \\u0644\\u0628\\u062e\\u0646\\u062f \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0628\\u0627 \\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\\u060c \\u0648\\u0646\\u06cc\\u0631\\u0647\\u0627 \\u0648 \\u0645\\u0648\\u0627\\u0631\\u062f \\u062f\\u06cc\\u06af\\u0631 \\u0627\\u0641\\u0632\\u0627\\u06cc\\u0634 \\u062f\\u0647\\u06cc\\u062f.\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/service\\/cosmetic-dentistry\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"title_btn\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"pxl_animate\":\"wow scaleIn\",\"pxl_animate_delay\":\"300\",\"pxl_animate2\":\"wow fadeInUp\",\"pxl_animate_delay2\":\"500\",\"title_color\":\"#10244B\",\"background_color\":\"#FFFFFF\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true},{\"id\":\"964d2d6\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"background_background\":\"classic\",\"background_image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_position\":\"center center\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"width_tablet_extra\":{\"unit\":\"%\",\"size\":48.5,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":48,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"flex_justify_content\":\"center\"},\"elements\":[{\"id\":\"336bf6f\",\"elType\":\"widget\",\"settings\":{\"layout\":\"3\",\"icon_type\":\"image\",\"icon_image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/tooth-3.png\",\"id\":628,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646\",\"desc\":\"\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u0645\\u0644\\u0627\\u06cc\\u0645 \\u0648 \\u0633\\u0631\\u06af\\u0631\\u0645\\u200c\\u06a9\\u0646\\u0646\\u062f\\u0647 \\u0627\\u0632 \\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646 \\u062a\\u0627 \\u0644\\u0628\\u062e\\u0646\\u062f\\u06cc \\u0633\\u0627\\u0644\\u0645 \\u0648 \\u0634\\u0627\\u062f \\u062f\\u0627\\u0634\\u062a\\u0647 \\u0628\\u0627\\u0634\\u0646\\u062f.\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/service\\/pediatric-dentistry\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"title_btn\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"pxl_animate\":\"wow scaleIn\",\"pxl_animate_delay\":\"300\",\"pxl_animate2\":\"wow fadeInUp\",\"pxl_animate_delay2\":\"500\",\"title_color\":\"#10244B\",\"background_color\":\"#FFFFFF\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true},{\"id\":\"2e4cbee\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"width_tablet_extra\":{\"unit\":\"%\",\"size\":49,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":48.5,\"sizes\":[]},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"2029233\",\"elType\":\"widget\",\"settings\":{\"layout\":\"3\",\"icon_type\":\"image\",\"icon_image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/tooth-4.png\",\"id\":629,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"title\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u062a\\u0631\\u0645\\u06cc\\u0645\\u06cc\",\"desc\":\"\\u062f\\u0646\\u062f\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u0634\\u0645\\u0627 \\u0631\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u0631\\u0627\\u062d\\u062a\\u06cc \\u0648 \\u0639\\u0645\\u0644\\u06a9\\u0631\\u062f \\u067e\\u0627\\u06cc\\u062f\\u0627\\u0631 \\u062a\\u0631\\u0645\\u06cc\\u0645 \\u0648 \\u0628\\u0627\\u0632\\u0633\\u0627\\u0632\\u06cc \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u062f.\\n\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/service\\/restorative-dentistry\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"title_btn\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"pxl_animate\":\"wow scaleIn\",\"pxl_animate_delay\":\"300\",\"pxl_animate2\":\"wow fadeInUp\",\"pxl_animate_delay2\":\"500\",\"title_color\":\"#10244B\",\"background_color\":\"#FFFFFF\"},\"elements\":[],\"widgetType\":\"pxl_icon_box\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true},{\"id\":\"e71413a\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u0647\\u0645\\u0647 \\u062e\\u062f\\u0645\\u0627\\u062a\",\"link\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/all-services\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"align\":\"center\",\"_margin\":{\"unit\":\"px\",\"top\":\"48\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_button\"}],\"isInner\":false},{\"id\":\"b92d7a4\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#000A5B\",\"padding\":{\"unit\":\"px\",\"top\":\"60\",\"right\":\"15\",\"bottom\":\"60\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"d408d83\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"25\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"c08f676\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0628\\u06cc\\u0645\\u0627\\u0631\\u0627\\u0646 \\u0634\\u0627\\u062f\",\"starting_number\":5000,\"ending_number\":10000,\"suffix\":\"+\",\"pxl_animate\":\"wow fadeInRight\",\"pxl_animate_delay\":\"300\"},\"elements\":[],\"widgetType\":\"pxl_counter\"}],\"isInner\":true},{\"id\":\"3ffca2e\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"25\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"17f3015\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0633\\u0641\\u06cc\\u062f \\u06a9\\u0631\\u062f\\u0646 \\u062f\\u0646\\u062f\\u0627\\u0646\",\"starting_number\":2000,\"ending_number\":2500,\"suffix\":\"+\",\"pxl_animate\":\"wow fadeInRight\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_counter\"}],\"isInner\":true},{\"id\":\"5163797\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"25\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"344472f\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u06cc\\u0645\\u067e\\u0644\\u0646\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\",\"starting_number\":500,\"ending_number\":800,\"suffix\":\"+\",\"pxl_animate\":\"wow fadeInRight\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_counter\"}],\"isInner\":true},{\"id\":\"7ac7412\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"25\"},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"62d672d\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0633\\u0627\\u0644 \\u062a\\u062c\\u0631\\u0628\\u0647\",\"ending_number\":15,\"suffix\":\"+\",\"pxl_animate\":\"wow fadeInRight\",\"pxl_animate_delay\":\"600\"},\"elements\":[],\"widgetType\":\"pxl_counter\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"fc38de1\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":50,\"column\":\"50\",\"row\":\"50\",\"isLinked\":true},\"flex_direction_mobile_extra\":\"column\",\"flex_gap_laptop\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"padding\":{\"unit\":\"px\",\"top\":\"120\",\"right\":\"15\",\"bottom\":\"155\",\"left\":\"15\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"0\",\"bottom\":\"70\",\"left\":\"0\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"931cd86\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"c7857de\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0633\\u062a\\u062b\\u0646\\u0627\\u06cc\\u06cc \\u0628\\u0627 \\u0631\\u0648\\u06cc\\u06a9\\u0631\\u062f\\u06cc \\u0634\\u062e\\u0635\\u06cc\",\"sub_title\":\"\\u0686\\u0631\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0645\\u0627 \\u0631\\u0627 \\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u06a9\\u0646\\u06cc\\u062f\",\"h_width\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"602ea93\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0627\\u0631\\u0627\\u0626\\u0647 \\u062f\\u0647\\u0646\\u062f\\u0647 \\u062e\\u062f\\u0645\\u0627\\u062a \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0645\\u0646\\u0627\\u0633\\u0628 \\u0627\\u0647\\u0645\\u06cc\\u062a \\u062f\\u0627\\u0631\\u062f. \\u0645\\u0627 \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062a\\u062e\\u0635\\u0635\\u06cc\\u060c \\u0641\\u0646\\u0627\\u0648\\u0631\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647 \\u0648 \\u0641\\u0636\\u0627\\u06cc\\u06cc \\u06af\\u0631\\u0645 \\u0631\\u0627 \\u0628\\u0627 \\u0647\\u0645 \\u062a\\u0631\\u06a9\\u06cc\\u0628 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u06cc\\u0645 \\u062a\\u0627 \\u0627\\u0637\\u0645\\u06cc\\u0646\\u0627\\u0646 \\u062d\\u0627\\u0635\\u0644 \\u06a9\\u0646\\u06cc\\u0645 \\u06a9\\u0647 \\u0647\\u0631 \\u0648\\u06cc\\u0632\\u06cc\\u062a \\u0631\\u0627\\u062d\\u062a\\u060c \\u06a9\\u0627\\u0631\\u0622\\u0645\\u062f \\u0648 \\u0645\\u062a\\u0646\\u0627\\u0633\\u0628 \\u0628\\u0627 \\u0646\\u06cc\\u0627\\u0632\\u0647\\u0627\\u06cc \\u0645\\u0646\\u062d\\u0635\\u0631 \\u0628\\u0647 \\u0641\\u0631\\u062f \\u0634\\u0645\\u0627 \\u062e\\u0648\\u0627\\u0647\\u062f \\u0628\\u0648\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"21\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"9f3be1f\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_gap\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"flex_gap_laptop\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_direction_tablet\":\"column\",\"flex_gap_tablet\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"border_color\":\"#0000004D\",\"padding\":{\"unit\":\"px\",\"top\":\"22\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"e4d5e10\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_gap\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"flex_gap_tablet_extra\":{\"column\":\"15\",\"row\":\"15\",\"isLinked\":true,\"unit\":\"px\",\"size\":15}},\"elements\":[{\"id\":\"3f475ce\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"d437b1c\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<h5>\\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9 \\u0628\\u0627\\u062a\\u062c\\u0631\\u0628\\u0647<\\/h5>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"78e6e2b\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062a\\u062e\\u0635\\u0635\\u06cc \\u0628\\u0627 \\u067e\\u0634\\u062a\\u0648\\u0627\\u0646\\u0647 \\u0633\\u0627\\u0644\\u200c\\u0647\\u0627 \\u062a\\u062c\\u0631\\u0628\\u0647 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0642\\u0627\\u0628\\u0644 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"c548350\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"65c31f4\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<h5>\\u062f\\u0631\\u0645\\u0627\\u0646 \\u0634\\u062e\\u0635\\u06cc\\u200c\\u0633\\u0627\\u0632\\u06cc\\u200c\\u0634\\u062f\\u0647<\\/h5>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"24d4409\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647\\u200c\\u0647\\u0627\\u06cc \\u0645\\u0631\\u0627\\u0642\\u0628\\u062a\\u06cc \\u0633\\u0641\\u0627\\u0631\\u0634\\u06cc \\u06a9\\u0647 \\u0645\\u062a\\u0646\\u0627\\u0633\\u0628 \\u0628\\u0627 \\u0644\\u0628\\u062e\\u0646\\u062f \\u0648 \\u0633\\u0628\\u06a9 \\u0632\\u0646\\u062f\\u06af\\u06cc \\u0634\\u0645\\u0627 \\u062a\\u0647\\u06cc\\u0647 \\u0645\\u06cc\\u200c\\u0634\\u0648\\u0646\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"64807c6\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"flex_gap\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"flex_gap_tablet_extra\":{\"column\":\"15\",\"row\":\"15\",\"isLinked\":true,\"unit\":\"px\",\"size\":15}},\"elements\":[{\"id\":\"0cb580b\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"pxl_parallax_bg_position\":\"\",\"pxl_parallax_bg_position_laptop\":\"\",\"pxl_parallax_bg_position_tablet_extra\":\"\",\"pxl_parallax_bg_position_tablet\":\"\",\"pxl_parallax_bg_position_mobile_extra\":\"\",\"pxl_parallax_bg_position_mobile\":\"\",\"pxl_parallax_bg_pos_custom_x\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_x_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_pos_custom_y_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size\":\"\",\"pxl_parallax_bg_size_laptop\":\"\",\"pxl_parallax_bg_size_tablet_extra\":\"\",\"pxl_parallax_bg_size_tablet\":\"\",\"pxl_parallax_bg_size_mobile_extra\":\"\",\"pxl_parallax_bg_size_mobile\":\"\",\"pxl_parallax_bg_size_custom\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"pxl_parallax_bg_size_custom_laptop\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile_extra\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_parallax_bg_size_custom_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"pxl_overlay_img_position\":\"\",\"pxl_overlay_img_position_laptop\":\"\",\"pxl_overlay_img_position_tablet_extra\":\"\",\"pxl_overlay_img_position_tablet\":\"\",\"pxl_overlay_img_position_mobile_extra\":\"\",\"pxl_overlay_img_position_mobile\":\"\",\"pxl_overlay_img_right_position\":\"\",\"pxl_overlay_img_right_position_laptop\":\"\",\"pxl_overlay_img_right_position_tablet_extra\":\"\",\"pxl_overlay_img_right_position_tablet\":\"\",\"pxl_overlay_img_right_position_mobile_extra\":\"\",\"pxl_overlay_img_right_position_mobile\":\"\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"89fbcf5\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<h5>\\u0641\\u0646\\u0627\\u0648\\u0631\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647<\\/h5>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"1a2ce28\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0627\\u0628\\u0632\\u0627\\u0631\\u0647\\u0627\\u06cc \\u0645\\u062f\\u0631\\u0646\\u060c \\u062f\\u0631\\u0645\\u0627\\u0646\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0642\\u06cc\\u0642 \\u0648 \\u06a9\\u0627\\u0631\\u0622\\u0645\\u062f \\u0631\\u0627 \\u062a\\u0636\\u0645\\u06cc\\u0646 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0646\\u062f.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true},{\"id\":\"5c18bec\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"0139430\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<h5>\\u0645\\u0646\\u0627\\u0633\\u0628 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u0647<\\/h5>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"},{\"id\":\"3e9309c\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p>\\u0641\\u0636\\u0627\\u06cc\\u06cc \\u062f\\u0644\\u0646\\u0634\\u06cc\\u0646 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0648\\u062f\\u06a9\\u0627\\u0646\\u060c \\u0646\\u0648\\u062c\\u0648\\u0627\\u0646\\u0627\\u0646\\u060c \\u0628\\u0632\\u0631\\u06af\\u0633\\u0627\\u0644\\u0627\\u0646 \\u0648 \\u0633\\u0627\\u0644\\u0645\\u0646\\u062f\\u0627\\u0646.<\\/p>\",\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_text_editor\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true},{\"id\":\"c0bac5e\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"width_mobile_extra\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"flex_align_items\":\"center\",\"flex_gap\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"9ce2c5c\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_gap\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"flex_gap_tablet_extra\":{\"column\":\"25\",\"row\":\"25\",\"isLinked\":true,\"unit\":\"px\",\"size\":25},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"e530c81\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/exceptional2.jpg\",\"id\":607,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":236.80000000000001136868377216160297393798828125,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"300\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"300\",\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"60\",\"isLinked\":false},\"_padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"pxl_image\"},{\"id\":\"21bc2cb\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/exceptional1.jpg\",\"id\":606,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":296,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"500\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"500\"},\"elements\":[],\"widgetType\":\"pxl_image\"}],\"isInner\":true},{\"id\":\"2b3fb22\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"a7be7b9\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/dentia.sunthemes.ir\\/wp-content\\/uploads\\/2025\\/08\\/exceptional3.jpg\",\"id\":608,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_type\":\"bg\",\"image_height\":{\"unit\":\"px\",\"size\":399.6000000000000227373675443232059478759765625,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"parallax_value\":\"40\",\"max_tilt\":\"10\",\"speed_tilt\":\"400\",\"perspective_tilt\":\"1000\",\"pxl_animate\":\"wow zoomInSmall\",\"pxl_animate_delay\":\"400\",\"pxl_animate_img\":\"wow scaleIn\",\"pxl_animate_img_delay\":\"400\"},\"elements\":[],\"widgetType\":\"pxl_image\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false},{\"id\":\"d0d5540\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#4A7CD21A\",\"padding\":{\"unit\":\"px\",\"top\":\"120\",\"right\":\"15\",\"bottom\":\"108\",\"left\":\"15\",\"isLinked\":false},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[],\"padding_tablet\":{\"unit\":\"px\",\"top\":\"70\",\"right\":\"15\",\"bottom\":\"70\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"964e490\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100},\"col_sticky_offset_top\":\"30\",\"row_effect_images\":[]},\"elements\":[{\"id\":\"d075595\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u062a\\u0639\\u0647\\u062f \\u0628\\u0647 \\u0644\\u0628\\u062e\\u0646\\u062f \\u0634\\u0645\\u0627\",\"sub_title\":\" \\u0628\\u0627 \\u062a\\u06cc\\u0645 \\u062f\\u0646\\u062f\\u0627\\u0646\\u067e\\u0632\\u0634\\u06a9\\u06cc \\u0645\\u0627 \\u0622\\u0634\\u0646\\u0627 \\u0634\\u0648\\u06cc\\u062f\",\"h_width\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_laptop\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"h_width_mobile_extra\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"h_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"title_tag\":\"h2\",\"sub_title_space_bottom\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"pxl_animate\":\"wow fadeInUp\",\"pxl_animate_delay\":\"400\",\"pxl_animate_sub\":\"wow fadeInUp\",\"pxl_animate_delay_sub\":\"300\",\"align\":\"center\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"pxl_heading\"},{\"id\":\"acd7da4\",\"elType\":\"widget\",\"settings\":{\"text_ed\":\"<p class=\\\"wow fadeInUp animated\\